# coding: utf-8

"""
    OpenAPI

    OpenAPI

    The version of the OpenAPI document: 0.0.1
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from datetime import datetime
from pydantic import BaseModel, ConfigDict, Field, StrictStr, field_validator
from typing import Any, ClassVar, Dict, List, Optional
from hubsante_model.cisu.models.attachment import Attachment
from hubsante_model.cisu.models.call_taker import CallTaker
from hubsante_model.cisu.models.caller import Caller
from hubsante_model.cisu.models.location import Location
from hubsante_model.cisu.models.notes import Notes
from hubsante_model.cisu.models.qualification import Qualification
from typing import Optional, Set
from typing_extensions import Self

class Alert(BaseModel):
    """
    Alert
    """ # noqa: E501
    id: StrictStr = Field(description="Identifiant technique unique de l'alerte. Il doit pouvoir être généré automatiquement par le système émetteur et ne doit pas avoir de signification / utilisation particulière par les différents systèmes pour garantir leur découplage. Voir la description de l'identifiant de l'affaire pour voir le format. Lorsqu’une alerte est générée dans NexSIS et crée une affaire, elle est qualifiée d’Alerte Initiale. a) Si cette dernière concerne un partenaire (caractère médical pour la Santé par exemple), elle est relayée seule dans le message. Il y’a un seul objet initialAlert. b) Sinon, une autre alerte liée à la même affaire peut être déclarée ultérieurement, concernant cette fois le partenaire. Lorsqu’elle est déclarée cette Nouvelle Alerte est relayée avec l’Alerte Initiale pour partager un contexte commun. Dans le message de création d’affaire il y’a deux objets alerte : initialAlert et newAlert. Le rattachement des messages à une affaire doivent s'appuyer sur les caseId et non les alertId qui peuvent varier d'un système à l'autre.")
    reception: str = Field(description="A valoriser avec le groupe date heure de réception de l'alerte/appel")
    reporting: StrictStr = Field(description="Permet d'attirer l'attention des forces partenaires sur une affaire pour le faire sortir du lot. Eventuellement automatisé en fonction des critères saisis et de leur paramétrage, ou renseigné par l'opérateur.  Prend les valeurs définies dans la nomenclature CISU : - standard : STANDARD - signalé : ATTENTION Les systèmes peuvent proposer des fonctionnalités faisant ressortir les dossiers avec le libellé ATTENTION")
    notes: Optional[List[Notes]] = None
    caller: Caller
    location: Location
    qualification: Qualification
    call_taker: CallTaker = Field(alias="callTaker")
    attachment: Optional[List[Attachment]] = None
    __properties: ClassVar[List[str]] = ["id", "reception", "reporting", "notes", "caller", "location", "qualification", "callTaker", "attachment"]

    @field_validator('reception')
    def reception_validate_regular_expression(cls, value):
        """Validates the regular expression"""
        if not re.match(r"^\d{4}-\d{2}-\d{2}T\d{2}:\d{2}:\d{2}[\-+]\d{2}:\d{2}$", value):
            raise ValueError(r"must validate the regular expression /^\d{4}-\d{2}-\d{2}T\d{2}:\d{2}:\d{2}[\-+]\d{2}:\d{2}$/")
        return value

    @field_validator('reporting')
    def reporting_validate_enum(cls, value):
        """Validates the enum"""
        if value not in set(['STANDARD', 'ATTENTION']):
            raise ValueError("must be one of enum values ('STANDARD', 'ATTENTION')")
        return value

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of Alert from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of each item in notes (list)
        _items = []
        if self.notes:
            for _item_notes in self.notes:
                if _item_notes:
                    _items.append(_item_notes.to_dict())
            _dict['notes'] = _items
        # override the default output from pydantic by calling `to_dict()` of caller
        if self.caller:
            _dict['caller'] = self.caller.to_dict()
        # override the default output from pydantic by calling `to_dict()` of location
        if self.location:
            _dict['location'] = self.location.to_dict()
        # override the default output from pydantic by calling `to_dict()` of qualification
        if self.qualification:
            _dict['qualification'] = self.qualification.to_dict()
        # override the default output from pydantic by calling `to_dict()` of call_taker
        if self.call_taker:
            _dict['callTaker'] = self.call_taker.to_dict()
        # override the default output from pydantic by calling `to_dict()` of each item in attachment (list)
        _items = []
        if self.attachment:
            for _item_attachment in self.attachment:
                if _item_attachment:
                    _items.append(_item_attachment.to_dict())
            _dict['attachment'] = _items
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of Alert from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "id": obj.get("id"),
            "reception": obj.get("reception"),
            "reporting": obj.get("reporting"),
            "notes": [Notes.from_dict(_item) for _item in obj["notes"]] if obj.get("notes") is not None else None,
            "caller": Caller.from_dict(obj["caller"]) if obj.get("caller") is not None else None,
            "location": Location.from_dict(obj["location"]) if obj.get("location") is not None else None,
            "qualification": Qualification.from_dict(obj["qualification"]) if obj.get("qualification") is not None else None,
            "callTaker": CallTaker.from_dict(obj["callTaker"]) if obj.get("callTaker") is not None else None,
            "attachment": [Attachment.from_dict(_item) for _item in obj["attachment"]] if obj.get("attachment") is not None else None
        })
        return _obj


