# coding: utf-8

"""
    OpenAPI

    OpenAPI

    The version of the OpenAPI document: 0.0.1
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from datetime import datetime
from pydantic import BaseModel, ConfigDict, Field, StrictStr, field_validator
from typing import Any, ClassVar, Dict, List, Optional
from typing_extensions import Annotated
from hubsante_model.cisu.models.additional_information import AdditionalInformation
from hubsante_model.cisu.models.alert import Alert
from hubsante_model.cisu.models.location import Location
from hubsante_model.cisu.models.qualification import Qualification
from typing import Optional, Set
from typing_extensions import Self

class CreateCase(BaseModel):
    """
    CreateCase
    """ # noqa: E501
    case_id: Annotated[str, Field(strict=True)] = Field(description="Identifiant partagé de l'affaire/dossier, généré une seule fois par le système du partenaire qui recoit la primo-demande de secours (créateur du dossier).  Il est valorisé comme suit lors de sa création :  {pays}.{domaine}.{organisation}.{senderCaseId}  Il doit pouvoir être généré de façon décentralisée et ne présenter aucune ambiguïté.  Il doit être unique dans l'ensemble des systèmes : le numéro de dossier fourni par celui qui génère l'identifiant partagé doit donc être un numéro unique dans son système.", alias="caseId")
    sender_case_id: Optional[StrictStr] = Field(default=None, description="A valoriser avec le numéro du dossier dans le SI de l'émetteur du message. ", alias="senderCaseId")
    creation: str = Field(description="A valoriser avec le groupe date heure de création du dossier/affaire.  Spécificité 15-18 : A valoriser avec le groupe date heure de début de partage lié à la création de l'affaire (et donc de génération du caseId).  Lors de l'ajout d'une nouvelle alerte, la valeur de ce champ ne doit pas être modifiée.   L'indicateur de fuseau horaire Z ne doit pas être utilisé. Il doit être renseigné à la fin du processus de la  création de la première alerte.")
    reference_version: StrictStr = Field(description="Indique le numéro de version du référentiel des nomenclatures des codes transmis.  Cela permet aux différents systèmes de s'assurer qu'ils utilisent la même version des codes de nomenclature que leurs partenaires.", alias="referenceVersion")
    qualification: Qualification
    location: Location
    initial_alert: Optional[Alert] = Field(default=None, alias="initialAlert")
    new_alert: Optional[List[Alert]] = Field(default=None, alias="newAlert")
    freetext: Optional[List[StrictStr]] = None
    additional_information: Optional[AdditionalInformation] = Field(default=None, alias="additionalInformation")
    __properties: ClassVar[List[str]] = ["caseId", "senderCaseId", "creation", "referenceVersion", "qualification", "location", "initialAlert", "newAlert", "freetext", "additionalInformation"]

    @field_validator('case_id')
    def case_id_validate_regular_expression(cls, value):
        """Validates the regular expression"""
        if not re.match(r"^([\w-]+\.?){4,10}$", value):
            raise ValueError(r"must validate the regular expression /^([\w-]+\.?){4,10}$/")
        return value

    @field_validator('creation')
    def creation_validate_regular_expression(cls, value):
        """Validates the regular expression"""
        if not re.match(r"^\d{4}-\d{2}-\d{2}T\d{2}:\d{2}:\d{2}[\-+]\d{2}:\d{2}$", value):
            raise ValueError(r"must validate the regular expression /^\d{4}-\d{2}-\d{2}T\d{2}:\d{2}:\d{2}[\-+]\d{2}:\d{2}$/")
        return value

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of CreateCase from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of qualification
        if self.qualification:
            _dict['qualification'] = self.qualification.to_dict()
        # override the default output from pydantic by calling `to_dict()` of location
        if self.location:
            _dict['location'] = self.location.to_dict()
        # override the default output from pydantic by calling `to_dict()` of initial_alert
        if self.initial_alert:
            _dict['initialAlert'] = self.initial_alert.to_dict()
        # override the default output from pydantic by calling `to_dict()` of each item in new_alert (list)
        _items = []
        if self.new_alert:
            for _item_new_alert in self.new_alert:
                if _item_new_alert:
                    _items.append(_item_new_alert.to_dict())
            _dict['newAlert'] = _items
        # override the default output from pydantic by calling `to_dict()` of additional_information
        if self.additional_information:
            _dict['additionalInformation'] = self.additional_information.to_dict()
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of CreateCase from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "caseId": obj.get("caseId"),
            "senderCaseId": obj.get("senderCaseId"),
            "creation": obj.get("creation"),
            "referenceVersion": obj.get("referenceVersion"),
            "qualification": Qualification.from_dict(obj["qualification"]) if obj.get("qualification") is not None else None,
            "location": Location.from_dict(obj["location"]) if obj.get("location") is not None else None,
            "initialAlert": Alert.from_dict(obj["initialAlert"]) if obj.get("initialAlert") is not None else None,
            "newAlert": [Alert.from_dict(_item) for _item in obj["newAlert"]] if obj.get("newAlert") is not None else None,
            "freetext": obj.get("freetext"),
            "additionalInformation": AdditionalInformation.from_dict(obj["additionalInformation"]) if obj.get("additionalInformation") is not None else None
        })
        return _obj


