# coding: utf-8

"""
    OpenAPI

    OpenAPI

    The version of the OpenAPI document: 0.0.1
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from datetime import datetime
from pydantic import BaseModel, ConfigDict, Field, StrictBool, StrictFloat, StrictInt, StrictStr, field_validator
from typing import Any, ClassVar, Dict, List, Optional, Union
from typing_extensions import Annotated
from hubsante_model.geolocation.models.coord import Coord
from typing import Optional, Set
from typing_extensions import Self

class Position(BaseModel):
    """
    Position
    """ # noqa: E501
    resource_id: Annotated[str, Field(strict=True)] = Field(description="A valoriser avec l'identifiant partagé unique de la ressource engagée, normé comme suit : {orgID}.resource.{ID unique de la ressource partagée} OU - uniquement dans le cas où un ID unique de ressource ne peut pas être garanti par l'organisation propriétaire : {orgID}.resource.{sendercaseId}.{n° d’ordre chronologique de la ressource}", alias="resourceId")
    datetime: str = Field(description="Date et heure de réception des coordonnées transmises")
    coord: Coord
    speed: Optional[Union[StrictFloat, StrictInt]] = Field(default=None, description="Vitesse de la ressource enregistrée, exprimée en km/h")
    cap: Optional[StrictStr] = Field(default=None, description="Direction de la ressource, exprimé en degrés")
    move: Optional[StrictStr] = Field(default=None, description="Indique si la ressource est en mouvement (MOBILE) ou non (STATIQUE)")
    engine_on: Optional[StrictBool] = Field(default=None, description="Indique si le moteur de la ressource est éteint (FAUX) ou allumé/en marche (VRAI)", alias="engineOn")
    ground_status: Optional[StrictBool] = Field(default=None, description="Indique si l'hélicoptère est au sol (VRAI) ou en l'air (FAUX)", alias="groundStatus")
    status: Optional[StrictStr] = Field(default=None, description="Définit le statut de disponibilité d'une ressource. - DISPONIBLE : Lorsque la ressource est disponible - INDISPONIBLE : Lorsque la ressource n'est pas disponible, celle-ci peut être engagée ou en maintenance - INCONNU : Lorsque le status est inconnu")
    engaged_status: Optional[StrictStr] = Field(default=None, description="Précise le statut d'une ressource qui est engagée sur une mission", alias="engagedStatus")
    __properties: ClassVar[List[str]] = ["resourceId", "datetime", "coord", "speed", "cap", "move", "engineOn", "groundStatus", "status", "engagedStatus"]

    @field_validator('resource_id')
    def resource_id_validate_regular_expression(cls, value):
        """Validates the regular expression"""
        if not re.match(r"^([\w-]+\.){3,8}resource(\.[\w-]+){1,2}$", value):
            raise ValueError(r"must validate the regular expression /^([\w-]+\.){3,8}resource(\.[\w-]+){1,2}$/")
        return value

    @field_validator('datetime')
    def datetime_validate_regular_expression(cls, value):
        """Validates the regular expression"""
        if not re.match(r"^\d{4}-\d{2}-\d{2}T\d{2}:\d{2}:\d{2}[\-+]\d{2}:\d{2}$", value):
            raise ValueError(r"must validate the regular expression /^\d{4}-\d{2}-\d{2}T\d{2}:\d{2}:\d{2}[\-+]\d{2}:\d{2}$/")
        return value

    @field_validator('move')
    def move_validate_enum(cls, value):
        """Validates the enum"""
        if value is None:
            return value

        if value not in set(['MOBILE', 'STATIQUE']):
            raise ValueError("must be one of enum values ('MOBILE', 'STATIQUE')")
        return value

    @field_validator('status')
    def status_validate_enum(cls, value):
        """Validates the enum"""
        if value is None:
            return value

        if value not in set(['DISPONIBLE', 'INDISPONIBLE', 'INCONNU']):
            raise ValueError("must be one of enum values ('DISPONIBLE', 'INDISPONIBLE', 'INCONNU')")
        return value

    @field_validator('engaged_status')
    def engaged_status_validate_enum(cls, value):
        """Validates the enum"""
        if value is None:
            return value

        if value not in set(['ALERTEE', 'PARTIE', 'ARRIVEE_LIEU', 'TRANSPORT_DESTINATION', 'ARRIVEE_DESTINATION', 'FIN_MED', 'QUITTE_DESTINATION', 'RETOUR_DISPONIBLE', 'RETOUR_INDISPONIBLE', 'ARRIVEE_CENTRE']):
            raise ValueError("must be one of enum values ('ALERTEE', 'PARTIE', 'ARRIVEE_LIEU', 'TRANSPORT_DESTINATION', 'ARRIVEE_DESTINATION', 'FIN_MED', 'QUITTE_DESTINATION', 'RETOUR_DISPONIBLE', 'RETOUR_INDISPONIBLE', 'ARRIVEE_CENTRE')")
        return value

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of Position from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of coord
        if self.coord:
            _dict['coord'] = self.coord.to_dict()
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of Position from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "resourceId": obj.get("resourceId"),
            "datetime": obj.get("datetime"),
            "coord": Coord.from_dict(obj["coord"]) if obj.get("coord") is not None else None,
            "speed": obj.get("speed"),
            "cap": obj.get("cap"),
            "move": obj.get("move"),
            "engineOn": obj.get("engineOn"),
            "groundStatus": obj.get("groundStatus"),
            "status": obj.get("status"),
            "engagedStatus": obj.get("engagedStatus")
        })
        return _obj


