# coding: utf-8

"""
    OpenAPI

    OpenAPI

    The version of the OpenAPI document: 0.0.1
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictStr, field_validator
from typing import Any, ClassVar, Dict, List, Optional
from typing_extensions import Annotated
from typing import Optional, Set
from typing_extensions import Self

class Access(BaseModel):
    """
    Access
    """ # noqa: E501
    floor: Optional[StrictStr] = Field(default=None, description="A valoriser avec le numéro ou nom de l'étage ")
    room_number: Optional[StrictStr] = Field(default=None, description="A valoriser avec le numéro d'appartement, de chambre, de bureau", alias="roomNumber")
    interphone: Optional[StrictStr] = Field(default=None, description="A valoriser avec les informations nécessaires à l'identification de l'interphone (numéro, nom)")
    access_code: Optional[List[StrictStr]] = Field(default=None, alias="accessCode")
    elevator: Optional[StrictStr] = Field(default=None, description="A valoriser avec le nom ou le numéro de l'ascenseur ou de la cage d'escalier ")
    building_name: Optional[StrictStr] = Field(default=None, description="A valoriser avec le nom du bâtiment", alias="buildingName")
    entrance: Optional[StrictStr] = Field(default=None, description="A valoriser avec le nom de l'entrée")
    entity: Optional[StrictStr] = Field(default=None, description="A valoriser avec le nom du service concerné au sein de l'établissement : infirmerie, service finance, service comptabilité.")
    phone_number: Optional[Annotated[str, Field(strict=True)]] = Field(default=None, description="A valoriser avec le numéro de téléphone du lieu de l'intervention, par exemple : téléphone du secrétariat, téléphone du service administratif ou se trouve le patient/ la victime. Le format attendu est le suivant : +{indicatif pays}{numéro de téléphone}", alias="phoneNumber")
    __properties: ClassVar[List[str]] = ["floor", "roomNumber", "interphone", "accessCode", "elevator", "buildingName", "entrance", "entity", "phoneNumber"]

    @field_validator('phone_number')
    def phone_number_validate_regular_expression(cls, value):
        """Validates the regular expression"""
        if value is None:
            return value

        if not re.match(r"^\+\d{5,18}$", value):
            raise ValueError(r"must validate the regular expression /^\+\d{5,18}$/")
        return value

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of Access from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of Access from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "floor": obj.get("floor"),
            "roomNumber": obj.get("roomNumber"),
            "interphone": obj.get("interphone"),
            "accessCode": obj.get("accessCode"),
            "elevator": obj.get("elevator"),
            "buildingName": obj.get("buildingName"),
            "entrance": obj.get("entrance"),
            "entity": obj.get("entity"),
            "phoneNumber": obj.get("phoneNumber")
        })
        return _obj


