# coding: utf-8

"""
    OpenAPI

    OpenAPI

    The version of the OpenAPI document: 0.0.1
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictStr, field_validator
from typing import Any, ClassVar, Dict, List, Optional
from hubsante_model.health.models.contact import Contact
from hubsante_model.health.models.detailed_name import DetailedName
from typing import Optional, Set
from typing_extensions import Self

class Caller(BaseModel):
    """
    Caller
    """ # noqa: E501
    caller_contact: Contact = Field(alias="callerContact")
    callback_contact: Optional[Contact] = Field(default=None, alias="callbackContact")
    language: Optional[StrictStr] = Field(default=None, description="A valoriser avec la langue parlée par le requérant.  cf.nomenclature associée.")
    type: Optional[StrictStr] = Field(default=None, description="A valoriser avec la relation du requérant avec l'incident / le patient / la victime. cf. nomenclature associée.")
    communication: Optional[StrictStr] = Field(default=None, description="A valoriser avec la nature des éventuelles difficultés de communication rencontrées par le requérant.  cf.nomenclature associée.")
    freetext: Optional[StrictStr] = Field(default=None, description="Champ libre qui permet de compléter les informations spécifiquement liées au requérant.")
    detailed_name: Optional[DetailedName] = Field(default=None, alias="detailedName")
    __properties: ClassVar[List[str]] = ["callerContact", "callbackContact", "language", "type", "communication", "freetext", "detailedName"]

    @field_validator('language')
    def language_validate_enum(cls, value):
        """Validates the enum"""
        if value is None:
            return value

        if value not in set(['aa', 'ab', 'ae', 'af', 'ak', 'am', 'an', 'ar', 'as', 'av', 'ay', 'az', 'ba', 'be', 'bg', 'bi', 'bm', 'bn', 'bo', 'br', 'bs', 'ca', 'ce', 'ch', 'co', 'cr', 'cs', 'cu', 'cv', 'cy', 'da', 'de', 'dv', 'dz', 'ee', 'el', 'en', 'eo', 'es', 'et', 'eu', 'fa', 'ff', 'fi', 'fj', 'fo', 'fr', 'fy', 'ga', 'gd', 'gl', 'gn', 'gu', 'gv', 'ha', 'he', 'hi', 'ho', 'hr', 'ht', 'hu', 'hy', 'hz', 'ia', 'id', 'ie', 'ig', 'ii', 'ik', 'io', 'is', 'it', 'iu', 'ja', 'jv', 'ka', 'kg', 'ki', 'kj', 'kk', 'kl', 'km', 'kn', 'ko', 'kr', 'ks', 'ku', 'kv', 'kw', 'ky', 'la', 'lb', 'lg', 'li', 'ln', 'lo', 'lt', 'lu', 'lv', 'mg', 'mh', 'mi', 'mk', 'ml', 'mn', 'mr', 'ms', 'mt', 'my', 'na', 'nb', 'nd', 'ne', 'ng', 'nl', 'nn', 'no', 'nr', 'nv', 'ny', 'oc', 'oj', 'om', 'or', 'os', 'pa', 'pi', 'pl', 'ps', 'pt', 'qu', 'rm', 'rn', 'ro', 'ru', 'rw', 'sa', 'sc', 'sd', 'se', 'sg', 'si', 'sk', 'sl', 'sm', 'sn', 'so', 'sq', 'sr', 'ss', 'st', 'su', 'sv', 'sw', 'ta', 'te', 'tg', 'th', 'ti', 'tk', 'tl', 'tn', 'to', 'tr', 'ts', 'tt', 'tw', 'ty', 'ug', 'uk', 'ur', 'uz', 've', 'vi', 'vo', 'wa', 'wo', 'xh', 'yi', 'yo', 'za', 'zh', 'zu']):
            raise ValueError("must be one of enum values ('aa', 'ab', 'ae', 'af', 'ak', 'am', 'an', 'ar', 'as', 'av', 'ay', 'az', 'ba', 'be', 'bg', 'bi', 'bm', 'bn', 'bo', 'br', 'bs', 'ca', 'ce', 'ch', 'co', 'cr', 'cs', 'cu', 'cv', 'cy', 'da', 'de', 'dv', 'dz', 'ee', 'el', 'en', 'eo', 'es', 'et', 'eu', 'fa', 'ff', 'fi', 'fj', 'fo', 'fr', 'fy', 'ga', 'gd', 'gl', 'gn', 'gu', 'gv', 'ha', 'he', 'hi', 'ho', 'hr', 'ht', 'hu', 'hy', 'hz', 'ia', 'id', 'ie', 'ig', 'ii', 'ik', 'io', 'is', 'it', 'iu', 'ja', 'jv', 'ka', 'kg', 'ki', 'kj', 'kk', 'kl', 'km', 'kn', 'ko', 'kr', 'ks', 'ku', 'kv', 'kw', 'ky', 'la', 'lb', 'lg', 'li', 'ln', 'lo', 'lt', 'lu', 'lv', 'mg', 'mh', 'mi', 'mk', 'ml', 'mn', 'mr', 'ms', 'mt', 'my', 'na', 'nb', 'nd', 'ne', 'ng', 'nl', 'nn', 'no', 'nr', 'nv', 'ny', 'oc', 'oj', 'om', 'or', 'os', 'pa', 'pi', 'pl', 'ps', 'pt', 'qu', 'rm', 'rn', 'ro', 'ru', 'rw', 'sa', 'sc', 'sd', 'se', 'sg', 'si', 'sk', 'sl', 'sm', 'sn', 'so', 'sq', 'sr', 'ss', 'st', 'su', 'sv', 'sw', 'ta', 'te', 'tg', 'th', 'ti', 'tk', 'tl', 'tn', 'to', 'tr', 'ts', 'tt', 'tw', 'ty', 'ug', 'uk', 'ur', 'uz', 've', 'vi', 'vo', 'wa', 'wo', 'xh', 'yi', 'yo', 'za', 'zh', 'zu')")
        return value

    @field_validator('type')
    def type_validate_enum(cls, value):
        """Validates the enum"""
        if value is None:
            return value

        if value not in set(['SUJET', 'FAMILLE', 'TIERS', 'POMPIER', 'AMBULANC', 'AMBULANC.AASC', 'AMBULANC.AUTRESEC', 'SECOUR', 'MED', 'MED.MEDSOS', 'MED.MRL', 'MED.EFFML', 'SANTE', 'SANTE.INF', 'SANTE.AIDESOIN', 'SANTE.SF', 'SANTE.AIDEDOM', 'SANTE.PHARMA', 'SANTE.DENTISTE', 'SANTE.LABO', 'FDO-MILI', 'FDO-MILI.POL', 'FDO-MILI.GENDARM', 'FDO-MILI.MILI', 'ADM-TUTL', 'VIP', 'OBJCONNC', 'AUTRE', 'INCONNU']):
            raise ValueError("must be one of enum values ('SUJET', 'FAMILLE', 'TIERS', 'POMPIER', 'AMBULANC', 'AMBULANC.AASC', 'AMBULANC.AUTRESEC', 'SECOUR', 'MED', 'MED.MEDSOS', 'MED.MRL', 'MED.EFFML', 'SANTE', 'SANTE.INF', 'SANTE.AIDESOIN', 'SANTE.SF', 'SANTE.AIDEDOM', 'SANTE.PHARMA', 'SANTE.DENTISTE', 'SANTE.LABO', 'FDO-MILI', 'FDO-MILI.POL', 'FDO-MILI.GENDARM', 'FDO-MILI.MILI', 'ADM-TUTL', 'VIP', 'OBJCONNC', 'AUTRE', 'INCONNU')")
        return value

    @field_validator('communication')
    def communication_validate_enum(cls, value):
        """Validates the enum"""
        if value is None:
            return value

        if value not in set(['AUCUNE', 'MUET', 'VISION', 'LANGUE', 'PANIQUE', 'HOSTILE', 'AGITE', 'AUTRE', 'IMPOSS']):
            raise ValueError("must be one of enum values ('AUCUNE', 'MUET', 'VISION', 'LANGUE', 'PANIQUE', 'HOSTILE', 'AGITE', 'AUTRE', 'IMPOSS')")
        return value

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of Caller from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of caller_contact
        if self.caller_contact:
            _dict['callerContact'] = self.caller_contact.to_dict()
        # override the default output from pydantic by calling `to_dict()` of callback_contact
        if self.callback_contact:
            _dict['callbackContact'] = self.callback_contact.to_dict()
        # override the default output from pydantic by calling `to_dict()` of detailed_name
        if self.detailed_name:
            _dict['detailedName'] = self.detailed_name.to_dict()
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of Caller from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "callerContact": Contact.from_dict(obj["callerContact"]) if obj.get("callerContact") is not None else None,
            "callbackContact": Contact.from_dict(obj["callbackContact"]) if obj.get("callbackContact") is not None else None,
            "language": obj.get("language"),
            "type": obj.get("type"),
            "communication": obj.get("communication"),
            "freetext": obj.get("freetext"),
            "detailedName": DetailedName.from_dict(obj["detailedName"]) if obj.get("detailedName") is not None else None
        })
        return _obj


