# coding: utf-8

"""
    OpenAPI

    OpenAPI

    The version of the OpenAPI document: 0.0.1
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictStr, field_validator
from typing import Any, ClassVar, Dict, List, Optional
from typing import Optional, Set
from typing_extensions import Self

class CaseDetails(BaseModel):
    """
    CaseDetails
    """ # noqa: E501
    status: Optional[StrictStr] = Field(default=None, description="A valoriser avec l'état du dossier dans le système émetteur Spécificité 15-15 : peut être ignoré en réception, partagé à titre indicatif uniquement Spécificité 15-SMUR : à utiliser à minima pour transmettre le statut CLOTURE à la tablette")
    attribution: Optional[StrictStr] = Field(default=None, description="Décrit le type de professionnel médical à qui le dossier est attribué : médecin généraliste, médecin urgentiste etc.")
    priority: Optional[StrictStr] = Field(default=None, description="Décrit la priorité de régulation médicale du dossier : P0, P1, P2, P3")
    care_level: Optional[StrictStr] = Field(default=None, description="Décrit le niveau de soins global du dossier identifié au cours de l'acte de régulation médicale : s'il y a plusieurs niveaux de soins différents pour chaque patient, on indique ici le niveau le plus grave. cf.nomenclature associée.", alias="careLevel")
    __properties: ClassVar[List[str]] = ["status", "attribution", "priority", "careLevel"]

    @field_validator('status')
    def status_validate_enum(cls, value):
        """Validates the enum"""
        if value is None:
            return value

        if value not in set(['PROGRAM', 'ACTIF', 'ACHEVE', 'VALIDE', 'CLOTURE', 'CLASSE', 'ARCHIVE']):
            raise ValueError("must be one of enum values ('PROGRAM', 'ACTIF', 'ACHEVE', 'VALIDE', 'CLOTURE', 'CLASSE', 'ARCHIVE')")
        return value

    @field_validator('attribution')
    def attribution_validate_enum(cls, value):
        """Validates the enum"""
        if value is None:
            return value

        if value not in set(['DRM', 'DRM.MRU', 'DRM.MRU.MU', 'DRM.MRU.INDISPMU', 'DRM.MRU.SSE', 'DRM.MRU.PLANBLAN', 'DRM.MRU.PCSAMU', 'DRM.SPE', 'DRM.SPE.DENT', 'DRM.SPE.GERIA', 'DRM.SPE.PEDIA', 'DRM.SPE.OBST', 'DRM.SPE.PSY', 'DRM.SPE.TOXICOL', 'DRM.SPE.AUTRESPE', 'DRM.MRL', 'DRM.MRL.MG', 'DRM.MRL.INDISPMG', 'DRM.MRL.ABSML', 'DR', 'DR.DREG', 'DR.DREG.DRARM', 'DR.DREG.DRDAC', 'DR.DREG.DRMED', 'DR.DREG.DRPHARMA', 'DR.DREG.DRDENT', 'DR.DREG.DRINFO', 'DR.DREG.DOS-SIS', 'DR.DREG.DOS-FDO', 'D', 'D.D-MALV', 'D.D-MALV.ERR', 'D.D-MALV.NRP', 'D.D-MALV.MALV', 'D.D-MALV.FAX', 'D.D-MALV.ITERATIF', 'D.D-IDENT', 'D.D-IDENT.ADMIN', 'D.D-IDENT.PERSO', 'D.D-IDENT.AUTRE']):
            raise ValueError("must be one of enum values ('DRM', 'DRM.MRU', 'DRM.MRU.MU', 'DRM.MRU.INDISPMU', 'DRM.MRU.SSE', 'DRM.MRU.PLANBLAN', 'DRM.MRU.PCSAMU', 'DRM.SPE', 'DRM.SPE.DENT', 'DRM.SPE.GERIA', 'DRM.SPE.PEDIA', 'DRM.SPE.OBST', 'DRM.SPE.PSY', 'DRM.SPE.TOXICOL', 'DRM.SPE.AUTRESPE', 'DRM.MRL', 'DRM.MRL.MG', 'DRM.MRL.INDISPMG', 'DRM.MRL.ABSML', 'DR', 'DR.DREG', 'DR.DREG.DRARM', 'DR.DREG.DRDAC', 'DR.DREG.DRMED', 'DR.DREG.DRPHARMA', 'DR.DREG.DRDENT', 'DR.DREG.DRINFO', 'DR.DREG.DOS-SIS', 'DR.DREG.DOS-FDO', 'D', 'D.D-MALV', 'D.D-MALV.ERR', 'D.D-MALV.NRP', 'D.D-MALV.MALV', 'D.D-MALV.FAX', 'D.D-MALV.ITERATIF', 'D.D-IDENT', 'D.D-IDENT.ADMIN', 'D.D-IDENT.PERSO', 'D.D-IDENT.AUTRE')")
        return value

    @field_validator('priority')
    def priority_validate_enum(cls, value):
        """Validates the enum"""
        if value is None:
            return value

        if value not in set(['P0', 'P1', 'P2', 'P3', 'NR']):
            raise ValueError("must be one of enum values ('P0', 'P1', 'P2', 'P3', 'NR')")
        return value

    @field_validator('care_level')
    def care_level_validate_enum(cls, value):
        """Validates the enum"""
        if value is None:
            return value

        if value not in set(['R1', 'R2', 'R3', 'R4']):
            raise ValueError("must be one of enum values ('R1', 'R2', 'R3', 'R4')")
        return value

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of CaseDetails from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of CaseDetails from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "status": obj.get("status"),
            "attribution": obj.get("attribution"),
            "priority": obj.get("priority"),
            "careLevel": obj.get("careLevel")
        })
        return _obj


