# coding: utf-8

"""
    OpenAPI

    OpenAPI

    The version of the OpenAPI document: 0.0.1
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from datetime import datetime
from pydantic import BaseModel, ConfigDict, Field, StrictStr, field_validator
from typing import Any, ClassVar, Dict, List, Optional
from typing_extensions import Annotated
from hubsante_model.resources.info.models.contact import Contact
from hubsante_model.resources.info.models.state import State
from hubsante_model.resources.info.models.team import Team
from typing import Optional, Set
from typing_extensions import Self

class Resource(BaseModel):
    """
    Resource
    """ # noqa: E501
    datetime: str = Field(description="A valoriser avec la date et heure d'engagement de la ressource/du vecteur")
    resource_id: Annotated[str, Field(strict=True)] = Field(description="A valoriser avec l'identifiant partagé unique de la ressource engagée, normé comme suit : {orgID}.resource.{ID unique de la ressource partagée} OU - uniquement dans le cas où un ID unique de ressource ne peut pas être garanti par l'organisation propriétaire : {orgID}.resource.{sendercaseId}.{n° d’ordre chronologique de la ressource}", alias="resourceId")
    request_id: Optional[Annotated[str, Field(strict=True)]] = Field(default=None, description="A valoriser avec l'identifiant unique partagé de la demande de ressource (si la ressource a été engagée suite à une demande de ressource), normé comme suit : {orgID}.request.{ID unique de la demande dans le système émetteur} OU - si un ID unique de la demande n'était pas disponible :  {OrgId émetteur}.request.{senderCaseId}.{numéro d’ordre chronologique}", alias="requestId")
    mission_id: Optional[StrictStr] = Field(default=None, description="A valoriser avec le numéro de mission unique du central d’appel (PSAP, …) qui a déclenché le vecteur", alias="missionId")
    org_id: Optional[StrictStr] = Field(default=None, description="A valoriser avec l'identifiant de l'organisation à laquelle appartient la ressource, normé comme suit :  {pays}.{domaine}.{organisation}", alias="orgId")
    patient_id: Optional[StrictStr] = Field(default=None, description="Identifiant partagé du patient qui est transporté. Ce n'est à remplir que lorsque l'on sait quel vecteur transporte quel patient.  Il est valorisé comme suit lors de sa création :  {OrgId émetteur}.patient.{n°patient unique dans le système émetteur}  OU, si un n°patient unique n'existe pas dans le système émetteur : {ID émetteur}.{senderCaseId}.patient.{numéro d’ordre chronologique au dossier}", alias="patientId")
    center_name: Optional[StrictStr] = Field(default=None, description="A valoriser avec le lieu de garage principal", alias="centerName")
    vehicle_type: StrictStr = Field(description="A valoriser avec le type de vecteur mobilisé : cf. nomenclature associée", alias="vehicleType")
    name: Optional[StrictStr] = Field(default=None, description="A valoriser avec le nom donné à la ressource par l’organisation d’appartenance")
    center_city: Optional[Annotated[str, Field(strict=True)]] = Field(default=None, description="A valoriser avec le code INSEE de la commune du centre d'affectation", alias="centerCity")
    team: Optional[Team] = None
    state: Optional[List[State]] = None
    contact: Optional[Contact] = None
    freetext: Optional[List[StrictStr]] = None
    __properties: ClassVar[List[str]] = ["datetime", "resourceId", "requestId", "missionId", "orgId", "patientId", "centerName", "vehicleType", "name", "centerCity", "team", "state", "contact", "freetext"]

    @field_validator('datetime')
    def datetime_validate_regular_expression(cls, value):
        """Validates the regular expression"""
        if not re.match(r"^\d{4}-\d{2}-\d{2}T\d{2}:\d{2}:\d{2}[\-+]\d{2}:\d{2}$", value):
            raise ValueError(r"must validate the regular expression /^\d{4}-\d{2}-\d{2}T\d{2}:\d{2}:\d{2}[\-+]\d{2}:\d{2}$/")
        return value

    @field_validator('resource_id')
    def resource_id_validate_regular_expression(cls, value):
        """Validates the regular expression"""
        if not re.match(r"^([\w-]+\.){3,8}resource(\.[\w-]+){1,2}$", value):
            raise ValueError(r"must validate the regular expression /^([\w-]+\.){3,8}resource(\.[\w-]+){1,2}$/")
        return value

    @field_validator('request_id')
    def request_id_validate_regular_expression(cls, value):
        """Validates the regular expression"""
        if value is None:
            return value

        if not re.match(r"^([\w-]+\.){3,8}request(\.[\w-]+){1,2}$", value):
            raise ValueError(r"must validate the regular expression /^([\w-]+\.){3,8}request(\.[\w-]+){1,2}$/")
        return value

    @field_validator('vehicle_type')
    def vehicle_type_validate_enum(cls, value):
        """Validates the enum"""
        if value not in set(['AASC', 'AASC.VLSC', 'AASC.VPSP', 'AASC.AUTRESC', 'AUTREVEC', 'AUTREVEC.APIED', 'AUTREVEC.AVION', 'AUTREVEC.PERSO', 'AUTREVEC.TAXI', 'AUTREVEC.TRAIN', 'AUTREVEC.TRANSP', 'AUTREVEC.AUTRE', 'AUTREVEC.AUTRETRA', 'FSI', 'FSI.HELIFSI', 'FSI.VLFSI', 'FSI.FFSI', 'FSI.VHFSI', 'LIB', 'LIB.MEDV', 'LIB.INF', 'LIB.AUTREPRO', 'SIS', 'SIS.DRAGON', 'SIS.AVSC', 'SIS.FEUSIS', 'SIS.GRIMP', 'SIS.NAVISIS', 'SIS.PCSIS', 'SIS.SRSIS', 'SIS.VCH', 'SIS.VLCG', 'SIS.VLISP', 'SIS.VLMSP', 'SIS.VLSIS', 'SIS.VPL', 'SIS.VPMA', 'SIS.VR', 'SIS.VSAV', 'SIS.MOYSSE', 'SIS.AUTRESIS', 'SMUR', 'SMUR.VLM', 'SMUR.VL', 'SMUR.PSM1', 'SMUR.PSM2', 'SMUR.PSM3', 'SMUR.PSMP', 'SMUR.VPC', 'SMUR.AR', 'SMUR.AR-BAR', 'SMUR.AR-PED', 'SMUR.HELISMUR', 'SMUR.HELISAN', 'SMUR.AVSMUR', 'SMUR.AVSAN', 'SMUR.NAVISMUR', 'TSU', 'TSU.VSL', 'TSU.AMB-GV', 'TSU.AMB-PV', 'TSU.AMB-BAR', 'TSU.AMB']):
            raise ValueError("must be one of enum values ('AASC', 'AASC.VLSC', 'AASC.VPSP', 'AASC.AUTRESC', 'AUTREVEC', 'AUTREVEC.APIED', 'AUTREVEC.AVION', 'AUTREVEC.PERSO', 'AUTREVEC.TAXI', 'AUTREVEC.TRAIN', 'AUTREVEC.TRANSP', 'AUTREVEC.AUTRE', 'AUTREVEC.AUTRETRA', 'FSI', 'FSI.HELIFSI', 'FSI.VLFSI', 'FSI.FFSI', 'FSI.VHFSI', 'LIB', 'LIB.MEDV', 'LIB.INF', 'LIB.AUTREPRO', 'SIS', 'SIS.DRAGON', 'SIS.AVSC', 'SIS.FEUSIS', 'SIS.GRIMP', 'SIS.NAVISIS', 'SIS.PCSIS', 'SIS.SRSIS', 'SIS.VCH', 'SIS.VLCG', 'SIS.VLISP', 'SIS.VLMSP', 'SIS.VLSIS', 'SIS.VPL', 'SIS.VPMA', 'SIS.VR', 'SIS.VSAV', 'SIS.MOYSSE', 'SIS.AUTRESIS', 'SMUR', 'SMUR.VLM', 'SMUR.VL', 'SMUR.PSM1', 'SMUR.PSM2', 'SMUR.PSM3', 'SMUR.PSMP', 'SMUR.VPC', 'SMUR.AR', 'SMUR.AR-BAR', 'SMUR.AR-PED', 'SMUR.HELISMUR', 'SMUR.HELISAN', 'SMUR.AVSMUR', 'SMUR.AVSAN', 'SMUR.NAVISMUR', 'TSU', 'TSU.VSL', 'TSU.AMB-GV', 'TSU.AMB-PV', 'TSU.AMB-BAR', 'TSU.AMB')")
        return value

    @field_validator('center_city')
    def center_city_validate_regular_expression(cls, value):
        """Validates the regular expression"""
        if value is None:
            return value

        if not re.match(r"^[0-9]{5}$", value):
            raise ValueError(r"must validate the regular expression /^[0-9]{5}$/")
        return value

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of Resource from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of team
        if self.team:
            _dict['team'] = self.team.to_dict()
        # override the default output from pydantic by calling `to_dict()` of each item in state (list)
        _items = []
        if self.state:
            for _item_state in self.state:
                if _item_state:
                    _items.append(_item_state.to_dict())
            _dict['state'] = _items
        # override the default output from pydantic by calling `to_dict()` of contact
        if self.contact:
            _dict['contact'] = self.contact.to_dict()
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of Resource from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "datetime": obj.get("datetime"),
            "resourceId": obj.get("resourceId"),
            "requestId": obj.get("requestId"),
            "missionId": obj.get("missionId"),
            "orgId": obj.get("orgId"),
            "patientId": obj.get("patientId"),
            "centerName": obj.get("centerName"),
            "vehicleType": obj.get("vehicleType"),
            "name": obj.get("name"),
            "centerCity": obj.get("centerCity"),
            "team": Team.from_dict(obj["team"]) if obj.get("team") is not None else None,
            "state": [State.from_dict(_item) for _item in obj["state"]] if obj.get("state") is not None else None,
            "contact": Contact.from_dict(obj["contact"]) if obj.get("contact") is not None else None,
            "freetext": obj.get("freetext")
        })
        return _obj


