# coding: utf-8

"""
    OpenAPI

    OpenAPI

    The version of the OpenAPI document: 0.0.1
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from datetime import datetime
from pydantic import BaseModel, ConfigDict, Field, StrictStr, field_validator
from typing import Any, ClassVar, Dict, List, Optional
from typing_extensions import Annotated
from typing import Optional, Set
from typing_extensions import Self

class Request(BaseModel):
    """
    Request
    """ # noqa: E501
    request_id: Annotated[str, Field(strict=True)] = Field(description="Identifiant unique partagé de la demande de ressource,  généré une seule fois par le système du partenaire qui émet la demande  Il est valorisé comme suit lors de sa création :  {orgID}.request.{ID unique de la demande dans le système émetteur}  OU - uniquement si un ID unique de la demande n'est pas disponible :  {OrgId émetteur}.request.{senderCaseId}.{numéro d’ordre chronologique}", alias="requestId")
    datetime: str = Field(description="A valoriser avec le groupe date heure de création de la demande")
    convention: Optional[StrictStr] = Field(default=None, description="A valoriser avec le cadre conventionnel de la demande. Cf nomenclature associée")
    purpose: StrictStr = Field(description="A valoriser avec le motif de la demande de ressource auprès du partenaire. Cf Nomenclature associée.")
    deadline: Optional[StrictStr] = Field(default=None, description="A valoriser avec le délai d'intervention maximum souhaité (cf. nomenclature associée)")
    freetext: Optional[StrictStr] = Field(default=None, description="Texte libre permettant de détailler la demande")
    __properties: ClassVar[List[str]] = ["requestId", "datetime", "convention", "purpose", "deadline", "freetext"]

    @field_validator('request_id')
    def request_id_validate_regular_expression(cls, value):
        """Validates the regular expression"""
        if not re.match(r"^([\w-]+\.){3,8}request(\.[\w-]+){1,2}$", value):
            raise ValueError(r"must validate the regular expression /^([\w-]+\.){3,8}request(\.[\w-]+){1,2}$/")
        return value

    @field_validator('datetime')
    def datetime_validate_regular_expression(cls, value):
        """Validates the regular expression"""
        if not re.match(r"^\d{4}-\d{2}-\d{2}T\d{2}:\d{2}:\d{2}[\-+]\d{2}:\d{2}$", value):
            raise ValueError(r"must validate the regular expression /^\d{4}-\d{2}-\d{2}T\d{2}:\d{2}:\d{2}[\-+]\d{2}:\d{2}$/")
        return value

    @field_validator('convention')
    def convention_validate_enum(cls, value):
        """Validates the enum"""
        if value is None:
            return value

        if value not in set(['DRSIS', 'MISSION', 'ITSP', 'CARENCE', 'CONVENT', 'SPE', 'HORS', 'AUTRE1', 'AUTRE2', 'AUTRE3']):
            raise ValueError("must be one of enum values ('DRSIS', 'MISSION', 'ITSP', 'CARENCE', 'CONVENT', 'SPE', 'HORS', 'AUTRE1', 'AUTRE2', 'AUTRE3')")
        return value

    @field_validator('purpose')
    def purpose_validate_enum(cls, value):
        """Validates the enum"""
        if value not in set(['SAP', 'REGUL', 'CUMP', 'SMUR', 'MG', 'PARAMED', 'SAMU', 'RELEVE', 'NOVI', 'TIH', 'BRANCARD', 'BARIA']):
            raise ValueError("must be one of enum values ('SAP', 'REGUL', 'CUMP', 'SMUR', 'MG', 'PARAMED', 'SAMU', 'RELEVE', 'NOVI', 'TIH', 'BRANCARD', 'BARIA')")
        return value

    @field_validator('deadline')
    def deadline_validate_enum(cls, value):
        """Validates the enum"""
        if value is None:
            return value

        if value not in set(['DEL0', 'ASAP', '30M', '45M', '1H', '2H', '4H', '8H', '12H', '24H', 'RDV']):
            raise ValueError("must be one of enum values ('DEL0', 'ASAP', '30M', '45M', '1H', '2H', '4H', '8H', '12H', '24H', 'RDV')")
        return value

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of Request from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of Request from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "requestId": obj.get("requestId"),
            "datetime": obj.get("datetime"),
            "convention": obj.get("convention"),
            "purpose": obj.get("purpose"),
            "deadline": obj.get("deadline"),
            "freetext": obj.get("freetext")
        })
        return _obj


