# coding: utf-8

"""
    OpenAPI

    OpenAPI

    The version of the OpenAPI document: 0.0.1
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from datetime import datetime
from pydantic import BaseModel, ConfigDict, Field, StrictStr, field_validator
from typing import Any, ClassVar, Dict, List, Optional
from typing import Optional, Set
from typing_extensions import Self

class Response(BaseModel):
    """
    Response
    """ # noqa: E501
    datetime: str = Field(description="Groupe date heure de début de la demande")
    answer: StrictStr = Field(description="A valoriser avec la réponse apportée. Cf Nomenclature associée ACCEPTEE, REFUSEE, PARTIELLE, DIFFEREE")
    deadline: Optional[StrictStr] = Field(default=None, description="A valoriser avec le délai de réponse auquel s'engage l'expéditeur (cf. nomenclature)  Cas particulier : en cas de réponse \"Partielle\" car le délai souhaité ne peut pas être respecté,  à valoriser obligatoirement avec le délai de réponse maximum auquel s'engage l'expéditeur de la réponse, ")
    freetext: Optional[StrictStr] = Field(default=None, description="Commentaire libre permettant d'apporter toutes précisions utiles à la réponse. Le motif de refus est notifié dans ce champ.")
    __properties: ClassVar[List[str]] = ["datetime", "answer", "deadline", "freetext"]

    @field_validator('datetime')
    def datetime_validate_regular_expression(cls, value):
        """Validates the regular expression"""
        if not re.match(r"^\d{4}-\d{2}-\d{2}T\d{2}:\d{2}:\d{2}[\-+]\d{2}:\d{2}$", value):
            raise ValueError(r"must validate the regular expression /^\d{4}-\d{2}-\d{2}T\d{2}:\d{2}:\d{2}[\-+]\d{2}:\d{2}$/")
        return value

    @field_validator('answer')
    def answer_validate_enum(cls, value):
        """Validates the enum"""
        if value not in set(['ACCEPTEE', 'PARTIELLE', 'REFUSEE', 'DIFFEREE']):
            raise ValueError("must be one of enum values ('ACCEPTEE', 'PARTIELLE', 'REFUSEE', 'DIFFEREE')")
        return value

    @field_validator('deadline')
    def deadline_validate_enum(cls, value):
        """Validates the enum"""
        if value is None:
            return value

        if value not in set(['DEL0', 'ASAP', '30M', '45M', '1H', '2H', '4H', '8H', '12H', '24H', 'RDV']):
            raise ValueError("must be one of enum values ('DEL0', 'ASAP', '30M', '45M', '1H', '2H', '4H', '8H', '12H', '24H', 'RDV')")
        return value

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of Response from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of Response from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "datetime": obj.get("datetime"),
            "answer": obj.get("answer"),
            "deadline": obj.get("deadline"),
            "freetext": obj.get("freetext")
        })
        return _obj


