# coding: utf-8

"""
    OpenAPI

    OpenAPI

    The version of the OpenAPI document: 0.0.1
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictStr, field_validator
from typing import Any, ClassVar, Dict, List
from typing import Optional, Set
from typing_extensions import Self

class Decision(BaseModel):
    """
    Decision
    """ # noqa: E501
    resource_type: StrictStr = Field(description="Précise le type de moyen engagé dans l'intervention (SMUR, TSU, HOSPIT, etc.).  A valoriser par un code de la nomenclature SI-SAMU-TYPE_MOYEN.", alias="resourceType")
    vehicle_type: StrictStr = Field(description="Précise le type de véhicule terrestre / aérien / maritime engagé dans l'intervention. A valoriser par un code de la nomenclature SI-SAMU-TYPE_VECTEUR.", alias="vehicleType")
    medical_level: StrictStr = Field(description="Type d’équipe (médical, paramédicale, secouriste). A valoriser par un code de la nomenclature SI-SAMU-NIVSOIN.", alias="medicalLevel")
    __properties: ClassVar[List[str]] = ["resourceType", "vehicleType", "medicalLevel"]

    @field_validator('resource_type')
    def resource_type_validate_enum(cls, value):
        """Validates the enum"""
        if value not in set(['SMUR', 'SMUR.ADULT', 'SMUR.PED', 'SMUR.UMH-S', 'SMUR.CUMP', 'HOSPIT', 'LIBERAL', 'LIBERAL.MG', 'LIBERAL.PHARM', 'LIBERAL.INF', 'LIBERAL.KINE', 'LIBERAL.SOS', 'LIBERAL.MMG', 'LIBERAL.MSPD', 'LIBERAL.MCS', 'LIBERAL.SPEMED', 'LIBERAL.DENT', 'LIBERAL.LABO', 'LIBERAL.AUTREPRO', 'TSU', 'SIS', 'SIS.MEDSP', 'SIS.ISP', 'SIS.SP', 'AASC', 'FDO', 'FDO.PN', 'FDO.GEND', 'FDO.PM', 'FDO.DOUANES', 'AUTRE', 'AUTRE.ADM', 'AUTRE.DAE', 'AUTRE.AUTRE']):
            raise ValueError("must be one of enum values ('SMUR', 'SMUR.ADULT', 'SMUR.PED', 'SMUR.UMH-S', 'SMUR.CUMP', 'HOSPIT', 'LIBERAL', 'LIBERAL.MG', 'LIBERAL.PHARM', 'LIBERAL.INF', 'LIBERAL.KINE', 'LIBERAL.SOS', 'LIBERAL.MMG', 'LIBERAL.MSPD', 'LIBERAL.MCS', 'LIBERAL.SPEMED', 'LIBERAL.DENT', 'LIBERAL.LABO', 'LIBERAL.AUTREPRO', 'TSU', 'SIS', 'SIS.MEDSP', 'SIS.ISP', 'SIS.SP', 'AASC', 'FDO', 'FDO.PN', 'FDO.GEND', 'FDO.PM', 'FDO.DOUANES', 'AUTRE', 'AUTRE.ADM', 'AUTRE.DAE', 'AUTRE.AUTRE')")
        return value

    @field_validator('vehicle_type')
    def vehicle_type_validate_enum(cls, value):
        """Validates the enum"""
        if value not in set(['AASC', 'AASC.VLSC', 'AASC.VPSP', 'AASC.AUTRESC', 'AUTREVEC', 'AUTREVEC.APIED', 'AUTREVEC.AVION', 'AUTREVEC.PERSO', 'AUTREVEC.TAXI', 'AUTREVEC.TRAIN', 'AUTREVEC.TRANSP', 'AUTREVEC.AUTRE', 'AUTREVEC.AUTRETRA', 'FSI', 'FSI.HELIFSI', 'FSI.VLFSI', 'FSI.FFSI', 'FSI.VHFSI', 'LIB', 'LIB.MEDV', 'LIB.INF', 'LIB.AUTREPRO', 'SIS', 'SIS.DRAGON', 'SIS.AVSC', 'SIS.FEUSIS', 'SIS.GRIMP', 'SIS.NAVISIS', 'SIS.PCSIS', 'SIS.SRSIS', 'SIS.VCH', 'SIS.VLCG', 'SIS.VLISP', 'SIS.VLMSP', 'SIS.VLSIS', 'SIS.VPL', 'SIS.VPMA', 'SIS.VR', 'SIS.VSAV', 'SIS.MOYSSE', 'SIS.AUTRESIS', 'SMUR', 'SMUR.VLM', 'SMUR.VL', 'SMUR.PSM1', 'SMUR.PSM2', 'SMUR.PSM3', 'SMUR.PSMP', 'SMUR.VPC', 'SMUR.AR', 'SMUR.AR-BAR', 'SMUR.AR-PED', 'SMUR.HELISMUR', 'SMUR.HELISAN', 'SMUR.AVSMUR', 'SMUR.AVSAN', 'SMUR.NAVISMUR', 'TSU', 'TSU.VSL', 'TSU.AMB-GV', 'TSU.AMB-PV', 'TSU.AMB-BAR', 'TSU.AMB']):
            raise ValueError("must be one of enum values ('AASC', 'AASC.VLSC', 'AASC.VPSP', 'AASC.AUTRESC', 'AUTREVEC', 'AUTREVEC.APIED', 'AUTREVEC.AVION', 'AUTREVEC.PERSO', 'AUTREVEC.TAXI', 'AUTREVEC.TRAIN', 'AUTREVEC.TRANSP', 'AUTREVEC.AUTRE', 'AUTREVEC.AUTRETRA', 'FSI', 'FSI.HELIFSI', 'FSI.VLFSI', 'FSI.FFSI', 'FSI.VHFSI', 'LIB', 'LIB.MEDV', 'LIB.INF', 'LIB.AUTREPRO', 'SIS', 'SIS.DRAGON', 'SIS.AVSC', 'SIS.FEUSIS', 'SIS.GRIMP', 'SIS.NAVISIS', 'SIS.PCSIS', 'SIS.SRSIS', 'SIS.VCH', 'SIS.VLCG', 'SIS.VLISP', 'SIS.VLMSP', 'SIS.VLSIS', 'SIS.VPL', 'SIS.VPMA', 'SIS.VR', 'SIS.VSAV', 'SIS.MOYSSE', 'SIS.AUTRESIS', 'SMUR', 'SMUR.VLM', 'SMUR.VL', 'SMUR.PSM1', 'SMUR.PSM2', 'SMUR.PSM3', 'SMUR.PSMP', 'SMUR.VPC', 'SMUR.AR', 'SMUR.AR-BAR', 'SMUR.AR-PED', 'SMUR.HELISMUR', 'SMUR.HELISAN', 'SMUR.AVSMUR', 'SMUR.AVSAN', 'SMUR.NAVISMUR', 'TSU', 'TSU.VSL', 'TSU.AMB-GV', 'TSU.AMB-PV', 'TSU.AMB-BAR', 'TSU.AMB')")
        return value

    @field_validator('medical_level')
    def medical_level_validate_enum(cls, value):
        """Validates the enum"""
        if value not in set(['MED', 'PARAMED', 'SECOURS', 'SANS']):
            raise ValueError("must be one of enum values ('MED', 'PARAMED', 'SECOURS', 'SANS')")
        return value

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of Decision from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of Decision from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "resourceType": obj.get("resourceType"),
            "vehicleType": obj.get("vehicleType"),
            "medicalLevel": obj.get("medicalLevel")
        })
        return _obj


