# coding: utf-8

"""
    OpenAPI

    OpenAPI

    The version of the OpenAPI document: 0.0.1
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from datetime import datetime
from pydantic import BaseModel, ConfigDict, Field, StrictStr, field_validator
from typing import Any, ClassVar, Dict, List
from typing_extensions import Annotated
from typing import Optional, Set
from typing_extensions import Self

class Event(BaseModel):
    """
    Event
    """ # noqa: E501
    org_id: Annotated[str, Field(strict=True)] = Field(description="Numéro du SAMU régulant la mission SMUR.  A valoriser par fr.health.samuXXX :  {pays}.{domaine}.{organisation} ", alias="orgId")
    sender_case_id: StrictStr = Field(description="Numéro du dossier SAMU à l’origine de la mission SMUR A valoriser par DRFR15DDXAAJJJ00000 :  - DR = désignation d'un dossier sous forme abrégée, - FR : désigne le pays (FR = France), - 15 : désigne le fait que le dossier a été pris en charge par un SAMU / SAS, - DD : désigne le département où est situé le SAMU / SAS qui a traité le dossier, - X : lettre désignant le SAMU / SAS en cas de pluralité de SAMU / SAS sur le même département ou le troisième chiffre des DOM, - AA : année durant laquelle l’appel a été créé, - JJJ : désigne le jour de l'année (de 1j à 365j),\\par - 00000 : numéro d’ordre chronologique du dossier dans la journée de référence ci-dessus.", alias="senderCaseId")
    creation_date: str = Field(description="s'exprime au format ISO 8601 YYY-MM-DDThh:mm:ss", alias="creationDate")
    decision_date: str = Field(description="s'exprime au format ISO 8601 YYY-MM-DDThh:mm:ss", alias="decisionDate")
    ressource_finess_legal: StrictStr = Field(description="FINESS juridique établissement rattachement SMUR", alias="ressourceFinessLegal")
    ressource_finess_geo: StrictStr = Field(description="FINESS géographique établissement rattachement SMUR ou antenne SMUR", alias="ressourceFinessGeo")
    ressource_structure: StrictStr = Field(description="9 = Antenne SMUR, 0 = SMUR général, 1 = SMUR pédiatrique, 2 = SMUR neonatal ", alias="ressourceStructure")
    __properties: ClassVar[List[str]] = ["orgId", "senderCaseId", "creationDate", "decisionDate", "ressourceFinessLegal", "ressourceFinessGeo", "ressourceStructure"]

    @field_validator('org_id')
    def org_id_validate_regular_expression(cls, value):
        """Validates the regular expression"""
        if not re.match(r"^([\w-]+\.?){4,10}$", value):
            raise ValueError(r"must validate the regular expression /^([\w-]+\.?){4,10}$/")
        return value

    @field_validator('creation_date')
    def creation_date_validate_regular_expression(cls, value):
        """Validates the regular expression"""
        if not re.match(r"^\d{4}-\d{2}-\d{2}T\d{2}:\d{2}:\d{2}[\-+]\d{2}:\d{2}$", value):
            raise ValueError(r"must validate the regular expression /^\d{4}-\d{2}-\d{2}T\d{2}:\d{2}:\d{2}[\-+]\d{2}:\d{2}$/")
        return value

    @field_validator('decision_date')
    def decision_date_validate_regular_expression(cls, value):
        """Validates the regular expression"""
        if not re.match(r"^\d{4}-\d{2}-\d{2}T\d{2}:\d{2}:\d{2}[\-+]\d{2}:\d{2}$", value):
            raise ValueError(r"must validate the regular expression /^\d{4}-\d{2}-\d{2}T\d{2}:\d{2}:\d{2}[\-+]\d{2}:\d{2}$/")
        return value

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of Event from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of Event from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "orgId": obj.get("orgId"),
            "senderCaseId": obj.get("senderCaseId"),
            "creationDate": obj.get("creationDate"),
            "decisionDate": obj.get("decisionDate"),
            "ressourceFinessLegal": obj.get("ressourceFinessLegal"),
            "ressourceFinessGeo": obj.get("ressourceFinessGeo"),
            "ressourceStructure": obj.get("ressourceStructure")
        })
        return _obj


