# coding: utf-8

"""
    OpenAPI

    OpenAPI

    The version of the OpenAPI document: 0.0.1
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from datetime import datetime
from pydantic import BaseModel, ConfigDict, Field, field_validator
from typing import Any, ClassVar, Dict, List, Optional
from typing import Optional, Set
from typing_extensions import Self

class ResourceStatus(BaseModel):
    """
    ResourceStatus
    """ # noqa: E501
    depart_smur: str = Field(description="Date et heure à laquelle le SMUR quitte sa base.  s'exprime au format ISO 8601 YYY-MM-DDThh:mm:ss", alias="departSmur")
    arrived_smur: Optional[str] = Field(default=None, description="Date et heure à laquelle le SMUR arrive sur les lieux de l'intervention.  s'exprime au format ISO 8601 YYY-MM-DDThh:mm:ss", alias="arrivedSmur")
    depart_location: Optional[str] = Field(default=None, description="Date et heure à laquelle le SMUR quitte les lieux de l'intervention.  s'exprime au format ISO 8601 YYY-MM-DDThh:mm:ss", alias="departLocation")
    arrived_destination: Optional[str] = Field(default=None, description="Date et heure à laquelle le SMUR qui transporte arrive à destination.  s'exprime au format ISO 8601 YYY-MM-DDThh:mm:ss", alias="arrivedDestination")
    team_available: str = Field(description="Date et heure à laquelle le SMUR est disponible (dispose de tout les équipements pour faire une autre intervention).  s'exprime au format ISO 8601 YYY-MM-DDThh:mm:ss", alias="teamAvailable")
    return_smur: str = Field(description="Date et heure à laquelle le SMUR est de retour à la base.  s'exprime au format ISO 8601 YYY-MM-DDThh:mm:ss", alias="returnSmur")
    __properties: ClassVar[List[str]] = ["departSmur", "arrivedSmur", "departLocation", "arrivedDestination", "teamAvailable", "returnSmur"]

    @field_validator('depart_smur')
    def depart_smur_validate_regular_expression(cls, value):
        """Validates the regular expression"""
        if not re.match(r"^\d{4}-\d{2}-\d{2}T\d{2}:\d{2}:\d{2}[\-+]\d{2}:\d{2}$", value):
            raise ValueError(r"must validate the regular expression /^\d{4}-\d{2}-\d{2}T\d{2}:\d{2}:\d{2}[\-+]\d{2}:\d{2}$/")
        return value

    @field_validator('arrived_smur')
    def arrived_smur_validate_regular_expression(cls, value):
        """Validates the regular expression"""
        if value is None:
            return value

        if not re.match(r"^\d{4}-\d{2}-\d{2}T\d{2}:\d{2}:\d{2}[\-+]\d{2}:\d{2}$", value):
            raise ValueError(r"must validate the regular expression /^\d{4}-\d{2}-\d{2}T\d{2}:\d{2}:\d{2}[\-+]\d{2}:\d{2}$/")
        return value

    @field_validator('depart_location')
    def depart_location_validate_regular_expression(cls, value):
        """Validates the regular expression"""
        if value is None:
            return value

        if not re.match(r"^\d{4}-\d{2}-\d{2}T\d{2}:\d{2}:\d{2}[\-+]\d{2}:\d{2}$", value):
            raise ValueError(r"must validate the regular expression /^\d{4}-\d{2}-\d{2}T\d{2}:\d{2}:\d{2}[\-+]\d{2}:\d{2}$/")
        return value

    @field_validator('arrived_destination')
    def arrived_destination_validate_regular_expression(cls, value):
        """Validates the regular expression"""
        if value is None:
            return value

        if not re.match(r"^\d{4}-\d{2}-\d{2}T\d{2}:\d{2}:\d{2}[\-+]\d{2}:\d{2}$", value):
            raise ValueError(r"must validate the regular expression /^\d{4}-\d{2}-\d{2}T\d{2}:\d{2}:\d{2}[\-+]\d{2}:\d{2}$/")
        return value

    @field_validator('team_available')
    def team_available_validate_regular_expression(cls, value):
        """Validates the regular expression"""
        if not re.match(r"^\d{4}-\d{2}-\d{2}T\d{2}:\d{2}:\d{2}[\-+]\d{2}:\d{2}$", value):
            raise ValueError(r"must validate the regular expression /^\d{4}-\d{2}-\d{2}T\d{2}:\d{2}:\d{2}[\-+]\d{2}:\d{2}$/")
        return value

    @field_validator('return_smur')
    def return_smur_validate_regular_expression(cls, value):
        """Validates the regular expression"""
        if not re.match(r"^\d{4}-\d{2}-\d{2}T\d{2}:\d{2}:\d{2}[\-+]\d{2}:\d{2}$", value):
            raise ValueError(r"must validate the regular expression /^\d{4}-\d{2}-\d{2}T\d{2}:\d{2}:\d{2}[\-+]\d{2}:\d{2}$/")
        return value

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of ResourceStatus from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of ResourceStatus from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "departSmur": obj.get("departSmur"),
            "arrivedSmur": obj.get("arrivedSmur"),
            "departLocation": obj.get("departLocation"),
            "arrivedDestination": obj.get("arrivedDestination"),
            "teamAvailable": obj.get("teamAvailable"),
            "returnSmur": obj.get("returnSmur")
        })
        return _obj


