"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.LockFile = exports.getEsBuildVersion = exports.extractDependencies = exports.exec = exports.findUp = exports.nodeMajorVersion = exports.callsites = void 0;
const child_process_1 = require("child_process");
const fs = require("fs");
const os = require("os");
const path = require("path");
/**
 * Get callsites from the V8 stack trace API
 *
 * https://github.com/sindresorhus/callsites
 */
function callsites() {
    var _a;
    const _prepareStackTrace = Error.prepareStackTrace;
    Error.prepareStackTrace = (_, stack) => stack;
    const stack = (_a = new Error().stack) === null || _a === void 0 ? void 0 : _a.slice(1);
    Error.prepareStackTrace = _prepareStackTrace;
    return stack;
}
exports.callsites = callsites;
/**
 * Returns the major version of node installation
 */
function nodeMajorVersion() {
    return parseInt(process.versions.node.split('.')[0], 10);
}
exports.nodeMajorVersion = nodeMajorVersion;
/**
 * Find a file by walking up parent directories
 */
function findUp(name, directory = process.cwd()) {
    const absoluteDirectory = path.resolve(directory);
    const file = path.join(directory, name);
    if (fs.existsSync(file)) {
        return file;
    }
    const { root } = path.parse(absoluteDirectory);
    if (absoluteDirectory === root) {
        return undefined;
    }
    return findUp(name, path.dirname(absoluteDirectory));
}
exports.findUp = findUp;
/**
 * Spawn sync with error handling
 */
function exec(cmd, args, options) {
    var _a, _b;
    const proc = child_process_1.spawnSync(cmd, args, options);
    if (proc.error) {
        throw proc.error;
    }
    if (proc.status !== 0) {
        if (proc.stdout || proc.stderr) {
            throw new Error(`[Status ${proc.status}] stdout: ${(_a = proc.stdout) === null || _a === void 0 ? void 0 : _a.toString().trim()}\n\n\nstderr: ${(_b = proc.stderr) === null || _b === void 0 ? void 0 : _b.toString().trim()}`);
        }
        throw new Error(`${cmd} exited with status ${proc.status}`);
    }
    return proc;
}
exports.exec = exec;
/**
 * Extract versions for a list of modules.
 *
 * First lookup the version in the package.json and then fallback to requiring
 * the module's package.json. The fallback is needed for transitive dependencies.
 */
function extractDependencies(pkgPath, modules) {
    var _a, _b, _c, _d;
    const dependencies = {};
    // Use require for cache
    const pkgJson = require(pkgPath); // eslint-disable-line @typescript-eslint/no-require-imports
    const pkgDependencies = {
        ...(_a = pkgJson.dependencies) !== null && _a !== void 0 ? _a : {},
        ...(_b = pkgJson.devDependencies) !== null && _b !== void 0 ? _b : {},
        ...(_c = pkgJson.peerDependencies) !== null && _c !== void 0 ? _c : {},
    };
    for (const mod of modules) {
        try {
            // eslint-disable-next-line @typescript-eslint/no-require-imports
            const version = (_d = pkgDependencies[mod]) !== null && _d !== void 0 ? _d : require(`${mod}/package.json`).version;
            dependencies[mod] = version;
        }
        catch (err) {
            throw new Error(`Cannot extract version for module '${mod}'. Check that it's referenced in your package.json or installed.`);
        }
    }
    return dependencies;
}
exports.extractDependencies = extractDependencies;
/**
 * Returns the installed esbuild version
 */
function getEsBuildVersion() {
    try {
        // --no-install ensures that we are checking for an installed version
        // (either locally or globally)
        const npx = os.platform() === 'win32' ? 'npx.cmd' : 'npx';
        const esbuild = child_process_1.spawnSync(npx, ['--no-install', 'esbuild', '--version']);
        if (esbuild.status !== 0 || esbuild.error) {
            return undefined;
        }
        return esbuild.stdout.toString().trim();
    }
    catch (err) {
        return undefined;
    }
}
exports.getEsBuildVersion = getEsBuildVersion;
var LockFile;
(function (LockFile) {
    LockFile["NPM"] = "package-lock.json";
    LockFile["YARN"] = "yarn.lock";
})(LockFile = exports.LockFile || (exports.LockFile = {}));
//# sourceMappingURL=data:application/json;base64,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