"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.constructInfoFromStack = exports.constructInfoFromConstruct = void 0;
const stack_1 = require("../stack");
const stage_1 = require("../stage");
const ALLOWED_FQN_PREFIXES = [
    // SCOPES
    '@aws-cdk/', '@aws-cdk-containers/', '@aws-solutions-konstruk/', '@aws-solutions-constructs/', '@amzn/',
    // PACKAGES
    'aws-rfdk.', 'aws-cdk-lib.', 'monocdk.',
];
/**
 * Symbol for accessing jsii runtime information
 *
 * Introduced in jsii 1.19.0, cdk 1.90.0.
 */
const JSII_RUNTIME_SYMBOL = Symbol.for('jsii.rtti');
function constructInfoFromConstruct(construct) {
    const jsiiRuntimeInfo = Object.getPrototypeOf(construct).constructor[JSII_RUNTIME_SYMBOL];
    if (typeof jsiiRuntimeInfo === 'object'
        && jsiiRuntimeInfo !== null
        && typeof jsiiRuntimeInfo.fqn === 'string'
        && typeof jsiiRuntimeInfo.version === 'string') {
        return { fqn: jsiiRuntimeInfo.fqn, version: jsiiRuntimeInfo.version };
    }
    else if (jsiiRuntimeInfo) {
        // There is something defined, but doesn't match our expectations. Fail fast and hard.
        throw new Error(`malformed jsii runtime info for construct: '${construct.node.path}'`);
    }
    return undefined;
}
exports.constructInfoFromConstruct = constructInfoFromConstruct;
/**
 * For a given stack, walks the tree and finds the runtime info for all constructs within the tree.
 * Returns the unique list of construct info present in the stack,
 * as long as the construct fully-qualified names match the defined allow list.
 */
function constructInfoFromStack(stack) {
    const isDefined = (value) => value !== undefined;
    const allConstructInfos = constructsInStack(stack)
        .map(construct => constructInfoFromConstruct(construct))
        .filter(isDefined)
        .filter(info => ALLOWED_FQN_PREFIXES.find(prefix => info.fqn.startsWith(prefix)));
    // Adds the jsii runtime as a psuedo construct for reporting purposes.
    allConstructInfos.push({
        fqn: 'jsii-runtime.Runtime',
        version: getJsiiAgentVersion(),
    });
    // Filter out duplicate values
    const uniqKeys = new Set();
    return allConstructInfos.filter(construct => {
        const constructKey = `${construct.fqn}@${construct.version}`;
        const isDuplicate = uniqKeys.has(constructKey);
        uniqKeys.add(constructKey);
        return !isDuplicate;
    });
}
exports.constructInfoFromStack = constructInfoFromStack;
/**
 * Returns all constructs under the parent construct (including the parent),
 * stopping when it reaches a boundary of another stack (e.g., Stack, Stage, NestedStack).
 */
function constructsInStack(construct) {
    const constructs = [construct];
    construct.node.children
        .filter(child => !stage_1.Stage.isStage(child) && !stack_1.Stack.isStack(child))
        .forEach(child => constructs.push(...constructsInStack(child)));
    return constructs;
}
function getJsiiAgentVersion() {
    let jsiiAgent = process.env.JSII_AGENT;
    // if JSII_AGENT is not specified, we will assume this is a node.js runtime
    // and plug in our node.js version
    if (!jsiiAgent) {
        jsiiAgent = `node.js/${process.version}`;
    }
    // Sanitize the agent to remove characters which might mess with the downstream
    // prefix encoding & decoding. In particular the .NET jsii agent takes a form like:
    // DotNet/5.0.3/.NETCoreApp,Version=v3.1/1.0.0.0
    // The `,` in the above messes with the prefix decoding when reporting the analytics.
    jsiiAgent = jsiiAgent.replace(/[^a-z0-9.-/=_]/gi, '-');
    return jsiiAgent;
}
//# sourceMappingURL=data:application/json;base64,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