# AUTOGENERATED! DO NOT EDIT! File to edit: ../../../nbs/hf.datasets.utils.ipynb.

# %% auto 0
__all__ = ['load_datasets', 'concatenate_dataset_dicts']

# %% ../../../nbs/hf.datasets.utils.ipynb 4
def load_datasets(dataset_kwargs_list: list[dict]) -> Dataset:
    datasets = []
    for dataset_kwargs in dataset_kwargs_list:
        dataset = load_dataset(**dataset_kwargs)
        datasets.append(dataset)
    return concatenate_datasets(datasets)

# %% ../../../nbs/hf.datasets.utils.ipynb 5
def concatenate_dataset_dicts(dataset_dicts: list[DatasetDict]):
    """
    Concatenate multiple `DatasetDict` objects into a single `DatasetDict`.
    """
    splits = {key for dd in dataset_dicts for key in dd.keys()}
    output_dsd = {}
    for split in splits:
        dataset_list = []
        for dd in dataset_dicts:
            if split in dd.keys():
                dataset_list.append(dd[split])
        output_dsd[split] = concatenate_datasets(dataset_list)
    return DatasetDict(output_dsd)

