/**
 * Asserts that a value is an instance of a given type.
 *
 * @param value The value to test.
 * @param type The type of which value must be an instance.
 */
export declare function assertType<T>(value: any, type: new (...args: any) => T): T;
/**
 * Locates an instance of a given type within an array.
 *
 * @param container The array to search.
 * @param type The type of which value must be an instance.
 * @return The located value
 * @throws {TypeError} if the value was not found or not of
 */
export declare function findInstanceOf<A, T extends A>(container: A[], type: new (...args: any) => T): T;
//# sourceMappingURL=types.d.ts.map