"""Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT."""

from __future__ import annotations

from typing import Optional

import pydantic
from typing_extensions import Annotated, NotRequired, TypedDict

from friendli_core.types import BaseModel


class AutoscalingPolicyTypedDict(TypedDict):
    r"""Autoscaling policy."""

    cooldown_period: NotRequired[int]
    r"""Determines how long the endpoint waits before scaling down after the last request."""
    max_replica: NotRequired[int]
    r"""The maximum replicas that the endpoint can scale up to. The maximum value is 10."""
    min_replica: NotRequired[int]
    r"""Setting `minReplica` to 0 allows the endpoint to sleep when idle, reducing costs. The minimum value is 0."""


class AutoscalingPolicy(BaseModel):
    r"""Autoscaling policy."""

    cooldown_period: Annotated[
        Optional[int], pydantic.Field(alias="cooldownPeriod")
    ] = 300
    r"""Determines how long the endpoint waits before scaling down after the last request."""

    max_replica: Annotated[Optional[int], pydantic.Field(alias="maxReplica")] = 1
    r"""The maximum replicas that the endpoint can scale up to. The maximum value is 10."""

    min_replica: Annotated[Optional[int], pydantic.Field(alias="minReplica")] = 0
    r"""Setting `minReplica` to 0 allows the endpoint to sleep when idle, reducing costs. The minimum value is 0."""
