"""Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT."""

from __future__ import annotations

import pydantic
from typing_extensions import Annotated, TypedDict

from friendli_core.types import BaseModel

from .dedicateddatasetmodality import (
    DedicatedDatasetModality,
    DedicatedDatasetModalityTypedDict,
)


class DatasetInfoTypedDict(TypedDict):
    r"""Dataset info."""

    created_at: int
    r"""Unix timestamp (in seconds) of when the dataset was created."""
    id: str
    r"""ID of the dataset."""
    modality: DedicatedDatasetModalityTypedDict
    r"""Dataset modality."""
    name: str
    r"""Name of the dataset."""
    updated_at: int
    r"""Unix timestamp (in seconds) of when the dataset was last modified."""


class DatasetInfo(BaseModel):
    r"""Dataset info."""

    created_at: Annotated[int, pydantic.Field(alias="createdAt")]
    r"""Unix timestamp (in seconds) of when the dataset was created."""

    id: str
    r"""ID of the dataset."""

    modality: DedicatedDatasetModality
    r"""Dataset modality."""

    name: str
    r"""Name of the dataset."""

    updated_at: Annotated[int, pydantic.Field(alias="updatedAt")]
    r"""Unix timestamp (in seconds) of when the dataset was last modified."""
