"""Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT."""

from __future__ import annotations

import pydantic
from pydantic import model_serializer
from typing_extensions import Annotated, TypedDict

from friendli_core.types import UNSET_SENTINEL, BaseModel, Nullable


class DedicatedEndpointWandbArtifactCreateResponseTypedDict(TypedDict):
    r"""Endpoint create response."""

    endpoint_id: str
    r"""The ID of the created endpoint."""
    endpoint_name: str
    r"""The name of the created endpoint."""
    project_id: str
    r"""The ID of the project where the endpoint was created."""
    project_name: str
    r"""The name of the project where the endpoint was created."""
    team_id: str
    r"""The ID of the team where the endpoint was created."""
    team_name: Nullable[str]
    r"""The name of the team where the endpoint was created."""


class DedicatedEndpointWandbArtifactCreateResponse(BaseModel):
    r"""Endpoint create response."""

    endpoint_id: Annotated[str, pydantic.Field(alias="endpointId")]
    r"""The ID of the created endpoint."""

    endpoint_name: Annotated[str, pydantic.Field(alias="endpointName")]
    r"""The name of the created endpoint."""

    project_id: Annotated[str, pydantic.Field(alias="projectId")]
    r"""The ID of the project where the endpoint was created."""

    project_name: Annotated[str, pydantic.Field(alias="projectName")]
    r"""The name of the project where the endpoint was created."""

    team_id: Annotated[str, pydantic.Field(alias="teamId")]
    r"""The ID of the team where the endpoint was created."""

    team_name: Annotated[Nullable[str], pydantic.Field(alias="teamName")]
    r"""The name of the team where the endpoint was created."""

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = []
        nullable_fields = ["teamName"]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in type(self).model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m
