"""Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT."""

from abc import abstractmethod

from friendli_core.friendlicore_serverless_chat import (
    AsyncFriendliCoreServerlessChat,
    SyncFriendliCoreServerlessChat,
)
from friendli_core.friendlicore_serverless_completions import (
    AsyncFriendliCoreServerlessCompletions,
    SyncFriendliCoreServerlessCompletions,
)
from friendli_core.friendlicore_serverless_token import (
    AsyncFriendliCoreServerlessToken,
    SyncFriendliCoreServerlessToken,
)
from friendli_core.knowledge import AsyncKnowledge, SyncKnowledge
from friendli_core.model import AsyncModel, SyncModel
from friendli_core.toolassistedchat import AsyncToolAssistedChat, SyncToolAssistedChat

from .basesdk import AsyncSDK, BaseSDK, SyncSDK
from .sdkconfiguration import SDKConfiguration


class BaseServerless(BaseSDK):
    def __init__(self, sdk_config: SDKConfiguration) -> None:
        BaseSDK.__init__(self, sdk_config)
        self.sdk_configuration = sdk_config
        self._init_sdks()

    @abstractmethod
    def _init_sdks(self):
        pass


class SyncServerless(BaseServerless, SyncSDK):
    chat: SyncFriendliCoreServerlessChat
    completions: SyncFriendliCoreServerlessCompletions
    token: SyncFriendliCoreServerlessToken
    tool_assisted_chat: SyncToolAssistedChat
    knowledge: SyncKnowledge
    model: SyncModel

    def _init_sdks(self):
        self.chat = SyncFriendliCoreServerlessChat(self.sdk_configuration)
        self.completions = SyncFriendliCoreServerlessCompletions(self.sdk_configuration)
        self.token = SyncFriendliCoreServerlessToken(self.sdk_configuration)
        self.tool_assisted_chat = SyncToolAssistedChat(self.sdk_configuration)
        self.knowledge = SyncKnowledge(self.sdk_configuration)
        self.model = SyncModel(self.sdk_configuration)


class AsyncServerless(BaseServerless, AsyncSDK):
    chat: AsyncFriendliCoreServerlessChat
    completions: AsyncFriendliCoreServerlessCompletions
    token: AsyncFriendliCoreServerlessToken
    tool_assisted_chat: AsyncToolAssistedChat
    knowledge: AsyncKnowledge
    model: AsyncModel

    def _init_sdks(self):
        self.chat = AsyncFriendliCoreServerlessChat(self.sdk_configuration)
        self.completions = AsyncFriendliCoreServerlessCompletions(
            self.sdk_configuration
        )
        self.token = AsyncFriendliCoreServerlessToken(self.sdk_configuration)
        self.tool_assisted_chat = AsyncToolAssistedChat(self.sdk_configuration)
        self.knowledge = AsyncKnowledge(self.sdk_configuration)
        self.model = AsyncModel(self.sdk_configuration)
