"""
    Portfolio Reporting Batcher

    The Portfolio Reporting Batcher (PRB) API allows clients to systematically leverage functionalities of the PRB application.  # noqa: E501

    The version of the OpenAPI document: 1.1.0
    Contact: api@factset.com
    Generated by: https://openapi-generator.tech
"""


import re  # noqa: F401
import sys  # noqa: F401
from multiprocessing.pool import ApplyResult
import typing

from fds.sdk.PortfolioReportingBatcher.api_client import ApiClient, Endpoint as _Endpoint
from fds.sdk.PortfolioReportingBatcher.model_utils import (  # noqa: F401
    check_allowed_values,
    check_validations,
    date,
    datetime,
    file_type,
    none_type,
    validate_and_convert_types
)
from fds.sdk.PortfolioReportingBatcher.exceptions import ApiException
from fds.sdk.PortfolioReportingBatcher.model.client_error_response import ClientErrorResponse
from fds.sdk.PortfolioReportingBatcher.model.job_details_response import JobDetailsResponse
from fds.sdk.PortfolioReportingBatcher.model.job_list_response import JobListResponse
from fds.sdk.PortfolioReportingBatcher.model.job_types import JobTypes





class JobsApi(object):
    """NOTE: This class is auto generated by OpenAPI Generator
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    def __init__(self, api_client=None):
        if api_client is None:
            api_client = ApiClient()
        self.api_client = api_client

        self.v1_get_details_for_job_endpoint = _Endpoint(
            settings={
                'response_type': (
                  { 200: (JobDetailsResponse,), 400: (ClientErrorResponse,), 404: (ClientErrorResponse,), 429: (ClientErrorResponse,),  },
                  None
                ),
                'auth': [
                    'FactSetApiKey',
                    'FactSetOAuth2'
                ],
                'endpoint_path': '/jobs/{type}/{name}',
                'operation_id': 'v1_get_details_for_job',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'type',
                    'name',
                    'attribute',
                ],
                'required': [
                    'type',
                    'name',
                ],
                'nullable': [
                ],
                'enum': [
                    'attribute',
                ],
                'validation': [
                    'attribute',
                ]
            },
            root_map={
                'validations': {
                    ('attribute',): {

                        'max_items': 4,
                    },
                },
                'allowed_values': {
                    ('attribute',): {

                        "DOCUMENTS": "documents",
                        "TASKS": "tasks",
                        "ACCOUNTS": "accounts",
                        "RUNS": "runs"
                    },
                },
                'openapi_types': {
                    'type':
                        (JobTypes,),
                    'name':
                        (str,),
                    'attribute':
                        ([str],),
                },
                'attribute_map': {
                    'type': 'type',
                    'name': 'name',
                    'attribute': 'attribute',
                },
                'location_map': {
                    'type': 'path',
                    'name': 'path',
                    'attribute': 'query',
                },
                'collection_format_map': {
                    'attribute': 'csv',
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client
        )

        self.v1_get_prb_jobs_endpoint = _Endpoint(
            settings={
                'response_type': (
                  { 200: (JobListResponse,), 400: (ClientErrorResponse,),  },
                  None
                ),
                'auth': [
                    'FactSetApiKey',
                    'FactSetOAuth2'
                ],
                'endpoint_path': '/jobs',
                'operation_id': 'v1_get_prb_jobs',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'type',
                    'name',
                    'pagination_offset',
                    'pagination_limit',
                ],
                'required': [],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                    'pagination_limit',
                ]
            },
            root_map={
                'validations': {
                    ('pagination_limit',): {

                        'inclusive_maximum': 50,
                    },
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'type':
                        (JobTypes,),
                    'name':
                        (str,),
                    'pagination_offset':
                        (int,),
                    'pagination_limit':
                        (int,),
                },
                'attribute_map': {
                    'type': 'type',
                    'name': 'name',
                    'pagination_offset': '_paginationOffset',
                    'pagination_limit': '_paginationLimit',
                },
                'location_map': {
                    'type': 'query',
                    'name': 'query',
                    'pagination_offset': 'query',
                    'pagination_limit': 'query',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client
        )


    @staticmethod
    def apply_kwargs_defaults(kwargs, return_http_data_only, async_req):
        kwargs["async_req"] = async_req
        kwargs["_return_http_data_only"] = return_http_data_only
        kwargs["_preload_content"] = kwargs.get("_preload_content", True)
        kwargs["_request_timeout"] = kwargs.get("_request_timeout", None)
        kwargs["_check_input_type"] = kwargs.get("_check_input_type", True)
        kwargs["_check_return_type"] = kwargs.get("_check_return_type", True)
        kwargs["_spec_property_naming"] = kwargs.get("_spec_property_naming", False)
        kwargs["_content_type"] = kwargs.get("_content_type")
        kwargs["_host_index"] = kwargs.get("_host_index")


    def v1_get_details_for_job(
        self,
        type,
        name,
        **kwargs
    ) -> JobDetailsResponse:
        """Get details for the given PRB job  # noqa: E501

        Use this endpoint to fetch the documents, tasks, accounts, and/or runs for the PRB job given in the path. Please note jobs with type PD will not return tasks nor accounts so this will be ignored if given as part of the array of attributes in the request.  # noqa: E501
        This method makes a synchronous HTTP request. Returns the http data only

        Args:
            type (JobTypes): The jobs type
            name (str): The jobs name

        Keyword Args:
            attribute ([str]): The attribute parameter accepts a list of the given enums, separated by commas. Each of them returns the respective data associated with the job. Runs returns the run history of the job.. [optional]
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True. NOTE: if this API returns a file, it is the responsibility
                of the caller to close the file stream.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
        Returns:
            JobDetailsResponse
                Response Object
        """
        self.apply_kwargs_defaults(kwargs=kwargs, return_http_data_only=True, async_req=False)
        kwargs['type'] = \
            type
        kwargs['name'] = \
            name
        return self.v1_get_details_for_job_endpoint.call_with_http_info(**kwargs)

    def v1_get_details_for_job_with_http_info(
        self,
        type,
        name,
        **kwargs
    ) -> typing.Tuple[JobDetailsResponse, int, typing.MutableMapping]:
        """Get details for the given PRB job  # noqa: E501

        Use this endpoint to fetch the documents, tasks, accounts, and/or runs for the PRB job given in the path. Please note jobs with type PD will not return tasks nor accounts so this will be ignored if given as part of the array of attributes in the request.  # noqa: E501
        This method makes a synchronous HTTP request. Returns http data, http status and headers

        Args:
            type (JobTypes): The jobs type
            name (str): The jobs name

        Keyword Args:
            attribute ([str]): The attribute parameter accepts a list of the given enums, separated by commas. Each of them returns the respective data associated with the job. Runs returns the run history of the job.. [optional]
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True. NOTE: if this API returns a file, it is the responsibility
                of the caller to close the file stream.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
        Returns:
            JobDetailsResponse
                Response Object
            int
                Http Status Code
            dict
                Dictionary of the response headers
        """
        self.apply_kwargs_defaults(kwargs=kwargs, return_http_data_only=False, async_req=False)
        kwargs['type'] = \
            type
        kwargs['name'] = \
            name
        return self.v1_get_details_for_job_endpoint.call_with_http_info(**kwargs)

    def v1_get_details_for_job_async(
        self,
        type,
        name,
        **kwargs
    ) -> "ApplyResult[JobDetailsResponse]":
        """Get details for the given PRB job  # noqa: E501

        Use this endpoint to fetch the documents, tasks, accounts, and/or runs for the PRB job given in the path. Please note jobs with type PD will not return tasks nor accounts so this will be ignored if given as part of the array of attributes in the request.  # noqa: E501
        This method makes a asynchronous HTTP request. Returns the http data, wrapped in ApplyResult

        Args:
            type (JobTypes): The jobs type
            name (str): The jobs name

        Keyword Args:
            attribute ([str]): The attribute parameter accepts a list of the given enums, separated by commas. Each of them returns the respective data associated with the job. Runs returns the run history of the job.. [optional]
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True. NOTE: if this API returns a file, it is the responsibility
                of the caller to close the file stream.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
        Returns:
            ApplyResult[JobDetailsResponse]
        """
        self.apply_kwargs_defaults(kwargs=kwargs, return_http_data_only=True, async_req=True)
        kwargs['type'] = \
            type
        kwargs['name'] = \
            name
        return self.v1_get_details_for_job_endpoint.call_with_http_info(**kwargs)

    def v1_get_details_for_job_with_http_info_async(
        self,
        type,
        name,
        **kwargs
    ) -> "ApplyResult[typing.Tuple[JobDetailsResponse, int, typing.MutableMapping]]":
        """Get details for the given PRB job  # noqa: E501

        Use this endpoint to fetch the documents, tasks, accounts, and/or runs for the PRB job given in the path. Please note jobs with type PD will not return tasks nor accounts so this will be ignored if given as part of the array of attributes in the request.  # noqa: E501
        This method makes a asynchronous HTTP request. Returns http data, http status and headers, wrapped in ApplyResult

        Args:
            type (JobTypes): The jobs type
            name (str): The jobs name

        Keyword Args:
            attribute ([str]): The attribute parameter accepts a list of the given enums, separated by commas. Each of them returns the respective data associated with the job. Runs returns the run history of the job.. [optional]
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True. NOTE: if this API returns a file, it is the responsibility
                of the caller to close the file stream.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
        Returns:
            ApplyResult[(JobDetailsResponse, int, typing.Dict)]
        """
        self.apply_kwargs_defaults(kwargs=kwargs, return_http_data_only=False, async_req=True)
        kwargs['type'] = \
            type
        kwargs['name'] = \
            name
        return self.v1_get_details_for_job_endpoint.call_with_http_info(**kwargs)


    def v1_get_prb_jobs(
        self,
        **kwargs
    ) -> JobListResponse:
        """Get a list of existing jobs  # noqa: E501

        Use this endpoint with the optional 'type' or 'name' filters to get a list of PRB jobs.   # noqa: E501
        This method makes a synchronous HTTP request. Returns the http data only


        Keyword Args:
            type (JobTypes): The job type. [optional]
            name (str): The job name. [optional]
            pagination_offset (int): The number of jobs to skip (please note the jobs are ordered by last modified in descending order, i.e. most recently modified will show on the. [optional]
            pagination_limit (int): The number of jobs to bring back (maximum 50). [optional]
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True. NOTE: if this API returns a file, it is the responsibility
                of the caller to close the file stream.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
        Returns:
            JobListResponse
                Response Object
        """
        self.apply_kwargs_defaults(kwargs=kwargs, return_http_data_only=True, async_req=False)
        return self.v1_get_prb_jobs_endpoint.call_with_http_info(**kwargs)

    def v1_get_prb_jobs_with_http_info(
        self,
        **kwargs
    ) -> typing.Tuple[JobListResponse, int, typing.MutableMapping]:
        """Get a list of existing jobs  # noqa: E501

        Use this endpoint with the optional 'type' or 'name' filters to get a list of PRB jobs.   # noqa: E501
        This method makes a synchronous HTTP request. Returns http data, http status and headers


        Keyword Args:
            type (JobTypes): The job type. [optional]
            name (str): The job name. [optional]
            pagination_offset (int): The number of jobs to skip (please note the jobs are ordered by last modified in descending order, i.e. most recently modified will show on the. [optional]
            pagination_limit (int): The number of jobs to bring back (maximum 50). [optional]
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True. NOTE: if this API returns a file, it is the responsibility
                of the caller to close the file stream.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
        Returns:
            JobListResponse
                Response Object
            int
                Http Status Code
            dict
                Dictionary of the response headers
        """
        self.apply_kwargs_defaults(kwargs=kwargs, return_http_data_only=False, async_req=False)
        return self.v1_get_prb_jobs_endpoint.call_with_http_info(**kwargs)

    def v1_get_prb_jobs_async(
        self,
        **kwargs
    ) -> "ApplyResult[JobListResponse]":
        """Get a list of existing jobs  # noqa: E501

        Use this endpoint with the optional 'type' or 'name' filters to get a list of PRB jobs.   # noqa: E501
        This method makes a asynchronous HTTP request. Returns the http data, wrapped in ApplyResult


        Keyword Args:
            type (JobTypes): The job type. [optional]
            name (str): The job name. [optional]
            pagination_offset (int): The number of jobs to skip (please note the jobs are ordered by last modified in descending order, i.e. most recently modified will show on the. [optional]
            pagination_limit (int): The number of jobs to bring back (maximum 50). [optional]
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True. NOTE: if this API returns a file, it is the responsibility
                of the caller to close the file stream.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
        Returns:
            ApplyResult[JobListResponse]
        """
        self.apply_kwargs_defaults(kwargs=kwargs, return_http_data_only=True, async_req=True)
        return self.v1_get_prb_jobs_endpoint.call_with_http_info(**kwargs)

    def v1_get_prb_jobs_with_http_info_async(
        self,
        **kwargs
    ) -> "ApplyResult[typing.Tuple[JobListResponse, int, typing.MutableMapping]]":
        """Get a list of existing jobs  # noqa: E501

        Use this endpoint with the optional 'type' or 'name' filters to get a list of PRB jobs.   # noqa: E501
        This method makes a asynchronous HTTP request. Returns http data, http status and headers, wrapped in ApplyResult


        Keyword Args:
            type (JobTypes): The job type. [optional]
            name (str): The job name. [optional]
            pagination_offset (int): The number of jobs to skip (please note the jobs are ordered by last modified in descending order, i.e. most recently modified will show on the. [optional]
            pagination_limit (int): The number of jobs to bring back (maximum 50). [optional]
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True. NOTE: if this API returns a file, it is the responsibility
                of the caller to close the file stream.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
        Returns:
            ApplyResult[(JobListResponse, int, typing.Dict)]
        """
        self.apply_kwargs_defaults(kwargs=kwargs, return_http_data_only=False, async_req=True)
        return self.v1_get_prb_jobs_endpoint.call_with_http_info(**kwargs)


