"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.FunctionUrl = exports.HttpMethod = exports.FunctionUrlAuthType = void 0;
const jsiiDeprecationWarnings = require("../.warnings.jsii.js");
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const iam = require("@aws-cdk/aws-iam");
const core_1 = require("@aws-cdk/core");
const lambda_generated_1 = require("./lambda.generated");
/**
 * The auth types for a function url
 */
var FunctionUrlAuthType;
(function (FunctionUrlAuthType) {
    /**
     * Restrict access to authenticated IAM users only
     */
    FunctionUrlAuthType["AWS_IAM"] = "AWS_IAM";
    /**
     * Bypass IAM authentication to create a public endpoint
     */
    FunctionUrlAuthType["NONE"] = "NONE";
})(FunctionUrlAuthType = exports.FunctionUrlAuthType || (exports.FunctionUrlAuthType = {}));
/**
 * All http request methods
 */
var HttpMethod;
(function (HttpMethod) {
    /**
     * The GET method requests a representation of the specified resource.
     */
    HttpMethod["GET"] = "GET";
    /**
     * The PUT method replaces all current representations of the target resource with the request payload.
     */
    HttpMethod["PUT"] = "PUT";
    /**
     * The HEAD method asks for a response identical to that of a GET request, but without the response body.
     */
    HttpMethod["HEAD"] = "HEAD";
    /**
     * The POST method is used to submit an entity to the specified resource, often causing a change in state or side effects on the server.
     */
    HttpMethod["POST"] = "POST";
    /**
     * The DELETE method deletes the specified resource.
     */
    HttpMethod["DELETE"] = "DELETE";
    /**
     * The PATCH method applies partial modifications to a resource.
     */
    HttpMethod["PATCH"] = "PATCH";
    /**
     * The OPTIONS method describes the communication options for the target resource.
     */
    HttpMethod["OPTIONS"] = "OPTIONS";
    /**
     * The wildcard entry to allow all methods.
     */
    HttpMethod["ALL"] = "*";
})(HttpMethod = exports.HttpMethod || (exports.HttpMethod = {}));
/**
 * Defines a Lambda function url
 *
 * @resource AWS::Lambda::Url
 */
class FunctionUrl extends core_1.Resource {
    constructor(scope, id, props) {
        super(scope, id);
        try {
            jsiiDeprecationWarnings._aws_cdk_aws_lambda_FunctionUrlProps(props);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, FunctionUrl);
            }
            throw error;
        }
        if (this.instanceOfVersion(props.function)) {
            throw new Error('FunctionUrl cannot be used with a Version');
        }
        const resource = new lambda_generated_1.CfnUrl(this, 'Resource', {
            authType: props.authType ?? FunctionUrlAuthType.AWS_IAM,
            targetFunctionArn: props.function.functionArn,
            cors: props.cors ? this.renderCors(props.cors) : undefined,
        });
        this.url = resource.attrFunctionUrl;
        this.functionArn = resource.attrFunctionArn;
        this.function = props.function;
        if (props.authType === FunctionUrlAuthType.NONE) {
            props.function.addPermission('invoke-function-url', {
                principal: new iam.AnyPrincipal(),
                action: 'lambda:InvokeFunctionUrl',
                functionUrlAuthType: props.authType,
            });
        }
    }
    grantInvokeUrl(grantee) {
        return this.function.grantInvokeUrl(grantee);
    }
    instanceOfVersion(fn) {
        return 'version' in fn && !this.instanceOfAlias(fn);
    }
    instanceOfAlias(fn) {
        return 'aliasName' in fn;
    }
    renderCors(cors) {
        return {
            allowCredentials: cors.allowCredentials,
            allowHeaders: cors.allowedHeaders,
            allowMethods: cors.allowedMethods ?? [HttpMethod.ALL],
            allowOrigins: cors.allowedOrigins,
            exposeHeaders: cors.exposedHeaders,
            maxAge: cors.maxAge?.toSeconds(),
        };
    }
}
exports.FunctionUrl = FunctionUrl;
_a = JSII_RTTI_SYMBOL_1;
FunctionUrl[_a] = { fqn: "@aws-cdk/aws-lambda.FunctionUrl", version: "1.161.0" };
//# sourceMappingURL=data:application/json;base64,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