"use strict";
var _a, _b, _c, _d;
Object.defineProperty(exports, "__esModule", { value: true });
exports.Group = exports.User = exports.ClusterRoleBinding = exports.RoleBinding = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const cdk8s_1 = require("cdk8s");
const constructs_1 = require("constructs");
const base_1 = require("./base");
const k8s = require("./imports/k8s");
const utils_1 = require("./utils");
/**
 * A RoleBinding grants permissions within a specific namespace to a user or
 * set of users.
 */
class RoleBinding extends base_1.Resource {
    constructor(scope, id, props) {
        super(scope, id);
        this.resourceType = 'rolebindings';
        this.role = props.role;
        this._subjects = new Array();
        this.apiObject = new k8s.KubeRoleBinding(this, 'Resource', {
            metadata: props.metadata,
            subjects: cdk8s_1.Lazy.any({ produce: () => this.synthesizeSubjects() }),
            roleRef: cdk8s_1.Lazy.any({ produce: () => this.synthesizeRoleRef() }),
        });
    }
    /**
     * Adds a subject to the role.
     * @param subjects The subjects to add
     */
    addSubjects(...subjects) {
        for (const subject of subjects) {
            this._subjects.push(subject);
        }
    }
    get subjects() {
        return [...this._subjects];
    }
    synthesizeRoleRef() {
        return {
            apiGroup: this.role.apiGroup,
            kind: this.role.kind,
            name: this.role.name,
        };
    }
    synthesizeSubjects() {
        return this._subjects.map(subject => subject.toSubjectConfiguration()).map((subject) => utils_1.filterUndefined({
            apiGroup: subject.apiGroup === 'core' ? '' : subject.apiGroup,
            kind: subject.kind,
            name: subject.name,
            namespace: subject.namespace,
        }));
    }
}
exports.RoleBinding = RoleBinding;
_a = JSII_RTTI_SYMBOL_1;
RoleBinding[_a] = { fqn: "cdk8s-plus-23.RoleBinding", version: "2.3.33" };
/**
 * A ClusterRoleBinding grants permissions cluster-wide to a user or
 * set of users.
 */
class ClusterRoleBinding extends base_1.Resource {
    constructor(scope, id, props) {
        super(scope, id);
        this.resourceType = 'clusterrolebindings';
        this.role = props.role;
        this._subjects = new Array();
        this.apiObject = new k8s.KubeClusterRoleBinding(this, 'Resource', {
            metadata: props.metadata,
            subjects: cdk8s_1.Lazy.any({ produce: () => this.synthesizeSubjects() }),
            roleRef: cdk8s_1.Lazy.any({ produce: () => this.synthesizeRoleRef() }),
        });
    }
    /**
     * Adds a subject to the role.
     * @param subjects The subjects to add
     */
    addSubjects(...subjects) {
        for (const subject of subjects) {
            this._subjects.push(subject);
        }
    }
    get subjects() {
        return [...this._subjects];
    }
    synthesizeRoleRef() {
        return {
            apiGroup: this.role.apiGroup,
            kind: this.role.kind,
            name: this.role.name,
        };
    }
    synthesizeSubjects() {
        return this._subjects.map(subject => subject.toSubjectConfiguration()).map((subject) => utils_1.filterUndefined({
            apiGroup: subject.apiGroup === 'core' ? '' : subject.apiGroup,
            kind: subject.kind,
            name: subject.name,
            namespace: subject.namespace,
        }));
    }
}
exports.ClusterRoleBinding = ClusterRoleBinding;
_b = JSII_RTTI_SYMBOL_1;
ClusterRoleBinding[_b] = { fqn: "cdk8s-plus-23.ClusterRoleBinding", version: "2.3.33" };
/**
 * Represents a user.
 */
class User extends constructs_1.Construct {
    constructor(scope, id, name) {
        super(scope, id);
        this.apiGroup = 'rbac.authorization.k8s.io';
        this.kind = 'User';
        this.name = name;
    }
    /**
     * Reference a user in the cluster by name.
     */
    static fromName(scope, id, name) {
        return new User(scope, id, name);
    }
    /**
     * @see ISubect.toSubjectConfiguration()
     */
    toSubjectConfiguration() {
        return {
            kind: this.kind,
            name: this.name,
            apiGroup: this.apiGroup,
        };
    }
}
exports.User = User;
_c = JSII_RTTI_SYMBOL_1;
User[_c] = { fqn: "cdk8s-plus-23.User", version: "2.3.33" };
/**
 * Represents a group.
 */
class Group extends constructs_1.Construct {
    constructor(scope, id, name) {
        super(scope, id);
        this.apiGroup = 'rbac.authorization.k8s.io';
        this.kind = 'Group';
        this.name = name;
    }
    /**
     * Reference a group by name.
     */
    static fromName(scope, id, name) {
        return new Group(scope, id, name);
    }
    /**
     * @see ISubect.toSubjectConfiguration()
     */
    toSubjectConfiguration() {
        return {
            kind: this.kind,
            name: this.name,
            apiGroup: this.apiGroup,
        };
    }
}
exports.Group = Group;
_d = JSII_RTTI_SYMBOL_1;
Group[_d] = { fqn: "cdk8s-plus-23.Group", version: "2.3.33" };
//# sourceMappingURL=data:application/json;base64,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