import logging
from collections.abc import Callable, Generator, KeysView, Sequence
from typing import Any

from bidict import bidict
from socketio.base_server import BaseServer

default_logger: logging.Logger

class BaseManager:
    logger: logging.Logger | None
    server: BaseServer[Any, Any]
    rooms: dict[  # self.rooms[namespace][room][sio_sid] = eio_sid
        str, dict[str | None, bidict[str, str]]
    ]
    eio_to_sid: dict[str, str]
    callbacks: dict[str, dict[int, Callable[..., Any]]]
    pending_disconnect: dict[str, list[str]]
    def __init__(self) -> None: ...
    def set_server(self, server: BaseServer[Any, Any]) -> None: ...
    def initialize(self) -> None: ...
    def get_namespaces(self) -> KeysView[dict[str, Any]]: ...
    def get_participants(
        self, namespace: str, room: str | Sequence[str] | None
    ) -> Generator[tuple[str, str]]: ...
    def connect(self, eio_sid: str, namespace: str) -> str: ...
    def is_connected(self, sid: str, namespace: str) -> bool: ...
    def sid_from_eio_sid(self, eio_sid: str, namespace: str) -> str: ...
    def eio_sid_from_sid(self, sid: str, namespace: str) -> str | None: ...
    def pre_disconnect(self, sid: str, namespace: str) -> str | None: ...
    def basic_disconnect(self, sid: str, namespace: str, **kwargs: Any) -> None: ...
    def basic_enter_room(
        self, sid: str, namespace: str, room: str, eio_sid: str | None = ...
    ) -> None: ...
    def basic_leave_room(self, sid: str, namespace: str, room: str) -> None: ...
    def basic_close_room(self, room: str | Sequence[str], namespace: str) -> None: ...
    def get_rooms(self, sid: str, namespace: str) -> list[str]: ...
    def _get_logger(self) -> logging.Logger: ...
