from typing import overload, Any, Callable, TypeVar, Union
from typing import Tuple, List, Sequence, MutableSequence

Callback = Union[Callable[..., None], None]
Buffer = TypeVar('Buffer')
Pointer = TypeVar('Pointer')
Template = TypeVar('Template')

import vtkmodules.vtkCommonCore
import vtkmodules.vtkCommonTransforms

class vtkGeoProjection(vtkmodules.vtkCommonCore.vtkObject):
    def ClearOptionalParameters(self) -> None: ...
    def GetCentralMeridian(self) -> float: ...
    def GetDescription(self) -> str: ...
    def GetIndex(self) -> int: ...
    def GetName(self) -> str: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def GetNumberOfOptionalParameters(self) -> int: ...
    @staticmethod
    def GetNumberOfProjections() -> int: ...
    def GetOptionalParameterKey(self, index:int) -> str: ...
    def GetOptionalParameterValue(self, index:int) -> str: ...
    def GetPROJ4String(self) -> str: ...
    @staticmethod
    def GetProjectionDescription(projection:int) -> str: ...
    @staticmethod
    def GetProjectionName(projection:int) -> str: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> vtkGeoProjection: ...
    def RemoveOptionalParameter(self, __a:str) -> None: ...
    @staticmethod
    def SafeDownCast(o:vtkObjectBase) -> vtkGeoProjection: ...
    def SetCentralMeridian(self, _arg:float) -> None: ...
    def SetName(self, _arg:str) -> None: ...
    def SetOptionalParameter(self, key:str, value:str) -> None: ...
    def SetPROJ4String(self, _arg:str) -> None: ...

class vtkGeoTransform(vtkmodules.vtkCommonTransforms.vtkAbstractTransform):
    @overload
    @staticmethod
    def ComputeUTMZone(lon:float, lat:float) -> int: ...
    @overload
    @staticmethod
    def ComputeUTMZone(lonlat:[float, ...]) -> int: ...
    def GetDestinationProjection(self) -> vtkGeoProjection: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def GetSourceProjection(self) -> vtkGeoProjection: ...
    def InternalTransformDerivative(self, in_:(float, float, float), out:[float, float, float], derivative:[[float, float, float], [float, float, float], [float, float, float]]) -> None: ...
    def InternalTransformPoint(self, in_:(float, float, float), out:[float, float, float]) -> None: ...
    def Inverse(self) -> None: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def MakeTransform(self) -> vtkAbstractTransform: ...
    def NewInstance(self) -> vtkGeoTransform: ...
    @staticmethod
    def SafeDownCast(o:vtkObjectBase) -> vtkGeoTransform: ...
    def SetDestinationProjection(self, dest:vtkGeoProjection) -> None: ...
    def SetSourceProjection(self, source:vtkGeoProjection) -> None: ...
    def TransformPoints(self, src:vtkPoints, dst:vtkPoints) -> None: ...

