import * as cdk from '@aws-cdk/core';
import * as cfn_parse from '@aws-cdk/core/lib/cfn-parse';
/**
 * Properties for defining a `AWS::S3::AccessPoint`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-s3-accesspoint.html
 * @external
 */
export interface CfnAccessPointProps {
    /**
     * `AWS::S3::AccessPoint.Bucket`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-s3-accesspoint.html#cfn-s3-accesspoint-bucket
     * @external
     */
    readonly bucket: string;
    /**
     * `AWS::S3::AccessPoint.CreationDate`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-s3-accesspoint.html#cfn-s3-accesspoint-creationdate
     * @external
     */
    readonly creationDate?: string;
    /**
     * `AWS::S3::AccessPoint.Name`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-s3-accesspoint.html#cfn-s3-accesspoint-name
     * @external
     */
    readonly name?: string;
    /**
     * `AWS::S3::AccessPoint.NetworkOrigin`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-s3-accesspoint.html#cfn-s3-accesspoint-networkorigin
     * @external
     */
    readonly networkOrigin?: string;
    /**
     * `AWS::S3::AccessPoint.Policy`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-s3-accesspoint.html#cfn-s3-accesspoint-policy
     * @external
     */
    readonly policy?: any | cdk.IResolvable;
    /**
     * `AWS::S3::AccessPoint.PolicyStatus`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-s3-accesspoint.html#cfn-s3-accesspoint-policystatus
     * @external
     */
    readonly policyStatus?: any | cdk.IResolvable;
    /**
     * `AWS::S3::AccessPoint.PublicAccessBlockConfiguration`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-s3-accesspoint.html#cfn-s3-accesspoint-publicaccessblockconfiguration
     * @external
     */
    readonly publicAccessBlockConfiguration?: CfnAccessPoint.PublicAccessBlockConfigurationProperty | cdk.IResolvable;
    /**
     * `AWS::S3::AccessPoint.VpcConfiguration`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-s3-accesspoint.html#cfn-s3-accesspoint-vpcconfiguration
     * @external
     */
    readonly vpcConfiguration?: CfnAccessPoint.VpcConfigurationProperty | cdk.IResolvable;
}
/**
 * A CloudFormation `AWS::S3::AccessPoint`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-s3-accesspoint.html
 * @external
 * @cloudformationResource AWS::S3::AccessPoint
 */
export declare class CfnAccessPoint extends cdk.CfnResource implements cdk.IInspectable {
    /**
     * The CloudFormation resource type name for this resource class.
     *
     * @external
     */
    static readonly CFN_RESOURCE_TYPE_NAME = "AWS::S3::AccessPoint";
    /**
     * A factory method that creates a new instance of this class from an object
     * containing the CloudFormation properties of this resource.
     * Used in the @aws-cdk/cloudformation-include module.
     *
     * @internal
     */
    static _fromCloudFormation(scope: cdk.Construct, id: string, resourceAttributes: any, options: cfn_parse.FromCloudFormationOptions): CfnAccessPoint;
    /**
     * `AWS::S3::AccessPoint.Bucket`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-s3-accesspoint.html#cfn-s3-accesspoint-bucket
     * @external
     */
    bucket: string;
    /**
     * `AWS::S3::AccessPoint.CreationDate`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-s3-accesspoint.html#cfn-s3-accesspoint-creationdate
     * @external
     */
    creationDate: string | undefined;
    /**
     * `AWS::S3::AccessPoint.Name`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-s3-accesspoint.html#cfn-s3-accesspoint-name
     * @external
     */
    name: string | undefined;
    /**
     * `AWS::S3::AccessPoint.NetworkOrigin`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-s3-accesspoint.html#cfn-s3-accesspoint-networkorigin
     * @external
     */
    networkOrigin: string | undefined;
    /**
     * `AWS::S3::AccessPoint.Policy`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-s3-accesspoint.html#cfn-s3-accesspoint-policy
     * @external
     */
    policy: any | cdk.IResolvable | undefined;
    /**
     * `AWS::S3::AccessPoint.PolicyStatus`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-s3-accesspoint.html#cfn-s3-accesspoint-policystatus
     * @external
     */
    policyStatus: any | cdk.IResolvable | undefined;
    /**
     * `AWS::S3::AccessPoint.PublicAccessBlockConfiguration`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-s3-accesspoint.html#cfn-s3-accesspoint-publicaccessblockconfiguration
     * @external
     */
    publicAccessBlockConfiguration: CfnAccessPoint.PublicAccessBlockConfigurationProperty | cdk.IResolvable | undefined;
    /**
     * `AWS::S3::AccessPoint.VpcConfiguration`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-s3-accesspoint.html#cfn-s3-accesspoint-vpcconfiguration
     * @external
     */
    vpcConfiguration: CfnAccessPoint.VpcConfigurationProperty | cdk.IResolvable | undefined;
    /**
     * Create a new `AWS::S3::AccessPoint`.
     *
     * @param scope - scope in which this resource is defined.
     * @param id - scoped id of the resource.
     * @param props - resource properties.
     * @external
     */
    constructor(scope: cdk.Construct, id: string, props: CfnAccessPointProps);
    /**
     * (experimental) Examines the CloudFormation resource and discloses attributes.
     *
     * @param inspector - tree inspector to collect and process attributes.
     * @experimental
     */
    inspect(inspector: cdk.TreeInspector): void;
    /**
     * @external
     */
    protected get cfnProperties(): {
        [key: string]: any;
    };
    /**
     * @external
     */
    protected renderProperties(props: {
        [key: string]: any;
    }): {
        [key: string]: any;
    };
}
/**
 * A CloudFormation `AWS::S3::AccessPoint`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-s3-accesspoint.html
 * @external
 * @cloudformationResource AWS::S3::AccessPoint
 */
export declare namespace CfnAccessPoint {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-accesspoint-publicaccessblockconfiguration.html
     * @external
     */
    interface PublicAccessBlockConfigurationProperty {
        /**
         * `CfnAccessPoint.PublicAccessBlockConfigurationProperty.BlockPublicAcls`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-accesspoint-publicaccessblockconfiguration.html#cfn-s3-accesspoint-publicaccessblockconfiguration-blockpublicacls
         * @external
         */
        readonly blockPublicAcls?: boolean | cdk.IResolvable;
        /**
         * `CfnAccessPoint.PublicAccessBlockConfigurationProperty.BlockPublicPolicy`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-accesspoint-publicaccessblockconfiguration.html#cfn-s3-accesspoint-publicaccessblockconfiguration-blockpublicpolicy
         * @external
         */
        readonly blockPublicPolicy?: boolean | cdk.IResolvable;
        /**
         * `CfnAccessPoint.PublicAccessBlockConfigurationProperty.IgnorePublicAcls`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-accesspoint-publicaccessblockconfiguration.html#cfn-s3-accesspoint-publicaccessblockconfiguration-ignorepublicacls
         * @external
         */
        readonly ignorePublicAcls?: boolean | cdk.IResolvable;
        /**
         * `CfnAccessPoint.PublicAccessBlockConfigurationProperty.RestrictPublicBuckets`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-accesspoint-publicaccessblockconfiguration.html#cfn-s3-accesspoint-publicaccessblockconfiguration-restrictpublicbuckets
         * @external
         */
        readonly restrictPublicBuckets?: boolean | cdk.IResolvable;
    }
}
/**
 * A CloudFormation `AWS::S3::AccessPoint`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-s3-accesspoint.html
 * @external
 * @cloudformationResource AWS::S3::AccessPoint
 */
export declare namespace CfnAccessPoint {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-accesspoint-vpcconfiguration.html
     * @external
     */
    interface VpcConfigurationProperty {
        /**
         * `CfnAccessPoint.VpcConfigurationProperty.VpcId`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-accesspoint-vpcconfiguration.html#cfn-s3-accesspoint-vpcconfiguration-vpcid
         * @external
         */
        readonly vpcId?: string;
    }
}
/**
 * Properties for defining a `AWS::S3::Bucket`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket.html
 * @external
 */
export interface CfnBucketProps {
    /**
     * `AWS::S3::Bucket.AccelerateConfiguration`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket.html#cfn-s3-bucket-accelerateconfiguration
     * @external
     */
    readonly accelerateConfiguration?: CfnBucket.AccelerateConfigurationProperty | cdk.IResolvable;
    /**
     * `AWS::S3::Bucket.AccessControl`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket.html#cfn-s3-bucket-accesscontrol
     * @external
     */
    readonly accessControl?: string;
    /**
     * `AWS::S3::Bucket.AnalyticsConfigurations`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket.html#cfn-s3-bucket-analyticsconfigurations
     * @external
     */
    readonly analyticsConfigurations?: Array<CfnBucket.AnalyticsConfigurationProperty | cdk.IResolvable> | cdk.IResolvable;
    /**
     * `AWS::S3::Bucket.BucketEncryption`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket.html#cfn-s3-bucket-bucketencryption
     * @external
     */
    readonly bucketEncryption?: CfnBucket.BucketEncryptionProperty | cdk.IResolvable;
    /**
     * `AWS::S3::Bucket.BucketName`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket.html#cfn-s3-bucket-name
     * @external
     */
    readonly bucketName?: string;
    /**
     * `AWS::S3::Bucket.CorsConfiguration`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket.html#cfn-s3-bucket-crossoriginconfig
     * @external
     */
    readonly corsConfiguration?: CfnBucket.CorsConfigurationProperty | cdk.IResolvable;
    /**
     * `AWS::S3::Bucket.IntelligentTieringConfigurations`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket.html#cfn-s3-bucket-intelligenttieringconfigurations
     * @external
     */
    readonly intelligentTieringConfigurations?: Array<CfnBucket.IntelligentTieringConfigurationProperty | cdk.IResolvable> | cdk.IResolvable;
    /**
     * `AWS::S3::Bucket.InventoryConfigurations`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket.html#cfn-s3-bucket-inventoryconfigurations
     * @external
     */
    readonly inventoryConfigurations?: Array<CfnBucket.InventoryConfigurationProperty | cdk.IResolvable> | cdk.IResolvable;
    /**
     * `AWS::S3::Bucket.LifecycleConfiguration`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket.html#cfn-s3-bucket-lifecycleconfig
     * @external
     */
    readonly lifecycleConfiguration?: CfnBucket.LifecycleConfigurationProperty | cdk.IResolvable;
    /**
     * `AWS::S3::Bucket.LoggingConfiguration`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket.html#cfn-s3-bucket-loggingconfig
     * @external
     */
    readonly loggingConfiguration?: CfnBucket.LoggingConfigurationProperty | cdk.IResolvable;
    /**
     * `AWS::S3::Bucket.MetricsConfigurations`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket.html#cfn-s3-bucket-metricsconfigurations
     * @external
     */
    readonly metricsConfigurations?: Array<CfnBucket.MetricsConfigurationProperty | cdk.IResolvable> | cdk.IResolvable;
    /**
     * `AWS::S3::Bucket.NotificationConfiguration`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket.html#cfn-s3-bucket-notification
     * @external
     */
    readonly notificationConfiguration?: CfnBucket.NotificationConfigurationProperty | cdk.IResolvable;
    /**
     * `AWS::S3::Bucket.ObjectLockConfiguration`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket.html#cfn-s3-bucket-objectlockconfiguration
     * @external
     */
    readonly objectLockConfiguration?: CfnBucket.ObjectLockConfigurationProperty | cdk.IResolvable;
    /**
     * `AWS::S3::Bucket.ObjectLockEnabled`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket.html#cfn-s3-bucket-objectlockenabled
     * @external
     */
    readonly objectLockEnabled?: boolean | cdk.IResolvable;
    /**
     * `AWS::S3::Bucket.OwnershipControls`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket.html#cfn-s3-bucket-ownershipcontrols
     * @external
     */
    readonly ownershipControls?: CfnBucket.OwnershipControlsProperty | cdk.IResolvable;
    /**
     * `AWS::S3::Bucket.PublicAccessBlockConfiguration`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket.html#cfn-s3-bucket-publicaccessblockconfiguration
     * @external
     */
    readonly publicAccessBlockConfiguration?: CfnBucket.PublicAccessBlockConfigurationProperty | cdk.IResolvable;
    /**
     * `AWS::S3::Bucket.ReplicationConfiguration`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket.html#cfn-s3-bucket-replicationconfiguration
     * @external
     */
    readonly replicationConfiguration?: CfnBucket.ReplicationConfigurationProperty | cdk.IResolvable;
    /**
     * `AWS::S3::Bucket.Tags`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket.html#cfn-s3-bucket-tags
     * @external
     */
    readonly tags?: cdk.CfnTag[];
    /**
     * `AWS::S3::Bucket.VersioningConfiguration`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket.html#cfn-s3-bucket-versioning
     * @external
     */
    readonly versioningConfiguration?: CfnBucket.VersioningConfigurationProperty | cdk.IResolvable;
    /**
     * `AWS::S3::Bucket.WebsiteConfiguration`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket.html#cfn-s3-bucket-websiteconfiguration
     * @external
     */
    readonly websiteConfiguration?: CfnBucket.WebsiteConfigurationProperty | cdk.IResolvable;
}
/**
 * A CloudFormation `AWS::S3::Bucket`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket.html
 * @external
 * @cloudformationResource AWS::S3::Bucket
 */
export declare class CfnBucket extends cdk.CfnResource implements cdk.IInspectable {
    /**
     * The CloudFormation resource type name for this resource class.
     *
     * @external
     */
    static readonly CFN_RESOURCE_TYPE_NAME = "AWS::S3::Bucket";
    /**
     * A factory method that creates a new instance of this class from an object
     * containing the CloudFormation properties of this resource.
     * Used in the @aws-cdk/cloudformation-include module.
     *
     * @internal
     */
    static _fromCloudFormation(scope: cdk.Construct, id: string, resourceAttributes: any, options: cfn_parse.FromCloudFormationOptions): CfnBucket;
    /**
     * @external
     * @cloudformationAttribute Arn
     */
    readonly attrArn: string;
    /**
     * @external
     * @cloudformationAttribute DomainName
     */
    readonly attrDomainName: string;
    /**
     * @external
     * @cloudformationAttribute DualStackDomainName
     */
    readonly attrDualStackDomainName: string;
    /**
     * @external
     * @cloudformationAttribute RegionalDomainName
     */
    readonly attrRegionalDomainName: string;
    /**
     * @external
     * @cloudformationAttribute WebsiteURL
     */
    readonly attrWebsiteUrl: string;
    /**
     * `AWS::S3::Bucket.AccelerateConfiguration`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket.html#cfn-s3-bucket-accelerateconfiguration
     * @external
     */
    accelerateConfiguration: CfnBucket.AccelerateConfigurationProperty | cdk.IResolvable | undefined;
    /**
     * `AWS::S3::Bucket.AccessControl`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket.html#cfn-s3-bucket-accesscontrol
     * @external
     */
    accessControl: string | undefined;
    /**
     * `AWS::S3::Bucket.AnalyticsConfigurations`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket.html#cfn-s3-bucket-analyticsconfigurations
     * @external
     */
    analyticsConfigurations: Array<CfnBucket.AnalyticsConfigurationProperty | cdk.IResolvable> | cdk.IResolvable | undefined;
    /**
     * `AWS::S3::Bucket.BucketEncryption`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket.html#cfn-s3-bucket-bucketencryption
     * @external
     */
    bucketEncryption: CfnBucket.BucketEncryptionProperty | cdk.IResolvable | undefined;
    /**
     * `AWS::S3::Bucket.BucketName`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket.html#cfn-s3-bucket-name
     * @external
     */
    bucketName: string | undefined;
    /**
     * `AWS::S3::Bucket.CorsConfiguration`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket.html#cfn-s3-bucket-crossoriginconfig
     * @external
     */
    corsConfiguration: CfnBucket.CorsConfigurationProperty | cdk.IResolvable | undefined;
    /**
     * `AWS::S3::Bucket.IntelligentTieringConfigurations`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket.html#cfn-s3-bucket-intelligenttieringconfigurations
     * @external
     */
    intelligentTieringConfigurations: Array<CfnBucket.IntelligentTieringConfigurationProperty | cdk.IResolvable> | cdk.IResolvable | undefined;
    /**
     * `AWS::S3::Bucket.InventoryConfigurations`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket.html#cfn-s3-bucket-inventoryconfigurations
     * @external
     */
    inventoryConfigurations: Array<CfnBucket.InventoryConfigurationProperty | cdk.IResolvable> | cdk.IResolvable | undefined;
    /**
     * `AWS::S3::Bucket.LifecycleConfiguration`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket.html#cfn-s3-bucket-lifecycleconfig
     * @external
     */
    lifecycleConfiguration: CfnBucket.LifecycleConfigurationProperty | cdk.IResolvable | undefined;
    /**
     * `AWS::S3::Bucket.LoggingConfiguration`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket.html#cfn-s3-bucket-loggingconfig
     * @external
     */
    loggingConfiguration: CfnBucket.LoggingConfigurationProperty | cdk.IResolvable | undefined;
    /**
     * `AWS::S3::Bucket.MetricsConfigurations`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket.html#cfn-s3-bucket-metricsconfigurations
     * @external
     */
    metricsConfigurations: Array<CfnBucket.MetricsConfigurationProperty | cdk.IResolvable> | cdk.IResolvable | undefined;
    /**
     * `AWS::S3::Bucket.NotificationConfiguration`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket.html#cfn-s3-bucket-notification
     * @external
     */
    notificationConfiguration: CfnBucket.NotificationConfigurationProperty | cdk.IResolvable | undefined;
    /**
     * `AWS::S3::Bucket.ObjectLockConfiguration`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket.html#cfn-s3-bucket-objectlockconfiguration
     * @external
     */
    objectLockConfiguration: CfnBucket.ObjectLockConfigurationProperty | cdk.IResolvable | undefined;
    /**
     * `AWS::S3::Bucket.ObjectLockEnabled`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket.html#cfn-s3-bucket-objectlockenabled
     * @external
     */
    objectLockEnabled: boolean | cdk.IResolvable | undefined;
    /**
     * `AWS::S3::Bucket.OwnershipControls`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket.html#cfn-s3-bucket-ownershipcontrols
     * @external
     */
    ownershipControls: CfnBucket.OwnershipControlsProperty | cdk.IResolvable | undefined;
    /**
     * `AWS::S3::Bucket.PublicAccessBlockConfiguration`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket.html#cfn-s3-bucket-publicaccessblockconfiguration
     * @external
     */
    publicAccessBlockConfiguration: CfnBucket.PublicAccessBlockConfigurationProperty | cdk.IResolvable | undefined;
    /**
     * `AWS::S3::Bucket.ReplicationConfiguration`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket.html#cfn-s3-bucket-replicationconfiguration
     * @external
     */
    replicationConfiguration: CfnBucket.ReplicationConfigurationProperty | cdk.IResolvable | undefined;
    /**
     * `AWS::S3::Bucket.Tags`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket.html#cfn-s3-bucket-tags
     * @external
     */
    readonly tags: cdk.TagManager;
    /**
     * `AWS::S3::Bucket.VersioningConfiguration`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket.html#cfn-s3-bucket-versioning
     * @external
     */
    versioningConfiguration: CfnBucket.VersioningConfigurationProperty | cdk.IResolvable | undefined;
    /**
     * `AWS::S3::Bucket.WebsiteConfiguration`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket.html#cfn-s3-bucket-websiteconfiguration
     * @external
     */
    websiteConfiguration: CfnBucket.WebsiteConfigurationProperty | cdk.IResolvable | undefined;
    /**
     * Create a new `AWS::S3::Bucket`.
     *
     * @param scope - scope in which this resource is defined.
     * @param id - scoped id of the resource.
     * @param props - resource properties.
     * @external
     */
    constructor(scope: cdk.Construct, id: string, props?: CfnBucketProps);
    /**
     * (experimental) Examines the CloudFormation resource and discloses attributes.
     *
     * @param inspector - tree inspector to collect and process attributes.
     * @experimental
     */
    inspect(inspector: cdk.TreeInspector): void;
    /**
     * @external
     */
    protected get cfnProperties(): {
        [key: string]: any;
    };
    /**
     * @external
     */
    protected renderProperties(props: {
        [key: string]: any;
    }): {
        [key: string]: any;
    };
}
/**
 * A CloudFormation `AWS::S3::Bucket`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket.html
 * @external
 * @cloudformationResource AWS::S3::Bucket
 */
export declare namespace CfnBucket {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-abortincompletemultipartupload.html
     * @external
     */
    interface AbortIncompleteMultipartUploadProperty {
        /**
         * `CfnBucket.AbortIncompleteMultipartUploadProperty.DaysAfterInitiation`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-abortincompletemultipartupload.html#cfn-s3-bucket-abortincompletemultipartupload-daysafterinitiation
         * @external
         */
        readonly daysAfterInitiation: number;
    }
}
/**
 * A CloudFormation `AWS::S3::Bucket`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket.html
 * @external
 * @cloudformationResource AWS::S3::Bucket
 */
export declare namespace CfnBucket {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-accelerateconfiguration.html
     * @external
     */
    interface AccelerateConfigurationProperty {
        /**
         * `CfnBucket.AccelerateConfigurationProperty.AccelerationStatus`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-accelerateconfiguration.html#cfn-s3-bucket-accelerateconfiguration-accelerationstatus
         * @external
         */
        readonly accelerationStatus: string;
    }
}
/**
 * A CloudFormation `AWS::S3::Bucket`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket.html
 * @external
 * @cloudformationResource AWS::S3::Bucket
 */
export declare namespace CfnBucket {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-accesscontroltranslation.html
     * @external
     */
    interface AccessControlTranslationProperty {
        /**
         * `CfnBucket.AccessControlTranslationProperty.Owner`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-accesscontroltranslation.html#cfn-s3-bucket-accesscontroltranslation-owner
         * @external
         */
        readonly owner: string;
    }
}
/**
 * A CloudFormation `AWS::S3::Bucket`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket.html
 * @external
 * @cloudformationResource AWS::S3::Bucket
 */
export declare namespace CfnBucket {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-analyticsconfiguration.html
     * @external
     */
    interface AnalyticsConfigurationProperty {
        /**
         * `CfnBucket.AnalyticsConfigurationProperty.Id`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-analyticsconfiguration.html#cfn-s3-bucket-analyticsconfiguration-id
         * @external
         */
        readonly id: string;
        /**
         * `CfnBucket.AnalyticsConfigurationProperty.Prefix`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-analyticsconfiguration.html#cfn-s3-bucket-analyticsconfiguration-prefix
         * @external
         */
        readonly prefix?: string;
        /**
         * `CfnBucket.AnalyticsConfigurationProperty.StorageClassAnalysis`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-analyticsconfiguration.html#cfn-s3-bucket-analyticsconfiguration-storageclassanalysis
         * @external
         */
        readonly storageClassAnalysis: CfnBucket.StorageClassAnalysisProperty | cdk.IResolvable;
        /**
         * `CfnBucket.AnalyticsConfigurationProperty.TagFilters`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-analyticsconfiguration.html#cfn-s3-bucket-analyticsconfiguration-tagfilters
         * @external
         */
        readonly tagFilters?: Array<CfnBucket.TagFilterProperty | cdk.IResolvable> | cdk.IResolvable;
    }
}
/**
 * A CloudFormation `AWS::S3::Bucket`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket.html
 * @external
 * @cloudformationResource AWS::S3::Bucket
 */
export declare namespace CfnBucket {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-bucketencryption.html
     * @external
     */
    interface BucketEncryptionProperty {
        /**
         * `CfnBucket.BucketEncryptionProperty.ServerSideEncryptionConfiguration`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-bucketencryption.html#cfn-s3-bucket-bucketencryption-serversideencryptionconfiguration
         * @external
         */
        readonly serverSideEncryptionConfiguration: Array<CfnBucket.ServerSideEncryptionRuleProperty | cdk.IResolvable> | cdk.IResolvable;
    }
}
/**
 * A CloudFormation `AWS::S3::Bucket`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket.html
 * @external
 * @cloudformationResource AWS::S3::Bucket
 */
export declare namespace CfnBucket {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-cors.html
     * @external
     */
    interface CorsConfigurationProperty {
        /**
         * `CfnBucket.CorsConfigurationProperty.CorsRules`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-cors.html#cfn-s3-bucket-cors-corsrule
         * @external
         */
        readonly corsRules: Array<CfnBucket.CorsRuleProperty | cdk.IResolvable> | cdk.IResolvable;
    }
}
/**
 * A CloudFormation `AWS::S3::Bucket`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket.html
 * @external
 * @cloudformationResource AWS::S3::Bucket
 */
export declare namespace CfnBucket {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-cors-corsrule.html
     * @external
     */
    interface CorsRuleProperty {
        /**
         * `CfnBucket.CorsRuleProperty.AllowedHeaders`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-cors-corsrule.html#cfn-s3-bucket-cors-corsrule-allowedheaders
         * @external
         */
        readonly allowedHeaders?: string[];
        /**
         * `CfnBucket.CorsRuleProperty.AllowedMethods`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-cors-corsrule.html#cfn-s3-bucket-cors-corsrule-allowedmethods
         * @external
         */
        readonly allowedMethods: string[];
        /**
         * `CfnBucket.CorsRuleProperty.AllowedOrigins`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-cors-corsrule.html#cfn-s3-bucket-cors-corsrule-allowedorigins
         * @external
         */
        readonly allowedOrigins: string[];
        /**
         * `CfnBucket.CorsRuleProperty.ExposedHeaders`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-cors-corsrule.html#cfn-s3-bucket-cors-corsrule-exposedheaders
         * @external
         */
        readonly exposedHeaders?: string[];
        /**
         * `CfnBucket.CorsRuleProperty.Id`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-cors-corsrule.html#cfn-s3-bucket-cors-corsrule-id
         * @external
         */
        readonly id?: string;
        /**
         * `CfnBucket.CorsRuleProperty.MaxAge`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-cors-corsrule.html#cfn-s3-bucket-cors-corsrule-maxage
         * @external
         */
        readonly maxAge?: number;
    }
}
/**
 * A CloudFormation `AWS::S3::Bucket`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket.html
 * @external
 * @cloudformationResource AWS::S3::Bucket
 */
export declare namespace CfnBucket {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-dataexport.html
     * @external
     */
    interface DataExportProperty {
        /**
         * `CfnBucket.DataExportProperty.Destination`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-dataexport.html#cfn-s3-bucket-dataexport-destination
         * @external
         */
        readonly destination: CfnBucket.DestinationProperty | cdk.IResolvable;
        /**
         * `CfnBucket.DataExportProperty.OutputSchemaVersion`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-dataexport.html#cfn-s3-bucket-dataexport-outputschemaversion
         * @external
         */
        readonly outputSchemaVersion: string;
    }
}
/**
 * A CloudFormation `AWS::S3::Bucket`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket.html
 * @external
 * @cloudformationResource AWS::S3::Bucket
 */
export declare namespace CfnBucket {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-defaultretention.html
     * @external
     */
    interface DefaultRetentionProperty {
        /**
         * `CfnBucket.DefaultRetentionProperty.Days`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-defaultretention.html#cfn-s3-bucket-defaultretention-days
         * @external
         */
        readonly days?: number;
        /**
         * `CfnBucket.DefaultRetentionProperty.Mode`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-defaultretention.html#cfn-s3-bucket-defaultretention-mode
         * @external
         */
        readonly mode?: string;
        /**
         * `CfnBucket.DefaultRetentionProperty.Years`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-defaultretention.html#cfn-s3-bucket-defaultretention-years
         * @external
         */
        readonly years?: number;
    }
}
/**
 * A CloudFormation `AWS::S3::Bucket`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket.html
 * @external
 * @cloudformationResource AWS::S3::Bucket
 */
export declare namespace CfnBucket {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-deletemarkerreplication.html
     * @external
     */
    interface DeleteMarkerReplicationProperty {
        /**
         * `CfnBucket.DeleteMarkerReplicationProperty.Status`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-deletemarkerreplication.html#cfn-s3-bucket-deletemarkerreplication-status
         * @external
         */
        readonly status?: string;
    }
}
/**
 * A CloudFormation `AWS::S3::Bucket`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket.html
 * @external
 * @cloudformationResource AWS::S3::Bucket
 */
export declare namespace CfnBucket {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-destination.html
     * @external
     */
    interface DestinationProperty {
        /**
         * `CfnBucket.DestinationProperty.BucketAccountId`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-destination.html#cfn-s3-bucket-destination-bucketaccountid
         * @external
         */
        readonly bucketAccountId?: string;
        /**
         * `CfnBucket.DestinationProperty.BucketArn`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-destination.html#cfn-s3-bucket-destination-bucketarn
         * @external
         */
        readonly bucketArn: string;
        /**
         * `CfnBucket.DestinationProperty.Format`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-destination.html#cfn-s3-bucket-destination-format
         * @external
         */
        readonly format: string;
        /**
         * `CfnBucket.DestinationProperty.Prefix`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-destination.html#cfn-s3-bucket-destination-prefix
         * @external
         */
        readonly prefix?: string;
    }
}
/**
 * A CloudFormation `AWS::S3::Bucket`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket.html
 * @external
 * @cloudformationResource AWS::S3::Bucket
 */
export declare namespace CfnBucket {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-encryptionconfiguration.html
     * @external
     */
    interface EncryptionConfigurationProperty {
        /**
         * `CfnBucket.EncryptionConfigurationProperty.ReplicaKmsKeyID`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-encryptionconfiguration.html#cfn-s3-bucket-encryptionconfiguration-replicakmskeyid
         * @external
         */
        readonly replicaKmsKeyId: string;
    }
}
/**
 * A CloudFormation `AWS::S3::Bucket`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket.html
 * @external
 * @cloudformationResource AWS::S3::Bucket
 */
export declare namespace CfnBucket {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-notificationconfiguration-config-filter-s3key-rules.html
     * @external
     */
    interface FilterRuleProperty {
        /**
         * `CfnBucket.FilterRuleProperty.Name`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-notificationconfiguration-config-filter-s3key-rules.html#cfn-s3-bucket-notificationconfiguraiton-config-filter-s3key-rules-name
         * @external
         */
        readonly name: string;
        /**
         * `CfnBucket.FilterRuleProperty.Value`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-notificationconfiguration-config-filter-s3key-rules.html#cfn-s3-bucket-notificationconfiguraiton-config-filter-s3key-rules-value
         * @external
         */
        readonly value: string;
    }
}
/**
 * A CloudFormation `AWS::S3::Bucket`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket.html
 * @external
 * @cloudformationResource AWS::S3::Bucket
 */
export declare namespace CfnBucket {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-intelligenttieringconfiguration.html
     * @external
     */
    interface IntelligentTieringConfigurationProperty {
        /**
         * `CfnBucket.IntelligentTieringConfigurationProperty.Id`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-intelligenttieringconfiguration.html#cfn-s3-bucket-intelligenttieringconfiguration-id
         * @external
         */
        readonly id: string;
        /**
         * `CfnBucket.IntelligentTieringConfigurationProperty.Prefix`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-intelligenttieringconfiguration.html#cfn-s3-bucket-intelligenttieringconfiguration-prefix
         * @external
         */
        readonly prefix?: string;
        /**
         * `CfnBucket.IntelligentTieringConfigurationProperty.Status`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-intelligenttieringconfiguration.html#cfn-s3-bucket-intelligenttieringconfiguration-status
         * @external
         */
        readonly status: string;
        /**
         * `CfnBucket.IntelligentTieringConfigurationProperty.TagFilters`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-intelligenttieringconfiguration.html#cfn-s3-bucket-intelligenttieringconfiguration-tagfilters
         * @external
         */
        readonly tagFilters?: Array<CfnBucket.TagFilterProperty | cdk.IResolvable> | cdk.IResolvable;
        /**
         * `CfnBucket.IntelligentTieringConfigurationProperty.Tierings`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-intelligenttieringconfiguration.html#cfn-s3-bucket-intelligenttieringconfiguration-tierings
         * @external
         */
        readonly tierings: Array<CfnBucket.TieringProperty | cdk.IResolvable> | cdk.IResolvable;
    }
}
/**
 * A CloudFormation `AWS::S3::Bucket`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket.html
 * @external
 * @cloudformationResource AWS::S3::Bucket
 */
export declare namespace CfnBucket {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-inventoryconfiguration.html
     * @external
     */
    interface InventoryConfigurationProperty {
        /**
         * `CfnBucket.InventoryConfigurationProperty.Destination`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-inventoryconfiguration.html#cfn-s3-bucket-inventoryconfiguration-destination
         * @external
         */
        readonly destination: CfnBucket.DestinationProperty | cdk.IResolvable;
        /**
         * `CfnBucket.InventoryConfigurationProperty.Enabled`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-inventoryconfiguration.html#cfn-s3-bucket-inventoryconfiguration-enabled
         * @external
         */
        readonly enabled: boolean | cdk.IResolvable;
        /**
         * `CfnBucket.InventoryConfigurationProperty.Id`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-inventoryconfiguration.html#cfn-s3-bucket-inventoryconfiguration-id
         * @external
         */
        readonly id: string;
        /**
         * `CfnBucket.InventoryConfigurationProperty.IncludedObjectVersions`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-inventoryconfiguration.html#cfn-s3-bucket-inventoryconfiguration-includedobjectversions
         * @external
         */
        readonly includedObjectVersions: string;
        /**
         * `CfnBucket.InventoryConfigurationProperty.OptionalFields`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-inventoryconfiguration.html#cfn-s3-bucket-inventoryconfiguration-optionalfields
         * @external
         */
        readonly optionalFields?: string[];
        /**
         * `CfnBucket.InventoryConfigurationProperty.Prefix`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-inventoryconfiguration.html#cfn-s3-bucket-inventoryconfiguration-prefix
         * @external
         */
        readonly prefix?: string;
        /**
         * `CfnBucket.InventoryConfigurationProperty.ScheduleFrequency`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-inventoryconfiguration.html#cfn-s3-bucket-inventoryconfiguration-schedulefrequency
         * @external
         */
        readonly scheduleFrequency: string;
    }
}
/**
 * A CloudFormation `AWS::S3::Bucket`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket.html
 * @external
 * @cloudformationResource AWS::S3::Bucket
 */
export declare namespace CfnBucket {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-notificationconfig-lambdaconfig.html
     * @external
     */
    interface LambdaConfigurationProperty {
        /**
         * `CfnBucket.LambdaConfigurationProperty.Event`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-notificationconfig-lambdaconfig.html#cfn-s3-bucket-notificationconfig-lambdaconfig-event
         * @external
         */
        readonly event: string;
        /**
         * `CfnBucket.LambdaConfigurationProperty.Filter`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-notificationconfig-lambdaconfig.html#cfn-s3-bucket-notificationconfig-lambdaconfig-filter
         * @external
         */
        readonly filter?: CfnBucket.NotificationFilterProperty | cdk.IResolvable;
        /**
         * `CfnBucket.LambdaConfigurationProperty.Function`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-notificationconfig-lambdaconfig.html#cfn-s3-bucket-notificationconfig-lambdaconfig-function
         * @external
         */
        readonly function: string;
    }
}
/**
 * A CloudFormation `AWS::S3::Bucket`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket.html
 * @external
 * @cloudformationResource AWS::S3::Bucket
 */
export declare namespace CfnBucket {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-lifecycleconfig.html
     * @external
     */
    interface LifecycleConfigurationProperty {
        /**
         * `CfnBucket.LifecycleConfigurationProperty.Rules`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-lifecycleconfig.html#cfn-s3-bucket-lifecycleconfig-rules
         * @external
         */
        readonly rules: Array<CfnBucket.RuleProperty | cdk.IResolvable> | cdk.IResolvable;
    }
}
/**
 * A CloudFormation `AWS::S3::Bucket`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket.html
 * @external
 * @cloudformationResource AWS::S3::Bucket
 */
export declare namespace CfnBucket {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-loggingconfig.html
     * @external
     */
    interface LoggingConfigurationProperty {
        /**
         * `CfnBucket.LoggingConfigurationProperty.DestinationBucketName`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-loggingconfig.html#cfn-s3-bucket-loggingconfig-destinationbucketname
         * @external
         */
        readonly destinationBucketName?: string;
        /**
         * `CfnBucket.LoggingConfigurationProperty.LogFilePrefix`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-loggingconfig.html#cfn-s3-bucket-loggingconfig-logfileprefix
         * @external
         */
        readonly logFilePrefix?: string;
    }
}
/**
 * A CloudFormation `AWS::S3::Bucket`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket.html
 * @external
 * @cloudformationResource AWS::S3::Bucket
 */
export declare namespace CfnBucket {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-metrics.html
     * @external
     */
    interface MetricsProperty {
        /**
         * `CfnBucket.MetricsProperty.EventThreshold`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-metrics.html#cfn-s3-bucket-metrics-eventthreshold
         * @external
         */
        readonly eventThreshold?: CfnBucket.ReplicationTimeValueProperty | cdk.IResolvable;
        /**
         * `CfnBucket.MetricsProperty.Status`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-metrics.html#cfn-s3-bucket-metrics-status
         * @external
         */
        readonly status: string;
    }
}
/**
 * A CloudFormation `AWS::S3::Bucket`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket.html
 * @external
 * @cloudformationResource AWS::S3::Bucket
 */
export declare namespace CfnBucket {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-metricsconfiguration.html
     * @external
     */
    interface MetricsConfigurationProperty {
        /**
         * `CfnBucket.MetricsConfigurationProperty.Id`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-metricsconfiguration.html#cfn-s3-bucket-metricsconfiguration-id
         * @external
         */
        readonly id: string;
        /**
         * `CfnBucket.MetricsConfigurationProperty.Prefix`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-metricsconfiguration.html#cfn-s3-bucket-metricsconfiguration-prefix
         * @external
         */
        readonly prefix?: string;
        /**
         * `CfnBucket.MetricsConfigurationProperty.TagFilters`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-metricsconfiguration.html#cfn-s3-bucket-metricsconfiguration-tagfilters
         * @external
         */
        readonly tagFilters?: Array<CfnBucket.TagFilterProperty | cdk.IResolvable> | cdk.IResolvable;
    }
}
/**
 * A CloudFormation `AWS::S3::Bucket`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket.html
 * @external
 * @cloudformationResource AWS::S3::Bucket
 */
export declare namespace CfnBucket {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-lifecycleconfig-rule-noncurrentversiontransition.html
     * @external
     */
    interface NoncurrentVersionTransitionProperty {
        /**
         * `CfnBucket.NoncurrentVersionTransitionProperty.StorageClass`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-lifecycleconfig-rule-noncurrentversiontransition.html#cfn-s3-bucket-lifecycleconfig-rule-noncurrentversiontransition-storageclass
         * @external
         */
        readonly storageClass: string;
        /**
         * `CfnBucket.NoncurrentVersionTransitionProperty.TransitionInDays`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-lifecycleconfig-rule-noncurrentversiontransition.html#cfn-s3-bucket-lifecycleconfig-rule-noncurrentversiontransition-transitionindays
         * @external
         */
        readonly transitionInDays: number;
    }
}
/**
 * A CloudFormation `AWS::S3::Bucket`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket.html
 * @external
 * @cloudformationResource AWS::S3::Bucket
 */
export declare namespace CfnBucket {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-notificationconfig.html
     * @external
     */
    interface NotificationConfigurationProperty {
        /**
         * `CfnBucket.NotificationConfigurationProperty.LambdaConfigurations`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-notificationconfig.html#cfn-s3-bucket-notificationconfig-lambdaconfig
         * @external
         */
        readonly lambdaConfigurations?: Array<CfnBucket.LambdaConfigurationProperty | cdk.IResolvable> | cdk.IResolvable;
        /**
         * `CfnBucket.NotificationConfigurationProperty.QueueConfigurations`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-notificationconfig.html#cfn-s3-bucket-notificationconfig-queueconfig
         * @external
         */
        readonly queueConfigurations?: Array<CfnBucket.QueueConfigurationProperty | cdk.IResolvable> | cdk.IResolvable;
        /**
         * `CfnBucket.NotificationConfigurationProperty.TopicConfigurations`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-notificationconfig.html#cfn-s3-bucket-notificationconfig-topicconfig
         * @external
         */
        readonly topicConfigurations?: Array<CfnBucket.TopicConfigurationProperty | cdk.IResolvable> | cdk.IResolvable;
    }
}
/**
 * A CloudFormation `AWS::S3::Bucket`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket.html
 * @external
 * @cloudformationResource AWS::S3::Bucket
 */
export declare namespace CfnBucket {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-notificationconfiguration-config-filter.html
     * @external
     */
    interface NotificationFilterProperty {
        /**
         * `CfnBucket.NotificationFilterProperty.S3Key`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-notificationconfiguration-config-filter.html#cfn-s3-bucket-notificationconfiguraiton-config-filter-s3key
         * @external
         */
        readonly s3Key: CfnBucket.S3KeyFilterProperty | cdk.IResolvable;
    }
}
/**
 * A CloudFormation `AWS::S3::Bucket`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket.html
 * @external
 * @cloudformationResource AWS::S3::Bucket
 */
export declare namespace CfnBucket {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-objectlockconfiguration.html
     * @external
     */
    interface ObjectLockConfigurationProperty {
        /**
         * `CfnBucket.ObjectLockConfigurationProperty.ObjectLockEnabled`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-objectlockconfiguration.html#cfn-s3-bucket-objectlockconfiguration-objectlockenabled
         * @external
         */
        readonly objectLockEnabled?: string;
        /**
         * `CfnBucket.ObjectLockConfigurationProperty.Rule`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-objectlockconfiguration.html#cfn-s3-bucket-objectlockconfiguration-rule
         * @external
         */
        readonly rule?: CfnBucket.ObjectLockRuleProperty | cdk.IResolvable;
    }
}
/**
 * A CloudFormation `AWS::S3::Bucket`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket.html
 * @external
 * @cloudformationResource AWS::S3::Bucket
 */
export declare namespace CfnBucket {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-objectlockrule.html
     * @external
     */
    interface ObjectLockRuleProperty {
        /**
         * `CfnBucket.ObjectLockRuleProperty.DefaultRetention`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-objectlockrule.html#cfn-s3-bucket-objectlockrule-defaultretention
         * @external
         */
        readonly defaultRetention?: CfnBucket.DefaultRetentionProperty | cdk.IResolvable;
    }
}
/**
 * A CloudFormation `AWS::S3::Bucket`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket.html
 * @external
 * @cloudformationResource AWS::S3::Bucket
 */
export declare namespace CfnBucket {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-ownershipcontrols.html
     * @external
     */
    interface OwnershipControlsProperty {
        /**
         * `CfnBucket.OwnershipControlsProperty.Rules`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-ownershipcontrols.html#cfn-s3-bucket-ownershipcontrols-rules
         * @external
         */
        readonly rules: Array<CfnBucket.OwnershipControlsRuleProperty | cdk.IResolvable> | cdk.IResolvable;
    }
}
/**
 * A CloudFormation `AWS::S3::Bucket`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket.html
 * @external
 * @cloudformationResource AWS::S3::Bucket
 */
export declare namespace CfnBucket {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-ownershipcontrolsrule.html
     * @external
     */
    interface OwnershipControlsRuleProperty {
        /**
         * `CfnBucket.OwnershipControlsRuleProperty.ObjectOwnership`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-ownershipcontrolsrule.html#cfn-s3-bucket-ownershipcontrolsrule-objectownership
         * @external
         */
        readonly objectOwnership?: string;
    }
}
/**
 * A CloudFormation `AWS::S3::Bucket`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket.html
 * @external
 * @cloudformationResource AWS::S3::Bucket
 */
export declare namespace CfnBucket {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-publicaccessblockconfiguration.html
     * @external
     */
    interface PublicAccessBlockConfigurationProperty {
        /**
         * `CfnBucket.PublicAccessBlockConfigurationProperty.BlockPublicAcls`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-publicaccessblockconfiguration.html#cfn-s3-bucket-publicaccessblockconfiguration-blockpublicacls
         * @external
         */
        readonly blockPublicAcls?: boolean | cdk.IResolvable;
        /**
         * `CfnBucket.PublicAccessBlockConfigurationProperty.BlockPublicPolicy`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-publicaccessblockconfiguration.html#cfn-s3-bucket-publicaccessblockconfiguration-blockpublicpolicy
         * @external
         */
        readonly blockPublicPolicy?: boolean | cdk.IResolvable;
        /**
         * `CfnBucket.PublicAccessBlockConfigurationProperty.IgnorePublicAcls`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-publicaccessblockconfiguration.html#cfn-s3-bucket-publicaccessblockconfiguration-ignorepublicacls
         * @external
         */
        readonly ignorePublicAcls?: boolean | cdk.IResolvable;
        /**
         * `CfnBucket.PublicAccessBlockConfigurationProperty.RestrictPublicBuckets`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-publicaccessblockconfiguration.html#cfn-s3-bucket-publicaccessblockconfiguration-restrictpublicbuckets
         * @external
         */
        readonly restrictPublicBuckets?: boolean | cdk.IResolvable;
    }
}
/**
 * A CloudFormation `AWS::S3::Bucket`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket.html
 * @external
 * @cloudformationResource AWS::S3::Bucket
 */
export declare namespace CfnBucket {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-notificationconfig-queueconfig.html
     * @external
     */
    interface QueueConfigurationProperty {
        /**
         * `CfnBucket.QueueConfigurationProperty.Event`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-notificationconfig-queueconfig.html#cfn-s3-bucket-notificationconfig-queueconfig-event
         * @external
         */
        readonly event: string;
        /**
         * `CfnBucket.QueueConfigurationProperty.Filter`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-notificationconfig-queueconfig.html#cfn-s3-bucket-notificationconfig-queueconfig-filter
         * @external
         */
        readonly filter?: CfnBucket.NotificationFilterProperty | cdk.IResolvable;
        /**
         * `CfnBucket.QueueConfigurationProperty.Queue`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-notificationconfig-queueconfig.html#cfn-s3-bucket-notificationconfig-queueconfig-queue
         * @external
         */
        readonly queue: string;
    }
}
/**
 * A CloudFormation `AWS::S3::Bucket`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket.html
 * @external
 * @cloudformationResource AWS::S3::Bucket
 */
export declare namespace CfnBucket {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-websiteconfiguration-redirectallrequeststo.html
     * @external
     */
    interface RedirectAllRequestsToProperty {
        /**
         * `CfnBucket.RedirectAllRequestsToProperty.HostName`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-websiteconfiguration-redirectallrequeststo.html#cfn-s3-websiteconfiguration-redirectallrequeststo-hostname
         * @external
         */
        readonly hostName: string;
        /**
         * `CfnBucket.RedirectAllRequestsToProperty.Protocol`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-websiteconfiguration-redirectallrequeststo.html#cfn-s3-websiteconfiguration-redirectallrequeststo-protocol
         * @external
         */
        readonly protocol?: string;
    }
}
/**
 * A CloudFormation `AWS::S3::Bucket`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket.html
 * @external
 * @cloudformationResource AWS::S3::Bucket
 */
export declare namespace CfnBucket {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-websiteconfiguration-routingrules-redirectrule.html
     * @external
     */
    interface RedirectRuleProperty {
        /**
         * `CfnBucket.RedirectRuleProperty.HostName`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-websiteconfiguration-routingrules-redirectrule.html#cfn-s3-websiteconfiguration-redirectrule-hostname
         * @external
         */
        readonly hostName?: string;
        /**
         * `CfnBucket.RedirectRuleProperty.HttpRedirectCode`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-websiteconfiguration-routingrules-redirectrule.html#cfn-s3-websiteconfiguration-redirectrule-httpredirectcode
         * @external
         */
        readonly httpRedirectCode?: string;
        /**
         * `CfnBucket.RedirectRuleProperty.Protocol`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-websiteconfiguration-routingrules-redirectrule.html#cfn-s3-websiteconfiguration-redirectrule-protocol
         * @external
         */
        readonly protocol?: string;
        /**
         * `CfnBucket.RedirectRuleProperty.ReplaceKeyPrefixWith`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-websiteconfiguration-routingrules-redirectrule.html#cfn-s3-websiteconfiguration-redirectrule-replacekeyprefixwith
         * @external
         */
        readonly replaceKeyPrefixWith?: string;
        /**
         * `CfnBucket.RedirectRuleProperty.ReplaceKeyWith`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-websiteconfiguration-routingrules-redirectrule.html#cfn-s3-websiteconfiguration-redirectrule-replacekeywith
         * @external
         */
        readonly replaceKeyWith?: string;
    }
}
/**
 * A CloudFormation `AWS::S3::Bucket`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket.html
 * @external
 * @cloudformationResource AWS::S3::Bucket
 */
export declare namespace CfnBucket {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-replicationconfiguration.html
     * @external
     */
    interface ReplicationConfigurationProperty {
        /**
         * `CfnBucket.ReplicationConfigurationProperty.Role`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-replicationconfiguration.html#cfn-s3-bucket-replicationconfiguration-role
         * @external
         */
        readonly role: string;
        /**
         * `CfnBucket.ReplicationConfigurationProperty.Rules`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-replicationconfiguration.html#cfn-s3-bucket-replicationconfiguration-rules
         * @external
         */
        readonly rules: Array<CfnBucket.ReplicationRuleProperty | cdk.IResolvable> | cdk.IResolvable;
    }
}
/**
 * A CloudFormation `AWS::S3::Bucket`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket.html
 * @external
 * @cloudformationResource AWS::S3::Bucket
 */
export declare namespace CfnBucket {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-replicationconfiguration-rules-destination.html
     * @external
     */
    interface ReplicationDestinationProperty {
        /**
         * `CfnBucket.ReplicationDestinationProperty.AccessControlTranslation`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-replicationconfiguration-rules-destination.html#cfn-s3-bucket-replicationdestination-accesscontroltranslation
         * @external
         */
        readonly accessControlTranslation?: CfnBucket.AccessControlTranslationProperty | cdk.IResolvable;
        /**
         * `CfnBucket.ReplicationDestinationProperty.Account`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-replicationconfiguration-rules-destination.html#cfn-s3-bucket-replicationdestination-account
         * @external
         */
        readonly account?: string;
        /**
         * `CfnBucket.ReplicationDestinationProperty.Bucket`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-replicationconfiguration-rules-destination.html#cfn-s3-bucket-replicationconfiguration-rules-destination-bucket
         * @external
         */
        readonly bucket: string;
        /**
         * `CfnBucket.ReplicationDestinationProperty.EncryptionConfiguration`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-replicationconfiguration-rules-destination.html#cfn-s3-bucket-replicationdestination-encryptionconfiguration
         * @external
         */
        readonly encryptionConfiguration?: CfnBucket.EncryptionConfigurationProperty | cdk.IResolvable;
        /**
         * `CfnBucket.ReplicationDestinationProperty.Metrics`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-replicationconfiguration-rules-destination.html#cfn-s3-bucket-replicationdestination-metrics
         * @external
         */
        readonly metrics?: CfnBucket.MetricsProperty | cdk.IResolvable;
        /**
         * `CfnBucket.ReplicationDestinationProperty.ReplicationTime`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-replicationconfiguration-rules-destination.html#cfn-s3-bucket-replicationdestination-replicationtime
         * @external
         */
        readonly replicationTime?: CfnBucket.ReplicationTimeProperty | cdk.IResolvable;
        /**
         * `CfnBucket.ReplicationDestinationProperty.StorageClass`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-replicationconfiguration-rules-destination.html#cfn-s3-bucket-replicationconfiguration-rules-destination-storageclass
         * @external
         */
        readonly storageClass?: string;
    }
}
/**
 * A CloudFormation `AWS::S3::Bucket`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket.html
 * @external
 * @cloudformationResource AWS::S3::Bucket
 */
export declare namespace CfnBucket {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-replicationconfiguration-rules.html
     * @external
     */
    interface ReplicationRuleProperty {
        /**
         * `CfnBucket.ReplicationRuleProperty.DeleteMarkerReplication`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-replicationconfiguration-rules.html#cfn-s3-bucket-replicationrule-deletemarkerreplication
         * @external
         */
        readonly deleteMarkerReplication?: CfnBucket.DeleteMarkerReplicationProperty | cdk.IResolvable;
        /**
         * `CfnBucket.ReplicationRuleProperty.Destination`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-replicationconfiguration-rules.html#cfn-s3-bucket-replicationconfiguration-rules-destination
         * @external
         */
        readonly destination: CfnBucket.ReplicationDestinationProperty | cdk.IResolvable;
        /**
         * `CfnBucket.ReplicationRuleProperty.Filter`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-replicationconfiguration-rules.html#cfn-s3-bucket-replicationrule-filter
         * @external
         */
        readonly filter?: CfnBucket.ReplicationRuleFilterProperty | cdk.IResolvable;
        /**
         * `CfnBucket.ReplicationRuleProperty.Id`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-replicationconfiguration-rules.html#cfn-s3-bucket-replicationconfiguration-rules-id
         * @external
         */
        readonly id?: string;
        /**
         * `CfnBucket.ReplicationRuleProperty.Prefix`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-replicationconfiguration-rules.html#cfn-s3-bucket-replicationconfiguration-rules-prefix
         * @external
         */
        readonly prefix?: string;
        /**
         * `CfnBucket.ReplicationRuleProperty.Priority`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-replicationconfiguration-rules.html#cfn-s3-bucket-replicationrule-priority
         * @external
         */
        readonly priority?: number;
        /**
         * `CfnBucket.ReplicationRuleProperty.SourceSelectionCriteria`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-replicationconfiguration-rules.html#cfn-s3-bucket-replicationrule-sourceselectioncriteria
         * @external
         */
        readonly sourceSelectionCriteria?: CfnBucket.SourceSelectionCriteriaProperty | cdk.IResolvable;
        /**
         * `CfnBucket.ReplicationRuleProperty.Status`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-replicationconfiguration-rules.html#cfn-s3-bucket-replicationconfiguration-rules-status
         * @external
         */
        readonly status: string;
    }
}
/**
 * A CloudFormation `AWS::S3::Bucket`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket.html
 * @external
 * @cloudformationResource AWS::S3::Bucket
 */
export declare namespace CfnBucket {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-replicationruleandoperator.html
     * @external
     */
    interface ReplicationRuleAndOperatorProperty {
        /**
         * `CfnBucket.ReplicationRuleAndOperatorProperty.Prefix`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-replicationruleandoperator.html#cfn-s3-bucket-replicationruleandoperator-prefix
         * @external
         */
        readonly prefix?: string;
        /**
         * `CfnBucket.ReplicationRuleAndOperatorProperty.TagFilters`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-replicationruleandoperator.html#cfn-s3-bucket-replicationruleandoperator-tagfilters
         * @external
         */
        readonly tagFilters?: Array<CfnBucket.TagFilterProperty | cdk.IResolvable> | cdk.IResolvable;
    }
}
/**
 * A CloudFormation `AWS::S3::Bucket`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket.html
 * @external
 * @cloudformationResource AWS::S3::Bucket
 */
export declare namespace CfnBucket {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-replicationrulefilter.html
     * @external
     */
    interface ReplicationRuleFilterProperty {
        /**
         * `CfnBucket.ReplicationRuleFilterProperty.And`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-replicationrulefilter.html#cfn-s3-bucket-replicationrulefilter-and
         * @external
         */
        readonly and?: CfnBucket.ReplicationRuleAndOperatorProperty | cdk.IResolvable;
        /**
         * `CfnBucket.ReplicationRuleFilterProperty.Prefix`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-replicationrulefilter.html#cfn-s3-bucket-replicationrulefilter-prefix
         * @external
         */
        readonly prefix?: string;
        /**
         * `CfnBucket.ReplicationRuleFilterProperty.TagFilter`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-replicationrulefilter.html#cfn-s3-bucket-replicationrulefilter-tagfilter
         * @external
         */
        readonly tagFilter?: CfnBucket.TagFilterProperty | cdk.IResolvable;
    }
}
/**
 * A CloudFormation `AWS::S3::Bucket`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket.html
 * @external
 * @cloudformationResource AWS::S3::Bucket
 */
export declare namespace CfnBucket {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-replicationtime.html
     * @external
     */
    interface ReplicationTimeProperty {
        /**
         * `CfnBucket.ReplicationTimeProperty.Status`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-replicationtime.html#cfn-s3-bucket-replicationtime-status
         * @external
         */
        readonly status: string;
        /**
         * `CfnBucket.ReplicationTimeProperty.Time`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-replicationtime.html#cfn-s3-bucket-replicationtime-time
         * @external
         */
        readonly time: CfnBucket.ReplicationTimeValueProperty | cdk.IResolvable;
    }
}
/**
 * A CloudFormation `AWS::S3::Bucket`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket.html
 * @external
 * @cloudformationResource AWS::S3::Bucket
 */
export declare namespace CfnBucket {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-replicationtimevalue.html
     * @external
     */
    interface ReplicationTimeValueProperty {
        /**
         * `CfnBucket.ReplicationTimeValueProperty.Minutes`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-replicationtimevalue.html#cfn-s3-bucket-replicationtimevalue-minutes
         * @external
         */
        readonly minutes: number;
    }
}
/**
 * A CloudFormation `AWS::S3::Bucket`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket.html
 * @external
 * @cloudformationResource AWS::S3::Bucket
 */
export declare namespace CfnBucket {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-websiteconfiguration-routingrules.html
     * @external
     */
    interface RoutingRuleProperty {
        /**
         * `CfnBucket.RoutingRuleProperty.RedirectRule`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-websiteconfiguration-routingrules.html#cfn-s3-websiteconfiguration-routingrules-redirectrule
         * @external
         */
        readonly redirectRule: CfnBucket.RedirectRuleProperty | cdk.IResolvable;
        /**
         * `CfnBucket.RoutingRuleProperty.RoutingRuleCondition`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-websiteconfiguration-routingrules.html#cfn-s3-websiteconfiguration-routingrules-routingrulecondition
         * @external
         */
        readonly routingRuleCondition?: CfnBucket.RoutingRuleConditionProperty | cdk.IResolvable;
    }
}
/**
 * A CloudFormation `AWS::S3::Bucket`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket.html
 * @external
 * @cloudformationResource AWS::S3::Bucket
 */
export declare namespace CfnBucket {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-websiteconfiguration-routingrules-routingrulecondition.html
     * @external
     */
    interface RoutingRuleConditionProperty {
        /**
         * `CfnBucket.RoutingRuleConditionProperty.HttpErrorCodeReturnedEquals`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-websiteconfiguration-routingrules-routingrulecondition.html#cfn-s3-websiteconfiguration-routingrules-routingrulecondition-httperrorcodereturnedequals
         * @external
         */
        readonly httpErrorCodeReturnedEquals?: string;
        /**
         * `CfnBucket.RoutingRuleConditionProperty.KeyPrefixEquals`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-websiteconfiguration-routingrules-routingrulecondition.html#cfn-s3-websiteconfiguration-routingrules-routingrulecondition-keyprefixequals
         * @external
         */
        readonly keyPrefixEquals?: string;
    }
}
/**
 * A CloudFormation `AWS::S3::Bucket`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket.html
 * @external
 * @cloudformationResource AWS::S3::Bucket
 */
export declare namespace CfnBucket {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-lifecycleconfig-rule.html
     * @external
     */
    interface RuleProperty {
        /**
         * `CfnBucket.RuleProperty.AbortIncompleteMultipartUpload`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-lifecycleconfig-rule.html#cfn-s3-bucket-rule-abortincompletemultipartupload
         * @external
         */
        readonly abortIncompleteMultipartUpload?: CfnBucket.AbortIncompleteMultipartUploadProperty | cdk.IResolvable;
        /**
         * `CfnBucket.RuleProperty.ExpirationDate`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-lifecycleconfig-rule.html#cfn-s3-bucket-lifecycleconfig-rule-expirationdate
         * @external
         */
        readonly expirationDate?: Date | cdk.IResolvable;
        /**
         * `CfnBucket.RuleProperty.ExpirationInDays`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-lifecycleconfig-rule.html#cfn-s3-bucket-lifecycleconfig-rule-expirationindays
         * @external
         */
        readonly expirationInDays?: number;
        /**
         * `CfnBucket.RuleProperty.Id`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-lifecycleconfig-rule.html#cfn-s3-bucket-lifecycleconfig-rule-id
         * @external
         */
        readonly id?: string;
        /**
         * `CfnBucket.RuleProperty.NoncurrentVersionExpirationInDays`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-lifecycleconfig-rule.html#cfn-s3-bucket-lifecycleconfig-rule-noncurrentversionexpirationindays
         * @external
         */
        readonly noncurrentVersionExpirationInDays?: number;
        /**
         * `CfnBucket.RuleProperty.NoncurrentVersionTransition`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-lifecycleconfig-rule.html#cfn-s3-bucket-lifecycleconfig-rule-noncurrentversiontransition
         * @external
         */
        readonly noncurrentVersionTransition?: CfnBucket.NoncurrentVersionTransitionProperty | cdk.IResolvable;
        /**
         * `CfnBucket.RuleProperty.NoncurrentVersionTransitions`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-lifecycleconfig-rule.html#cfn-s3-bucket-lifecycleconfig-rule-noncurrentversiontransitions
         * @external
         */
        readonly noncurrentVersionTransitions?: Array<CfnBucket.NoncurrentVersionTransitionProperty | cdk.IResolvable> | cdk.IResolvable;
        /**
         * `CfnBucket.RuleProperty.Prefix`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-lifecycleconfig-rule.html#cfn-s3-bucket-lifecycleconfig-rule-prefix
         * @external
         */
        readonly prefix?: string;
        /**
         * `CfnBucket.RuleProperty.Status`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-lifecycleconfig-rule.html#cfn-s3-bucket-lifecycleconfig-rule-status
         * @external
         */
        readonly status: string;
        /**
         * `CfnBucket.RuleProperty.TagFilters`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-lifecycleconfig-rule.html#cfn-s3-bucket-rule-tagfilters
         * @external
         */
        readonly tagFilters?: Array<CfnBucket.TagFilterProperty | cdk.IResolvable> | cdk.IResolvable;
        /**
         * `CfnBucket.RuleProperty.Transition`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-lifecycleconfig-rule.html#cfn-s3-bucket-lifecycleconfig-rule-transition
         * @external
         */
        readonly transition?: CfnBucket.TransitionProperty | cdk.IResolvable;
        /**
         * `CfnBucket.RuleProperty.Transitions`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-lifecycleconfig-rule.html#cfn-s3-bucket-lifecycleconfig-rule-transitions
         * @external
         */
        readonly transitions?: Array<CfnBucket.TransitionProperty | cdk.IResolvable> | cdk.IResolvable;
    }
}
/**
 * A CloudFormation `AWS::S3::Bucket`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket.html
 * @external
 * @cloudformationResource AWS::S3::Bucket
 */
export declare namespace CfnBucket {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-notificationconfiguration-config-filter-s3key.html
     * @external
     */
    interface S3KeyFilterProperty {
        /**
         * `CfnBucket.S3KeyFilterProperty.Rules`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-notificationconfiguration-config-filter-s3key.html#cfn-s3-bucket-notificationconfiguraiton-config-filter-s3key-rules
         * @external
         */
        readonly rules: Array<CfnBucket.FilterRuleProperty | cdk.IResolvable> | cdk.IResolvable;
    }
}
/**
 * A CloudFormation `AWS::S3::Bucket`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket.html
 * @external
 * @cloudformationResource AWS::S3::Bucket
 */
export declare namespace CfnBucket {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-serversideencryptionbydefault.html
     * @external
     */
    interface ServerSideEncryptionByDefaultProperty {
        /**
         * `CfnBucket.ServerSideEncryptionByDefaultProperty.KMSMasterKeyID`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-serversideencryptionbydefault.html#cfn-s3-bucket-serversideencryptionbydefault-kmsmasterkeyid
         * @external
         */
        readonly kmsMasterKeyId?: string;
        /**
         * `CfnBucket.ServerSideEncryptionByDefaultProperty.SSEAlgorithm`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-serversideencryptionbydefault.html#cfn-s3-bucket-serversideencryptionbydefault-ssealgorithm
         * @external
         */
        readonly sseAlgorithm: string;
    }
}
/**
 * A CloudFormation `AWS::S3::Bucket`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket.html
 * @external
 * @cloudformationResource AWS::S3::Bucket
 */
export declare namespace CfnBucket {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-serversideencryptionrule.html
     * @external
     */
    interface ServerSideEncryptionRuleProperty {
        /**
         * `CfnBucket.ServerSideEncryptionRuleProperty.ServerSideEncryptionByDefault`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-serversideencryptionrule.html#cfn-s3-bucket-serversideencryptionrule-serversideencryptionbydefault
         * @external
         */
        readonly serverSideEncryptionByDefault?: CfnBucket.ServerSideEncryptionByDefaultProperty | cdk.IResolvable;
    }
}
/**
 * A CloudFormation `AWS::S3::Bucket`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket.html
 * @external
 * @cloudformationResource AWS::S3::Bucket
 */
export declare namespace CfnBucket {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-sourceselectioncriteria.html
     * @external
     */
    interface SourceSelectionCriteriaProperty {
        /**
         * `CfnBucket.SourceSelectionCriteriaProperty.SseKmsEncryptedObjects`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-sourceselectioncriteria.html#cfn-s3-bucket-sourceselectioncriteria-ssekmsencryptedobjects
         * @external
         */
        readonly sseKmsEncryptedObjects?: CfnBucket.SseKmsEncryptedObjectsProperty | cdk.IResolvable;
    }
}
/**
 * A CloudFormation `AWS::S3::Bucket`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket.html
 * @external
 * @cloudformationResource AWS::S3::Bucket
 */
export declare namespace CfnBucket {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-ssekmsencryptedobjects.html
     * @external
     */
    interface SseKmsEncryptedObjectsProperty {
        /**
         * `CfnBucket.SseKmsEncryptedObjectsProperty.Status`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-ssekmsencryptedobjects.html#cfn-s3-bucket-ssekmsencryptedobjects-status
         * @external
         */
        readonly status: string;
    }
}
/**
 * A CloudFormation `AWS::S3::Bucket`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket.html
 * @external
 * @cloudformationResource AWS::S3::Bucket
 */
export declare namespace CfnBucket {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-storageclassanalysis.html
     * @external
     */
    interface StorageClassAnalysisProperty {
        /**
         * `CfnBucket.StorageClassAnalysisProperty.DataExport`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-storageclassanalysis.html#cfn-s3-bucket-storageclassanalysis-dataexport
         * @external
         */
        readonly dataExport?: CfnBucket.DataExportProperty | cdk.IResolvable;
    }
}
/**
 * A CloudFormation `AWS::S3::Bucket`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket.html
 * @external
 * @cloudformationResource AWS::S3::Bucket
 */
export declare namespace CfnBucket {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-tagfilter.html
     * @external
     */
    interface TagFilterProperty {
        /**
         * `CfnBucket.TagFilterProperty.Key`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-tagfilter.html#cfn-s3-bucket-tagfilter-key
         * @external
         */
        readonly key: string;
        /**
         * `CfnBucket.TagFilterProperty.Value`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-tagfilter.html#cfn-s3-bucket-tagfilter-value
         * @external
         */
        readonly value: string;
    }
}
/**
 * A CloudFormation `AWS::S3::Bucket`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket.html
 * @external
 * @cloudformationResource AWS::S3::Bucket
 */
export declare namespace CfnBucket {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-tiering.html
     * @external
     */
    interface TieringProperty {
        /**
         * `CfnBucket.TieringProperty.AccessTier`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-tiering.html#cfn-s3-bucket-tiering-accesstier
         * @external
         */
        readonly accessTier: string;
        /**
         * `CfnBucket.TieringProperty.Days`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-tiering.html#cfn-s3-bucket-tiering-days
         * @external
         */
        readonly days: number;
    }
}
/**
 * A CloudFormation `AWS::S3::Bucket`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket.html
 * @external
 * @cloudformationResource AWS::S3::Bucket
 */
export declare namespace CfnBucket {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-notificationconfig-topicconfig.html
     * @external
     */
    interface TopicConfigurationProperty {
        /**
         * `CfnBucket.TopicConfigurationProperty.Event`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-notificationconfig-topicconfig.html#cfn-s3-bucket-notificationconfig-topicconfig-event
         * @external
         */
        readonly event: string;
        /**
         * `CfnBucket.TopicConfigurationProperty.Filter`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-notificationconfig-topicconfig.html#cfn-s3-bucket-notificationconfig-topicconfig-filter
         * @external
         */
        readonly filter?: CfnBucket.NotificationFilterProperty | cdk.IResolvable;
        /**
         * `CfnBucket.TopicConfigurationProperty.Topic`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-notificationconfig-topicconfig.html#cfn-s3-bucket-notificationconfig-topicconfig-topic
         * @external
         */
        readonly topic: string;
    }
}
/**
 * A CloudFormation `AWS::S3::Bucket`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket.html
 * @external
 * @cloudformationResource AWS::S3::Bucket
 */
export declare namespace CfnBucket {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-lifecycleconfig-rule-transition.html
     * @external
     */
    interface TransitionProperty {
        /**
         * `CfnBucket.TransitionProperty.StorageClass`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-lifecycleconfig-rule-transition.html#cfn-s3-bucket-lifecycleconfig-rule-transition-storageclass
         * @external
         */
        readonly storageClass: string;
        /**
         * `CfnBucket.TransitionProperty.TransitionDate`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-lifecycleconfig-rule-transition.html#cfn-s3-bucket-lifecycleconfig-rule-transition-transitiondate
         * @external
         */
        readonly transitionDate?: Date | cdk.IResolvable;
        /**
         * `CfnBucket.TransitionProperty.TransitionInDays`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-lifecycleconfig-rule-transition.html#cfn-s3-bucket-lifecycleconfig-rule-transition-transitionindays
         * @external
         */
        readonly transitionInDays?: number;
    }
}
/**
 * A CloudFormation `AWS::S3::Bucket`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket.html
 * @external
 * @cloudformationResource AWS::S3::Bucket
 */
export declare namespace CfnBucket {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-versioningconfig.html
     * @external
     */
    interface VersioningConfigurationProperty {
        /**
         * `CfnBucket.VersioningConfigurationProperty.Status`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-versioningconfig.html#cfn-s3-bucket-versioningconfig-status
         * @external
         */
        readonly status: string;
    }
}
/**
 * A CloudFormation `AWS::S3::Bucket`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket.html
 * @external
 * @cloudformationResource AWS::S3::Bucket
 */
export declare namespace CfnBucket {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-websiteconfiguration.html
     * @external
     */
    interface WebsiteConfigurationProperty {
        /**
         * `CfnBucket.WebsiteConfigurationProperty.ErrorDocument`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-websiteconfiguration.html#cfn-s3-websiteconfiguration-errordocument
         * @external
         */
        readonly errorDocument?: string;
        /**
         * `CfnBucket.WebsiteConfigurationProperty.IndexDocument`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-websiteconfiguration.html#cfn-s3-websiteconfiguration-indexdocument
         * @external
         */
        readonly indexDocument?: string;
        /**
         * `CfnBucket.WebsiteConfigurationProperty.RedirectAllRequestsTo`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-websiteconfiguration.html#cfn-s3-websiteconfiguration-redirectallrequeststo
         * @external
         */
        readonly redirectAllRequestsTo?: CfnBucket.RedirectAllRequestsToProperty | cdk.IResolvable;
        /**
         * `CfnBucket.WebsiteConfigurationProperty.RoutingRules`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-websiteconfiguration.html#cfn-s3-websiteconfiguration-routingrules
         * @external
         */
        readonly routingRules?: Array<CfnBucket.RoutingRuleProperty | cdk.IResolvable> | cdk.IResolvable;
    }
}
/**
 * Properties for defining a `AWS::S3::BucketPolicy`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-policy.html
 * @external
 */
export interface CfnBucketPolicyProps {
    /**
     * `AWS::S3::BucketPolicy.Bucket`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-policy.html#aws-properties-s3-policy-bucket
     * @external
     */
    readonly bucket: string;
    /**
     * `AWS::S3::BucketPolicy.PolicyDocument`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-policy.html#aws-properties-s3-policy-policydocument
     * @external
     */
    readonly policyDocument: any | cdk.IResolvable;
}
/**
 * A CloudFormation `AWS::S3::BucketPolicy`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-policy.html
 * @external
 * @cloudformationResource AWS::S3::BucketPolicy
 */
export declare class CfnBucketPolicy extends cdk.CfnResource implements cdk.IInspectable {
    /**
     * The CloudFormation resource type name for this resource class.
     *
     * @external
     */
    static readonly CFN_RESOURCE_TYPE_NAME = "AWS::S3::BucketPolicy";
    /**
     * A factory method that creates a new instance of this class from an object
     * containing the CloudFormation properties of this resource.
     * Used in the @aws-cdk/cloudformation-include module.
     *
     * @internal
     */
    static _fromCloudFormation(scope: cdk.Construct, id: string, resourceAttributes: any, options: cfn_parse.FromCloudFormationOptions): CfnBucketPolicy;
    /**
     * `AWS::S3::BucketPolicy.Bucket`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-policy.html#aws-properties-s3-policy-bucket
     * @external
     */
    bucket: string;
    /**
     * `AWS::S3::BucketPolicy.PolicyDocument`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-policy.html#aws-properties-s3-policy-policydocument
     * @external
     */
    policyDocument: any | cdk.IResolvable;
    /**
     * Create a new `AWS::S3::BucketPolicy`.
     *
     * @param scope - scope in which this resource is defined.
     * @param id - scoped id of the resource.
     * @param props - resource properties.
     * @external
     */
    constructor(scope: cdk.Construct, id: string, props: CfnBucketPolicyProps);
    /**
     * (experimental) Examines the CloudFormation resource and discloses attributes.
     *
     * @param inspector - tree inspector to collect and process attributes.
     * @experimental
     */
    inspect(inspector: cdk.TreeInspector): void;
    /**
     * @external
     */
    protected get cfnProperties(): {
        [key: string]: any;
    };
    /**
     * @external
     */
    protected renderProperties(props: {
        [key: string]: any;
    }): {
        [key: string]: any;
    };
}
/**
 * Properties for defining a `AWS::S3::StorageLens`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-s3-storagelens.html
 * @external
 */
export interface CfnStorageLensProps {
    /**
     * `AWS::S3::StorageLens.StorageLensConfiguration`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-s3-storagelens.html#cfn-s3-storagelens-storagelensconfiguration
     * @external
     */
    readonly storageLensConfiguration: CfnStorageLens.StorageLensConfigurationProperty | cdk.IResolvable;
    /**
     * `AWS::S3::StorageLens.Tags`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-s3-storagelens.html#cfn-s3-storagelens-tags
     * @external
     */
    readonly tags?: cdk.CfnTag[];
}
/**
 * A CloudFormation `AWS::S3::StorageLens`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-s3-storagelens.html
 * @external
 * @cloudformationResource AWS::S3::StorageLens
 */
export declare class CfnStorageLens extends cdk.CfnResource implements cdk.IInspectable {
    /**
     * The CloudFormation resource type name for this resource class.
     *
     * @external
     */
    static readonly CFN_RESOURCE_TYPE_NAME = "AWS::S3::StorageLens";
    /**
     * A factory method that creates a new instance of this class from an object
     * containing the CloudFormation properties of this resource.
     * Used in the @aws-cdk/cloudformation-include module.
     *
     * @internal
     */
    static _fromCloudFormation(scope: cdk.Construct, id: string, resourceAttributes: any, options: cfn_parse.FromCloudFormationOptions): CfnStorageLens;
    /**
     * @external
     * @cloudformationAttribute StorageLensArn
     */
    readonly attrStorageLensArn: string;
    /**
     * `AWS::S3::StorageLens.StorageLensConfiguration`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-s3-storagelens.html#cfn-s3-storagelens-storagelensconfiguration
     * @external
     */
    storageLensConfiguration: CfnStorageLens.StorageLensConfigurationProperty | cdk.IResolvable;
    /**
     * `AWS::S3::StorageLens.Tags`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-s3-storagelens.html#cfn-s3-storagelens-tags
     * @external
     */
    readonly tags: cdk.TagManager;
    /**
     * Create a new `AWS::S3::StorageLens`.
     *
     * @param scope - scope in which this resource is defined.
     * @param id - scoped id of the resource.
     * @param props - resource properties.
     * @external
     */
    constructor(scope: cdk.Construct, id: string, props: CfnStorageLensProps);
    /**
     * (experimental) Examines the CloudFormation resource and discloses attributes.
     *
     * @param inspector - tree inspector to collect and process attributes.
     * @experimental
     */
    inspect(inspector: cdk.TreeInspector): void;
    /**
     * @external
     */
    protected get cfnProperties(): {
        [key: string]: any;
    };
    /**
     * @external
     */
    protected renderProperties(props: {
        [key: string]: any;
    }): {
        [key: string]: any;
    };
}
/**
 * A CloudFormation `AWS::S3::StorageLens`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-s3-storagelens.html
 * @external
 * @cloudformationResource AWS::S3::StorageLens
 */
export declare namespace CfnStorageLens {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-storagelens-accountlevel.html
     * @external
     */
    interface AccountLevelProperty {
        /**
         * `CfnStorageLens.AccountLevelProperty.ActivityMetrics`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-storagelens-accountlevel.html#cfn-s3-storagelens-accountlevel-activitymetrics
         * @external
         */
        readonly activityMetrics?: CfnStorageLens.ActivityMetricsProperty | cdk.IResolvable;
        /**
         * `CfnStorageLens.AccountLevelProperty.BucketLevel`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-storagelens-accountlevel.html#cfn-s3-storagelens-accountlevel-bucketlevel
         * @external
         */
        readonly bucketLevel: CfnStorageLens.BucketLevelProperty | cdk.IResolvable;
    }
}
/**
 * A CloudFormation `AWS::S3::StorageLens`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-s3-storagelens.html
 * @external
 * @cloudformationResource AWS::S3::StorageLens
 */
export declare namespace CfnStorageLens {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-storagelens-activitymetrics.html
     * @external
     */
    interface ActivityMetricsProperty {
        /**
         * `CfnStorageLens.ActivityMetricsProperty.IsEnabled`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-storagelens-activitymetrics.html#cfn-s3-storagelens-activitymetrics-isenabled
         * @external
         */
        readonly isEnabled?: boolean | cdk.IResolvable;
    }
}
/**
 * A CloudFormation `AWS::S3::StorageLens`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-s3-storagelens.html
 * @external
 * @cloudformationResource AWS::S3::StorageLens
 */
export declare namespace CfnStorageLens {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-storagelens-awsorg.html
     * @external
     */
    interface AwsOrgProperty {
        /**
         * `CfnStorageLens.AwsOrgProperty.Arn`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-storagelens-awsorg.html#cfn-s3-storagelens-awsorg-arn
         * @external
         */
        readonly arn: string;
    }
}
/**
 * A CloudFormation `AWS::S3::StorageLens`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-s3-storagelens.html
 * @external
 * @cloudformationResource AWS::S3::StorageLens
 */
export declare namespace CfnStorageLens {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-storagelens-bucketlevel.html
     * @external
     */
    interface BucketLevelProperty {
        /**
         * `CfnStorageLens.BucketLevelProperty.ActivityMetrics`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-storagelens-bucketlevel.html#cfn-s3-storagelens-bucketlevel-activitymetrics
         * @external
         */
        readonly activityMetrics?: CfnStorageLens.ActivityMetricsProperty | cdk.IResolvable;
        /**
         * `CfnStorageLens.BucketLevelProperty.PrefixLevel`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-storagelens-bucketlevel.html#cfn-s3-storagelens-bucketlevel-prefixlevel
         * @external
         */
        readonly prefixLevel?: CfnStorageLens.PrefixLevelProperty | cdk.IResolvable;
    }
}
/**
 * A CloudFormation `AWS::S3::StorageLens`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-s3-storagelens.html
 * @external
 * @cloudformationResource AWS::S3::StorageLens
 */
export declare namespace CfnStorageLens {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-storagelens-bucketsandregions.html
     * @external
     */
    interface BucketsAndRegionsProperty {
        /**
         * `CfnStorageLens.BucketsAndRegionsProperty.Buckets`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-storagelens-bucketsandregions.html#cfn-s3-storagelens-bucketsandregions-buckets
         * @external
         */
        readonly buckets?: string[];
        /**
         * `CfnStorageLens.BucketsAndRegionsProperty.Regions`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-storagelens-bucketsandregions.html#cfn-s3-storagelens-bucketsandregions-regions
         * @external
         */
        readonly regions?: string[];
    }
}
/**
 * A CloudFormation `AWS::S3::StorageLens`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-s3-storagelens.html
 * @external
 * @cloudformationResource AWS::S3::StorageLens
 */
export declare namespace CfnStorageLens {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-storagelens-dataexport.html
     * @external
     */
    interface DataExportProperty {
        /**
         * `CfnStorageLens.DataExportProperty.S3BucketDestination`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-storagelens-dataexport.html#cfn-s3-storagelens-dataexport-s3bucketdestination
         * @external
         */
        readonly s3BucketDestination: CfnStorageLens.S3BucketDestinationProperty | cdk.IResolvable;
    }
}
/**
 * A CloudFormation `AWS::S3::StorageLens`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-s3-storagelens.html
 * @external
 * @cloudformationResource AWS::S3::StorageLens
 */
export declare namespace CfnStorageLens {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-storagelens-encryption.html
     * @external
     */
    interface EncryptionProperty {
    }
}
/**
 * A CloudFormation `AWS::S3::StorageLens`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-s3-storagelens.html
 * @external
 * @cloudformationResource AWS::S3::StorageLens
 */
export declare namespace CfnStorageLens {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-storagelens-prefixlevel.html
     * @external
     */
    interface PrefixLevelProperty {
        /**
         * `CfnStorageLens.PrefixLevelProperty.StorageMetrics`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-storagelens-prefixlevel.html#cfn-s3-storagelens-prefixlevel-storagemetrics
         * @external
         */
        readonly storageMetrics: CfnStorageLens.PrefixLevelStorageMetricsProperty | cdk.IResolvable;
    }
}
/**
 * A CloudFormation `AWS::S3::StorageLens`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-s3-storagelens.html
 * @external
 * @cloudformationResource AWS::S3::StorageLens
 */
export declare namespace CfnStorageLens {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-storagelens-prefixlevelstoragemetrics.html
     * @external
     */
    interface PrefixLevelStorageMetricsProperty {
        /**
         * `CfnStorageLens.PrefixLevelStorageMetricsProperty.IsEnabled`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-storagelens-prefixlevelstoragemetrics.html#cfn-s3-storagelens-prefixlevelstoragemetrics-isenabled
         * @external
         */
        readonly isEnabled?: boolean | cdk.IResolvable;
        /**
         * `CfnStorageLens.PrefixLevelStorageMetricsProperty.SelectionCriteria`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-storagelens-prefixlevelstoragemetrics.html#cfn-s3-storagelens-prefixlevelstoragemetrics-selectioncriteria
         * @external
         */
        readonly selectionCriteria?: CfnStorageLens.SelectionCriteriaProperty | cdk.IResolvable;
    }
}
/**
 * A CloudFormation `AWS::S3::StorageLens`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-s3-storagelens.html
 * @external
 * @cloudformationResource AWS::S3::StorageLens
 */
export declare namespace CfnStorageLens {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-storagelens-s3bucketdestination.html
     * @external
     */
    interface S3BucketDestinationProperty {
        /**
         * `CfnStorageLens.S3BucketDestinationProperty.AccountId`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-storagelens-s3bucketdestination.html#cfn-s3-storagelens-s3bucketdestination-accountid
         * @external
         */
        readonly accountId: string;
        /**
         * `CfnStorageLens.S3BucketDestinationProperty.Arn`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-storagelens-s3bucketdestination.html#cfn-s3-storagelens-s3bucketdestination-arn
         * @external
         */
        readonly arn: string;
        /**
         * `CfnStorageLens.S3BucketDestinationProperty.Encryption`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-storagelens-s3bucketdestination.html#cfn-s3-storagelens-s3bucketdestination-encryption
         * @external
         */
        readonly encryption?: CfnStorageLens.EncryptionProperty | cdk.IResolvable;
        /**
         * `CfnStorageLens.S3BucketDestinationProperty.Format`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-storagelens-s3bucketdestination.html#cfn-s3-storagelens-s3bucketdestination-format
         * @external
         */
        readonly format: string;
        /**
         * `CfnStorageLens.S3BucketDestinationProperty.OutputSchemaVersion`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-storagelens-s3bucketdestination.html#cfn-s3-storagelens-s3bucketdestination-outputschemaversion
         * @external
         */
        readonly outputSchemaVersion: string;
        /**
         * `CfnStorageLens.S3BucketDestinationProperty.Prefix`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-storagelens-s3bucketdestination.html#cfn-s3-storagelens-s3bucketdestination-prefix
         * @external
         */
        readonly prefix?: string;
    }
}
/**
 * A CloudFormation `AWS::S3::StorageLens`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-s3-storagelens.html
 * @external
 * @cloudformationResource AWS::S3::StorageLens
 */
export declare namespace CfnStorageLens {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-storagelens-selectioncriteria.html
     * @external
     */
    interface SelectionCriteriaProperty {
        /**
         * `CfnStorageLens.SelectionCriteriaProperty.Delimiter`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-storagelens-selectioncriteria.html#cfn-s3-storagelens-selectioncriteria-delimiter
         * @external
         */
        readonly delimiter?: string;
        /**
         * `CfnStorageLens.SelectionCriteriaProperty.MaxDepth`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-storagelens-selectioncriteria.html#cfn-s3-storagelens-selectioncriteria-maxdepth
         * @external
         */
        readonly maxDepth?: number;
        /**
         * `CfnStorageLens.SelectionCriteriaProperty.MinStorageBytesPercentage`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-storagelens-selectioncriteria.html#cfn-s3-storagelens-selectioncriteria-minstoragebytespercentage
         * @external
         */
        readonly minStorageBytesPercentage?: number;
    }
}
/**
 * A CloudFormation `AWS::S3::StorageLens`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-s3-storagelens.html
 * @external
 * @cloudformationResource AWS::S3::StorageLens
 */
export declare namespace CfnStorageLens {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-storagelens-storagelensconfiguration.html
     * @external
     */
    interface StorageLensConfigurationProperty {
        /**
         * `CfnStorageLens.StorageLensConfigurationProperty.AccountLevel`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-storagelens-storagelensconfiguration.html#cfn-s3-storagelens-storagelensconfiguration-accountlevel
         * @external
         */
        readonly accountLevel: CfnStorageLens.AccountLevelProperty | cdk.IResolvable;
        /**
         * `CfnStorageLens.StorageLensConfigurationProperty.AwsOrg`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-storagelens-storagelensconfiguration.html#cfn-s3-storagelens-storagelensconfiguration-awsorg
         * @external
         */
        readonly awsOrg?: CfnStorageLens.AwsOrgProperty | cdk.IResolvable;
        /**
         * `CfnStorageLens.StorageLensConfigurationProperty.DataExport`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-storagelens-storagelensconfiguration.html#cfn-s3-storagelens-storagelensconfiguration-dataexport
         * @external
         */
        readonly dataExport?: CfnStorageLens.DataExportProperty | cdk.IResolvable;
        /**
         * `CfnStorageLens.StorageLensConfigurationProperty.Exclude`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-storagelens-storagelensconfiguration.html#cfn-s3-storagelens-storagelensconfiguration-exclude
         * @external
         */
        readonly exclude?: CfnStorageLens.BucketsAndRegionsProperty | cdk.IResolvable;
        /**
         * `CfnStorageLens.StorageLensConfigurationProperty.Id`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-storagelens-storagelensconfiguration.html#cfn-s3-storagelens-storagelensconfiguration-id
         * @external
         */
        readonly id: string;
        /**
         * `CfnStorageLens.StorageLensConfigurationProperty.Include`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-storagelens-storagelensconfiguration.html#cfn-s3-storagelens-storagelensconfiguration-include
         * @external
         */
        readonly include?: CfnStorageLens.BucketsAndRegionsProperty | cdk.IResolvable;
        /**
         * `CfnStorageLens.StorageLensConfigurationProperty.IsEnabled`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-storagelens-storagelensconfiguration.html#cfn-s3-storagelens-storagelensconfiguration-isenabled
         * @external
         */
        readonly isEnabled: boolean | cdk.IResolvable;
        /**
         * `CfnStorageLens.StorageLensConfigurationProperty.StorageLensArn`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-storagelens-storagelensconfiguration.html#cfn-s3-storagelens-storagelensconfiguration-storagelensarn
         * @external
         */
        readonly storageLensArn?: string;
    }
}
