# coding: utf-8

"""
    NiFi Rest Api

    The Rest Api provides programmatic access to command and control a NiFi instance in real time. Start and                                              stop processors, monitor queues, query provenance data, and more. Each endpoint below includes a description,                                             definitions of the expected input and output, potential response codes, and the authorizations required                                             to invoke each service.

    OpenAPI spec version: 1.2.0
    Contact: dev@nifi.apache.org
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""


from pprint import pformat
from six import iteritems
import re


class ProcessGroupDTO(object):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    """


    """
    Attributes:
      swagger_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    swagger_types = {
        'id': 'str',
        'parent_group_id': 'str',
        'position': 'PositionDTO',
        'name': 'str',
        'comments': 'str',
        'running_count': 'int',
        'stopped_count': 'int',
        'invalid_count': 'int',
        'disabled_count': 'int',
        'active_remote_port_count': 'int',
        'inactive_remote_port_count': 'int',
        'input_port_count': 'int',
        'output_port_count': 'int'
    }

    attribute_map = {
        'id': 'id',
        'parent_group_id': 'parentGroupId',
        'position': 'position',
        'name': 'name',
        'comments': 'comments',
        'running_count': 'runningCount',
        'stopped_count': 'stoppedCount',
        'invalid_count': 'invalidCount',
        'disabled_count': 'disabledCount',
        'active_remote_port_count': 'activeRemotePortCount',
        'inactive_remote_port_count': 'inactiveRemotePortCount',
        'input_port_count': 'inputPortCount',
        'output_port_count': 'outputPortCount'
    }

    def __init__(self, id=None, parent_group_id=None, position=None, name=None, comments=None, running_count=None, stopped_count=None, invalid_count=None, disabled_count=None, active_remote_port_count=None, inactive_remote_port_count=None, input_port_count=None, output_port_count=None):
        """
        ProcessGroupDTO - a model defined in Swagger
        """

        self._id = None
        self._parent_group_id = None
        self._position = None
        self._name = None
        self._comments = None
        self._running_count = None
        self._stopped_count = None
        self._invalid_count = None
        self._disabled_count = None
        self._active_remote_port_count = None
        self._inactive_remote_port_count = None
        self._input_port_count = None
        self._output_port_count = None

        if id is not None:
          self.id = id
        if parent_group_id is not None:
          self.parent_group_id = parent_group_id
        if position is not None:
          self.position = position
        if name is not None:
          self.name = name
        if comments is not None:
          self.comments = comments
        if running_count is not None:
          self.running_count = running_count
        if stopped_count is not None:
          self.stopped_count = stopped_count
        if invalid_count is not None:
          self.invalid_count = invalid_count
        if disabled_count is not None:
          self.disabled_count = disabled_count
        if active_remote_port_count is not None:
          self.active_remote_port_count = active_remote_port_count
        if inactive_remote_port_count is not None:
          self.inactive_remote_port_count = inactive_remote_port_count
        if input_port_count is not None:
          self.input_port_count = input_port_count
        if output_port_count is not None:
          self.output_port_count = output_port_count

    @property
    def id(self):
        """
        Gets the id of this ProcessGroupDTO.
        The id of the component.

        :return: The id of this ProcessGroupDTO.
        :rtype: str
        """
        return self._id

    @id.setter
    def id(self, id):
        """
        Sets the id of this ProcessGroupDTO.
        The id of the component.

        :param id: The id of this ProcessGroupDTO.
        :type: str
        """

        self._id = id

    @property
    def parent_group_id(self):
        """
        Gets the parent_group_id of this ProcessGroupDTO.
        The id of parent process group of this component if applicable.

        :return: The parent_group_id of this ProcessGroupDTO.
        :rtype: str
        """
        return self._parent_group_id

    @parent_group_id.setter
    def parent_group_id(self, parent_group_id):
        """
        Sets the parent_group_id of this ProcessGroupDTO.
        The id of parent process group of this component if applicable.

        :param parent_group_id: The parent_group_id of this ProcessGroupDTO.
        :type: str
        """

        self._parent_group_id = parent_group_id

    @property
    def position(self):
        """
        Gets the position of this ProcessGroupDTO.
        The position of this component in the UI if applicable.

        :return: The position of this ProcessGroupDTO.
        :rtype: PositionDTO
        """
        return self._position

    @position.setter
    def position(self, position):
        """
        Sets the position of this ProcessGroupDTO.
        The position of this component in the UI if applicable.

        :param position: The position of this ProcessGroupDTO.
        :type: PositionDTO
        """

        self._position = position

    @property
    def name(self):
        """
        Gets the name of this ProcessGroupDTO.
        The name of the process group.

        :return: The name of this ProcessGroupDTO.
        :rtype: str
        """
        return self._name

    @name.setter
    def name(self, name):
        """
        Sets the name of this ProcessGroupDTO.
        The name of the process group.

        :param name: The name of this ProcessGroupDTO.
        :type: str
        """

        self._name = name

    @property
    def comments(self):
        """
        Gets the comments of this ProcessGroupDTO.
        The comments for the process group.

        :return: The comments of this ProcessGroupDTO.
        :rtype: str
        """
        return self._comments

    @comments.setter
    def comments(self, comments):
        """
        Sets the comments of this ProcessGroupDTO.
        The comments for the process group.

        :param comments: The comments of this ProcessGroupDTO.
        :type: str
        """

        self._comments = comments

    @property
    def running_count(self):
        """
        Gets the running_count of this ProcessGroupDTO.
        The number of running components in this process group.

        :return: The running_count of this ProcessGroupDTO.
        :rtype: int
        """
        return self._running_count

    @running_count.setter
    def running_count(self, running_count):
        """
        Sets the running_count of this ProcessGroupDTO.
        The number of running components in this process group.

        :param running_count: The running_count of this ProcessGroupDTO.
        :type: int
        """

        self._running_count = running_count

    @property
    def stopped_count(self):
        """
        Gets the stopped_count of this ProcessGroupDTO.
        The number of stopped components in the process group.

        :return: The stopped_count of this ProcessGroupDTO.
        :rtype: int
        """
        return self._stopped_count

    @stopped_count.setter
    def stopped_count(self, stopped_count):
        """
        Sets the stopped_count of this ProcessGroupDTO.
        The number of stopped components in the process group.

        :param stopped_count: The stopped_count of this ProcessGroupDTO.
        :type: int
        """

        self._stopped_count = stopped_count

    @property
    def invalid_count(self):
        """
        Gets the invalid_count of this ProcessGroupDTO.
        The number of invalid components in the process group.

        :return: The invalid_count of this ProcessGroupDTO.
        :rtype: int
        """
        return self._invalid_count

    @invalid_count.setter
    def invalid_count(self, invalid_count):
        """
        Sets the invalid_count of this ProcessGroupDTO.
        The number of invalid components in the process group.

        :param invalid_count: The invalid_count of this ProcessGroupDTO.
        :type: int
        """

        self._invalid_count = invalid_count

    @property
    def disabled_count(self):
        """
        Gets the disabled_count of this ProcessGroupDTO.
        The number of disabled components in the process group.

        :return: The disabled_count of this ProcessGroupDTO.
        :rtype: int
        """
        return self._disabled_count

    @disabled_count.setter
    def disabled_count(self, disabled_count):
        """
        Sets the disabled_count of this ProcessGroupDTO.
        The number of disabled components in the process group.

        :param disabled_count: The disabled_count of this ProcessGroupDTO.
        :type: int
        """

        self._disabled_count = disabled_count

    @property
    def active_remote_port_count(self):
        """
        Gets the active_remote_port_count of this ProcessGroupDTO.
        The number of active remote ports in the process group.

        :return: The active_remote_port_count of this ProcessGroupDTO.
        :rtype: int
        """
        return self._active_remote_port_count

    @active_remote_port_count.setter
    def active_remote_port_count(self, active_remote_port_count):
        """
        Sets the active_remote_port_count of this ProcessGroupDTO.
        The number of active remote ports in the process group.

        :param active_remote_port_count: The active_remote_port_count of this ProcessGroupDTO.
        :type: int
        """

        self._active_remote_port_count = active_remote_port_count

    @property
    def inactive_remote_port_count(self):
        """
        Gets the inactive_remote_port_count of this ProcessGroupDTO.
        The number of inactive remote ports in the process group.

        :return: The inactive_remote_port_count of this ProcessGroupDTO.
        :rtype: int
        """
        return self._inactive_remote_port_count

    @inactive_remote_port_count.setter
    def inactive_remote_port_count(self, inactive_remote_port_count):
        """
        Sets the inactive_remote_port_count of this ProcessGroupDTO.
        The number of inactive remote ports in the process group.

        :param inactive_remote_port_count: The inactive_remote_port_count of this ProcessGroupDTO.
        :type: int
        """

        self._inactive_remote_port_count = inactive_remote_port_count

    @property
    def input_port_count(self):
        """
        Gets the input_port_count of this ProcessGroupDTO.
        The number of input ports in the process group.

        :return: The input_port_count of this ProcessGroupDTO.
        :rtype: int
        """
        return self._input_port_count

    @input_port_count.setter
    def input_port_count(self, input_port_count):
        """
        Sets the input_port_count of this ProcessGroupDTO.
        The number of input ports in the process group.

        :param input_port_count: The input_port_count of this ProcessGroupDTO.
        :type: int
        """

        self._input_port_count = input_port_count

    @property
    def output_port_count(self):
        """
        Gets the output_port_count of this ProcessGroupDTO.
        The number of output ports in the process group.

        :return: The output_port_count of this ProcessGroupDTO.
        :rtype: int
        """
        return self._output_port_count

    @output_port_count.setter
    def output_port_count(self, output_port_count):
        """
        Sets the output_port_count of this ProcessGroupDTO.
        The number of output ports in the process group.

        :param output_port_count: The output_port_count of this ProcessGroupDTO.
        :type: int
        """

        self._output_port_count = output_port_count

    def to_dict(self):
        """
        Returns the model properties as a dict
        """
        result = {}

        for attr, _ in iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_str(self):
        """
        Returns the string representation of the model
        """
        return pformat(self.to_dict())

    def __repr__(self):
        """
        For `print` and `pprint`
        """
        return self.to_str()

    def __eq__(self, other):
        """
        Returns true if both objects are equal
        """
        if not isinstance(other, ProcessGroupDTO):
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """
        Returns true if both objects are not equal
        """
        return not self == other
