# CLI Usage

初回の実行時のみ, HuggingFaseHub からモデルの重みファイルをダウンロードします。
以下のコマンドにて、文書画像の解析を実行します。

```
yomitoku ${path_data} -v -o results
```

- `${path_data}` 解析対象の画像が含まれたディレクトリか画像ファイルのパスを直接して指定してください。ディレクトリを対象とした場合はディレクトリのサブディレクトリ内の画像も含めて処理を実行します。ファイル形式は pdf, jpeg, png, bmp, tiff をサポートしています。
- `-o`, `--outdir` 出力先のディレクトリ名を指定します。存在しない場合は新規で作成されます。
- `-v`, `--vis` を指定すると解析結果を可視化した画像を出力します。

**Note**:

- 活字のみの識別をサポートしております。手書き文字に関しては、読み取れる場合もありますが、公式にはサポートしておりません。
- OCR は文書 OCR と情景 OCR(看板など紙以外にプリントされた文字)に大別されますが、Yomitoku は文書 OCR 向けに最適化されています。
- AI-OCR の識別精度を高めるために、入力画像の解像度が重要です。低解像度画像では識別精度が低下します。画像の短辺を 1000px 以上の画像で推論することをお勧めします。

## ヘルプの参照

`--help`, `-h`にて CLI に指定可能なオプションを表示します。

## 軽量モードでの実行

`--lite`オプションを付与することで、軽量モデルを使用して、推論することが可能です。通常モードより高速に解析が実行可能です。ただし、文字の認識精度が低下する可能性があります。

```
yomitoku ${path_data} --lite -v
```

## 出力フォーマットの指定

`--format`, `-f` オプションを使用することで解析結果の出力形式のフォーマットを指定できます。出力フォーマットの種類は json, csv, html, md(markdown)をサポートしています。

```
yomitoku ${path_data} -f md
```

## 出力デバイスの指定

- `-d`, `--device` オプションを使用することで、モデルを実行するためのデバイスを指定します。(cuda | cpu | mps)。gpu が利用できない場合は cpu で推論が実行されます。(デフォルト: cuda)

```
yomitoku ${path_data} -d cpu
```

## 改行の無視

通常モードでは、画像内で記述された情報に従い、改行を行います。 `--ignore_line_break` オプションを使用することで、画像の改行位置を無視して、段落内の同一文章を連結して返すことが可能です。

```
yomitoku ${path_data} --ignore_line_break
```

## 図やグラフ画像の出力

通常モードでは、文書画像内の含まれる図や画像の情報を出力しません。`--figure`オプションを使用することで、文書画像に含まれる、図や画像を切り出し、個別の画像として保存、また、出力ファイル内に検出した個別の画像に対するリンクを出力します。

```
yomitoku ${path_data} --figure
```

## 図や画像内に含まれる文字の出力

通常モードでは、図や画像内に含まれる文字情報は出力ファイルに出力しません。 `--figure_letter` オプションを使用することで、画像や図に含まれる文字情報も出力ファイルに出力します。

```
yomitoku ${path_data} --figure_letter
```

## 出力ファイルの文字コードの指定

出力ファイルの文字コードを`--encoding`オプションにて指定できます。(utf-8, utf-8-sig, shift-jis, enc-jp, cp932)。サポートされていない文字コードが含まれる場合は、その文字を無視し、出力しません。

```
yomitoku ${path_data} --encoding utf-8-sig
```

## コンフィグのパスの指定

各モジュールに対する config ファイルのパスを指定します。

- `--td_cfg`: Text Detector に対する config が記述された yaml ファイルに対するパス
- `--tr_cfg`: Text Recognizer に対する config が記述された yaml ファイルに対するパス
- `--lp_cfg`: Layout Parser に対する config が記述された yaml ファイルに対するパス
- `--tsr_cfg`: Table Structure Recognizer に対する config が記述された yaml ファイルに対するパス

```
yomitoku ${path_data} --td_cfg ${path_yaml}
```

## メタ情報を出力ファイルに加えない

ヘッダーやフッター等のメタデータを出力ファイルに加えないようにすることができます。

```
yomitoku ${path_data} --ignore_meta
```

## 複数ページを統合する

PDFに複数ページが含まれる場合に複数ページを一つのファイルにまとめてエクスポートできます。

```
yomitoku ${path_data} -f md --combine
```