## 🌟 概要

YomiToku は日本語に特化した AI 文章画像解析エンジン(Document AI)です。画像内の文字の全文 OCR およびレイアウト解析機能を有しており、画像内の文字情報や図表を認識、抽出、変換します。

- 🤖 日本語データセットで学習した 4 種類(文字位置の検知、文字列認識、レイアウト解析、表の構造認識)の AI モデルを搭載しています。4 種類のモデルはすべて独自に学習されたモデルで日本語文書に対して、高精度に推論可能です。
- 🇯🇵 各モデルは日本語の文書画像に特化して学習されており、7000 文字を超える日本語文字の認識をサーポート、縦書きなど日本語特有のレイアウト構造の文書画像の解析も可能です。（日本語以外にも英語の文書に対しても対応しています）。
- 📈 レイアウト解析、表の構造解析, 読み順推定機能により、文書画像のレイアウトの意味的構造を壊さずに情報を抽出することが可能です。
- 📄 多様な出力形式をサポートしています。html やマークダウン、json、csv のいずれかのフォーマットに変換可能です。また、文書内に含まれる図表、画像の抽出の出力も可能です。
- ⚡ GPU 環境で高速に動作し、効率的に文書の文字起こし解析が可能です。また、VRAM も 8GB 以内で動作し、ハイエンドな GPU を用意する必要はありません。

## 🙋 FAQ

### Q. インターネットに接続できない環境での動作は可能ですか？

A. 可能です。Yomitoku は初回実行時に HuggingFaceHub にアクセスし、自動でモデルファイルのダウンロードを行いますが、この際にインターネットに接続します。しかし、事前に手動でダウンロードすることでインターネットへ接続できない環境でも動作可能です。詳しくは[Module Usase](module.ja.md)の「インターネットに接続できない環境での利用」を参照してください。

### Q. 商用利用は可能ですか？

A. 本パッケージは [CC BY-NC 4.0](https://creativecommons.org/licenses/by-nc/4.0/) に従います。個人の利用や研究利用に関しては無償でご利用いただけます。商用利用に関しては、別途、有償の商用ライセンスを発行しますので、開発者まで問い合わせください。

### Q. 手書き文字は認識できますか？

A. 活字のみの識別をサポートしております。手書き文字に関しては、読み取れる場合もありますが、公式にはサポートしておりません。
