import { Construct, Resource } from '@aws-cdk/core';
import { IIdentity } from './identity-base';
import { IManagedPolicy } from './managed-policy';
import { Policy } from './policy';
import { PolicyStatement } from './policy-statement';
import { IPrincipal, PrincipalPolicyFragment } from './principals';
import { IUser } from './user';
export interface IGroup extends IIdentity {
    /**
     * Returns the IAM Group Name
     *
     * @attribute
     */
    readonly groupName: string;
    /**
     * Returns the IAM Group ARN
     *
     * @attribute
     */
    readonly groupArn: string;
}
export interface GroupProps {
    /**
     * A name for the IAM group. For valid values, see the GroupName parameter
     * for the CreateGroup action in the IAM API Reference. If you don't specify
     * a name, AWS CloudFormation generates a unique physical ID and uses that
     * ID for the group name.
     *
     * If you specify a name, you must specify the CAPABILITY_NAMED_IAM value to
     * acknowledge your template's capabilities. For more information, see
     * Acknowledging IAM Resources in AWS CloudFormation Templates.
     *
     * @default Generated by CloudFormation (recommended)
     */
    readonly groupName?: string;
    /**
     * A list of managed policies associated with this role.
     *
     * You can add managed policies later using
     * `addManagedPolicy(ManagedPolicy.fromAwsManagedPolicyName(policyName))`.
     *
     * @default - No managed policies.
     */
    readonly managedPolicies?: IManagedPolicy[];
    /**
     * The path to the group. For more information about paths, see [IAM
     * Identifiers](http://docs.aws.amazon.com/IAM/latest/UserGuide/index.html?Using_Identifiers.html)
     * in the IAM User Guide.
     *
     * @default /
     */
    readonly path?: string;
}
declare abstract class GroupBase extends Resource implements IGroup {
    abstract readonly groupName: string;
    abstract readonly groupArn: string;
    readonly grantPrincipal: IPrincipal;
    readonly assumeRoleAction: string;
    private readonly attachedPolicies;
    private defaultPolicy?;
    readonly policyFragment: PrincipalPolicyFragment;
    /**
     * Attaches a policy to this group.
     * @param policy The policy to attach.
     */
    attachInlinePolicy(policy: Policy): void;
    addManagedPolicy(_policy: IManagedPolicy): void;
    /**
     * Adds a user to this group.
     */
    addUser(user: IUser): void;
    /**
     * Adds an IAM statement to the default policy.
     */
    addToPolicy(statement: PolicyStatement): boolean;
}
export declare class Group extends GroupBase {
    /**
     * Imports a group from ARN
     * @param groupArn (e.g. `arn:aws:iam::account-id:group/group-name`)
     */
    static fromGroupArn(scope: Construct, id: string, groupArn: string): IGroup;
    readonly groupName: string;
    readonly groupArn: string;
    private readonly managedPolicies;
    constructor(scope: Construct, id: string, props?: GroupProps);
    /**
     * Attaches a managed policy to this group.
     * @param policy The managed policy to attach.
     */
    addManagedPolicy(policy: IManagedPolicy): void;
}
export {};
