"use strict";
// tests for the L1 escape hatches (overrides). those are in the IAM module
// because we want to verify them end-to-end, as a complement to the unit
// tests in the @aws-cdk/core module
const assert_1 = require("@aws-cdk/assert");
const core_1 = require("@aws-cdk/core");
const iam = require("../lib");
module.exports = {
    'addPropertyOverride should allow overriding supported properties'(test) {
        const stack = new core_1.Stack();
        const user = new iam.User(stack, 'user', {
            userName: 'MyUserName',
        });
        const cfn = user.node.findChild('Resource');
        cfn.addPropertyOverride('UserName', 'OverriddenUserName');
        assert_1.expect(stack).toMatch({
            "Resources": {
                "user2C2B57AE": {
                    "Type": "AWS::IAM::User",
                    "Properties": {
                        "UserName": "OverriddenUserName"
                    }
                }
            }
        });
        test.done();
    },
    'addPropertyOverrides should allow specifying arbitrary properties'(test) {
        // GIVEN
        const stack = new core_1.Stack();
        const user = new iam.User(stack, 'user', { userName: 'MyUserName' });
        const cfn = user.node.findChild('Resource');
        // WHEN
        cfn.addPropertyOverride('Hello.World', 'Boom');
        // THEN
        assert_1.expect(stack).toMatch({
            "Resources": {
                "user2C2B57AE": {
                    "Type": "AWS::IAM::User",
                    "Properties": {
                        "UserName": "MyUserName",
                        "Hello": {
                            "World": "Boom"
                        }
                    }
                }
            }
        });
        test.done();
    },
    'addOverride should allow overriding properties'(test) {
        // GIVEN
        const stack = new core_1.Stack();
        const user = new iam.User(stack, 'user', { userName: 'MyUserName' });
        const cfn = user.node.findChild('Resource');
        cfn.cfnOptions.updatePolicy = { useOnlineResharding: true };
        // WHEN
        cfn.addOverride('Properties.Hello.World', 'Bam');
        cfn.addOverride('Properties.UserName', 'HA!');
        cfn.addOverride('Joob.Jab', 'Jib');
        cfn.addOverride('Joob.Jab', 'Jib');
        cfn.addOverride('UpdatePolicy.UseOnlineResharding.Type', 'None');
        // THEN
        assert_1.expect(stack).toMatch({
            "Resources": {
                "user2C2B57AE": {
                    "Type": "AWS::IAM::User",
                    "Properties": {
                        "UserName": "HA!",
                        "Hello": {
                            "World": "Bam"
                        }
                    },
                    "Joob": {
                        "Jab": "Jib"
                    },
                    "UpdatePolicy": {
                        "UseOnlineResharding": {
                            "Type": "None"
                        }
                    }
                }
            }
        });
        test.done();
    }
};
//# sourceMappingURL=data:application/json;base64,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