# coding: utf-8

"""
    Application Load Balancer API

    This API offers an interface to provision and manage load balancing servers in your STACKIT project. It also has the possibility of pooling target servers for load balancing purposes.  For each application load balancer provided, two VMs are deployed in your OpenStack project subject to a fee.

    The version of the OpenAPI document: 1beta.0.0
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501 docstring might be too long

from __future__ import annotations

import json
import pprint
from typing import Any, ClassVar, Dict, List, Optional, Set

from pydantic import BaseModel, ConfigDict, Field, StrictStr, field_validator
from typing_extensions import Self


class LoadBalancerError(BaseModel):
    """
    LoadBalancerError
    """

    description: Optional[StrictStr] = Field(
        default=None,
        description='The error description contains additional helpful user information to fix the error state of the application load balancer. For example the IP 45.135.247.139 does not exist in the project, then the description will report: Floating IP "45.135.247.139" could not be found.',
    )
    type: Optional[StrictStr] = Field(
        default=None,
        description="The error type specifies which part of the application load balancer encountered the error. I.e. the API will not check if a provided public IP is actually available in the project. Instead the application load balancer with try to use the provided IP and if not available reports TYPE_FIP_NOT_CONFIGURED error.",
    )
    __properties: ClassVar[List[str]] = ["description", "type"]

    @field_validator("type")
    def type_validate_enum(cls, value):
        """Validates the enum"""
        if value is None:
            return value

        if value not in set(
            [
                "TYPE_UNSPECIFIED",
                "TYPE_INTERNAL",
                "TYPE_QUOTA_SECGROUP_EXCEEDED",
                "TYPE_QUOTA_SECGROUPRULE_EXCEEDED",
                "TYPE_PORT_NOT_CONFIGURED",
                "TYPE_FIP_NOT_CONFIGURED",
                "TYPE_TARGET_NOT_ACTIVE",
                "TYPE_METRICS_MISCONFIGURED",
                "TYPE_LOGS_MISCONFIGURED",
            ]
        ):
            raise ValueError(
                "must be one of enum values ('TYPE_UNSPECIFIED', 'TYPE_INTERNAL', 'TYPE_QUOTA_SECGROUP_EXCEEDED', 'TYPE_QUOTA_SECGROUPRULE_EXCEEDED', 'TYPE_PORT_NOT_CONFIGURED', 'TYPE_FIP_NOT_CONFIGURED', 'TYPE_TARGET_NOT_ACTIVE', 'TYPE_METRICS_MISCONFIGURED', 'TYPE_LOGS_MISCONFIGURED')"
            )
        return value

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of LoadBalancerError from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of LoadBalancerError from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({"description": obj.get("description"), "type": obj.get("type")})
        return _obj
