# generated by datamodel-codegen:
#   filename:  alfresco-search.yaml
#   timestamp: 2025-06-25T01:56:52+00:00

from __future__ import annotations

from datetime import datetime
from enum import Enum
from typing import Annotated, Any

from pydantic import BaseModel, ConfigDict, Field, RootModel


class ContentInfo(BaseModel):
    encoding: str | None = None
    mimeType: str
    mimeTypeGroup: str | None = None
    mimeTypeName: str
    sizeInBytes: int


class Error1(BaseModel):
    briefSummary: str | None = None
    descriptionURL: str | None = None
    errorKey: str | None = None
    logId: str | None = None
    stackTrace: str | None = None
    statusCode: int | None = None


class Error(BaseModel):
    error: Error1


class BucketInfo(BaseModel):
    end: Annotated[str | None, Field(description='The end of range')] = None
    endInclusive: Annotated[
        bool | None, Field(description='Includes values less than or equal to "end"')
    ] = None
    start: Annotated[str | None, Field(description='The start of range')] = None
    startInclusive: Annotated[
        bool | None, Field(description='Includes values greater or equal to "start"')
    ] = None


class GenericMetric(BaseModel):
    type: Annotated[str | None, Field(description='The type of metric, e.g. count')] = None
    value: Annotated[
        dict[str, Any] | None, Field(description='The metric value, e.g. {"count": 34}\n')
    ] = None


class Pagination(BaseModel):
    count: Annotated[int, Field(description='The number of objects in the entries array.\n')]
    hasMoreItems: Annotated[
        bool,
        Field(
            description='A boolean value which is **true** if there are more entities in the collection\nbeyond those in this response. A true value means a request with a larger value\nfor the **skipCount** or the **maxItems** parameter will return more entities.\n'
        ),
    ]
    maxItems: Annotated[
        int,
        Field(
            description='The value of the **maxItems** parameter used to generate this list,\nor if there was no **maxItems** parameter the default value is 100\n'
        ),
    ]
    skipCount: Annotated[
        int,
        Field(
            description='An integer describing how many entities exist in the collection before\nthose included in this list.\n'
        ),
    ]
    totalItems: Annotated[
        int | None,
        Field(
            description='An integer describing the total number of entities in the collection.\nThe API might not be able to determine this value,\nin which case this property will not be present.\n'
        ),
    ] = None


class PathElement(BaseModel):
    id: str | None = None
    name: str | None = None


class PathInfo(BaseModel):
    elements: list[PathElement] | None = None
    isComplete: bool | None = None
    name: str | None = None


class DefaultFTSFieldOperator(Enum):
    AND = 'AND'
    OR = 'OR'


class DefaultFTSOperator(Enum):
    AND = 'AND'
    OR = 'OR'


class RequestDefaults(BaseModel):
    defaultFTSFieldOperator: Annotated[
        DefaultFTSFieldOperator | None,
        Field(
            description='The default way to combine query parts in field query groups when AND or OR is not explicitly stated - includes ! - +\nFIELD:(one two three)\n'
        ),
    ] = 'AND'
    defaultFTSOperator: Annotated[
        DefaultFTSOperator | None,
        Field(
            description='The default way to combine query parts when AND or OR is not explicitly stated - includes ! - +\none two three\n(one two three)\n'
        ),
    ] = 'AND'
    defaultFieldName: str | None = 'TEXT'
    namespace: Annotated[
        str | None, Field(description='The default name space to use if one is not provided')
    ] = 'cm'
    textAttributes: Annotated[
        list[str] | None,
        Field(
            description='A list of query fields/properties used to expand TEXT: queries.\nThe default is cm:content.\nYou could include all content properties using d:content or list all individual content properties or types.\nAs more terms are included the query size, complexity, memory impact and query time will increase.\n'
        ),
    ] = None


class Method(Enum):
    ENUM = 'ENUM'
    FC = 'FC'


class Sort(Enum):
    COUNT = 'COUNT'
    INDEX = 'INDEX'


class RequestFacetField(BaseModel):
    excludeFilters: Annotated[
        list[str] | None,
        Field(
            description='Filter Queries with tags listed here will not be included in facet counts.\nThis is used for multi-select facetting.\n'
        ),
    ] = None
    facetEnumCacheMinDf: int | None = None
    field: Annotated[str | None, Field(description='The facet field')] = None
    label: Annotated[
        str | None, Field(description='A label to include in place of the facet field')
    ] = None
    limit: int | None = None
    method: Method | None = None
    mincount: Annotated[
        int | None,
        Field(
            description='The minimum count required for a facet field to be included in the response.'
        ),
    ] = 1
    missing: Annotated[
        bool | None,
        Field(
            description='When true, count results that match the query but which have no facet value for the field (in addition to the Term-based constraints).'
        ),
    ] = False
    offset: int | None = None
    prefix: Annotated[
        str | None,
        Field(
            description='Restricts the possible constraints to only indexed values with a specified prefix.'
        ),
    ] = None
    sort: Sort | None = None


class RequestFacetFields(BaseModel):
    facets: Annotated[
        list[RequestFacetField] | None,
        Field(
            description='Define specifc fields on which to facet (adds SOLR facet.field and f.<field>.facet.* options)\n'
        ),
    ] = None


class RequestFacetQuery(BaseModel):
    label: Annotated[
        str | None, Field(description='A label to include in place of the facet query')
    ] = None
    query: Annotated[str | None, Field(description='A facet query')] = None


class RequestFacetQueries(RootModel[list[RequestFacetQuery]]):
    root: Annotated[list[RequestFacetQuery], Field(description='Facet queries to include')]


class RequestFacetSet(BaseModel):
    end: Annotated[str | None, Field(description='The end of the range')] = None
    endInclusive: Annotated[
        bool | None,
        Field(description='When true, the set will include values less than or equal to "end"'),
    ] = True
    label: Annotated[str | None, Field(description='A label to use to identify the set')] = None
    start: Annotated[str | None, Field(description='The start of the range')] = None
    startInclusive: Annotated[
        bool | None,
        Field(description='When true, the set will include values greater or equal to "start"'),
    ] = True


class RequestFields(RootModel[list[str]]):
    root: Annotated[
        list[str],
        Field(
            description='A list of field names.\nYou can use this parameter to restrict the fields returned within a response if, for example, you want to save on overall bandwidth.\nThe list applies to a returned individual entity or entries within a collection.\nIf the **include** parameter is used aswell then the fields specified in the **include** parameter are returned in addition to those specified in the **fields** parameter.'
        ),
    ]


class RequestFilterQuery(BaseModel):
    query: Annotated[
        str | None,
        Field(
            description='The filter query expression.\nFor multi-select facets selected facets must be order together\n'
        ),
    ] = None
    tags: Annotated[
        list[str] | None,
        Field(
            description='Tags used exclude the filters from facet evaluation for multi-select facet support'
        ),
    ] = None


class RequestFilterQueries(RootModel[list[RequestFilterQuery]]):
    root: Annotated[
        list[RequestFilterQuery],
        Field(
            description='Filter Queries. Constraints that apply to the results set but do not affect the score of each entry.'
        ),
    ]


class FieldModel(BaseModel):
    field: Annotated[str | None, Field(description='The name of the field to highlight.')] = None
    fragmentSize: int | None = None
    mergeContiguous: bool | None = None
    postfix: str | None = None
    prefix: str | None = None
    snippetCount: int | None = None


class RequestHighlight(BaseModel):
    fields: Annotated[
        list[FieldModel] | None,
        Field(
            description='The fields to highlight and field specific configuration properties for each field'
        ),
    ] = None
    fragmentSize: Annotated[
        int | None, Field(description='The character length of each snippet.')
    ] = None
    maxAnalyzedChars: Annotated[
        int | None,
        Field(
            description='The number of characters to be considered for highlighting. Matches after this count will not be shown.'
        ),
    ] = None
    mergeContiguous: Annotated[
        bool | None,
        Field(description='If fragments over lap they can be  merged into one larger fragment'),
    ] = None
    postfix: Annotated[
        str | None,
        Field(description='The string used to mark the end of a highlight in a fragment.'),
    ] = None
    prefix: Annotated[
        str | None,
        Field(description='The string used to mark the start of a highlight in a fragment.'),
    ] = None
    snippetCount: Annotated[
        int | None,
        Field(
            description='The maximum number of distinct highlight snippets to return for each highlight field.'
        ),
    ] = None
    usePhraseHighlighter: Annotated[
        bool | None, Field(description='Should phrases be identified.')
    ] = None


class RequestIncludeEnum(Enum):
    allowableOperations = 'allowableOperations'
    aspectNames = 'aspectNames'
    isLink = 'isLink'
    isLocked = 'isLocked'
    path = 'path'
    properties = 'properties'


class RequestInclude(RootModel[list[RequestIncludeEnum]]):
    root: Annotated[
        list[RequestIncludeEnum],
        Field(
            description='Returns additional information about the node. The following optional fields can be requested:\n * properties\n * aspectNames\n * path\n * isLink\n * allowableOperations\n * association\n'
        ),
    ]


class RequestLimits(BaseModel):
    permissionEvaluationCount: Annotated[
        int | None, Field(description='Maximum count of post query permission evaluations')
    ] = 2000
    permissionEvaluationTime: Annotated[
        int | None, Field(description='Maximum time for post query permission evaluation')
    ] = 20000


class RequestLocalization(BaseModel):
    locales: Annotated[
        list[str] | None,
        Field(
            description='A list of Locales definied by IETF BCP 47.  The ordering is significant.  The first locale (leftmost) is used for sort and query localization, whereas the remaining locales are used for query only.'
        ),
    ] = None
    timezone: Annotated[
        str | None, Field(description='A valid timezone id supported by @see java.time.ZoneId')
    ] = None


class RequestPagination(BaseModel):
    maxItems: Annotated[
        int | None,
        Field(description='The maximum number of items to return in the query results', ge=1),
    ] = 100
    skipCount: Annotated[
        int | None,
        Field(description='The number of items to skip from the start of the query set', ge=0),
    ] = 0


class RequestPivot(BaseModel):
    key: Annotated[
        str | None,
        Field(description='A key corresponding to a matching field facet label or stats.'),
    ] = None
    pivots: list[RequestPivot] | None = None


class Language(Enum):
    afts = 'afts'
    lucene = 'lucene'
    cmis = 'cmis'


class RequestQuery(BaseModel):
    language: Annotated[
        Language | None, Field(description='The query language in which the query is written.')
    ] = 'afts'
    query: Annotated[
        str,
        Field(description='The query which may have been generated in some way from the userQuery'),
    ]
    userQuery: Annotated[
        str | None, Field(description='The exact search request typed in by the user')
    ] = None


class RequestRange(BaseModel):
    end: Annotated[str | None, Field(description='The end of the range')] = None
    excludeFilters: Annotated[
        list[str] | None, Field(description='Filter queries to exclude when calculating statistics')
    ] = None
    field: Annotated[str | None, Field(description='The name of the field to perform range')] = None
    gap: Annotated[str | None, Field(description='Bucket size')] = None
    hardend: Annotated[
        bool | None,
        Field(
            description='If true means that the last bucket will end at “end” even if it is less than “gap” wide.'
        ),
    ] = None
    include: Annotated[list[str] | None, Field(description='lower, upper, edge, outer, all')] = None
    label: Annotated[str | None, Field(description='A label to include as a pivot reference')] = (
        None
    )
    other: Annotated[list[str] | None, Field(description='before, after, between, non, all')] = None
    start: Annotated[str | None, Field(description='The start of the range')] = None


class Locations(Enum):
    nodes = 'nodes'
    versions = 'versions'
    deleted_nodes = 'deleted-nodes'


class RequestScope(BaseModel):
    locations: Annotated[
        Locations | None, Field(description='The locations to include in the query\n')
    ] = None


class Type(Enum):
    FIELD = 'FIELD'
    DOCUMENT = 'DOCUMENT'
    SCORE = 'SCORE'


class RequestSortDefinitionItem(BaseModel):
    ascending: Annotated[
        bool | None,
        Field(
            description='The sort order. (The ordering of nulls is determined by the SOLR configuration)'
        ),
    ] = False
    field: Annotated[str | None, Field(description='The name of the field')] = None
    type: Annotated[
        Type | None,
        Field(
            description='How to order - using a field, when position of the document in the index, score/relevence.'
        ),
    ] = 'FIELD'


class RequestSortDefinition(RootModel[list[RequestSortDefinitionItem]]):
    root: Annotated[
        list[RequestSortDefinitionItem],
        Field(
            description='How to sort the rows? An array of sort specifications. The array order defines the ordering precedence.'
        ),
    ]


class RequestSpellcheck(BaseModel):
    query: str | None = None


class RequestStats(BaseModel):
    cardinality: Annotated[
        bool | None,
        Field(description='A statistical approximation of the number of distinct values'),
    ] = False
    cardinalityAccuracy: Annotated[
        float | None,
        Field(
            description='Number between 0.0 and 1.0 indicating how aggressively the algorithm should try to be accurate. Used with boolean cardinality flag.'
        ),
    ] = 0.3
    countDistinct: Annotated[
        bool | None,
        Field(
            description='The number of distinct values  (This can be very expensive to calculate)'
        ),
    ] = False
    countValues: Annotated[
        bool | None, Field(description='The number which have a value for this field')
    ] = True
    distinctValues: Annotated[
        bool | None,
        Field(
            description='The set of all distinct values for the field (This can be very expensive to calculate)'
        ),
    ] = False
    excludeFilters: Annotated[
        list[str] | None, Field(description='A list of filters to exclude')
    ] = None
    field: Annotated[str | None, Field(description='The stats field')] = None
    label: Annotated[
        str | None, Field(description='A label to include for reference the stats field')
    ] = None
    max: Annotated[bool | None, Field(description='The maximum value of the field')] = True
    mean: Annotated[bool | None, Field(description='The average')] = True
    min: Annotated[bool | None, Field(description='The minimum value of the field')] = True
    missing: Annotated[
        bool | None, Field(description='The number which do not have a value for this field')
    ] = True
    percentiles: Annotated[
        list[float] | None, Field(description='A list of percentile values, e.g. "1,99,99.9"')
    ] = None
    stddev: Annotated[bool | None, Field(description='Standard deviation')] = True
    sum: Annotated[bool | None, Field(description='The sum of all values of the field')] = True
    sumOfSquares: Annotated[bool | None, Field(description='Sum of all values squared')] = True


class RequestTemplate(BaseModel):
    name: Annotated[str | None, Field(description='The template name')] = None
    template: Annotated[str | None, Field(description='The template')] = None


class RequestTemplates(RootModel[list[RequestTemplate]]):
    root: Annotated[
        list[RequestTemplate],
        Field(
            description='Templates usewd for query expansion.\nA template called "WOOF" defined as "%(cm:name cm:title)" allows\nWOOF:example\nto generate\ncm:name:example cm:name:example\n'
        ),
    ]


class ResponseConsistency(BaseModel):
    lastTxId: Annotated[int | None, Field(description='The id of the last indexed transaction')] = (
        None
    )


class Bucket(BaseModel):
    count: Annotated[int | None, Field(description='The count for the bucket')] = None
    display: Annotated[
        dict[str, Any] | None,
        Field(description='An optional field for additional display information'),
    ] = None
    filterQuery: Annotated[
        str | None, Field(description='The filter query you can use to apply this facet')
    ] = None
    label: Annotated[str | None, Field(description='The bucket label')] = None


class ResultBuckets(BaseModel):
    buckets: Annotated[list[Bucket] | None, Field(description='An array of buckets and values')] = (
        None
    )
    label: Annotated[
        str | None,
        Field(description='The field name or its explicit label, if provided on the request'),
    ] = None


class FacetQuery(BaseModel):
    count: int | None = None
    filterQuery: Annotated[
        str | None, Field(description='The filter query you can use to apply this facet')
    ] = None
    label: str | None = None


class Type1(Enum):
    searchInsteadFor = 'searchInsteadFor'
    didYouMean = 'didYouMean'


class SpellcheckItem(BaseModel):
    suggestion: Annotated[list[str] | None, Field(description='A suggested alternative query')] = (
        None
    )
    type: Type1 | None = None


class HighlightItem(BaseModel):
    field: Annotated[
        str | None,
        Field(
            description='The field where a match occured (one of the fields defined on the request)'
        ),
    ] = None
    snippets: Annotated[
        list[str] | None,
        Field(
            description='Any number of snippets for the specified field highlighting the matching text'
        ),
    ] = None


class SearchEntry(BaseModel):
    highlight: Annotated[
        list[HighlightItem] | None,
        Field(
            description='Highlight fragments if requested and available. A match can happen in any of the requested field.\n'
        ),
    ] = None
    score: Annotated[float | None, Field(description='The score for this row')] = None


class UserInfo(BaseModel):
    displayName: str
    id: str


class GenericBucket(BaseModel):
    bucketInfo: Annotated[
        BucketInfo | None, Field(description='Additional information of nested facet')
    ] = None
    display: Annotated[
        dict[str, Any] | None,
        Field(description='An optional field for additional display information'),
    ] = None
    facets: Annotated[
        list[dict[str, Any]] | None, Field(description='Additional list of nested facets')
    ] = None
    filterQuery: Annotated[
        str | None, Field(description='The filter query you can use to apply this facet')
    ] = None
    label: Annotated[str | None, Field(description='The bucket label')] = None
    metrics: Annotated[
        list[GenericMetric] | None, Field(description='An array of buckets and values')
    ] = None


class GenericFacetResponse(BaseModel):
    buckets: Annotated[
        list[GenericBucket] | None, Field(description='An array of buckets and values')
    ] = None
    label: Annotated[
        str | None,
        Field(description='The field name or its explicit label, if provided on the request'),
    ] = None
    type: Annotated[
        str | None, Field(description='The facet type, eg. interval, range, pivot, stats')
    ] = None


class Node(BaseModel):
    model_config = ConfigDict(
        regex_engine="python-re",
    )
    allowableOperations: list[str] | None = None
    aspectNames: list[str] | None = None
    content: ContentInfo | None = None
    createdAt: datetime
    createdByUser: UserInfo
    id: str
    isFile: bool
    isFolder: bool
    isLink: bool | None = None
    isLocked: bool | None = False
    modifiedAt: datetime
    modifiedByUser: UserInfo
    name: Annotated[
        str,
        Field(
            description='The name must not contain spaces or the following special characters: * " < > \\ / ? : and |.\nThe character . must not be used at the end of the name.\n',
            pattern='^(?!(.*[\\"\\*\\\\\\>\\<\\?\\/\\:\\|]+.*)|(.*[\\.]?.*[\\.]+$)|(.*[ ]+$))',
        ),
    ]
    nodeType: str
    parentId: str | None = None
    path: PathInfo | None = None
    properties: dict[str, Any] | None = None


class Interval(BaseModel):
    field: Annotated[str | None, Field(description='The field to facet on')] = None
    label: Annotated[
        str | None, Field(description='A label to use to identify the field facet')
    ] = None
    sets: Annotated[
        list[RequestFacetSet] | None, Field(description='Sets the intervals for all fields.')
    ] = None


class RequestFacetIntervals(BaseModel):
    intervals: Annotated[
        list[Interval] | None, Field(description='Specifies the fields to facet by interval.')
    ] = None
    sets: Annotated[
        list[RequestFacetSet] | None, Field(description='Sets the intervals for all fields.')
    ] = None


class ResultNode(Node):
    archivedAt: datetime | None = None
    archivedByUser: UserInfo | None = None
    search: SearchEntry | None = None
    versionComment: str | None = None
    versionLabel: str | None = None


class ResultSetRowEntry(BaseModel):
    entry: ResultNode


class SearchRequest(BaseModel):
    defaults: RequestDefaults | None = None
    facetFields: RequestFacetFields | None = None
    facetIntervals: RequestFacetIntervals | None = None
    facetQueries: RequestFacetQueries | None = None
    fields: RequestFields | None = None
    filterQueries: RequestFilterQueries | None = None
    highlight: RequestHighlight | None = None
    include: RequestInclude | None = None
    includeRequest: Annotated[
        bool | None, Field(description='When true, include the original request in the response')
    ] = False
    limits: RequestLimits | None = None
    localization: RequestLocalization | None = None
    paging: RequestPagination | None = None
    pivots: list[RequestPivot] | None = None
    query: RequestQuery
    ranges: list[RequestRange] | None = None
    scope: RequestScope | None = None
    sort: RequestSortDefinition | None = None
    spellcheck: RequestSpellcheck | None = None
    stats: list[RequestStats] | None = None
    templates: RequestTemplates | None = None


class ResultSetContext(BaseModel):
    consistency: ResponseConsistency | None = None
    facetQueries: Annotated[
        list[FacetQuery] | None, Field(description='The counts from facet queries')
    ] = None
    facets: Annotated[
        list[GenericFacetResponse] | None, Field(description='The faceted response')
    ] = None
    facetsFields: Annotated[
        list[ResultBuckets] | None, Field(description='The counts from field facets')
    ] = None
    request: SearchRequest | None = None
    spellcheck: Annotated[
        list[SpellcheckItem] | None,
        Field(
            description='Suggested corrections\n\nIf zero results were found for the original query then a single entry of type "searchInsteadFor" will be returned.\nIf alternatives were found that return more results than the original query they are returned as "didYouMean" options.\nThe highest quality suggestion is first.\n'
        ),
    ] = None


class List(BaseModel):
    context: ResultSetContext | None = None
    entries: list[ResultSetRowEntry] | None = None
    pagination: Pagination | None = None


class ResultSetPaging(BaseModel):
    list: List | None = None


RequestPivot.model_rebuild()
