# generated by datamodel-codegen:
#   filename:  alfresco-search-sql.yaml
#   timestamp: 2025-06-25T01:56:57+00:00

from __future__ import annotations

from typing import Annotated

from pydantic import BaseModel, Field, RootModel


class Error1(BaseModel):
    briefSummary: str | None = None
    descriptionURL: str | None = None
    errorKey: str | None = None
    logId: str | None = None
    stackTrace: str | None = None
    statusCode: int | None = None


class Error(BaseModel):
    error: Error1


class Pagination(BaseModel):
    count: Annotated[int, Field(description='The number of objects in the entries array.\n')]
    hasMoreItems: Annotated[
        bool,
        Field(
            description='A boolean value which is **true** if there are more entities in the collection\nbeyond those in this response. A true value means a request with a larger value\nfor the **skipCount** or the **maxItems** parameter will return more entities.\n'
        ),
    ]
    maxItems: Annotated[
        int,
        Field(
            description='The value of the **maxItems** parameter used to generate this list,\nor if there was no **maxItems** parameter the default value is 100\n'
        ),
    ]
    skipCount: Annotated[
        int,
        Field(
            description='An integer describing how many entities exist in the collection before\nthose included in this list.\n'
        ),
    ]
    totalItems: Annotated[
        int | None,
        Field(
            description='An integer describing the total number of entities in the collection.\nThe API might not be able to determine this value,\nin which case this property will not be present.\n'
        ),
    ] = None


class SQLResultSetRowEntry(BaseModel):
    label: str | None = None
    value: str | None = None


class SQLSearchRequest(BaseModel):
    filterQueries: list[str] | None = None
    format: str | None = None
    includeMetadata: bool | None = None
    locales: list[str] | None = None
    stmt: str | None = None
    timezone: str | None = None


class Doc(BaseModel):
    label: str | None = None
    value: str | None = None


class Docs(RootModel[list[Doc]]):
    root: Annotated[
        list[Doc],
        Field(
            description='Array of documents returned by the query, note that this is a Solr convention.'
        ),
    ]


class List(BaseModel):
    entries: list[SQLResultSetRowEntry] | None = None
    pagination: Pagination | None = None


class SQLResultSetPaging(BaseModel):
    list: List | None = None


class SolrResultSet(BaseModel):
    result_set: Annotated[Docs | None, Field(alias='result-set')] = None
