from collections.abc import Mapping
from typing import TYPE_CHECKING, Any, TypeVar

from attrs import define as _attrs_define
from attrs import field as _attrs_field

if TYPE_CHECKING:
    from ..models.shared_link_paging_list import SharedLinkPagingList


T = TypeVar("T", bound="SharedLinkPaging")


@_attrs_define
class SharedLinkPaging:
    """
    Attributes:
        list_ (SharedLinkPagingList):
    """

    list_: "SharedLinkPagingList"
    additional_properties: dict[str, Any] = _attrs_field(init=False, factory=dict)

    def to_dict(self) -> dict[str, Any]:
        list_ = self.list_.to_dict()

        field_dict: dict[str, Any] = {}
        field_dict.update(self.additional_properties)
        field_dict.update(
            {
                "list": list_,
            }
        )

        return field_dict

    @classmethod
    def from_dict(cls: type[T], src_dict: Mapping[str, Any]) -> T:
        from ..models.shared_link_paging_list import SharedLinkPagingList

        d = dict(src_dict)
        list_ = SharedLinkPagingList.from_dict(d.pop("list"))

        shared_link_paging = cls(
            list_=list_,
        )

        shared_link_paging.additional_properties = d
        return shared_link_paging

    @property
    def additional_keys(self) -> list[str]:
        return list(self.additional_properties.keys())

    def __getitem__(self, key: str) -> Any:
        return self.additional_properties[key]

    def __setitem__(self, key: str, value: Any) -> None:
        self.additional_properties[key] = value

    def __delitem__(self, key: str) -> None:
        del self.additional_properties[key]

    def __contains__(self, key: str) -> bool:
        return key in self.additional_properties
