import { ExceptionOptionType as __ExceptionOptionType } from "@smithy/smithy-client";
import { CodeDeployServiceException as __BaseException } from "./CodeDeployServiceException";
export interface Tag {
  Key?: string;
  Value?: string;
}
export interface AddTagsToOnPremisesInstancesInput {
  tags: Tag[] | undefined;
  instanceNames: string[] | undefined;
}
export declare class InstanceLimitExceededException extends __BaseException {
  readonly name: "InstanceLimitExceededException";
  readonly $fault: "client";
  constructor(
    opts: __ExceptionOptionType<InstanceLimitExceededException, __BaseException>
  );
}
export declare class InstanceNameRequiredException extends __BaseException {
  readonly name: "InstanceNameRequiredException";
  readonly $fault: "client";
  constructor(
    opts: __ExceptionOptionType<InstanceNameRequiredException, __BaseException>
  );
}
export declare class InstanceNotRegisteredException extends __BaseException {
  readonly name: "InstanceNotRegisteredException";
  readonly $fault: "client";
  constructor(
    opts: __ExceptionOptionType<InstanceNotRegisteredException, __BaseException>
  );
}
export declare class InvalidInstanceNameException extends __BaseException {
  readonly name: "InvalidInstanceNameException";
  readonly $fault: "client";
  constructor(
    opts: __ExceptionOptionType<InvalidInstanceNameException, __BaseException>
  );
}
export declare class InvalidTagException extends __BaseException {
  readonly name: "InvalidTagException";
  readonly $fault: "client";
  constructor(
    opts: __ExceptionOptionType<InvalidTagException, __BaseException>
  );
}
export declare class TagLimitExceededException extends __BaseException {
  readonly name: "TagLimitExceededException";
  readonly $fault: "client";
  constructor(
    opts: __ExceptionOptionType<TagLimitExceededException, __BaseException>
  );
}
export declare class TagRequiredException extends __BaseException {
  readonly name: "TagRequiredException";
  readonly $fault: "client";
  constructor(
    opts: __ExceptionOptionType<TagRequiredException, __BaseException>
  );
}
export interface Alarm {
  name?: string;
}
export interface AlarmConfiguration {
  enabled?: boolean;
  ignorePollAlarmFailure?: boolean;
  alarms?: Alarm[];
}
export declare class AlarmsLimitExceededException extends __BaseException {
  readonly name: "AlarmsLimitExceededException";
  readonly $fault: "client";
  constructor(
    opts: __ExceptionOptionType<AlarmsLimitExceededException, __BaseException>
  );
}
export declare class ApplicationAlreadyExistsException extends __BaseException {
  readonly name: "ApplicationAlreadyExistsException";
  readonly $fault: "client";
  constructor(
    opts: __ExceptionOptionType<
      ApplicationAlreadyExistsException,
      __BaseException
    >
  );
}
export declare class ApplicationDoesNotExistException extends __BaseException {
  readonly name: "ApplicationDoesNotExistException";
  readonly $fault: "client";
  constructor(
    opts: __ExceptionOptionType<
      ApplicationDoesNotExistException,
      __BaseException
    >
  );
}
export declare const ComputePlatform: {
  readonly ECS: "ECS";
  readonly LAMBDA: "Lambda";
  readonly SERVER: "Server";
};
export type ComputePlatform =
  (typeof ComputePlatform)[keyof typeof ComputePlatform];
export interface ApplicationInfo {
  applicationId?: string;
  applicationName?: string;
  createTime?: Date;
  linkedToGitHub?: boolean;
  gitHubAccountName?: string;
  computePlatform?: ComputePlatform;
}
export declare class ApplicationLimitExceededException extends __BaseException {
  readonly name: "ApplicationLimitExceededException";
  readonly $fault: "client";
  constructor(
    opts: __ExceptionOptionType<
      ApplicationLimitExceededException,
      __BaseException
    >
  );
}
export declare class ApplicationNameRequiredException extends __BaseException {
  readonly name: "ApplicationNameRequiredException";
  readonly $fault: "client";
  constructor(
    opts: __ExceptionOptionType<
      ApplicationNameRequiredException,
      __BaseException
    >
  );
}
export declare const ApplicationRevisionSortBy: {
  readonly FirstUsedTime: "firstUsedTime";
  readonly LastUsedTime: "lastUsedTime";
  readonly RegisterTime: "registerTime";
};
export type ApplicationRevisionSortBy =
  (typeof ApplicationRevisionSortBy)[keyof typeof ApplicationRevisionSortBy];
export interface AppSpecContent {
  content?: string;
  sha256?: string;
}
export declare class ArnNotSupportedException extends __BaseException {
  readonly name: "ArnNotSupportedException";
  readonly $fault: "client";
  constructor(
    opts: __ExceptionOptionType<ArnNotSupportedException, __BaseException>
  );
}
export declare const AutoRollbackEvent: {
  readonly DEPLOYMENT_FAILURE: "DEPLOYMENT_FAILURE";
  readonly DEPLOYMENT_STOP_ON_ALARM: "DEPLOYMENT_STOP_ON_ALARM";
  readonly DEPLOYMENT_STOP_ON_REQUEST: "DEPLOYMENT_STOP_ON_REQUEST";
};
export type AutoRollbackEvent =
  (typeof AutoRollbackEvent)[keyof typeof AutoRollbackEvent];
export interface AutoRollbackConfiguration {
  enabled?: boolean;
  events?: AutoRollbackEvent[];
}
export interface AutoScalingGroup {
  name?: string;
  hook?: string;
  terminationHook?: string;
}
export interface GitHubLocation {
  repository?: string;
  commitId?: string;
}
export declare const RevisionLocationType: {
  readonly AppSpecContent: "AppSpecContent";
  readonly GitHub: "GitHub";
  readonly S3: "S3";
  readonly String: "String";
};
export type RevisionLocationType =
  (typeof RevisionLocationType)[keyof typeof RevisionLocationType];
export declare const BundleType: {
  readonly JSON: "JSON";
  readonly Tar: "tar";
  readonly TarGZip: "tgz";
  readonly YAML: "YAML";
  readonly Zip: "zip";
};
export type BundleType = (typeof BundleType)[keyof typeof BundleType];
export interface S3Location {
  bucket?: string;
  key?: string;
  bundleType?: BundleType;
  version?: string;
  eTag?: string;
}
export interface RawString {
  content?: string;
  sha256?: string;
}
export interface RevisionLocation {
  revisionType?: RevisionLocationType;
  s3Location?: S3Location;
  gitHubLocation?: GitHubLocation;
  string?: RawString;
  appSpecContent?: AppSpecContent;
}
export interface BatchGetApplicationRevisionsInput {
  applicationName: string | undefined;
  revisions: RevisionLocation[] | undefined;
}
export interface GenericRevisionInfo {
  description?: string;
  deploymentGroups?: string[];
  firstUsedTime?: Date;
  lastUsedTime?: Date;
  registerTime?: Date;
}
export interface RevisionInfo {
  revisionLocation?: RevisionLocation;
  genericRevisionInfo?: GenericRevisionInfo;
}
export interface BatchGetApplicationRevisionsOutput {
  applicationName?: string;
  errorMessage?: string;
  revisions?: RevisionInfo[];
}
export declare class BatchLimitExceededException extends __BaseException {
  readonly name: "BatchLimitExceededException";
  readonly $fault: "client";
  constructor(
    opts: __ExceptionOptionType<BatchLimitExceededException, __BaseException>
  );
}
export declare class InvalidApplicationNameException extends __BaseException {
  readonly name: "InvalidApplicationNameException";
  readonly $fault: "client";
  constructor(
    opts: __ExceptionOptionType<
      InvalidApplicationNameException,
      __BaseException
    >
  );
}
export declare class InvalidRevisionException extends __BaseException {
  readonly name: "InvalidRevisionException";
  readonly $fault: "client";
  constructor(
    opts: __ExceptionOptionType<InvalidRevisionException, __BaseException>
  );
}
export declare class RevisionRequiredException extends __BaseException {
  readonly name: "RevisionRequiredException";
  readonly $fault: "client";
  constructor(
    opts: __ExceptionOptionType<RevisionRequiredException, __BaseException>
  );
}
export interface BatchGetApplicationsInput {
  applicationNames: string[] | undefined;
}
export interface BatchGetApplicationsOutput {
  applicationsInfo?: ApplicationInfo[];
}
export interface BatchGetDeploymentGroupsInput {
  applicationName: string | undefined;
  deploymentGroupNames: string[] | undefined;
}
export declare const DeploymentReadyAction: {
  readonly CONTINUE_DEPLOYMENT: "CONTINUE_DEPLOYMENT";
  readonly STOP_DEPLOYMENT: "STOP_DEPLOYMENT";
};
export type DeploymentReadyAction =
  (typeof DeploymentReadyAction)[keyof typeof DeploymentReadyAction];
export interface DeploymentReadyOption {
  actionOnTimeout?: DeploymentReadyAction;
  waitTimeInMinutes?: number;
}
export declare const GreenFleetProvisioningAction: {
  readonly COPY_AUTO_SCALING_GROUP: "COPY_AUTO_SCALING_GROUP";
  readonly DISCOVER_EXISTING: "DISCOVER_EXISTING";
};
export type GreenFleetProvisioningAction =
  (typeof GreenFleetProvisioningAction)[keyof typeof GreenFleetProvisioningAction];
export interface GreenFleetProvisioningOption {
  action?: GreenFleetProvisioningAction;
}
export declare const InstanceAction: {
  readonly KEEP_ALIVE: "KEEP_ALIVE";
  readonly TERMINATE: "TERMINATE";
};
export type InstanceAction =
  (typeof InstanceAction)[keyof typeof InstanceAction];
export interface BlueInstanceTerminationOption {
  action?: InstanceAction;
  terminationWaitTimeInMinutes?: number;
}
export interface BlueGreenDeploymentConfiguration {
  terminateBlueInstancesOnDeploymentSuccess?: BlueInstanceTerminationOption;
  deploymentReadyOption?: DeploymentReadyOption;
  greenFleetProvisioningOption?: GreenFleetProvisioningOption;
}
export declare const DeploymentOption: {
  readonly WITHOUT_TRAFFIC_CONTROL: "WITHOUT_TRAFFIC_CONTROL";
  readonly WITH_TRAFFIC_CONTROL: "WITH_TRAFFIC_CONTROL";
};
export type DeploymentOption =
  (typeof DeploymentOption)[keyof typeof DeploymentOption];
export declare const DeploymentType: {
  readonly BLUE_GREEN: "BLUE_GREEN";
  readonly IN_PLACE: "IN_PLACE";
};
export type DeploymentType =
  (typeof DeploymentType)[keyof typeof DeploymentType];
export interface DeploymentStyle {
  deploymentType?: DeploymentType;
  deploymentOption?: DeploymentOption;
}
export declare const EC2TagFilterType: {
  readonly KEY_AND_VALUE: "KEY_AND_VALUE";
  readonly KEY_ONLY: "KEY_ONLY";
  readonly VALUE_ONLY: "VALUE_ONLY";
};
export type EC2TagFilterType =
  (typeof EC2TagFilterType)[keyof typeof EC2TagFilterType];
export interface EC2TagFilter {
  Key?: string;
  Value?: string;
  Type?: EC2TagFilterType;
}
export interface EC2TagSet {
  ec2TagSetList?: EC2TagFilter[][];
}
export interface ECSService {
  serviceName?: string;
  clusterName?: string;
}
export declare const DeploymentStatus: {
  readonly BAKING: "Baking";
  readonly CREATED: "Created";
  readonly FAILED: "Failed";
  readonly IN_PROGRESS: "InProgress";
  readonly QUEUED: "Queued";
  readonly READY: "Ready";
  readonly STOPPED: "Stopped";
  readonly SUCCEEDED: "Succeeded";
};
export type DeploymentStatus =
  (typeof DeploymentStatus)[keyof typeof DeploymentStatus];
export interface LastDeploymentInfo {
  deploymentId?: string;
  status?: DeploymentStatus;
  endTime?: Date;
  createTime?: Date;
}
export interface ELBInfo {
  name?: string;
}
export interface TargetGroupInfo {
  name?: string;
}
export interface TrafficRoute {
  listenerArns?: string[];
}
export interface TargetGroupPairInfo {
  targetGroups?: TargetGroupInfo[];
  prodTrafficRoute?: TrafficRoute;
  testTrafficRoute?: TrafficRoute;
}
export interface LoadBalancerInfo {
  elbInfoList?: ELBInfo[];
  targetGroupInfoList?: TargetGroupInfo[];
  targetGroupPairInfoList?: TargetGroupPairInfo[];
}
export declare const TagFilterType: {
  readonly KEY_AND_VALUE: "KEY_AND_VALUE";
  readonly KEY_ONLY: "KEY_ONLY";
  readonly VALUE_ONLY: "VALUE_ONLY";
};
export type TagFilterType = (typeof TagFilterType)[keyof typeof TagFilterType];
export interface TagFilter {
  Key?: string;
  Value?: string;
  Type?: TagFilterType;
}
export interface OnPremisesTagSet {
  onPremisesTagSetList?: TagFilter[][];
}
export declare const OutdatedInstancesStrategy: {
  readonly Ignore: "IGNORE";
  readonly Update: "UPDATE";
};
export type OutdatedInstancesStrategy =
  (typeof OutdatedInstancesStrategy)[keyof typeof OutdatedInstancesStrategy];
export declare const TriggerEventType: {
  readonly DEPLOYMENT_FAILURE: "DeploymentFailure";
  readonly DEPLOYMENT_READY: "DeploymentReady";
  readonly DEPLOYMENT_ROLLBACK: "DeploymentRollback";
  readonly DEPLOYMENT_START: "DeploymentStart";
  readonly DEPLOYMENT_STOP: "DeploymentStop";
  readonly DEPLOYMENT_SUCCESS: "DeploymentSuccess";
  readonly INSTANCE_FAILURE: "InstanceFailure";
  readonly INSTANCE_READY: "InstanceReady";
  readonly INSTANCE_START: "InstanceStart";
  readonly INSTANCE_SUCCESS: "InstanceSuccess";
};
export type TriggerEventType =
  (typeof TriggerEventType)[keyof typeof TriggerEventType];
export interface TriggerConfig {
  triggerName?: string;
  triggerTargetArn?: string;
  triggerEvents?: TriggerEventType[];
}
export interface DeploymentGroupInfo {
  applicationName?: string;
  deploymentGroupId?: string;
  deploymentGroupName?: string;
  deploymentConfigName?: string;
  ec2TagFilters?: EC2TagFilter[];
  onPremisesInstanceTagFilters?: TagFilter[];
  autoScalingGroups?: AutoScalingGroup[];
  serviceRoleArn?: string;
  targetRevision?: RevisionLocation;
  triggerConfigurations?: TriggerConfig[];
  alarmConfiguration?: AlarmConfiguration;
  autoRollbackConfiguration?: AutoRollbackConfiguration;
  deploymentStyle?: DeploymentStyle;
  outdatedInstancesStrategy?: OutdatedInstancesStrategy;
  blueGreenDeploymentConfiguration?: BlueGreenDeploymentConfiguration;
  loadBalancerInfo?: LoadBalancerInfo;
  lastSuccessfulDeployment?: LastDeploymentInfo;
  lastAttemptedDeployment?: LastDeploymentInfo;
  ec2TagSet?: EC2TagSet;
  onPremisesTagSet?: OnPremisesTagSet;
  computePlatform?: ComputePlatform;
  ecsServices?: ECSService[];
  terminationHookEnabled?: boolean;
}
export interface BatchGetDeploymentGroupsOutput {
  deploymentGroupsInfo?: DeploymentGroupInfo[];
  errorMessage?: string;
}
export declare class DeploymentConfigDoesNotExistException extends __BaseException {
  readonly name: "DeploymentConfigDoesNotExistException";
  readonly $fault: "client";
  constructor(
    opts: __ExceptionOptionType<
      DeploymentConfigDoesNotExistException,
      __BaseException
    >
  );
}
export declare class DeploymentGroupNameRequiredException extends __BaseException {
  readonly name: "DeploymentGroupNameRequiredException";
  readonly $fault: "client";
  constructor(
    opts: __ExceptionOptionType<
      DeploymentGroupNameRequiredException,
      __BaseException
    >
  );
}
export declare class InvalidDeploymentGroupNameException extends __BaseException {
  readonly name: "InvalidDeploymentGroupNameException";
  readonly $fault: "client";
  constructor(
    opts: __ExceptionOptionType<
      InvalidDeploymentGroupNameException,
      __BaseException
    >
  );
}
export interface BatchGetDeploymentInstancesInput {
  deploymentId: string | undefined;
  instanceIds: string[] | undefined;
}
export declare const _InstanceType: {
  readonly BLUE: "Blue";
  readonly GREEN: "Green";
};
export type _InstanceType = (typeof _InstanceType)[keyof typeof _InstanceType];
export declare const LifecycleErrorCode: {
  readonly SCRIPT_FAILED: "ScriptFailed";
  readonly SCRIPT_MISSING: "ScriptMissing";
  readonly SCRIPT_NOT_EXECUTABLE: "ScriptNotExecutable";
  readonly SCRIPT_TIMED_OUT: "ScriptTimedOut";
  readonly SUCCESS: "Success";
  readonly UNKNOWN_ERROR: "UnknownError";
};
export type LifecycleErrorCode =
  (typeof LifecycleErrorCode)[keyof typeof LifecycleErrorCode];
export interface Diagnostics {
  errorCode?: LifecycleErrorCode;
  scriptName?: string;
  message?: string;
  logTail?: string;
}
export declare const LifecycleEventStatus: {
  readonly FAILED: "Failed";
  readonly IN_PROGRESS: "InProgress";
  readonly PENDING: "Pending";
  readonly SKIPPED: "Skipped";
  readonly SUCCEEDED: "Succeeded";
  readonly UNKNOWN: "Unknown";
};
export type LifecycleEventStatus =
  (typeof LifecycleEventStatus)[keyof typeof LifecycleEventStatus];
export interface LifecycleEvent {
  lifecycleEventName?: string;
  diagnostics?: Diagnostics;
  startTime?: Date;
  endTime?: Date;
  status?: LifecycleEventStatus;
}
export declare const InstanceStatus: {
  readonly FAILED: "Failed";
  readonly IN_PROGRESS: "InProgress";
  readonly PENDING: "Pending";
  readonly READY: "Ready";
  readonly SKIPPED: "Skipped";
  readonly SUCCEEDED: "Succeeded";
  readonly UNKNOWN: "Unknown";
};
export type InstanceStatus =
  (typeof InstanceStatus)[keyof typeof InstanceStatus];
export interface InstanceSummary {
  deploymentId?: string;
  instanceId?: string;
  status?: InstanceStatus;
  lastUpdatedAt?: Date;
  lifecycleEvents?: LifecycleEvent[];
  instanceType?: _InstanceType;
}
export interface BatchGetDeploymentInstancesOutput {
  instancesSummary?: InstanceSummary[];
  errorMessage?: string;
}
export declare class DeploymentDoesNotExistException extends __BaseException {
  readonly name: "DeploymentDoesNotExistException";
  readonly $fault: "client";
  constructor(
    opts: __ExceptionOptionType<
      DeploymentDoesNotExistException,
      __BaseException
    >
  );
}
export declare class DeploymentIdRequiredException extends __BaseException {
  readonly name: "DeploymentIdRequiredException";
  readonly $fault: "client";
  constructor(
    opts: __ExceptionOptionType<DeploymentIdRequiredException, __BaseException>
  );
}
export declare class InstanceIdRequiredException extends __BaseException {
  readonly name: "InstanceIdRequiredException";
  readonly $fault: "client";
  constructor(
    opts: __ExceptionOptionType<InstanceIdRequiredException, __BaseException>
  );
}
export declare class InvalidComputePlatformException extends __BaseException {
  readonly name: "InvalidComputePlatformException";
  readonly $fault: "client";
  constructor(
    opts: __ExceptionOptionType<
      InvalidComputePlatformException,
      __BaseException
    >
  );
}
export declare class InvalidDeploymentIdException extends __BaseException {
  readonly name: "InvalidDeploymentIdException";
  readonly $fault: "client";
  constructor(
    opts: __ExceptionOptionType<InvalidDeploymentIdException, __BaseException>
  );
}
export interface BatchGetDeploymentsInput {
  deploymentIds: string[] | undefined;
}
export declare const DeploymentCreator: {
  readonly Autoscaling: "autoscaling";
  readonly AutoscalingTermination: "autoscalingTermination";
  readonly CloudFormation: "CloudFormation";
  readonly CloudFormationRollback: "CloudFormationRollback";
  readonly CodeDeploy: "CodeDeploy";
  readonly CodeDeployAutoUpdate: "CodeDeployAutoUpdate";
  readonly CodeDeployRollback: "codeDeployRollback";
  readonly User: "user";
};
export type DeploymentCreator =
  (typeof DeploymentCreator)[keyof typeof DeploymentCreator];
export interface DeploymentOverview {
  Pending?: number;
  InProgress?: number;
  Succeeded?: number;
  Failed?: number;
  Skipped?: number;
  Ready?: number;
}
export declare const ErrorCode: {
  readonly AGENT_ISSUE: "AGENT_ISSUE";
  readonly ALARM_ACTIVE: "ALARM_ACTIVE";
  readonly APPLICATION_MISSING: "APPLICATION_MISSING";
  readonly AUTOSCALING_VALIDATION_ERROR: "AUTOSCALING_VALIDATION_ERROR";
  readonly AUTO_SCALING_CONFIGURATION: "AUTO_SCALING_CONFIGURATION";
  readonly AUTO_SCALING_IAM_ROLE_PERMISSIONS: "AUTO_SCALING_IAM_ROLE_PERMISSIONS";
  readonly CLOUDFORMATION_STACK_FAILURE: "CLOUDFORMATION_STACK_FAILURE";
  readonly CODEDEPLOY_RESOURCE_CANNOT_BE_FOUND: "CODEDEPLOY_RESOURCE_CANNOT_BE_FOUND";
  readonly CUSTOMER_APPLICATION_UNHEALTHY: "CUSTOMER_APPLICATION_UNHEALTHY";
  readonly DEPLOYMENT_GROUP_MISSING: "DEPLOYMENT_GROUP_MISSING";
  readonly ECS_UPDATE_ERROR: "ECS_UPDATE_ERROR";
  readonly ELASTIC_LOAD_BALANCING_INVALID: "ELASTIC_LOAD_BALANCING_INVALID";
  readonly ELB_INVALID_INSTANCE: "ELB_INVALID_INSTANCE";
  readonly HEALTH_CONSTRAINTS: "HEALTH_CONSTRAINTS";
  readonly HEALTH_CONSTRAINTS_INVALID: "HEALTH_CONSTRAINTS_INVALID";
  readonly HOOK_EXECUTION_FAILURE: "HOOK_EXECUTION_FAILURE";
  readonly IAM_ROLE_MISSING: "IAM_ROLE_MISSING";
  readonly IAM_ROLE_PERMISSIONS: "IAM_ROLE_PERMISSIONS";
  readonly INTERNAL_ERROR: "INTERNAL_ERROR";
  readonly INVALID_ECS_SERVICE: "INVALID_ECS_SERVICE";
  readonly INVALID_LAMBDA_CONFIGURATION: "INVALID_LAMBDA_CONFIGURATION";
  readonly INVALID_LAMBDA_FUNCTION: "INVALID_LAMBDA_FUNCTION";
  readonly INVALID_REVISION: "INVALID_REVISION";
  readonly MANUAL_STOP: "MANUAL_STOP";
  readonly MISSING_BLUE_GREEN_DEPLOYMENT_CONFIGURATION: "MISSING_BLUE_GREEN_DEPLOYMENT_CONFIGURATION";
  readonly MISSING_ELB_INFORMATION: "MISSING_ELB_INFORMATION";
  readonly MISSING_GITHUB_TOKEN: "MISSING_GITHUB_TOKEN";
  readonly NO_EC2_SUBSCRIPTION: "NO_EC2_SUBSCRIPTION";
  readonly NO_INSTANCES: "NO_INSTANCES";
  readonly OVER_MAX_INSTANCES: "OVER_MAX_INSTANCES";
  readonly RESOURCE_LIMIT_EXCEEDED: "RESOURCE_LIMIT_EXCEEDED";
  readonly REVISION_MISSING: "REVISION_MISSING";
  readonly THROTTLED: "THROTTLED";
  readonly TIMEOUT: "TIMEOUT";
};
export type ErrorCode = (typeof ErrorCode)[keyof typeof ErrorCode];
export interface ErrorInformation {
  code?: ErrorCode;
  message?: string;
}
export declare const FileExistsBehavior: {
  readonly DISALLOW: "DISALLOW";
  readonly OVERWRITE: "OVERWRITE";
  readonly RETAIN: "RETAIN";
};
export type FileExistsBehavior =
  (typeof FileExistsBehavior)[keyof typeof FileExistsBehavior];
export interface RelatedDeployments {
  autoUpdateOutdatedInstancesRootDeploymentId?: string;
  autoUpdateOutdatedInstancesDeploymentIds?: string[];
}
export interface RollbackInfo {
  rollbackDeploymentId?: string;
  rollbackTriggeringDeploymentId?: string;
  rollbackMessage?: string;
}
export interface TargetInstances {
  tagFilters?: EC2TagFilter[];
  autoScalingGroups?: string[];
  ec2TagSet?: EC2TagSet;
}
export interface DeploymentInfo {
  applicationName?: string;
  deploymentGroupName?: string;
  deploymentConfigName?: string;
  deploymentId?: string;
  previousRevision?: RevisionLocation;
  revision?: RevisionLocation;
  status?: DeploymentStatus;
  errorInformation?: ErrorInformation;
  createTime?: Date;
  startTime?: Date;
  completeTime?: Date;
  deploymentOverview?: DeploymentOverview;
  description?: string;
  creator?: DeploymentCreator;
  ignoreApplicationStopFailures?: boolean;
  autoRollbackConfiguration?: AutoRollbackConfiguration;
  updateOutdatedInstancesOnly?: boolean;
  rollbackInfo?: RollbackInfo;
  deploymentStyle?: DeploymentStyle;
  targetInstances?: TargetInstances;
  instanceTerminationWaitTimeStarted?: boolean;
  blueGreenDeploymentConfiguration?: BlueGreenDeploymentConfiguration;
  loadBalancerInfo?: LoadBalancerInfo;
  additionalDeploymentStatusInfo?: string;
  fileExistsBehavior?: FileExistsBehavior;
  deploymentStatusMessages?: string[];
  computePlatform?: ComputePlatform;
  externalId?: string;
  relatedDeployments?: RelatedDeployments;
  overrideAlarmConfiguration?: AlarmConfiguration;
}
export interface BatchGetDeploymentsOutput {
  deploymentsInfo?: DeploymentInfo[];
}
export interface BatchGetDeploymentTargetsInput {
  deploymentId: string | undefined;
  targetIds: string[] | undefined;
}
export declare const TargetStatus: {
  readonly FAILED: "Failed";
  readonly IN_PROGRESS: "InProgress";
  readonly PENDING: "Pending";
  readonly READY: "Ready";
  readonly SKIPPED: "Skipped";
  readonly SUCCEEDED: "Succeeded";
  readonly UNKNOWN: "Unknown";
};
export type TargetStatus = (typeof TargetStatus)[keyof typeof TargetStatus];
export interface CloudFormationTarget {
  deploymentId?: string;
  targetId?: string;
  lastUpdatedAt?: Date;
  lifecycleEvents?: LifecycleEvent[];
  status?: TargetStatus;
  resourceType?: string;
  targetVersionWeight?: number;
}
export declare const DeploymentTargetType: {
  readonly CLOUDFORMATION_TARGET: "CloudFormationTarget";
  readonly ECS_TARGET: "ECSTarget";
  readonly INSTANCE_TARGET: "InstanceTarget";
  readonly LAMBDA_TARGET: "LambdaTarget";
};
export type DeploymentTargetType =
  (typeof DeploymentTargetType)[keyof typeof DeploymentTargetType];
export declare const TargetLabel: {
  readonly BLUE: "Blue";
  readonly GREEN: "Green";
};
export type TargetLabel = (typeof TargetLabel)[keyof typeof TargetLabel];
export interface ECSTaskSet {
  identifer?: string;
  desiredCount?: number;
  pendingCount?: number;
  runningCount?: number;
  status?: string;
  trafficWeight?: number;
  targetGroup?: TargetGroupInfo;
  taskSetLabel?: TargetLabel;
}
export interface ECSTarget {
  deploymentId?: string;
  targetId?: string;
  targetArn?: string;
  lastUpdatedAt?: Date;
  lifecycleEvents?: LifecycleEvent[];
  status?: TargetStatus;
  taskSetsInfo?: ECSTaskSet[];
}
export interface InstanceTarget {
  deploymentId?: string;
  targetId?: string;
  targetArn?: string;
  status?: TargetStatus;
  lastUpdatedAt?: Date;
  lifecycleEvents?: LifecycleEvent[];
  instanceLabel?: TargetLabel;
}
export interface LambdaFunctionInfo {
  functionName?: string;
  functionAlias?: string;
  currentVersion?: string;
  targetVersion?: string;
  targetVersionWeight?: number;
}
export interface LambdaTarget {
  deploymentId?: string;
  targetId?: string;
  targetArn?: string;
  status?: TargetStatus;
  lastUpdatedAt?: Date;
  lifecycleEvents?: LifecycleEvent[];
  lambdaFunctionInfo?: LambdaFunctionInfo;
}
export interface DeploymentTarget {
  deploymentTargetType?: DeploymentTargetType;
  instanceTarget?: InstanceTarget;
  lambdaTarget?: LambdaTarget;
  ecsTarget?: ECSTarget;
  cloudFormationTarget?: CloudFormationTarget;
}
export interface BatchGetDeploymentTargetsOutput {
  deploymentTargets?: DeploymentTarget[];
}
export declare class DeploymentNotStartedException extends __BaseException {
  readonly name: "DeploymentNotStartedException";
  readonly $fault: "client";
  constructor(
    opts: __ExceptionOptionType<DeploymentNotStartedException, __BaseException>
  );
}
export declare class DeploymentTargetDoesNotExistException extends __BaseException {
  readonly name: "DeploymentTargetDoesNotExistException";
  readonly $fault: "client";
  constructor(
    opts: __ExceptionOptionType<
      DeploymentTargetDoesNotExistException,
      __BaseException
    >
  );
}
export declare class DeploymentTargetIdRequiredException extends __BaseException {
  readonly name: "DeploymentTargetIdRequiredException";
  readonly $fault: "client";
  constructor(
    opts: __ExceptionOptionType<
      DeploymentTargetIdRequiredException,
      __BaseException
    >
  );
}
export declare class DeploymentTargetListSizeExceededException extends __BaseException {
  readonly name: "DeploymentTargetListSizeExceededException";
  readonly $fault: "client";
  constructor(
    opts: __ExceptionOptionType<
      DeploymentTargetListSizeExceededException,
      __BaseException
    >
  );
}
export declare class InstanceDoesNotExistException extends __BaseException {
  readonly name: "InstanceDoesNotExistException";
  readonly $fault: "client";
  constructor(
    opts: __ExceptionOptionType<InstanceDoesNotExistException, __BaseException>
  );
}
export declare class InvalidDeploymentTargetIdException extends __BaseException {
  readonly name: "InvalidDeploymentTargetIdException";
  readonly $fault: "client";
  constructor(
    opts: __ExceptionOptionType<
      InvalidDeploymentTargetIdException,
      __BaseException
    >
  );
}
export interface BatchGetOnPremisesInstancesInput {
  instanceNames: string[] | undefined;
}
export interface InstanceInfo {
  instanceName?: string;
  iamSessionArn?: string;
  iamUserArn?: string;
  instanceArn?: string;
  registerTime?: Date;
  deregisterTime?: Date;
  tags?: Tag[];
}
export interface BatchGetOnPremisesInstancesOutput {
  instanceInfos?: InstanceInfo[];
}
export declare class BucketNameFilterRequiredException extends __BaseException {
  readonly name: "BucketNameFilterRequiredException";
  readonly $fault: "client";
  constructor(
    opts: __ExceptionOptionType<
      BucketNameFilterRequiredException,
      __BaseException
    >
  );
}
export declare const DeploymentWaitType: {
  readonly READY_WAIT: "READY_WAIT";
  readonly TERMINATION_WAIT: "TERMINATION_WAIT";
};
export type DeploymentWaitType =
  (typeof DeploymentWaitType)[keyof typeof DeploymentWaitType];
export interface ContinueDeploymentInput {
  deploymentId?: string;
  deploymentWaitType?: DeploymentWaitType;
}
export declare class DeploymentAlreadyCompletedException extends __BaseException {
  readonly name: "DeploymentAlreadyCompletedException";
  readonly $fault: "client";
  constructor(
    opts: __ExceptionOptionType<
      DeploymentAlreadyCompletedException,
      __BaseException
    >
  );
}
export declare class DeploymentIsNotInReadyStateException extends __BaseException {
  readonly name: "DeploymentIsNotInReadyStateException";
  readonly $fault: "client";
  constructor(
    opts: __ExceptionOptionType<
      DeploymentIsNotInReadyStateException,
      __BaseException
    >
  );
}
export declare class InvalidDeploymentStatusException extends __BaseException {
  readonly name: "InvalidDeploymentStatusException";
  readonly $fault: "client";
  constructor(
    opts: __ExceptionOptionType<
      InvalidDeploymentStatusException,
      __BaseException
    >
  );
}
export declare class InvalidDeploymentWaitTypeException extends __BaseException {
  readonly name: "InvalidDeploymentWaitTypeException";
  readonly $fault: "client";
  constructor(
    opts: __ExceptionOptionType<
      InvalidDeploymentWaitTypeException,
      __BaseException
    >
  );
}
export declare class UnsupportedActionForDeploymentTypeException extends __BaseException {
  readonly name: "UnsupportedActionForDeploymentTypeException";
  readonly $fault: "client";
  constructor(
    opts: __ExceptionOptionType<
      UnsupportedActionForDeploymentTypeException,
      __BaseException
    >
  );
}
export interface CreateApplicationInput {
  applicationName: string | undefined;
  computePlatform?: ComputePlatform;
  tags?: Tag[];
}
export interface CreateApplicationOutput {
  applicationId?: string;
}
export declare class InvalidTagsToAddException extends __BaseException {
  readonly name: "InvalidTagsToAddException";
  readonly $fault: "client";
  constructor(
    opts: __ExceptionOptionType<InvalidTagsToAddException, __BaseException>
  );
}
export interface CreateDeploymentInput {
  applicationName: string | undefined;
  deploymentGroupName?: string;
  revision?: RevisionLocation;
  deploymentConfigName?: string;
  description?: string;
  ignoreApplicationStopFailures?: boolean;
  targetInstances?: TargetInstances;
  autoRollbackConfiguration?: AutoRollbackConfiguration;
  updateOutdatedInstancesOnly?: boolean;
  fileExistsBehavior?: FileExistsBehavior;
  overrideAlarmConfiguration?: AlarmConfiguration;
}
export interface CreateDeploymentOutput {
  deploymentId?: string;
}
export declare class DeploymentGroupDoesNotExistException extends __BaseException {
  readonly name: "DeploymentGroupDoesNotExistException";
  readonly $fault: "client";
  constructor(
    opts: __ExceptionOptionType<
      DeploymentGroupDoesNotExistException,
      __BaseException
    >
  );
}
export declare class DeploymentLimitExceededException extends __BaseException {
  readonly name: "DeploymentLimitExceededException";
  readonly $fault: "client";
  constructor(
    opts: __ExceptionOptionType<
      DeploymentLimitExceededException,
      __BaseException
    >
  );
}
export declare class DescriptionTooLongException extends __BaseException {
  readonly name: "DescriptionTooLongException";
  readonly $fault: "client";
  constructor(
    opts: __ExceptionOptionType<DescriptionTooLongException, __BaseException>
  );
}
export declare class InvalidAlarmConfigException extends __BaseException {
  readonly name: "InvalidAlarmConfigException";
  readonly $fault: "client";
  constructor(
    opts: __ExceptionOptionType<InvalidAlarmConfigException, __BaseException>
  );
}
export declare class InvalidAutoRollbackConfigException extends __BaseException {
  readonly name: "InvalidAutoRollbackConfigException";
  readonly $fault: "client";
  constructor(
    opts: __ExceptionOptionType<
      InvalidAutoRollbackConfigException,
      __BaseException
    >
  );
}
export declare class InvalidAutoScalingGroupException extends __BaseException {
  readonly name: "InvalidAutoScalingGroupException";
  readonly $fault: "client";
  constructor(
    opts: __ExceptionOptionType<
      InvalidAutoScalingGroupException,
      __BaseException
    >
  );
}
export declare class InvalidDeploymentConfigNameException extends __BaseException {
  readonly name: "InvalidDeploymentConfigNameException";
  readonly $fault: "client";
  constructor(
    opts: __ExceptionOptionType<
      InvalidDeploymentConfigNameException,
      __BaseException
    >
  );
}
export declare class InvalidFileExistsBehaviorException extends __BaseException {
  readonly name: "InvalidFileExistsBehaviorException";
  readonly $fault: "client";
  constructor(
    opts: __ExceptionOptionType<
      InvalidFileExistsBehaviorException,
      __BaseException
    >
  );
}
export declare class InvalidGitHubAccountTokenException extends __BaseException {
  readonly name: "InvalidGitHubAccountTokenException";
  readonly $fault: "client";
  constructor(
    opts: __ExceptionOptionType<
      InvalidGitHubAccountTokenException,
      __BaseException
    >
  );
}
export declare class InvalidIgnoreApplicationStopFailuresValueException extends __BaseException {
  readonly name: "InvalidIgnoreApplicationStopFailuresValueException";
  readonly $fault: "client";
  constructor(
    opts: __ExceptionOptionType<
      InvalidIgnoreApplicationStopFailuresValueException,
      __BaseException
    >
  );
}
export declare class InvalidLoadBalancerInfoException extends __BaseException {
  readonly name: "InvalidLoadBalancerInfoException";
  readonly $fault: "client";
  constructor(
    opts: __ExceptionOptionType<
      InvalidLoadBalancerInfoException,
      __BaseException
    >
  );
}
export declare class InvalidRoleException extends __BaseException {
  readonly name: "InvalidRoleException";
  readonly $fault: "client";
  constructor(
    opts: __ExceptionOptionType<InvalidRoleException, __BaseException>
  );
}
export declare class InvalidTargetInstancesException extends __BaseException {
  readonly name: "InvalidTargetInstancesException";
  readonly $fault: "client";
  constructor(
    opts: __ExceptionOptionType<
      InvalidTargetInstancesException,
      __BaseException
    >
  );
}
export declare class InvalidTrafficRoutingConfigurationException extends __BaseException {
  readonly name: "InvalidTrafficRoutingConfigurationException";
  readonly $fault: "client";
  constructor(
    opts: __ExceptionOptionType<
      InvalidTrafficRoutingConfigurationException,
      __BaseException
    >
  );
}
export declare class InvalidUpdateOutdatedInstancesOnlyValueException extends __BaseException {
  readonly name: "InvalidUpdateOutdatedInstancesOnlyValueException";
  readonly $fault: "client";
  constructor(
    opts: __ExceptionOptionType<
      InvalidUpdateOutdatedInstancesOnlyValueException,
      __BaseException
    >
  );
}
export declare class RevisionDoesNotExistException extends __BaseException {
  readonly name: "RevisionDoesNotExistException";
  readonly $fault: "client";
  constructor(
    opts: __ExceptionOptionType<RevisionDoesNotExistException, __BaseException>
  );
}
export declare class ThrottlingException extends __BaseException {
  readonly name: "ThrottlingException";
  readonly $fault: "client";
  constructor(
    opts: __ExceptionOptionType<ThrottlingException, __BaseException>
  );
}
export declare const MinimumHealthyHostsType: {
  readonly FLEET_PERCENT: "FLEET_PERCENT";
  readonly HOST_COUNT: "HOST_COUNT";
};
export type MinimumHealthyHostsType =
  (typeof MinimumHealthyHostsType)[keyof typeof MinimumHealthyHostsType];
export interface MinimumHealthyHosts {
  type?: MinimumHealthyHostsType;
  value?: number;
}
export interface TimeBasedCanary {
  canaryPercentage?: number;
  canaryInterval?: number;
}
export interface TimeBasedLinear {
  linearPercentage?: number;
  linearInterval?: number;
}
export declare const TrafficRoutingType: {
  readonly AllAtOnce: "AllAtOnce";
  readonly TimeBasedCanary: "TimeBasedCanary";
  readonly TimeBasedLinear: "TimeBasedLinear";
};
export type TrafficRoutingType =
  (typeof TrafficRoutingType)[keyof typeof TrafficRoutingType];
export interface TrafficRoutingConfig {
  type?: TrafficRoutingType;
  timeBasedCanary?: TimeBasedCanary;
  timeBasedLinear?: TimeBasedLinear;
}
export declare const MinimumHealthyHostsPerZoneType: {
  readonly FLEET_PERCENT: "FLEET_PERCENT";
  readonly HOST_COUNT: "HOST_COUNT";
};
export type MinimumHealthyHostsPerZoneType =
  (typeof MinimumHealthyHostsPerZoneType)[keyof typeof MinimumHealthyHostsPerZoneType];
export interface MinimumHealthyHostsPerZone {
  type?: MinimumHealthyHostsPerZoneType;
  value?: number;
}
export interface ZonalConfig {
  firstZoneMonitorDurationInSeconds?: number;
  monitorDurationInSeconds?: number;
  minimumHealthyHostsPerZone?: MinimumHealthyHostsPerZone;
}
export interface CreateDeploymentConfigInput {
  deploymentConfigName: string | undefined;
  minimumHealthyHosts?: MinimumHealthyHosts;
  trafficRoutingConfig?: TrafficRoutingConfig;
  computePlatform?: ComputePlatform;
  zonalConfig?: ZonalConfig;
}
export interface CreateDeploymentConfigOutput {
  deploymentConfigId?: string;
}
export declare class DeploymentConfigAlreadyExistsException extends __BaseException {
  readonly name: "DeploymentConfigAlreadyExistsException";
  readonly $fault: "client";
  constructor(
    opts: __ExceptionOptionType<
      DeploymentConfigAlreadyExistsException,
      __BaseException
    >
  );
}
export declare class DeploymentConfigLimitExceededException extends __BaseException {
  readonly name: "DeploymentConfigLimitExceededException";
  readonly $fault: "client";
  constructor(
    opts: __ExceptionOptionType<
      DeploymentConfigLimitExceededException,
      __BaseException
    >
  );
}
export declare class DeploymentConfigNameRequiredException extends __BaseException {
  readonly name: "DeploymentConfigNameRequiredException";
  readonly $fault: "client";
  constructor(
    opts: __ExceptionOptionType<
      DeploymentConfigNameRequiredException,
      __BaseException
    >
  );
}
export declare class InvalidMinimumHealthyHostValueException extends __BaseException {
  readonly name: "InvalidMinimumHealthyHostValueException";
  readonly $fault: "client";
  constructor(
    opts: __ExceptionOptionType<
      InvalidMinimumHealthyHostValueException,
      __BaseException
    >
  );
}
export declare class InvalidZonalDeploymentConfigurationException extends __BaseException {
  readonly name: "InvalidZonalDeploymentConfigurationException";
  readonly $fault: "client";
  constructor(
    opts: __ExceptionOptionType<
      InvalidZonalDeploymentConfigurationException,
      __BaseException
    >
  );
}
export interface CreateDeploymentGroupInput {
  applicationName: string | undefined;
  deploymentGroupName: string | undefined;
  deploymentConfigName?: string;
  ec2TagFilters?: EC2TagFilter[];
  onPremisesInstanceTagFilters?: TagFilter[];
  autoScalingGroups?: string[];
  serviceRoleArn: string | undefined;
  triggerConfigurations?: TriggerConfig[];
  alarmConfiguration?: AlarmConfiguration;
  autoRollbackConfiguration?: AutoRollbackConfiguration;
  outdatedInstancesStrategy?: OutdatedInstancesStrategy;
  deploymentStyle?: DeploymentStyle;
  blueGreenDeploymentConfiguration?: BlueGreenDeploymentConfiguration;
  loadBalancerInfo?: LoadBalancerInfo;
  ec2TagSet?: EC2TagSet;
  ecsServices?: ECSService[];
  onPremisesTagSet?: OnPremisesTagSet;
  tags?: Tag[];
  terminationHookEnabled?: boolean;
}
export interface CreateDeploymentGroupOutput {
  deploymentGroupId?: string;
}
export declare class DeploymentGroupAlreadyExistsException extends __BaseException {
  readonly name: "DeploymentGroupAlreadyExistsException";
  readonly $fault: "client";
  constructor(
    opts: __ExceptionOptionType<
      DeploymentGroupAlreadyExistsException,
      __BaseException
    >
  );
}
export declare class DeploymentGroupLimitExceededException extends __BaseException {
  readonly name: "DeploymentGroupLimitExceededException";
  readonly $fault: "client";
  constructor(
    opts: __ExceptionOptionType<
      DeploymentGroupLimitExceededException,
      __BaseException
    >
  );
}
export declare class ECSServiceMappingLimitExceededException extends __BaseException {
  readonly name: "ECSServiceMappingLimitExceededException";
  readonly $fault: "client";
  constructor(
    opts: __ExceptionOptionType<
      ECSServiceMappingLimitExceededException,
      __BaseException
    >
  );
}
export declare class InvalidBlueGreenDeploymentConfigurationException extends __BaseException {
  readonly name: "InvalidBlueGreenDeploymentConfigurationException";
  readonly $fault: "client";
  constructor(
    opts: __ExceptionOptionType<
      InvalidBlueGreenDeploymentConfigurationException,
      __BaseException
    >
  );
}
export declare class InvalidDeploymentStyleException extends __BaseException {
  readonly name: "InvalidDeploymentStyleException";
  readonly $fault: "client";
  constructor(
    opts: __ExceptionOptionType<
      InvalidDeploymentStyleException,
      __BaseException
    >
  );
}
export declare class InvalidEC2TagCombinationException extends __BaseException {
  readonly name: "InvalidEC2TagCombinationException";
  readonly $fault: "client";
  constructor(
    opts: __ExceptionOptionType<
      InvalidEC2TagCombinationException,
      __BaseException
    >
  );
}
export declare class InvalidEC2TagException extends __BaseException {
  readonly name: "InvalidEC2TagException";
  readonly $fault: "client";
  constructor(
    opts: __ExceptionOptionType<InvalidEC2TagException, __BaseException>
  );
}
export declare class InvalidECSServiceException extends __BaseException {
  readonly name: "InvalidECSServiceException";
  readonly $fault: "client";
  constructor(
    opts: __ExceptionOptionType<InvalidECSServiceException, __BaseException>
  );
}
export declare class InvalidInputException extends __BaseException {
  readonly name: "InvalidInputException";
  readonly $fault: "client";
  constructor(
    opts: __ExceptionOptionType<InvalidInputException, __BaseException>
  );
}
export declare class InvalidOnPremisesTagCombinationException extends __BaseException {
  readonly name: "InvalidOnPremisesTagCombinationException";
  readonly $fault: "client";
  constructor(
    opts: __ExceptionOptionType<
      InvalidOnPremisesTagCombinationException,
      __BaseException
    >
  );
}
export declare class InvalidTargetGroupPairException extends __BaseException {
  readonly name: "InvalidTargetGroupPairException";
  readonly $fault: "client";
  constructor(
    opts: __ExceptionOptionType<
      InvalidTargetGroupPairException,
      __BaseException
    >
  );
}
export declare class InvalidTriggerConfigException extends __BaseException {
  readonly name: "InvalidTriggerConfigException";
  readonly $fault: "client";
  constructor(
    opts: __ExceptionOptionType<InvalidTriggerConfigException, __BaseException>
  );
}
export declare class LifecycleHookLimitExceededException extends __BaseException {
  readonly name: "LifecycleHookLimitExceededException";
  readonly $fault: "client";
  constructor(
    opts: __ExceptionOptionType<
      LifecycleHookLimitExceededException,
      __BaseException
    >
  );
}
export declare class RoleRequiredException extends __BaseException {
  readonly name: "RoleRequiredException";
  readonly $fault: "client";
  constructor(
    opts: __ExceptionOptionType<RoleRequiredException, __BaseException>
  );
}
export declare class TagSetListLimitExceededException extends __BaseException {
  readonly name: "TagSetListLimitExceededException";
  readonly $fault: "client";
  constructor(
    opts: __ExceptionOptionType<
      TagSetListLimitExceededException,
      __BaseException
    >
  );
}
export declare class TriggerTargetsLimitExceededException extends __BaseException {
  readonly name: "TriggerTargetsLimitExceededException";
  readonly $fault: "client";
  constructor(
    opts: __ExceptionOptionType<
      TriggerTargetsLimitExceededException,
      __BaseException
    >
  );
}
export interface DeleteApplicationInput {
  applicationName: string | undefined;
}
export interface DeleteDeploymentConfigInput {
  deploymentConfigName: string | undefined;
}
export declare class DeploymentConfigInUseException extends __BaseException {
  readonly name: "DeploymentConfigInUseException";
  readonly $fault: "client";
  constructor(
    opts: __ExceptionOptionType<DeploymentConfigInUseException, __BaseException>
  );
}
export declare class InvalidOperationException extends __BaseException {
  readonly name: "InvalidOperationException";
  readonly $fault: "client";
  constructor(
    opts: __ExceptionOptionType<InvalidOperationException, __BaseException>
  );
}
export interface DeleteDeploymentGroupInput {
  applicationName: string | undefined;
  deploymentGroupName: string | undefined;
}
export interface DeleteDeploymentGroupOutput {
  hooksNotCleanedUp?: AutoScalingGroup[];
}
export interface DeleteGitHubAccountTokenInput {
  tokenName?: string;
}
export interface DeleteGitHubAccountTokenOutput {
  tokenName?: string;
}
export declare class GitHubAccountTokenDoesNotExistException extends __BaseException {
  readonly name: "GitHubAccountTokenDoesNotExistException";
  readonly $fault: "client";
  constructor(
    opts: __ExceptionOptionType<
      GitHubAccountTokenDoesNotExistException,
      __BaseException
    >
  );
}
export declare class GitHubAccountTokenNameRequiredException extends __BaseException {
  readonly name: "GitHubAccountTokenNameRequiredException";
  readonly $fault: "client";
  constructor(
    opts: __ExceptionOptionType<
      GitHubAccountTokenNameRequiredException,
      __BaseException
    >
  );
}
export declare class InvalidGitHubAccountTokenNameException extends __BaseException {
  readonly name: "InvalidGitHubAccountTokenNameException";
  readonly $fault: "client";
  constructor(
    opts: __ExceptionOptionType<
      InvalidGitHubAccountTokenNameException,
      __BaseException
    >
  );
}
export declare class OperationNotSupportedException extends __BaseException {
  readonly name: "OperationNotSupportedException";
  readonly $fault: "client";
  constructor(
    opts: __ExceptionOptionType<OperationNotSupportedException, __BaseException>
  );
}
export declare class ResourceValidationException extends __BaseException {
  readonly name: "ResourceValidationException";
  readonly $fault: "client";
  constructor(
    opts: __ExceptionOptionType<ResourceValidationException, __BaseException>
  );
}
export interface DeleteResourcesByExternalIdInput {
  externalId?: string;
}
export interface DeleteResourcesByExternalIdOutput {}
export interface DeregisterOnPremisesInstanceInput {
  instanceName: string | undefined;
}
export interface GetApplicationInput {
  applicationName: string | undefined;
}
export interface GetApplicationOutput {
  application?: ApplicationInfo;
}
export interface GetApplicationRevisionInput {
  applicationName: string | undefined;
  revision: RevisionLocation | undefined;
}
export interface GetApplicationRevisionOutput {
  applicationName?: string;
  revision?: RevisionLocation;
  revisionInfo?: GenericRevisionInfo;
}
export interface GetDeploymentInput {
  deploymentId: string | undefined;
}
export interface GetDeploymentOutput {
  deploymentInfo?: DeploymentInfo;
}
export interface GetDeploymentConfigInput {
  deploymentConfigName: string | undefined;
}
export interface DeploymentConfigInfo {
  deploymentConfigId?: string;
  deploymentConfigName?: string;
  minimumHealthyHosts?: MinimumHealthyHosts;
  createTime?: Date;
  computePlatform?: ComputePlatform;
  trafficRoutingConfig?: TrafficRoutingConfig;
  zonalConfig?: ZonalConfig;
}
export interface GetDeploymentConfigOutput {
  deploymentConfigInfo?: DeploymentConfigInfo;
}
export interface GetDeploymentGroupInput {
  applicationName: string | undefined;
  deploymentGroupName: string | undefined;
}
export interface GetDeploymentGroupOutput {
  deploymentGroupInfo?: DeploymentGroupInfo;
}
export interface GetDeploymentInstanceInput {
  deploymentId: string | undefined;
  instanceId: string | undefined;
}
export interface GetDeploymentInstanceOutput {
  instanceSummary?: InstanceSummary;
}
export interface GetDeploymentTargetInput {
  deploymentId: string | undefined;
  targetId: string | undefined;
}
export interface GetDeploymentTargetOutput {
  deploymentTarget?: DeploymentTarget;
}
export interface GetOnPremisesInstanceInput {
  instanceName: string | undefined;
}
export interface GetOnPremisesInstanceOutput {
  instanceInfo?: InstanceInfo;
}
export declare class InvalidBucketNameFilterException extends __BaseException {
  readonly name: "InvalidBucketNameFilterException";
  readonly $fault: "client";
  constructor(
    opts: __ExceptionOptionType<
      InvalidBucketNameFilterException,
      __BaseException
    >
  );
}
export declare class InvalidDeployedStateFilterException extends __BaseException {
  readonly name: "InvalidDeployedStateFilterException";
  readonly $fault: "client";
  constructor(
    opts: __ExceptionOptionType<
      InvalidDeployedStateFilterException,
      __BaseException
    >
  );
}
export declare class InvalidKeyPrefixFilterException extends __BaseException {
  readonly name: "InvalidKeyPrefixFilterException";
  readonly $fault: "client";
  constructor(
    opts: __ExceptionOptionType<
      InvalidKeyPrefixFilterException,
      __BaseException
    >
  );
}
export declare class InvalidNextTokenException extends __BaseException {
  readonly name: "InvalidNextTokenException";
  readonly $fault: "client";
  constructor(
    opts: __ExceptionOptionType<InvalidNextTokenException, __BaseException>
  );
}
export declare class InvalidSortByException extends __BaseException {
  readonly name: "InvalidSortByException";
  readonly $fault: "client";
  constructor(
    opts: __ExceptionOptionType<InvalidSortByException, __BaseException>
  );
}
export declare class InvalidSortOrderException extends __BaseException {
  readonly name: "InvalidSortOrderException";
  readonly $fault: "client";
  constructor(
    opts: __ExceptionOptionType<InvalidSortOrderException, __BaseException>
  );
}
export declare const ListStateFilterAction: {
  readonly Exclude: "exclude";
  readonly Ignore: "ignore";
  readonly Include: "include";
};
export type ListStateFilterAction =
  (typeof ListStateFilterAction)[keyof typeof ListStateFilterAction];
export declare const SortOrder: {
  readonly Ascending: "ascending";
  readonly Descending: "descending";
};
export type SortOrder = (typeof SortOrder)[keyof typeof SortOrder];
export interface ListApplicationRevisionsInput {
  applicationName: string | undefined;
  sortBy?: ApplicationRevisionSortBy;
  sortOrder?: SortOrder;
  s3Bucket?: string;
  s3KeyPrefix?: string;
  deployed?: ListStateFilterAction;
  nextToken?: string;
}
export interface ListApplicationRevisionsOutput {
  revisions?: RevisionLocation[];
  nextToken?: string;
}
export interface ListApplicationsInput {
  nextToken?: string;
}
export interface ListApplicationsOutput {
  applications?: string[];
  nextToken?: string;
}
export interface ListDeploymentConfigsInput {
  nextToken?: string;
}
export interface ListDeploymentConfigsOutput {
  deploymentConfigsList?: string[];
  nextToken?: string;
}
export interface ListDeploymentGroupsInput {
  applicationName: string | undefined;
  nextToken?: string;
}
export interface ListDeploymentGroupsOutput {
  applicationName?: string;
  deploymentGroups?: string[];
  nextToken?: string;
}
export declare class InvalidDeploymentInstanceTypeException extends __BaseException {
  readonly name: "InvalidDeploymentInstanceTypeException";
  readonly $fault: "client";
  constructor(
    opts: __ExceptionOptionType<
      InvalidDeploymentInstanceTypeException,
      __BaseException
    >
  );
}
export declare class InvalidInstanceStatusException extends __BaseException {
  readonly name: "InvalidInstanceStatusException";
  readonly $fault: "client";
  constructor(
    opts: __ExceptionOptionType<InvalidInstanceStatusException, __BaseException>
  );
}
export declare class InvalidInstanceTypeException extends __BaseException {
  readonly name: "InvalidInstanceTypeException";
  readonly $fault: "client";
  constructor(
    opts: __ExceptionOptionType<InvalidInstanceTypeException, __BaseException>
  );
}
export declare class InvalidTargetFilterNameException extends __BaseException {
  readonly name: "InvalidTargetFilterNameException";
  readonly $fault: "client";
  constructor(
    opts: __ExceptionOptionType<
      InvalidTargetFilterNameException,
      __BaseException
    >
  );
}
export interface ListDeploymentInstancesInput {
  deploymentId: string | undefined;
  nextToken?: string;
  instanceStatusFilter?: InstanceStatus[];
  instanceTypeFilter?: _InstanceType[];
}
export interface ListDeploymentInstancesOutput {
  instancesList?: string[];
  nextToken?: string;
}
export declare class InvalidExternalIdException extends __BaseException {
  readonly name: "InvalidExternalIdException";
  readonly $fault: "client";
  constructor(
    opts: __ExceptionOptionType<InvalidExternalIdException, __BaseException>
  );
}
export declare class InvalidTimeRangeException extends __BaseException {
  readonly name: "InvalidTimeRangeException";
  readonly $fault: "client";
  constructor(
    opts: __ExceptionOptionType<InvalidTimeRangeException, __BaseException>
  );
}
export interface TimeRange {
  start?: Date;
  end?: Date;
}
export interface ListDeploymentsInput {
  applicationName?: string;
  deploymentGroupName?: string;
  externalId?: string;
  includeOnlyStatuses?: DeploymentStatus[];
  createTimeRange?: TimeRange;
  nextToken?: string;
}
export interface ListDeploymentsOutput {
  deployments?: string[];
  nextToken?: string;
}
export declare const TargetFilterName: {
  readonly SERVER_INSTANCE_LABEL: "ServerInstanceLabel";
  readonly TARGET_STATUS: "TargetStatus";
};
export type TargetFilterName =
  (typeof TargetFilterName)[keyof typeof TargetFilterName];
export interface ListDeploymentTargetsInput {
  deploymentId: string | undefined;
  nextToken?: string;
  targetFilters?: Partial<Record<TargetFilterName, string[]>>;
}
export interface ListDeploymentTargetsOutput {
  targetIds?: string[];
  nextToken?: string;
}
export interface ListGitHubAccountTokenNamesInput {
  nextToken?: string;
}
export interface ListGitHubAccountTokenNamesOutput {
  tokenNameList?: string[];
  nextToken?: string;
}
export declare class InvalidRegistrationStatusException extends __BaseException {
  readonly name: "InvalidRegistrationStatusException";
  readonly $fault: "client";
  constructor(
    opts: __ExceptionOptionType<
      InvalidRegistrationStatusException,
      __BaseException
    >
  );
}
export declare class InvalidTagFilterException extends __BaseException {
  readonly name: "InvalidTagFilterException";
  readonly $fault: "client";
  constructor(
    opts: __ExceptionOptionType<InvalidTagFilterException, __BaseException>
  );
}
export declare const RegistrationStatus: {
  readonly Deregistered: "Deregistered";
  readonly Registered: "Registered";
};
export type RegistrationStatus =
  (typeof RegistrationStatus)[keyof typeof RegistrationStatus];
export interface ListOnPremisesInstancesInput {
  registrationStatus?: RegistrationStatus;
  tagFilters?: TagFilter[];
  nextToken?: string;
}
export interface ListOnPremisesInstancesOutput {
  instanceNames?: string[];
  nextToken?: string;
}
export declare class InvalidArnException extends __BaseException {
  readonly name: "InvalidArnException";
  readonly $fault: "client";
  constructor(
    opts: __ExceptionOptionType<InvalidArnException, __BaseException>
  );
}
export interface ListTagsForResourceInput {
  ResourceArn: string | undefined;
  NextToken?: string;
}
export interface ListTagsForResourceOutput {
  Tags?: Tag[];
  NextToken?: string;
}
export declare class ResourceArnRequiredException extends __BaseException {
  readonly name: "ResourceArnRequiredException";
  readonly $fault: "client";
  constructor(
    opts: __ExceptionOptionType<ResourceArnRequiredException, __BaseException>
  );
}
export declare class InvalidLifecycleEventHookExecutionIdException extends __BaseException {
  readonly name: "InvalidLifecycleEventHookExecutionIdException";
  readonly $fault: "client";
  constructor(
    opts: __ExceptionOptionType<
      InvalidLifecycleEventHookExecutionIdException,
      __BaseException
    >
  );
}
export declare class InvalidLifecycleEventHookExecutionStatusException extends __BaseException {
  readonly name: "InvalidLifecycleEventHookExecutionStatusException";
  readonly $fault: "client";
  constructor(
    opts: __ExceptionOptionType<
      InvalidLifecycleEventHookExecutionStatusException,
      __BaseException
    >
  );
}
export declare class LifecycleEventAlreadyCompletedException extends __BaseException {
  readonly name: "LifecycleEventAlreadyCompletedException";
  readonly $fault: "client";
  constructor(
    opts: __ExceptionOptionType<
      LifecycleEventAlreadyCompletedException,
      __BaseException
    >
  );
}
export interface PutLifecycleEventHookExecutionStatusInput {
  deploymentId?: string;
  lifecycleEventHookExecutionId?: string;
  status?: LifecycleEventStatus;
}
export interface PutLifecycleEventHookExecutionStatusOutput {
  lifecycleEventHookExecutionId?: string;
}
export interface RegisterApplicationRevisionInput {
  applicationName: string | undefined;
  description?: string;
  revision: RevisionLocation | undefined;
}
export declare class IamArnRequiredException extends __BaseException {
  readonly name: "IamArnRequiredException";
  readonly $fault: "client";
  constructor(
    opts: __ExceptionOptionType<IamArnRequiredException, __BaseException>
  );
}
export declare class IamSessionArnAlreadyRegisteredException extends __BaseException {
  readonly name: "IamSessionArnAlreadyRegisteredException";
  readonly $fault: "client";
  constructor(
    opts: __ExceptionOptionType<
      IamSessionArnAlreadyRegisteredException,
      __BaseException
    >
  );
}
export declare class IamUserArnAlreadyRegisteredException extends __BaseException {
  readonly name: "IamUserArnAlreadyRegisteredException";
  readonly $fault: "client";
  constructor(
    opts: __ExceptionOptionType<
      IamUserArnAlreadyRegisteredException,
      __BaseException
    >
  );
}
export declare class IamUserArnRequiredException extends __BaseException {
  readonly name: "IamUserArnRequiredException";
  readonly $fault: "client";
  constructor(
    opts: __ExceptionOptionType<IamUserArnRequiredException, __BaseException>
  );
}
export declare class InstanceNameAlreadyRegisteredException extends __BaseException {
  readonly name: "InstanceNameAlreadyRegisteredException";
  readonly $fault: "client";
  constructor(
    opts: __ExceptionOptionType<
      InstanceNameAlreadyRegisteredException,
      __BaseException
    >
  );
}
export declare class InvalidIamSessionArnException extends __BaseException {
  readonly name: "InvalidIamSessionArnException";
  readonly $fault: "client";
  constructor(
    opts: __ExceptionOptionType<InvalidIamSessionArnException, __BaseException>
  );
}
export declare class InvalidIamUserArnException extends __BaseException {
  readonly name: "InvalidIamUserArnException";
  readonly $fault: "client";
  constructor(
    opts: __ExceptionOptionType<InvalidIamUserArnException, __BaseException>
  );
}
export declare class MultipleIamArnsProvidedException extends __BaseException {
  readonly name: "MultipleIamArnsProvidedException";
  readonly $fault: "client";
  constructor(
    opts: __ExceptionOptionType<
      MultipleIamArnsProvidedException,
      __BaseException
    >
  );
}
export interface RegisterOnPremisesInstanceInput {
  instanceName: string | undefined;
  iamSessionArn?: string;
  iamUserArn?: string;
}
export interface RemoveTagsFromOnPremisesInstancesInput {
  tags: Tag[] | undefined;
  instanceNames: string[] | undefined;
}
export interface SkipWaitTimeForInstanceTerminationInput {
  deploymentId?: string;
}
export interface StopDeploymentInput {
  deploymentId: string | undefined;
  autoRollbackEnabled?: boolean;
}
export declare const StopStatus: {
  readonly PENDING: "Pending";
  readonly SUCCEEDED: "Succeeded";
};
export type StopStatus = (typeof StopStatus)[keyof typeof StopStatus];
export interface StopDeploymentOutput {
  status?: StopStatus;
  statusMessage?: string;
}
export interface TagResourceInput {
  ResourceArn: string | undefined;
  Tags: Tag[] | undefined;
}
export interface TagResourceOutput {}
export interface UntagResourceInput {
  ResourceArn: string | undefined;
  TagKeys: string[] | undefined;
}
export interface UntagResourceOutput {}
export interface UpdateApplicationInput {
  applicationName?: string;
  newApplicationName?: string;
}
export interface UpdateDeploymentGroupInput {
  applicationName: string | undefined;
  currentDeploymentGroupName: string | undefined;
  newDeploymentGroupName?: string;
  deploymentConfigName?: string;
  ec2TagFilters?: EC2TagFilter[];
  onPremisesInstanceTagFilters?: TagFilter[];
  autoScalingGroups?: string[];
  serviceRoleArn?: string;
  triggerConfigurations?: TriggerConfig[];
  alarmConfiguration?: AlarmConfiguration;
  autoRollbackConfiguration?: AutoRollbackConfiguration;
  outdatedInstancesStrategy?: OutdatedInstancesStrategy;
  deploymentStyle?: DeploymentStyle;
  blueGreenDeploymentConfiguration?: BlueGreenDeploymentConfiguration;
  loadBalancerInfo?: LoadBalancerInfo;
  ec2TagSet?: EC2TagSet;
  ecsServices?: ECSService[];
  onPremisesTagSet?: OnPremisesTagSet;
  terminationHookEnabled?: boolean;
}
export interface UpdateDeploymentGroupOutput {
  hooksNotCleanedUp?: AutoScalingGroup[];
}
