"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.EdgeFunction = void 0;
const aws_lambda_1 = require("@aws-cdk/aws-lambda");
const aws_ssm_1 = require("@aws-cdk/aws-ssm");
const base_edge_construct_1 = require("./base-edge-construct");
const edge_function_provider_1 = require("./edge-function-provider");
const edge_role_1 = require("./edge-role");
const with_configuration_1 = require("./with-configuration");
class EdgeFunction extends base_edge_construct_1.BaseEdgeConstruct {
    constructor(scope, id, props) {
        var _a, _b;
        super(scope, id);
        const stack = (_a = this.stack.nestedStackParent) !== null && _a !== void 0 ? _a : this.stack;
        const { name, parameterName = `/cloudcomponents/edge-lambda/${stack.stackName}/${name}/${this.stack.node.addr}` } = props;
        this.edgeRole = (_b = props.edgeRole) !== null && _b !== void 0 ? _b : new edge_role_1.EdgeRole(this, `${name}Role`);
        this.eventType = props.eventType;
        const edgeFunction = new aws_lambda_1.Function(this.edgeStack, `${name}Function`, {
            runtime: aws_lambda_1.Runtime.NODEJS_12_X,
            handler: 'index.handler',
            code: props.code,
            role: this.edgeRole.role,
        });
        const parameter = new aws_ssm_1.StringParameter(this.edgeStack, `${name}StringParameter`, {
            parameterName,
            description: 'Parameter stored for cross region Lambda@Edge',
            stringValue: edgeFunction.functionArn,
        });
        const { edgeFunction: retrievedEdgeFunction } = new edge_function_provider_1.EdgeFunctionProvider(scope, `${name}Provider`, {
            parameter,
        });
        const lambdaWithConfig = new with_configuration_1.WithConfiguration(this, 'WithConfiguration', {
            function: retrievedEdgeFunction,
            configuration: props.configuration,
        });
        this.functionVersion = lambdaWithConfig.functionVersion;
        this.lambdaFunction = this.functionVersion;
    }
}
exports.EdgeFunction = EdgeFunction;
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoiZWRnZS1mdW5jdGlvbi5qcyIsInNvdXJjZVJvb3QiOiIiLCJzb3VyY2VzIjpbIi4uL3NyYy9lZGdlLWZ1bmN0aW9uLnRzIl0sIm5hbWVzIjpbXSwibWFwcGluZ3MiOiI7OztBQUNBLG9EQUF3RTtBQUN4RSw4Q0FBbUQ7QUFHbkQsK0RBQTBEO0FBQzFELHFFQUFnRTtBQUVoRSwyQ0FBa0Q7QUFFbEQsNkRBQXdFO0FBa0J4RSxNQUFhLFlBQWEsU0FBUSx1Q0FBaUI7SUFNakQsWUFBWSxLQUFnQixFQUFFLEVBQVUsRUFBRSxLQUF3Qjs7UUFDaEUsS0FBSyxDQUFDLEtBQUssRUFBRSxFQUFFLENBQUMsQ0FBQztRQUNqQixNQUFNLEtBQUssU0FBRyxJQUFJLENBQUMsS0FBSyxDQUFDLGlCQUFpQixtQ0FBSSxJQUFJLENBQUMsS0FBSyxDQUFDO1FBRXpELE1BQU0sRUFBRSxJQUFJLEVBQUUsYUFBYSxHQUFHLGdDQUFnQyxLQUFLLENBQUMsU0FBUyxJQUFJLElBQUksSUFBSSxJQUFJLENBQUMsS0FBSyxDQUFDLElBQUksQ0FBQyxJQUFJLEVBQUUsRUFBRSxHQUFHLEtBQUssQ0FBQztRQUUxSCxJQUFJLENBQUMsUUFBUSxTQUFHLEtBQUssQ0FBQyxRQUFRLG1DQUFJLElBQUksb0JBQVEsQ0FBQyxJQUFJLEVBQUUsR0FBRyxJQUFJLE1BQU0sQ0FBQyxDQUFDO1FBRXBFLElBQUksQ0FBQyxTQUFTLEdBQUcsS0FBSyxDQUFDLFNBQVMsQ0FBQztRQUVqQyxNQUFNLFlBQVksR0FBRyxJQUFJLHFCQUFRLENBQUMsSUFBSSxDQUFDLFNBQVMsRUFBRSxHQUFHLElBQUksVUFBVSxFQUFFO1lBQ25FLE9BQU8sRUFBRSxvQkFBTyxDQUFDLFdBQVc7WUFDNUIsT0FBTyxFQUFFLGVBQWU7WUFDeEIsSUFBSSxFQUFFLEtBQUssQ0FBQyxJQUFJO1lBQ2hCLElBQUksRUFBRSxJQUFJLENBQUMsUUFBUSxDQUFDLElBQUk7U0FDekIsQ0FBQyxDQUFDO1FBRUgsTUFBTSxTQUFTLEdBQUcsSUFBSSx5QkFBZSxDQUFDLElBQUksQ0FBQyxTQUFTLEVBQUUsR0FBRyxJQUFJLGlCQUFpQixFQUFFO1lBQzlFLGFBQWE7WUFDYixXQUFXLEVBQUUsK0NBQStDO1lBQzVELFdBQVcsRUFBRSxZQUFZLENBQUMsV0FBVztTQUN0QyxDQUFDLENBQUM7UUFFSCxNQUFNLEVBQUUsWUFBWSxFQUFFLHFCQUFxQixFQUFFLEdBQUcsSUFBSSw2Q0FBb0IsQ0FBQyxLQUFLLEVBQUUsR0FBRyxJQUFJLFVBQVUsRUFBRTtZQUNqRyxTQUFTO1NBQ1YsQ0FBQyxDQUFDO1FBRUgsTUFBTSxnQkFBZ0IsR0FBRyxJQUFJLHNDQUFpQixDQUFDLElBQUksRUFBRSxtQkFBbUIsRUFBRTtZQUN4RSxRQUFRLEVBQUUscUJBQXFCO1lBQy9CLGFBQWEsRUFBRSxLQUFLLENBQUMsYUFBYTtTQUNuQyxDQUFDLENBQUM7UUFFSCxJQUFJLENBQUMsZUFBZSxHQUFHLGdCQUFnQixDQUFDLGVBQWUsQ0FBQztRQUV4RCxJQUFJLENBQUMsY0FBYyxHQUFHLElBQUksQ0FBQyxlQUFlLENBQUM7SUFDN0MsQ0FBQztDQUNGO0FBMUNELG9DQTBDQyIsInNvdXJjZXNDb250ZW50IjpbImltcG9ydCB7IExhbWJkYUVkZ2VFdmVudFR5cGUgfSBmcm9tICdAYXdzLWNkay9hd3MtY2xvdWRmcm9udCc7XG5pbXBvcnQgeyBDb2RlLCBGdW5jdGlvbiwgUnVudGltZSwgSVZlcnNpb24gfSBmcm9tICdAYXdzLWNkay9hd3MtbGFtYmRhJztcbmltcG9ydCB7IFN0cmluZ1BhcmFtZXRlciB9IGZyb20gJ0Bhd3MtY2RrL2F3cy1zc20nO1xuaW1wb3J0IHsgQ29uc3RydWN0IH0gZnJvbSAnQGF3cy1jZGsvY29yZSc7XG5cbmltcG9ydCB7IEJhc2VFZGdlQ29uc3RydWN0IH0gZnJvbSAnLi9iYXNlLWVkZ2UtY29uc3RydWN0JztcbmltcG9ydCB7IEVkZ2VGdW5jdGlvblByb3ZpZGVyIH0gZnJvbSAnLi9lZGdlLWZ1bmN0aW9uLXByb3ZpZGVyJztcbmltcG9ydCB7IElFZGdlTGFtYmRhIH0gZnJvbSAnLi9lZGdlLWxhbWJkYSc7XG5pbXBvcnQgeyBFZGdlUm9sZSwgSUVkZ2VSb2xlIH0gZnJvbSAnLi9lZGdlLXJvbGUnO1xuaW1wb3J0IHsgSUxhbWJkYUZ1bmN0aW9uQXNzb2NpYXRpb24gfSBmcm9tICcuL2xhbWJkYS1mdW5jdGlvbi1hc3NvY2lhdGlvbic7XG5pbXBvcnQgeyBDb25maWd1cmF0aW9uLCBXaXRoQ29uZmlndXJhdGlvbiB9IGZyb20gJy4vd2l0aC1jb25maWd1cmF0aW9uJztcblxuZXhwb3J0IGludGVyZmFjZSBDb21tb25FZGdlRnVuY3Rpb25Qcm9wcyB7XG4gICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgXG4gIHJlYWRvbmx5IHBhcmFtZXRlck5hbWU/OiBzdHJpbmc7XG5cbiAgcmVhZG9ubHkgZWRnZVJvbGU/OiBJRWRnZVJvbGU7XG59XG5cbmV4cG9ydCBpbnRlcmZhY2UgRWRnZUZ1bmN0aW9uUHJvcHMgZXh0ZW5kcyBDb21tb25FZGdlRnVuY3Rpb25Qcm9wcyB7XG4gIHJlYWRvbmx5IGNvbmZpZ3VyYXRpb246IENvbmZpZ3VyYXRpb247XG4gIHJlYWRvbmx5IGNvZGU6IENvZGU7XG4gIHJlYWRvbmx5IG5hbWU6IHN0cmluZztcbiAgcmVhZG9ubHkgZXZlbnRUeXBlOiBMYW1iZGFFZGdlRXZlbnRUeXBlO1xufVxuXG5leHBvcnQgY2xhc3MgRWRnZUZ1bmN0aW9uIGV4dGVuZHMgQmFzZUVkZ2VDb25zdHJ1Y3QgaW1wbGVtZW50cyBJTGFtYmRhRnVuY3Rpb25Bc3NvY2lhdGlvbiwgSUVkZ2VMYW1iZGEge1xuICBwdWJsaWMgcmVhZG9ubHkgZWRnZVJvbGU6IElFZGdlUm9sZTtcbiAgcHVibGljIHJlYWRvbmx5IGV2ZW50VHlwZTogTGFtYmRhRWRnZUV2ZW50VHlwZTtcbiAgcHVibGljIHJlYWRvbmx5IGZ1bmN0aW9uVmVyc2lvbjogSVZlcnNpb247XG4gIHB1YmxpYyByZWFkb25seSBsYW1iZGFGdW5jdGlvbjogSVZlcnNpb247XG5cbiAgY29uc3RydWN0b3Ioc2NvcGU6IENvbnN0cnVjdCwgaWQ6IHN0cmluZywgcHJvcHM6IEVkZ2VGdW5jdGlvblByb3BzKSB7XG4gICAgc3VwZXIoc2NvcGUsIGlkKTtcbiAgICBjb25zdCBzdGFjayA9IHRoaXMuc3RhY2submVzdGVkU3RhY2tQYXJlbnQgPz8gdGhpcy5zdGFjaztcblxuICAgIGNvbnN0IHsgbmFtZSwgcGFyYW1ldGVyTmFtZSA9IGAvY2xvdWRjb21wb25lbnRzL2VkZ2UtbGFtYmRhLyR7c3RhY2suc3RhY2tOYW1lfS8ke25hbWV9LyR7dGhpcy5zdGFjay5ub2RlLmFkZHJ9YCB9ID0gcHJvcHM7XG5cbiAgICB0aGlzLmVkZ2VSb2xlID0gcHJvcHMuZWRnZVJvbGUgPz8gbmV3IEVkZ2VSb2xlKHRoaXMsIGAke25hbWV9Um9sZWApO1xuXG4gICAgdGhpcy5ldmVudFR5cGUgPSBwcm9wcy5ldmVudFR5cGU7XG5cbiAgICBjb25zdCBlZGdlRnVuY3Rpb24gPSBuZXcgRnVuY3Rpb24odGhpcy5lZGdlU3RhY2ssIGAke25hbWV9RnVuY3Rpb25gLCB7XG4gICAgICBydW50aW1lOiBSdW50aW1lLk5PREVKU18xMl9YLFxuICAgICAgaGFuZGxlcjogJ2luZGV4LmhhbmRsZXInLFxuICAgICAgY29kZTogcHJvcHMuY29kZSxcbiAgICAgIHJvbGU6IHRoaXMuZWRnZVJvbGUucm9sZSxcbiAgICB9KTtcblxuICAgIGNvbnN0IHBhcmFtZXRlciA9IG5ldyBTdHJpbmdQYXJhbWV0ZXIodGhpcy5lZGdlU3RhY2ssIGAke25hbWV9U3RyaW5nUGFyYW1ldGVyYCwge1xuICAgICAgcGFyYW1ldGVyTmFtZSxcbiAgICAgIGRlc2NyaXB0aW9uOiAnUGFyYW1ldGVyIHN0b3JlZCBmb3IgY3Jvc3MgcmVnaW9uIExhbWJkYUBFZGdlJyxcbiAgICAgIHN0cmluZ1ZhbHVlOiBlZGdlRnVuY3Rpb24uZnVuY3Rpb25Bcm4sXG4gICAgfSk7XG5cbiAgICBjb25zdCB7IGVkZ2VGdW5jdGlvbjogcmV0cmlldmVkRWRnZUZ1bmN0aW9uIH0gPSBuZXcgRWRnZUZ1bmN0aW9uUHJvdmlkZXIoc2NvcGUsIGAke25hbWV9UHJvdmlkZXJgLCB7XG4gICAgICBwYXJhbWV0ZXIsXG4gICAgfSk7XG5cbiAgICBjb25zdCBsYW1iZGFXaXRoQ29uZmlnID0gbmV3IFdpdGhDb25maWd1cmF0aW9uKHRoaXMsICdXaXRoQ29uZmlndXJhdGlvbicsIHtcbiAgICAgIGZ1bmN0aW9uOiByZXRyaWV2ZWRFZGdlRnVuY3Rpb24sXG4gICAgICBjb25maWd1cmF0aW9uOiBwcm9wcy5jb25maWd1cmF0aW9uLFxuICAgIH0pO1xuXG4gICAgdGhpcy5mdW5jdGlvblZlcnNpb24gPSBsYW1iZGFXaXRoQ29uZmlnLmZ1bmN0aW9uVmVyc2lvbjtcblxuICAgIHRoaXMubGFtYmRhRnVuY3Rpb24gPSB0aGlzLmZ1bmN0aW9uVmVyc2lvbjtcbiAgfVxufVxuIl19