"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.AzurermProvider = exports.azurermProviderFeaturesToTerraform = exports.azurermProviderFeaturesVirtualMachineScaleSetToTerraform = exports.azurermProviderFeaturesVirtualMachineToTerraform = exports.azurermProviderFeaturesTemplateDeploymentToTerraform = exports.azurermProviderFeaturesResourceGroupToTerraform = exports.azurermProviderFeaturesNetworkToTerraform = exports.azurermProviderFeaturesLogAnalyticsWorkspaceToTerraform = exports.azurermProviderFeaturesKeyVaultToTerraform = exports.azurermProviderFeaturesCognitiveAccountToTerraform = exports.azurermProviderFeaturesApplicationInsightsToTerraform = exports.azurermProviderFeaturesApiManagementToTerraform = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const cdktf = require("cdktf");
function azurermProviderFeaturesApiManagementToTerraform(struct) {
    if (!cdktf.canInspect(struct) || cdktf.Tokenization.isResolvable(struct)) {
        return struct;
    }
    if (cdktf.isComplexElement(struct)) {
        throw new Error("A complex element was used as configuration, this is not supported: https://cdk.tf/complex-object-as-configuration");
    }
    return {
        purge_soft_delete_on_destroy: cdktf.booleanToTerraform(struct.purgeSoftDeleteOnDestroy),
        recover_soft_deleted: cdktf.booleanToTerraform(struct.recoverSoftDeleted),
    };
}
exports.azurermProviderFeaturesApiManagementToTerraform = azurermProviderFeaturesApiManagementToTerraform;
function azurermProviderFeaturesApplicationInsightsToTerraform(struct) {
    if (!cdktf.canInspect(struct) || cdktf.Tokenization.isResolvable(struct)) {
        return struct;
    }
    if (cdktf.isComplexElement(struct)) {
        throw new Error("A complex element was used as configuration, this is not supported: https://cdk.tf/complex-object-as-configuration");
    }
    return {
        disable_generated_rule: cdktf.booleanToTerraform(struct.disableGeneratedRule),
    };
}
exports.azurermProviderFeaturesApplicationInsightsToTerraform = azurermProviderFeaturesApplicationInsightsToTerraform;
function azurermProviderFeaturesCognitiveAccountToTerraform(struct) {
    if (!cdktf.canInspect(struct) || cdktf.Tokenization.isResolvable(struct)) {
        return struct;
    }
    if (cdktf.isComplexElement(struct)) {
        throw new Error("A complex element was used as configuration, this is not supported: https://cdk.tf/complex-object-as-configuration");
    }
    return {
        purge_soft_delete_on_destroy: cdktf.booleanToTerraform(struct.purgeSoftDeleteOnDestroy),
    };
}
exports.azurermProviderFeaturesCognitiveAccountToTerraform = azurermProviderFeaturesCognitiveAccountToTerraform;
function azurermProviderFeaturesKeyVaultToTerraform(struct) {
    if (!cdktf.canInspect(struct) || cdktf.Tokenization.isResolvable(struct)) {
        return struct;
    }
    if (cdktf.isComplexElement(struct)) {
        throw new Error("A complex element was used as configuration, this is not supported: https://cdk.tf/complex-object-as-configuration");
    }
    return {
        purge_soft_delete_on_destroy: cdktf.booleanToTerraform(struct.purgeSoftDeleteOnDestroy),
        purge_soft_deleted_certificates_on_destroy: cdktf.booleanToTerraform(struct.purgeSoftDeletedCertificatesOnDestroy),
        purge_soft_deleted_hardware_security_modules_on_destroy: cdktf.booleanToTerraform(struct.purgeSoftDeletedHardwareSecurityModulesOnDestroy),
        purge_soft_deleted_keys_on_destroy: cdktf.booleanToTerraform(struct.purgeSoftDeletedKeysOnDestroy),
        purge_soft_deleted_secrets_on_destroy: cdktf.booleanToTerraform(struct.purgeSoftDeletedSecretsOnDestroy),
        recover_soft_deleted_certificates: cdktf.booleanToTerraform(struct.recoverSoftDeletedCertificates),
        recover_soft_deleted_key_vaults: cdktf.booleanToTerraform(struct.recoverSoftDeletedKeyVaults),
        recover_soft_deleted_keys: cdktf.booleanToTerraform(struct.recoverSoftDeletedKeys),
        recover_soft_deleted_secrets: cdktf.booleanToTerraform(struct.recoverSoftDeletedSecrets),
    };
}
exports.azurermProviderFeaturesKeyVaultToTerraform = azurermProviderFeaturesKeyVaultToTerraform;
function azurermProviderFeaturesLogAnalyticsWorkspaceToTerraform(struct) {
    if (!cdktf.canInspect(struct) || cdktf.Tokenization.isResolvable(struct)) {
        return struct;
    }
    if (cdktf.isComplexElement(struct)) {
        throw new Error("A complex element was used as configuration, this is not supported: https://cdk.tf/complex-object-as-configuration");
    }
    return {
        permanently_delete_on_destroy: cdktf.booleanToTerraform(struct.permanentlyDeleteOnDestroy),
    };
}
exports.azurermProviderFeaturesLogAnalyticsWorkspaceToTerraform = azurermProviderFeaturesLogAnalyticsWorkspaceToTerraform;
function azurermProviderFeaturesNetworkToTerraform(struct) {
    if (!cdktf.canInspect(struct) || cdktf.Tokenization.isResolvable(struct)) {
        return struct;
    }
    if (cdktf.isComplexElement(struct)) {
        throw new Error("A complex element was used as configuration, this is not supported: https://cdk.tf/complex-object-as-configuration");
    }
    return {
        relaxed_locking: cdktf.booleanToTerraform(struct.relaxedLocking),
    };
}
exports.azurermProviderFeaturesNetworkToTerraform = azurermProviderFeaturesNetworkToTerraform;
function azurermProviderFeaturesResourceGroupToTerraform(struct) {
    if (!cdktf.canInspect(struct) || cdktf.Tokenization.isResolvable(struct)) {
        return struct;
    }
    if (cdktf.isComplexElement(struct)) {
        throw new Error("A complex element was used as configuration, this is not supported: https://cdk.tf/complex-object-as-configuration");
    }
    return {
        prevent_deletion_if_contains_resources: cdktf.booleanToTerraform(struct.preventDeletionIfContainsResources),
    };
}
exports.azurermProviderFeaturesResourceGroupToTerraform = azurermProviderFeaturesResourceGroupToTerraform;
function azurermProviderFeaturesTemplateDeploymentToTerraform(struct) {
    if (!cdktf.canInspect(struct) || cdktf.Tokenization.isResolvable(struct)) {
        return struct;
    }
    if (cdktf.isComplexElement(struct)) {
        throw new Error("A complex element was used as configuration, this is not supported: https://cdk.tf/complex-object-as-configuration");
    }
    return {
        delete_nested_items_during_deletion: cdktf.booleanToTerraform(struct.deleteNestedItemsDuringDeletion),
    };
}
exports.azurermProviderFeaturesTemplateDeploymentToTerraform = azurermProviderFeaturesTemplateDeploymentToTerraform;
function azurermProviderFeaturesVirtualMachineToTerraform(struct) {
    if (!cdktf.canInspect(struct) || cdktf.Tokenization.isResolvable(struct)) {
        return struct;
    }
    if (cdktf.isComplexElement(struct)) {
        throw new Error("A complex element was used as configuration, this is not supported: https://cdk.tf/complex-object-as-configuration");
    }
    return {
        delete_os_disk_on_deletion: cdktf.booleanToTerraform(struct.deleteOsDiskOnDeletion),
        graceful_shutdown: cdktf.booleanToTerraform(struct.gracefulShutdown),
        skip_shutdown_and_force_delete: cdktf.booleanToTerraform(struct.skipShutdownAndForceDelete),
    };
}
exports.azurermProviderFeaturesVirtualMachineToTerraform = azurermProviderFeaturesVirtualMachineToTerraform;
function azurermProviderFeaturesVirtualMachineScaleSetToTerraform(struct) {
    if (!cdktf.canInspect(struct) || cdktf.Tokenization.isResolvable(struct)) {
        return struct;
    }
    if (cdktf.isComplexElement(struct)) {
        throw new Error("A complex element was used as configuration, this is not supported: https://cdk.tf/complex-object-as-configuration");
    }
    return {
        force_delete: cdktf.booleanToTerraform(struct.forceDelete),
        roll_instances_when_required: cdktf.booleanToTerraform(struct.rollInstancesWhenRequired),
        scale_to_zero_before_deletion: cdktf.booleanToTerraform(struct.scaleToZeroBeforeDeletion),
    };
}
exports.azurermProviderFeaturesVirtualMachineScaleSetToTerraform = azurermProviderFeaturesVirtualMachineScaleSetToTerraform;
function azurermProviderFeaturesToTerraform(struct) {
    if (!cdktf.canInspect(struct) || cdktf.Tokenization.isResolvable(struct)) {
        return struct;
    }
    if (cdktf.isComplexElement(struct)) {
        throw new Error("A complex element was used as configuration, this is not supported: https://cdk.tf/complex-object-as-configuration");
    }
    return {
        api_management: azurermProviderFeaturesApiManagementToTerraform(struct.apiManagement),
        application_insights: azurermProviderFeaturesApplicationInsightsToTerraform(struct.applicationInsights),
        cognitive_account: azurermProviderFeaturesCognitiveAccountToTerraform(struct.cognitiveAccount),
        key_vault: azurermProviderFeaturesKeyVaultToTerraform(struct.keyVault),
        log_analytics_workspace: azurermProviderFeaturesLogAnalyticsWorkspaceToTerraform(struct.logAnalyticsWorkspace),
        network: azurermProviderFeaturesNetworkToTerraform(struct.network),
        resource_group: azurermProviderFeaturesResourceGroupToTerraform(struct.resourceGroup),
        template_deployment: azurermProviderFeaturesTemplateDeploymentToTerraform(struct.templateDeployment),
        virtual_machine: azurermProviderFeaturesVirtualMachineToTerraform(struct.virtualMachine),
        virtual_machine_scale_set: azurermProviderFeaturesVirtualMachineScaleSetToTerraform(struct.virtualMachineScaleSet),
    };
}
exports.azurermProviderFeaturesToTerraform = azurermProviderFeaturesToTerraform;
/**
* Represents a {@link https://www.terraform.io/docs/providers/azurerm azurerm}
*/
class AzurermProvider extends cdktf.TerraformProvider {
    // ===========
    // INITIALIZER
    // ===========
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/azurerm azurerm} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options AzurermProviderConfig
    */
    constructor(scope, id, config) {
        super(scope, id, {
            terraformResourceType: 'azurerm',
            terraformGeneratorMetadata: {
                providerName: 'azurerm',
                providerVersion: '3.24.0',
                providerVersionConstraint: '~> 3.10'
            },
            terraformProviderSource: 'azurerm'
        });
        this._auxiliaryTenantIds = config.auxiliaryTenantIds;
        this._clientCertificatePassword = config.clientCertificatePassword;
        this._clientCertificatePath = config.clientCertificatePath;
        this._clientId = config.clientId;
        this._clientSecret = config.clientSecret;
        this._disableCorrelationRequestId = config.disableCorrelationRequestId;
        this._disableTerraformPartnerId = config.disableTerraformPartnerId;
        this._environment = config.environment;
        this._metadataHost = config.metadataHost;
        this._msiEndpoint = config.msiEndpoint;
        this._oidcRequestToken = config.oidcRequestToken;
        this._oidcRequestUrl = config.oidcRequestUrl;
        this._oidcToken = config.oidcToken;
        this._partnerId = config.partnerId;
        this._skipProviderRegistration = config.skipProviderRegistration;
        this._storageUseAzuread = config.storageUseAzuread;
        this._subscriptionId = config.subscriptionId;
        this._tenantId = config.tenantId;
        this._useMsi = config.useMsi;
        this._useOidc = config.useOidc;
        this._alias = config.alias;
        this._features = config.features;
    }
    get auxiliaryTenantIds() {
        return this._auxiliaryTenantIds;
    }
    set auxiliaryTenantIds(value) {
        this._auxiliaryTenantIds = value;
    }
    resetAuxiliaryTenantIds() {
        this._auxiliaryTenantIds = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get auxiliaryTenantIdsInput() {
        return this._auxiliaryTenantIds;
    }
    get clientCertificatePassword() {
        return this._clientCertificatePassword;
    }
    set clientCertificatePassword(value) {
        this._clientCertificatePassword = value;
    }
    resetClientCertificatePassword() {
        this._clientCertificatePassword = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get clientCertificatePasswordInput() {
        return this._clientCertificatePassword;
    }
    get clientCertificatePath() {
        return this._clientCertificatePath;
    }
    set clientCertificatePath(value) {
        this._clientCertificatePath = value;
    }
    resetClientCertificatePath() {
        this._clientCertificatePath = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get clientCertificatePathInput() {
        return this._clientCertificatePath;
    }
    get clientId() {
        return this._clientId;
    }
    set clientId(value) {
        this._clientId = value;
    }
    resetClientId() {
        this._clientId = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get clientIdInput() {
        return this._clientId;
    }
    get clientSecret() {
        return this._clientSecret;
    }
    set clientSecret(value) {
        this._clientSecret = value;
    }
    resetClientSecret() {
        this._clientSecret = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get clientSecretInput() {
        return this._clientSecret;
    }
    get disableCorrelationRequestId() {
        return this._disableCorrelationRequestId;
    }
    set disableCorrelationRequestId(value) {
        this._disableCorrelationRequestId = value;
    }
    resetDisableCorrelationRequestId() {
        this._disableCorrelationRequestId = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get disableCorrelationRequestIdInput() {
        return this._disableCorrelationRequestId;
    }
    get disableTerraformPartnerId() {
        return this._disableTerraformPartnerId;
    }
    set disableTerraformPartnerId(value) {
        this._disableTerraformPartnerId = value;
    }
    resetDisableTerraformPartnerId() {
        this._disableTerraformPartnerId = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get disableTerraformPartnerIdInput() {
        return this._disableTerraformPartnerId;
    }
    get environment() {
        return this._environment;
    }
    set environment(value) {
        this._environment = value;
    }
    resetEnvironment() {
        this._environment = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get environmentInput() {
        return this._environment;
    }
    get metadataHost() {
        return this._metadataHost;
    }
    set metadataHost(value) {
        this._metadataHost = value;
    }
    resetMetadataHost() {
        this._metadataHost = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get metadataHostInput() {
        return this._metadataHost;
    }
    get msiEndpoint() {
        return this._msiEndpoint;
    }
    set msiEndpoint(value) {
        this._msiEndpoint = value;
    }
    resetMsiEndpoint() {
        this._msiEndpoint = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get msiEndpointInput() {
        return this._msiEndpoint;
    }
    get oidcRequestToken() {
        return this._oidcRequestToken;
    }
    set oidcRequestToken(value) {
        this._oidcRequestToken = value;
    }
    resetOidcRequestToken() {
        this._oidcRequestToken = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get oidcRequestTokenInput() {
        return this._oidcRequestToken;
    }
    get oidcRequestUrl() {
        return this._oidcRequestUrl;
    }
    set oidcRequestUrl(value) {
        this._oidcRequestUrl = value;
    }
    resetOidcRequestUrl() {
        this._oidcRequestUrl = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get oidcRequestUrlInput() {
        return this._oidcRequestUrl;
    }
    get oidcToken() {
        return this._oidcToken;
    }
    set oidcToken(value) {
        this._oidcToken = value;
    }
    resetOidcToken() {
        this._oidcToken = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get oidcTokenInput() {
        return this._oidcToken;
    }
    get partnerId() {
        return this._partnerId;
    }
    set partnerId(value) {
        this._partnerId = value;
    }
    resetPartnerId() {
        this._partnerId = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get partnerIdInput() {
        return this._partnerId;
    }
    get skipProviderRegistration() {
        return this._skipProviderRegistration;
    }
    set skipProviderRegistration(value) {
        this._skipProviderRegistration = value;
    }
    resetSkipProviderRegistration() {
        this._skipProviderRegistration = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get skipProviderRegistrationInput() {
        return this._skipProviderRegistration;
    }
    get storageUseAzuread() {
        return this._storageUseAzuread;
    }
    set storageUseAzuread(value) {
        this._storageUseAzuread = value;
    }
    resetStorageUseAzuread() {
        this._storageUseAzuread = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get storageUseAzureadInput() {
        return this._storageUseAzuread;
    }
    get subscriptionId() {
        return this._subscriptionId;
    }
    set subscriptionId(value) {
        this._subscriptionId = value;
    }
    resetSubscriptionId() {
        this._subscriptionId = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get subscriptionIdInput() {
        return this._subscriptionId;
    }
    get tenantId() {
        return this._tenantId;
    }
    set tenantId(value) {
        this._tenantId = value;
    }
    resetTenantId() {
        this._tenantId = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get tenantIdInput() {
        return this._tenantId;
    }
    get useMsi() {
        return this._useMsi;
    }
    set useMsi(value) {
        this._useMsi = value;
    }
    resetUseMsi() {
        this._useMsi = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get useMsiInput() {
        return this._useMsi;
    }
    get useOidc() {
        return this._useOidc;
    }
    set useOidc(value) {
        this._useOidc = value;
    }
    resetUseOidc() {
        this._useOidc = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get useOidcInput() {
        return this._useOidc;
    }
    get alias() {
        return this._alias;
    }
    set alias(value) {
        this._alias = value;
    }
    resetAlias() {
        this._alias = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get aliasInput() {
        return this._alias;
    }
    get features() {
        return this._features;
    }
    set features(value) {
        this._features = value;
    }
    // Temporarily expose input value. Use with caution.
    get featuresInput() {
        return this._features;
    }
    // =========
    // SYNTHESIS
    // =========
    synthesizeAttributes() {
        return {
            auxiliary_tenant_ids: cdktf.listMapper(cdktf.stringToTerraform, false)(this._auxiliaryTenantIds),
            client_certificate_password: cdktf.stringToTerraform(this._clientCertificatePassword),
            client_certificate_path: cdktf.stringToTerraform(this._clientCertificatePath),
            client_id: cdktf.stringToTerraform(this._clientId),
            client_secret: cdktf.stringToTerraform(this._clientSecret),
            disable_correlation_request_id: cdktf.booleanToTerraform(this._disableCorrelationRequestId),
            disable_terraform_partner_id: cdktf.booleanToTerraform(this._disableTerraformPartnerId),
            environment: cdktf.stringToTerraform(this._environment),
            metadata_host: cdktf.stringToTerraform(this._metadataHost),
            msi_endpoint: cdktf.stringToTerraform(this._msiEndpoint),
            oidc_request_token: cdktf.stringToTerraform(this._oidcRequestToken),
            oidc_request_url: cdktf.stringToTerraform(this._oidcRequestUrl),
            oidc_token: cdktf.stringToTerraform(this._oidcToken),
            partner_id: cdktf.stringToTerraform(this._partnerId),
            skip_provider_registration: cdktf.booleanToTerraform(this._skipProviderRegistration),
            storage_use_azuread: cdktf.booleanToTerraform(this._storageUseAzuread),
            subscription_id: cdktf.stringToTerraform(this._subscriptionId),
            tenant_id: cdktf.stringToTerraform(this._tenantId),
            use_msi: cdktf.booleanToTerraform(this._useMsi),
            use_oidc: cdktf.booleanToTerraform(this._useOidc),
            alias: cdktf.stringToTerraform(this._alias),
            features: azurermProviderFeaturesToTerraform(this._features),
        };
    }
}
exports.AzurermProvider = AzurermProvider;
_a = JSII_RTTI_SYMBOL_1;
AzurermProvider[_a] = { fqn: "@cdktf/provider-azurerm.AzurermProvider", version: "2.0.15" };
// =================
// STATIC PROPERTIES
// =================
AzurermProvider.tfResourceType = "azurerm";
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoiYXp1cmVybS1wcm92aWRlci5qcyIsInNvdXJjZVJvb3QiOiIiLCJzb3VyY2VzIjpbIi4uL3NyYy9henVyZXJtLXByb3ZpZGVyLnRzIl0sIm5hbWVzIjpbXSwibWFwcGluZ3MiOiI7Ozs7O0FBSUEsK0JBQStCO0FBbUovQixTQUFnQiwrQ0FBK0MsQ0FBQyxNQUE2QztJQUMzRyxJQUFJLENBQUMsS0FBSyxDQUFDLFVBQVUsQ0FBQyxNQUFNLENBQUMsSUFBSSxLQUFLLENBQUMsWUFBWSxDQUFDLFlBQVksQ0FBQyxNQUFNLENBQUMsRUFBRTtRQUFFLE9BQU8sTUFBTSxDQUFDO0tBQUU7SUFDNUYsSUFBSSxLQUFLLENBQUMsZ0JBQWdCLENBQUMsTUFBTSxDQUFDLEVBQUU7UUFDbEMsTUFBTSxJQUFJLEtBQUssQ0FBQyxvSEFBb0gsQ0FBQyxDQUFDO0tBQ3ZJO0lBQ0QsT0FBTztRQUNMLDRCQUE0QixFQUFFLEtBQUssQ0FBQyxrQkFBa0IsQ0FBQyxNQUFPLENBQUMsd0JBQXdCLENBQUM7UUFDeEYsb0JBQW9CLEVBQUUsS0FBSyxDQUFDLGtCQUFrQixDQUFDLE1BQU8sQ0FBQyxrQkFBa0IsQ0FBQztLQUMzRSxDQUFBO0FBQ0gsQ0FBQztBQVRELDBHQVNDO0FBU0QsU0FBZ0IscURBQXFELENBQUMsTUFBbUQ7SUFDdkgsSUFBSSxDQUFDLEtBQUssQ0FBQyxVQUFVLENBQUMsTUFBTSxDQUFDLElBQUksS0FBSyxDQUFDLFlBQVksQ0FBQyxZQUFZLENBQUMsTUFBTSxDQUFDLEVBQUU7UUFBRSxPQUFPLE1BQU0sQ0FBQztLQUFFO0lBQzVGLElBQUksS0FBSyxDQUFDLGdCQUFnQixDQUFDLE1BQU0sQ0FBQyxFQUFFO1FBQ2xDLE1BQU0sSUFBSSxLQUFLLENBQUMsb0hBQW9ILENBQUMsQ0FBQztLQUN2STtJQUNELE9BQU87UUFDTCxzQkFBc0IsRUFBRSxLQUFLLENBQUMsa0JBQWtCLENBQUMsTUFBTyxDQUFDLG9CQUFvQixDQUFDO0tBQy9FLENBQUE7QUFDSCxDQUFDO0FBUkQsc0hBUUM7QUFTRCxTQUFnQixrREFBa0QsQ0FBQyxNQUFnRDtJQUNqSCxJQUFJLENBQUMsS0FBSyxDQUFDLFVBQVUsQ0FBQyxNQUFNLENBQUMsSUFBSSxLQUFLLENBQUMsWUFBWSxDQUFDLFlBQVksQ0FBQyxNQUFNLENBQUMsRUFBRTtRQUFFLE9BQU8sTUFBTSxDQUFDO0tBQUU7SUFDNUYsSUFBSSxLQUFLLENBQUMsZ0JBQWdCLENBQUMsTUFBTSxDQUFDLEVBQUU7UUFDbEMsTUFBTSxJQUFJLEtBQUssQ0FBQyxvSEFBb0gsQ0FBQyxDQUFDO0tBQ3ZJO0lBQ0QsT0FBTztRQUNMLDRCQUE0QixFQUFFLEtBQUssQ0FBQyxrQkFBa0IsQ0FBQyxNQUFPLENBQUMsd0JBQXdCLENBQUM7S0FDekYsQ0FBQTtBQUNILENBQUM7QUFSRCxnSEFRQztBQTJERCxTQUFnQiwwQ0FBMEMsQ0FBQyxNQUF3QztJQUNqRyxJQUFJLENBQUMsS0FBSyxDQUFDLFVBQVUsQ0FBQyxNQUFNLENBQUMsSUFBSSxLQUFLLENBQUMsWUFBWSxDQUFDLFlBQVksQ0FBQyxNQUFNLENBQUMsRUFBRTtRQUFFLE9BQU8sTUFBTSxDQUFDO0tBQUU7SUFDNUYsSUFBSSxLQUFLLENBQUMsZ0JBQWdCLENBQUMsTUFBTSxDQUFDLEVBQUU7UUFDbEMsTUFBTSxJQUFJLEtBQUssQ0FBQyxvSEFBb0gsQ0FBQyxDQUFDO0tBQ3ZJO0lBQ0QsT0FBTztRQUNMLDRCQUE0QixFQUFFLEtBQUssQ0FBQyxrQkFBa0IsQ0FBQyxNQUFPLENBQUMsd0JBQXdCLENBQUM7UUFDeEYsMENBQTBDLEVBQUUsS0FBSyxDQUFDLGtCQUFrQixDQUFDLE1BQU8sQ0FBQyxxQ0FBcUMsQ0FBQztRQUNuSCx1REFBdUQsRUFBRSxLQUFLLENBQUMsa0JBQWtCLENBQUMsTUFBTyxDQUFDLGdEQUFnRCxDQUFDO1FBQzNJLGtDQUFrQyxFQUFFLEtBQUssQ0FBQyxrQkFBa0IsQ0FBQyxNQUFPLENBQUMsNkJBQTZCLENBQUM7UUFDbkcscUNBQXFDLEVBQUUsS0FBSyxDQUFDLGtCQUFrQixDQUFDLE1BQU8sQ0FBQyxnQ0FBZ0MsQ0FBQztRQUN6RyxpQ0FBaUMsRUFBRSxLQUFLLENBQUMsa0JBQWtCLENBQUMsTUFBTyxDQUFDLDhCQUE4QixDQUFDO1FBQ25HLCtCQUErQixFQUFFLEtBQUssQ0FBQyxrQkFBa0IsQ0FBQyxNQUFPLENBQUMsMkJBQTJCLENBQUM7UUFDOUYseUJBQXlCLEVBQUUsS0FBSyxDQUFDLGtCQUFrQixDQUFDLE1BQU8sQ0FBQyxzQkFBc0IsQ0FBQztRQUNuRiw0QkFBNEIsRUFBRSxLQUFLLENBQUMsa0JBQWtCLENBQUMsTUFBTyxDQUFDLHlCQUF5QixDQUFDO0tBQzFGLENBQUE7QUFDSCxDQUFDO0FBaEJELGdHQWdCQztBQVNELFNBQWdCLHVEQUF1RCxDQUFDLE1BQXFEO0lBQzNILElBQUksQ0FBQyxLQUFLLENBQUMsVUFBVSxDQUFDLE1BQU0sQ0FBQyxJQUFJLEtBQUssQ0FBQyxZQUFZLENBQUMsWUFBWSxDQUFDLE1BQU0sQ0FBQyxFQUFFO1FBQUUsT0FBTyxNQUFNLENBQUM7S0FBRTtJQUM1RixJQUFJLEtBQUssQ0FBQyxnQkFBZ0IsQ0FBQyxNQUFNLENBQUMsRUFBRTtRQUNsQyxNQUFNLElBQUksS0FBSyxDQUFDLG9IQUFvSCxDQUFDLENBQUM7S0FDdkk7SUFDRCxPQUFPO1FBQ0wsNkJBQTZCLEVBQUUsS0FBSyxDQUFDLGtCQUFrQixDQUFDLE1BQU8sQ0FBQywwQkFBMEIsQ0FBQztLQUM1RixDQUFBO0FBQ0gsQ0FBQztBQVJELDBIQVFDO0FBU0QsU0FBZ0IseUNBQXlDLENBQUMsTUFBdUM7SUFDL0YsSUFBSSxDQUFDLEtBQUssQ0FBQyxVQUFVLENBQUMsTUFBTSxDQUFDLElBQUksS0FBSyxDQUFDLFlBQVksQ0FBQyxZQUFZLENBQUMsTUFBTSxDQUFDLEVBQUU7UUFBRSxPQUFPLE1BQU0sQ0FBQztLQUFFO0lBQzVGLElBQUksS0FBSyxDQUFDLGdCQUFnQixDQUFDLE1BQU0sQ0FBQyxFQUFFO1FBQ2xDLE1BQU0sSUFBSSxLQUFLLENBQUMsb0hBQW9ILENBQUMsQ0FBQztLQUN2STtJQUNELE9BQU87UUFDTCxlQUFlLEVBQUUsS0FBSyxDQUFDLGtCQUFrQixDQUFDLE1BQU8sQ0FBQyxjQUFjLENBQUM7S0FDbEUsQ0FBQTtBQUNILENBQUM7QUFSRCw4RkFRQztBQVNELFNBQWdCLCtDQUErQyxDQUFDLE1BQTZDO0lBQzNHLElBQUksQ0FBQyxLQUFLLENBQUMsVUFBVSxDQUFDLE1BQU0sQ0FBQyxJQUFJLEtBQUssQ0FBQyxZQUFZLENBQUMsWUFBWSxDQUFDLE1BQU0sQ0FBQyxFQUFFO1FBQUUsT0FBTyxNQUFNLENBQUM7S0FBRTtJQUM1RixJQUFJLEtBQUssQ0FBQyxnQkFBZ0IsQ0FBQyxNQUFNLENBQUMsRUFBRTtRQUNsQyxNQUFNLElBQUksS0FBSyxDQUFDLG9IQUFvSCxDQUFDLENBQUM7S0FDdkk7SUFDRCxPQUFPO1FBQ0wsc0NBQXNDLEVBQUUsS0FBSyxDQUFDLGtCQUFrQixDQUFDLE1BQU8sQ0FBQyxrQ0FBa0MsQ0FBQztLQUM3RyxDQUFBO0FBQ0gsQ0FBQztBQVJELDBHQVFDO0FBU0QsU0FBZ0Isb0RBQW9ELENBQUMsTUFBa0Q7SUFDckgsSUFBSSxDQUFDLEtBQUssQ0FBQyxVQUFVLENBQUMsTUFBTSxDQUFDLElBQUksS0FBSyxDQUFDLFlBQVksQ0FBQyxZQUFZLENBQUMsTUFBTSxDQUFDLEVBQUU7UUFBRSxPQUFPLE1BQU0sQ0FBQztLQUFFO0lBQzVGLElBQUksS0FBSyxDQUFDLGdCQUFnQixDQUFDLE1BQU0sQ0FBQyxFQUFFO1FBQ2xDLE1BQU0sSUFBSSxLQUFLLENBQUMsb0hBQW9ILENBQUMsQ0FBQztLQUN2STtJQUNELE9BQU87UUFDTCxtQ0FBbUMsRUFBRSxLQUFLLENBQUMsa0JBQWtCLENBQUMsTUFBTyxDQUFDLCtCQUErQixDQUFDO0tBQ3ZHLENBQUE7QUFDSCxDQUFDO0FBUkQsb0hBUUM7QUFpQkQsU0FBZ0IsZ0RBQWdELENBQUMsTUFBOEM7SUFDN0csSUFBSSxDQUFDLEtBQUssQ0FBQyxVQUFVLENBQUMsTUFBTSxDQUFDLElBQUksS0FBSyxDQUFDLFlBQVksQ0FBQyxZQUFZLENBQUMsTUFBTSxDQUFDLEVBQUU7UUFBRSxPQUFPLE1BQU0sQ0FBQztLQUFFO0lBQzVGLElBQUksS0FBSyxDQUFDLGdCQUFnQixDQUFDLE1BQU0sQ0FBQyxFQUFFO1FBQ2xDLE1BQU0sSUFBSSxLQUFLLENBQUMsb0hBQW9ILENBQUMsQ0FBQztLQUN2STtJQUNELE9BQU87UUFDTCwwQkFBMEIsRUFBRSxLQUFLLENBQUMsa0JBQWtCLENBQUMsTUFBTyxDQUFDLHNCQUFzQixDQUFDO1FBQ3BGLGlCQUFpQixFQUFFLEtBQUssQ0FBQyxrQkFBa0IsQ0FBQyxNQUFPLENBQUMsZ0JBQWdCLENBQUM7UUFDckUsOEJBQThCLEVBQUUsS0FBSyxDQUFDLGtCQUFrQixDQUFDLE1BQU8sQ0FBQywwQkFBMEIsQ0FBQztLQUM3RixDQUFBO0FBQ0gsQ0FBQztBQVZELDRHQVVDO0FBaUJELFNBQWdCLHdEQUF3RCxDQUFDLE1BQXNEO0lBQzdILElBQUksQ0FBQyxLQUFLLENBQUMsVUFBVSxDQUFDLE1BQU0sQ0FBQyxJQUFJLEtBQUssQ0FBQyxZQUFZLENBQUMsWUFBWSxDQUFDLE1BQU0sQ0FBQyxFQUFFO1FBQUUsT0FBTyxNQUFNLENBQUM7S0FBRTtJQUM1RixJQUFJLEtBQUssQ0FBQyxnQkFBZ0IsQ0FBQyxNQUFNLENBQUMsRUFBRTtRQUNsQyxNQUFNLElBQUksS0FBSyxDQUFDLG9IQUFvSCxDQUFDLENBQUM7S0FDdkk7SUFDRCxPQUFPO1FBQ0wsWUFBWSxFQUFFLEtBQUssQ0FBQyxrQkFBa0IsQ0FBQyxNQUFPLENBQUMsV0FBVyxDQUFDO1FBQzNELDRCQUE0QixFQUFFLEtBQUssQ0FBQyxrQkFBa0IsQ0FBQyxNQUFPLENBQUMseUJBQXlCLENBQUM7UUFDekYsNkJBQTZCLEVBQUUsS0FBSyxDQUFDLGtCQUFrQixDQUFDLE1BQU8sQ0FBQyx5QkFBeUIsQ0FBQztLQUMzRixDQUFBO0FBQ0gsQ0FBQztBQVZELDRIQVVDO0FBaUVELFNBQWdCLGtDQUFrQyxDQUFDLE1BQWdDO0lBQ2pGLElBQUksQ0FBQyxLQUFLLENBQUMsVUFBVSxDQUFDLE1BQU0sQ0FBQyxJQUFJLEtBQUssQ0FBQyxZQUFZLENBQUMsWUFBWSxDQUFDLE1BQU0sQ0FBQyxFQUFFO1FBQUUsT0FBTyxNQUFNLENBQUM7S0FBRTtJQUM1RixJQUFJLEtBQUssQ0FBQyxnQkFBZ0IsQ0FBQyxNQUFNLENBQUMsRUFBRTtRQUNsQyxNQUFNLElBQUksS0FBSyxDQUFDLG9IQUFvSCxDQUFDLENBQUM7S0FDdkk7SUFDRCxPQUFPO1FBQ0wsY0FBYyxFQUFFLCtDQUErQyxDQUFDLE1BQU8sQ0FBQyxhQUFhLENBQUM7UUFDdEYsb0JBQW9CLEVBQUUscURBQXFELENBQUMsTUFBTyxDQUFDLG1CQUFtQixDQUFDO1FBQ3hHLGlCQUFpQixFQUFFLGtEQUFrRCxDQUFDLE1BQU8sQ0FBQyxnQkFBZ0IsQ0FBQztRQUMvRixTQUFTLEVBQUUsMENBQTBDLENBQUMsTUFBTyxDQUFDLFFBQVEsQ0FBQztRQUN2RSx1QkFBdUIsRUFBRSx1REFBdUQsQ0FBQyxNQUFPLENBQUMscUJBQXFCLENBQUM7UUFDL0csT0FBTyxFQUFFLHlDQUF5QyxDQUFDLE1BQU8sQ0FBQyxPQUFPLENBQUM7UUFDbkUsY0FBYyxFQUFFLCtDQUErQyxDQUFDLE1BQU8sQ0FBQyxhQUFhLENBQUM7UUFDdEYsbUJBQW1CLEVBQUUsb0RBQW9ELENBQUMsTUFBTyxDQUFDLGtCQUFrQixDQUFDO1FBQ3JHLGVBQWUsRUFBRSxnREFBZ0QsQ0FBQyxNQUFPLENBQUMsY0FBYyxDQUFDO1FBQ3pGLHlCQUF5QixFQUFFLHdEQUF3RCxDQUFDLE1BQU8sQ0FBQyxzQkFBc0IsQ0FBQztLQUNwSCxDQUFBO0FBQ0gsQ0FBQztBQWpCRCxnRkFpQkM7QUFHRDs7RUFFRTtBQUNGLE1BQWEsZUFBZ0IsU0FBUSxLQUFLLENBQUMsaUJBQWlCO0lBTzFELGNBQWM7SUFDZCxjQUFjO0lBQ2QsY0FBYztJQUVkOzs7Ozs7TUFNRTtJQUNGLFlBQW1CLEtBQWdCLEVBQUUsRUFBVSxFQUFFLE1BQTZCO1FBQzVFLEtBQUssQ0FBQyxLQUFLLEVBQUUsRUFBRSxFQUFFO1lBQ2YscUJBQXFCLEVBQUUsU0FBUztZQUNoQywwQkFBMEIsRUFBRTtnQkFDMUIsWUFBWSxFQUFFLFNBQVM7Z0JBQ3ZCLGVBQWUsRUFBRSxRQUFRO2dCQUN6Qix5QkFBeUIsRUFBRSxTQUFTO2FBQ3JDO1lBQ0QsdUJBQXVCLEVBQUUsU0FBUztTQUNuQyxDQUFDLENBQUM7UUFDSCxJQUFJLENBQUMsbUJBQW1CLEdBQUcsTUFBTSxDQUFDLGtCQUFrQixDQUFDO1FBQ3JELElBQUksQ0FBQywwQkFBMEIsR0FBRyxNQUFNLENBQUMseUJBQXlCLENBQUM7UUFDbkUsSUFBSSxDQUFDLHNCQUFzQixHQUFHLE1BQU0sQ0FBQyxxQkFBcUIsQ0FBQztRQUMzRCxJQUFJLENBQUMsU0FBUyxHQUFHLE1BQU0sQ0FBQyxRQUFRLENBQUM7UUFDakMsSUFBSSxDQUFDLGFBQWEsR0FBRyxNQUFNLENBQUMsWUFBWSxDQUFDO1FBQ3pDLElBQUksQ0FBQyw0QkFBNEIsR0FBRyxNQUFNLENBQUMsMkJBQTJCLENBQUM7UUFDdkUsSUFBSSxDQUFDLDBCQUEwQixHQUFHLE1BQU0sQ0FBQyx5QkFBeUIsQ0FBQztRQUNuRSxJQUFJLENBQUMsWUFBWSxHQUFHLE1BQU0sQ0FBQyxXQUFXLENBQUM7UUFDdkMsSUFBSSxDQUFDLGFBQWEsR0FBRyxNQUFNLENBQUMsWUFBWSxDQUFDO1FBQ3pDLElBQUksQ0FBQyxZQUFZLEdBQUcsTUFBTSxDQUFDLFdBQVcsQ0FBQztRQUN2QyxJQUFJLENBQUMsaUJBQWlCLEdBQUcsTUFBTSxDQUFDLGdCQUFnQixDQUFDO1FBQ2pELElBQUksQ0FBQyxlQUFlLEdBQUcsTUFBTSxDQUFDLGNBQWMsQ0FBQztRQUM3QyxJQUFJLENBQUMsVUFBVSxHQUFHLE1BQU0sQ0FBQyxTQUFTLENBQUM7UUFDbkMsSUFBSSxDQUFDLFVBQVUsR0FBRyxNQUFNLENBQUMsU0FBUyxDQUFDO1FBQ25DLElBQUksQ0FBQyx5QkFBeUIsR0FBRyxNQUFNLENBQUMsd0JBQXdCLENBQUM7UUFDakUsSUFBSSxDQUFDLGtCQUFrQixHQUFHLE1BQU0sQ0FBQyxpQkFBaUIsQ0FBQztRQUNuRCxJQUFJLENBQUMsZUFBZSxHQUFHLE1BQU0sQ0FBQyxjQUFjLENBQUM7UUFDN0MsSUFBSSxDQUFDLFNBQVMsR0FBRyxNQUFNLENBQUMsUUFBUSxDQUFDO1FBQ2pDLElBQUksQ0FBQyxPQUFPLEdBQUcsTUFBTSxDQUFDLE1BQU0sQ0FBQztRQUM3QixJQUFJLENBQUMsUUFBUSxHQUFHLE1BQU0sQ0FBQyxPQUFPLENBQUM7UUFDL0IsSUFBSSxDQUFDLE1BQU0sR0FBRyxNQUFNLENBQUMsS0FBSyxDQUFDO1FBQzNCLElBQUksQ0FBQyxTQUFTLEdBQUcsTUFBTSxDQUFDLFFBQVEsQ0FBQztJQUNuQyxDQUFDO0lBUUQsSUFBVyxrQkFBa0I7UUFDM0IsT0FBTyxJQUFJLENBQUMsbUJBQW1CLENBQUM7SUFDbEMsQ0FBQztJQUNELElBQVcsa0JBQWtCLENBQUMsS0FBMkI7UUFDdkQsSUFBSSxDQUFDLG1CQUFtQixHQUFHLEtBQUssQ0FBQztJQUNuQyxDQUFDO0lBQ00sdUJBQXVCO1FBQzVCLElBQUksQ0FBQyxtQkFBbUIsR0FBRyxTQUFTLENBQUM7SUFDdkMsQ0FBQztJQUNELG9EQUFvRDtJQUNwRCxJQUFXLHVCQUF1QjtRQUNoQyxPQUFPLElBQUksQ0FBQyxtQkFBbUIsQ0FBQztJQUNsQyxDQUFDO0lBSUQsSUFBVyx5QkFBeUI7UUFDbEMsT0FBTyxJQUFJLENBQUMsMEJBQTBCLENBQUM7SUFDekMsQ0FBQztJQUNELElBQVcseUJBQXlCLENBQUMsS0FBeUI7UUFDNUQsSUFBSSxDQUFDLDBCQUEwQixHQUFHLEtBQUssQ0FBQztJQUMxQyxDQUFDO0lBQ00sOEJBQThCO1FBQ25DLElBQUksQ0FBQywwQkFBMEIsR0FBRyxTQUFTLENBQUM7SUFDOUMsQ0FBQztJQUNELG9EQUFvRDtJQUNwRCxJQUFXLDhCQUE4QjtRQUN2QyxPQUFPLElBQUksQ0FBQywwQkFBMEIsQ0FBQztJQUN6QyxDQUFDO0lBSUQsSUFBVyxxQkFBcUI7UUFDOUIsT0FBTyxJQUFJLENBQUMsc0JBQXNCLENBQUM7SUFDckMsQ0FBQztJQUNELElBQVcscUJBQXFCLENBQUMsS0FBeUI7UUFDeEQsSUFBSSxDQUFDLHNCQUFzQixHQUFHLEtBQUssQ0FBQztJQUN0QyxDQUFDO0lBQ00sMEJBQTBCO1FBQy9CLElBQUksQ0FBQyxzQkFBc0IsR0FBRyxTQUFTLENBQUM7SUFDMUMsQ0FBQztJQUNELG9EQUFvRDtJQUNwRCxJQUFXLDBCQUEwQjtRQUNuQyxPQUFPLElBQUksQ0FBQyxzQkFBc0IsQ0FBQztJQUNyQyxDQUFDO0lBSUQsSUFBVyxRQUFRO1FBQ2pCLE9BQU8sSUFBSSxDQUFDLFNBQVMsQ0FBQztJQUN4QixDQUFDO0lBQ0QsSUFBVyxRQUFRLENBQUMsS0FBeUI7UUFDM0MsSUFBSSxDQUFDLFNBQVMsR0FBRyxLQUFLLENBQUM7SUFDekIsQ0FBQztJQUNNLGFBQWE7UUFDbEIsSUFBSSxDQUFDLFNBQVMsR0FBRyxTQUFTLENBQUM7SUFDN0IsQ0FBQztJQUNELG9EQUFvRDtJQUNwRCxJQUFXLGFBQWE7UUFDdEIsT0FBTyxJQUFJLENBQUMsU0FBUyxDQUFDO0lBQ3hCLENBQUM7SUFJRCxJQUFXLFlBQVk7UUFDckIsT0FBTyxJQUFJLENBQUMsYUFBYSxDQUFDO0lBQzVCLENBQUM7SUFDRCxJQUFXLFlBQVksQ0FBQyxLQUF5QjtRQUMvQyxJQUFJLENBQUMsYUFBYSxHQUFHLEtBQUssQ0FBQztJQUM3QixDQUFDO0lBQ00saUJBQWlCO1FBQ3RCLElBQUksQ0FBQyxhQUFhLEdBQUcsU0FBUyxDQUFDO0lBQ2pDLENBQUM7SUFDRCxvREFBb0Q7SUFDcEQsSUFBVyxpQkFBaUI7UUFDMUIsT0FBTyxJQUFJLENBQUMsYUFBYSxDQUFDO0lBQzVCLENBQUM7SUFJRCxJQUFXLDJCQUEyQjtRQUNwQyxPQUFPLElBQUksQ0FBQyw0QkFBNEIsQ0FBQztJQUMzQyxDQUFDO0lBQ0QsSUFBVywyQkFBMkIsQ0FBQyxLQUE4QztRQUNuRixJQUFJLENBQUMsNEJBQTRCLEdBQUcsS0FBSyxDQUFDO0lBQzVDLENBQUM7SUFDTSxnQ0FBZ0M7UUFDckMsSUFBSSxDQUFDLDRCQUE0QixHQUFHLFNBQVMsQ0FBQztJQUNoRCxDQUFDO0lBQ0Qsb0RBQW9EO0lBQ3BELElBQVcsZ0NBQWdDO1FBQ3pDLE9BQU8sSUFBSSxDQUFDLDRCQUE0QixDQUFDO0lBQzNDLENBQUM7SUFJRCxJQUFXLHlCQUF5QjtRQUNsQyxPQUFPLElBQUksQ0FBQywwQkFBMEIsQ0FBQztJQUN6QyxDQUFDO0lBQ0QsSUFBVyx5QkFBeUIsQ0FBQyxLQUE4QztRQUNqRixJQUFJLENBQUMsMEJBQTBCLEdBQUcsS0FBSyxDQUFDO0lBQzFDLENBQUM7SUFDTSw4QkFBOEI7UUFDbkMsSUFBSSxDQUFDLDBCQUEwQixHQUFHLFNBQVMsQ0FBQztJQUM5QyxDQUFDO0lBQ0Qsb0RBQW9EO0lBQ3BELElBQVcsOEJBQThCO1FBQ3ZDLE9BQU8sSUFBSSxDQUFDLDBCQUEwQixDQUFDO0lBQ3pDLENBQUM7SUFJRCxJQUFXLFdBQVc7UUFDcEIsT0FBTyxJQUFJLENBQUMsWUFBWSxDQUFDO0lBQzNCLENBQUM7SUFDRCxJQUFXLFdBQVcsQ0FBQyxLQUF5QjtRQUM5QyxJQUFJLENBQUMsWUFBWSxHQUFHLEtBQUssQ0FBQztJQUM1QixDQUFDO0lBQ00sZ0JBQWdCO1FBQ3JCLElBQUksQ0FBQyxZQUFZLEdBQUcsU0FBUyxDQUFDO0lBQ2hDLENBQUM7SUFDRCxvREFBb0Q7SUFDcEQsSUFBVyxnQkFBZ0I7UUFDekIsT0FBTyxJQUFJLENBQUMsWUFBWSxDQUFDO0lBQzNCLENBQUM7SUFJRCxJQUFXLFlBQVk7UUFDckIsT0FBTyxJQUFJLENBQUMsYUFBYSxDQUFDO0lBQzVCLENBQUM7SUFDRCxJQUFXLFlBQVksQ0FBQyxLQUF5QjtRQUMvQyxJQUFJLENBQUMsYUFBYSxHQUFHLEtBQUssQ0FBQztJQUM3QixDQUFDO0lBQ00saUJBQWlCO1FBQ3RCLElBQUksQ0FBQyxhQUFhLEdBQUcsU0FBUyxDQUFDO0lBQ2pDLENBQUM7SUFDRCxvREFBb0Q7SUFDcEQsSUFBVyxpQkFBaUI7UUFDMUIsT0FBTyxJQUFJLENBQUMsYUFBYSxDQUFDO0lBQzVCLENBQUM7SUFJRCxJQUFXLFdBQVc7UUFDcEIsT0FBTyxJQUFJLENBQUMsWUFBWSxDQUFDO0lBQzNCLENBQUM7SUFDRCxJQUFXLFdBQVcsQ0FBQyxLQUF5QjtRQUM5QyxJQUFJLENBQUMsWUFBWSxHQUFHLEtBQUssQ0FBQztJQUM1QixDQUFDO0lBQ00sZ0JBQWdCO1FBQ3JCLElBQUksQ0FBQyxZQUFZLEdBQUcsU0FBUyxDQUFDO0lBQ2hDLENBQUM7SUFDRCxvREFBb0Q7SUFDcEQsSUFBVyxnQkFBZ0I7UUFDekIsT0FBTyxJQUFJLENBQUMsWUFBWSxDQUFDO0lBQzNCLENBQUM7SUFJRCxJQUFXLGdCQUFnQjtRQUN6QixPQUFPLElBQUksQ0FBQyxpQkFBaUIsQ0FBQztJQUNoQyxDQUFDO0lBQ0QsSUFBVyxnQkFBZ0IsQ0FBQyxLQUF5QjtRQUNuRCxJQUFJLENBQUMsaUJBQWlCLEdBQUcsS0FBSyxDQUFDO0lBQ2pDLENBQUM7SUFDTSxxQkFBcUI7UUFDMUIsSUFBSSxDQUFDLGlCQUFpQixHQUFHLFNBQVMsQ0FBQztJQUNyQyxDQUFDO0lBQ0Qsb0RBQW9EO0lBQ3BELElBQVcscUJBQXFCO1FBQzlCLE9BQU8sSUFBSSxDQUFDLGlCQUFpQixDQUFDO0lBQ2hDLENBQUM7SUFJRCxJQUFXLGNBQWM7UUFDdkIsT0FBTyxJQUFJLENBQUMsZUFBZSxDQUFDO0lBQzlCLENBQUM7SUFDRCxJQUFXLGNBQWMsQ0FBQyxLQUF5QjtRQUNqRCxJQUFJLENBQUMsZUFBZSxHQUFHLEtBQUssQ0FBQztJQUMvQixDQUFDO0lBQ00sbUJBQW1CO1FBQ3hCLElBQUksQ0FBQyxlQUFlLEdBQUcsU0FBUyxDQUFDO0lBQ25DLENBQUM7SUFDRCxvREFBb0Q7SUFDcEQsSUFBVyxtQkFBbUI7UUFDNUIsT0FBTyxJQUFJLENBQUMsZUFBZSxDQUFDO0lBQzlCLENBQUM7SUFJRCxJQUFXLFNBQVM7UUFDbEIsT0FBTyxJQUFJLENBQUMsVUFBVSxDQUFDO0lBQ3pCLENBQUM7SUFDRCxJQUFXLFNBQVMsQ0FBQyxLQUF5QjtRQUM1QyxJQUFJLENBQUMsVUFBVSxHQUFHLEtBQUssQ0FBQztJQUMxQixDQUFDO0lBQ00sY0FBYztRQUNuQixJQUFJLENBQUMsVUFBVSxHQUFHLFNBQVMsQ0FBQztJQUM5QixDQUFDO0lBQ0Qsb0RBQW9EO0lBQ3BELElBQVcsY0FBYztRQUN2QixPQUFPLElBQUksQ0FBQyxVQUFVLENBQUM7SUFDekIsQ0FBQztJQUlELElBQVcsU0FBUztRQUNsQixPQUFPLElBQUksQ0FBQyxVQUFVLENBQUM7SUFDekIsQ0FBQztJQUNELElBQVcsU0FBUyxDQUFDLEtBQXlCO1FBQzVDLElBQUksQ0FBQyxVQUFVLEdBQUcsS0FBSyxDQUFDO0lBQzFCLENBQUM7SUFDTSxjQUFjO1FBQ25CLElBQUksQ0FBQyxVQUFVLEdBQUcsU0FBUyxDQUFDO0lBQzlCLENBQUM7SUFDRCxvREFBb0Q7SUFDcEQsSUFBVyxjQUFjO1FBQ3ZCLE9BQU8sSUFBSSxDQUFDLFVBQVUsQ0FBQztJQUN6QixDQUFDO0lBSUQsSUFBVyx3QkFBd0I7UUFDakMsT0FBTyxJQUFJLENBQUMseUJBQXlCLENBQUM7SUFDeEMsQ0FBQztJQUNELElBQVcsd0JBQXdCLENBQUMsS0FBOEM7UUFDaEYsSUFBSSxDQUFDLHlCQUF5QixHQUFHLEtBQUssQ0FBQztJQUN6QyxDQUFDO0lBQ00sNkJBQTZCO1FBQ2xDLElBQUksQ0FBQyx5QkFBeUIsR0FBRyxTQUFTLENBQUM7SUFDN0MsQ0FBQztJQUNELG9EQUFvRDtJQUNwRCxJQUFXLDZCQUE2QjtRQUN0QyxPQUFPLElBQUksQ0FBQyx5QkFBeUIsQ0FBQztJQUN4QyxDQUFDO0lBSUQsSUFBVyxpQkFBaUI7UUFDMUIsT0FBTyxJQUFJLENBQUMsa0JBQWtCLENBQUM7SUFDakMsQ0FBQztJQUNELElBQVcsaUJBQWlCLENBQUMsS0FBOEM7UUFDekUsSUFBSSxDQUFDLGtCQUFrQixHQUFHLEtBQUssQ0FBQztJQUNsQyxDQUFDO0lBQ00sc0JBQXNCO1FBQzNCLElBQUksQ0FBQyxrQkFBa0IsR0FBRyxTQUFTLENBQUM7SUFDdEMsQ0FBQztJQUNELG9EQUFvRDtJQUNwRCxJQUFXLHNCQUFzQjtRQUMvQixPQUFPLElBQUksQ0FBQyxrQkFBa0IsQ0FBQztJQUNqQyxDQUFDO0lBSUQsSUFBVyxjQUFjO1FBQ3ZCLE9BQU8sSUFBSSxDQUFDLGVBQWUsQ0FBQztJQUM5QixDQUFDO0lBQ0QsSUFBVyxjQUFjLENBQUMsS0FBeUI7UUFDakQsSUFBSSxDQUFDLGVBQWUsR0FBRyxLQUFLLENBQUM7SUFDL0IsQ0FBQztJQUNNLG1CQUFtQjtRQUN4QixJQUFJLENBQUMsZUFBZSxHQUFHLFNBQVMsQ0FBQztJQUNuQyxDQUFDO0lBQ0Qsb0RBQW9EO0lBQ3BELElBQVcsbUJBQW1CO1FBQzVCLE9BQU8sSUFBSSxDQUFDLGVBQWUsQ0FBQztJQUM5QixDQUFDO0lBSUQsSUFBVyxRQUFRO1FBQ2pCLE9BQU8sSUFBSSxDQUFDLFNBQVMsQ0FBQztJQUN4QixDQUFDO0lBQ0QsSUFBVyxRQUFRLENBQUMsS0FBeUI7UUFDM0MsSUFBSSxDQUFDLFNBQVMsR0FBRyxLQUFLLENBQUM7SUFDekIsQ0FBQztJQUNNLGFBQWE7UUFDbEIsSUFBSSxDQUFDLFNBQVMsR0FBRyxTQUFTLENBQUM7SUFDN0IsQ0FBQztJQUNELG9EQUFvRDtJQUNwRCxJQUFXLGFBQWE7UUFDdEIsT0FBTyxJQUFJLENBQUMsU0FBUyxDQUFDO0lBQ3hCLENBQUM7SUFJRCxJQUFXLE1BQU07UUFDZixPQUFPLElBQUksQ0FBQyxPQUFPLENBQUM7SUFDdEIsQ0FBQztJQUNELElBQVcsTUFBTSxDQUFDLEtBQThDO1FBQzlELElBQUksQ0FBQyxPQUFPLEdBQUcsS0FBSyxDQUFDO0lBQ3ZCLENBQUM7SUFDTSxXQUFXO1FBQ2hCLElBQUksQ0FBQyxPQUFPLEdBQUcsU0FBUyxDQUFDO0lBQzNCLENBQUM7SUFDRCxvREFBb0Q7SUFDcEQsSUFBVyxXQUFXO1FBQ3BCLE9BQU8sSUFBSSxDQUFDLE9BQU8sQ0FBQztJQUN0QixDQUFDO0lBSUQsSUFBVyxPQUFPO1FBQ2hCLE9BQU8sSUFBSSxDQUFDLFFBQVEsQ0FBQztJQUN2QixDQUFDO0lBQ0QsSUFBVyxPQUFPLENBQUMsS0FBOEM7UUFDL0QsSUFBSSxDQUFDLFFBQVEsR0FBRyxLQUFLLENBQUM7SUFDeEIsQ0FBQztJQUNNLFlBQVk7UUFDakIsSUFBSSxDQUFDLFFBQVEsR0FBRyxTQUFTLENBQUM7SUFDNUIsQ0FBQztJQUNELG9EQUFvRDtJQUNwRCxJQUFXLFlBQVk7UUFDckIsT0FBTyxJQUFJLENBQUMsUUFBUSxDQUFDO0lBQ3ZCLENBQUM7SUFJRCxJQUFXLEtBQUs7UUFDZCxPQUFPLElBQUksQ0FBQyxNQUFNLENBQUM7SUFDckIsQ0FBQztJQUNELElBQVcsS0FBSyxDQUFDLEtBQXlCO1FBQ3hDLElBQUksQ0FBQyxNQUFNLEdBQUcsS0FBSyxDQUFDO0lBQ3RCLENBQUM7SUFDTSxVQUFVO1FBQ2YsSUFBSSxDQUFDLE1BQU0sR0FBRyxTQUFTLENBQUM7SUFDMUIsQ0FBQztJQUNELG9EQUFvRDtJQUNwRCxJQUFXLFVBQVU7UUFDbkIsT0FBTyxJQUFJLENBQUMsTUFBTSxDQUFDO0lBQ3JCLENBQUM7SUFJRCxJQUFXLFFBQVE7UUFDakIsT0FBTyxJQUFJLENBQUMsU0FBUyxDQUFDO0lBQ3hCLENBQUM7SUFDRCxJQUFXLFFBQVEsQ0FBQyxLQUEwQztRQUM1RCxJQUFJLENBQUMsU0FBUyxHQUFHLEtBQUssQ0FBQztJQUN6QixDQUFDO0lBQ0Qsb0RBQW9EO0lBQ3BELElBQVcsYUFBYTtRQUN0QixPQUFPLElBQUksQ0FBQyxTQUFTLENBQUM7SUFDeEIsQ0FBQztJQUVELFlBQVk7SUFDWixZQUFZO0lBQ1osWUFBWTtJQUVGLG9CQUFvQjtRQUM1QixPQUFPO1lBQ0wsb0JBQW9CLEVBQUUsS0FBSyxDQUFDLFVBQVUsQ0FBQyxLQUFLLENBQUMsaUJBQWlCLEVBQUUsS0FBSyxDQUFDLENBQUMsSUFBSSxDQUFDLG1CQUFtQixDQUFDO1lBQ2hHLDJCQUEyQixFQUFFLEtBQUssQ0FBQyxpQkFBaUIsQ0FBQyxJQUFJLENBQUMsMEJBQTBCLENBQUM7WUFDckYsdUJBQXVCLEVBQUUsS0FBSyxDQUFDLGlCQUFpQixDQUFDLElBQUksQ0FBQyxzQkFBc0IsQ0FBQztZQUM3RSxTQUFTLEVBQUUsS0FBSyxDQUFDLGlCQUFpQixDQUFDLElBQUksQ0FBQyxTQUFTLENBQUM7WUFDbEQsYUFBYSxFQUFFLEtBQUssQ0FBQyxpQkFBaUIsQ0FBQyxJQUFJLENBQUMsYUFBYSxDQUFDO1lBQzFELDhCQUE4QixFQUFFLEtBQUssQ0FBQyxrQkFBa0IsQ0FBQyxJQUFJLENBQUMsNEJBQTRCLENBQUM7WUFDM0YsNEJBQTRCLEVBQUUsS0FBSyxDQUFDLGtCQUFrQixDQUFDLElBQUksQ0FBQywwQkFBMEIsQ0FBQztZQUN2RixXQUFXLEVBQUUsS0FBSyxDQUFDLGlCQUFpQixDQUFDLElBQUksQ0FBQyxZQUFZLENBQUM7WUFDdkQsYUFBYSxFQUFFLEtBQUssQ0FBQyxpQkFBaUIsQ0FBQyxJQUFJLENBQUMsYUFBYSxDQUFDO1lBQzFELFlBQVksRUFBRSxLQUFLLENBQUMsaUJBQWlCLENBQUMsSUFBSSxDQUFDLFlBQVksQ0FBQztZQUN4RCxrQkFBa0IsRUFBRSxLQUFLLENBQUMsaUJBQWlCLENBQUMsSUFBSSxDQUFDLGlCQUFpQixDQUFDO1lBQ25FLGdCQUFnQixFQUFFLEtBQUssQ0FBQyxpQkFBaUIsQ0FBQyxJQUFJLENBQUMsZUFBZSxDQUFDO1lBQy9ELFVBQVUsRUFBRSxLQUFLLENBQUMsaUJBQWlCLENBQUMsSUFBSSxDQUFDLFVBQVUsQ0FBQztZQUNwRCxVQUFVLEVBQUUsS0FBSyxDQUFDLGlCQUFpQixDQUFDLElBQUksQ0FBQyxVQUFVLENBQUM7WUFDcEQsMEJBQTBCLEVBQUUsS0FBSyxDQUFDLGtCQUFrQixDQUFDLElBQUksQ0FBQyx5QkFBeUIsQ0FBQztZQUNwRixtQkFBbUIsRUFBRSxLQUFLLENBQUMsa0JBQWtCLENBQUMsSUFBSSxDQUFDLGtCQUFrQixDQUFDO1lBQ3RFLGVBQWUsRUFBRSxLQUFLLENBQUMsaUJBQWlCLENBQUMsSUFBSSxDQUFDLGVBQWUsQ0FBQztZQUM5RCxTQUFTLEVBQUUsS0FBSyxDQUFDLGlCQUFpQixDQUFDLElBQUksQ0FBQyxTQUFTLENBQUM7WUFDbEQsT0FBTyxFQUFFLEtBQUssQ0FBQyxrQkFBa0IsQ0FBQyxJQUFJLENBQUMsT0FBTyxDQUFDO1lBQy9DLFFBQVEsRUFBRSxLQUFLLENBQUMsa0JBQWtCLENBQUMsSUFBSSxDQUFDLFFBQVEsQ0FBQztZQUNqRCxLQUFLLEVBQUUsS0FBSyxDQUFDLGlCQUFpQixDQUFDLElBQUksQ0FBQyxNQUFNLENBQUM7WUFDM0MsUUFBUSxFQUFFLGtDQUFrQyxDQUFDLElBQUksQ0FBQyxTQUFTLENBQUM7U0FDN0QsQ0FBQztJQUNKLENBQUM7O0FBbGJILDBDQW1iQzs7O0FBamJDLG9CQUFvQjtBQUNwQixvQkFBb0I7QUFDcEIsb0JBQW9CO0FBQ0csOEJBQWMsR0FBRyxTQUFTLENBQUMiLCJzb3VyY2VzQ29udGVudCI6WyIvLyBodHRwczovL3d3dy50ZXJyYWZvcm0uaW8vZG9jcy9wcm92aWRlcnMvYXp1cmVybVxuLy8gZ2VuZXJhdGVkIGZyb20gdGVycmFmb3JtIHJlc291cmNlIHNjaGVtYVxuXG5pbXBvcnQgeyBDb25zdHJ1Y3QgfSBmcm9tICdjb25zdHJ1Y3RzJztcbmltcG9ydCAqIGFzIGNka3RmIGZyb20gJ2Nka3RmJztcblxuLy8gQ29uZmlndXJhdGlvblxuXG5leHBvcnQgaW50ZXJmYWNlIEF6dXJlcm1Qcm92aWRlckNvbmZpZyB7XG4gIC8qKlxuICAqIERvY3MgYXQgVGVycmFmb3JtIFJlZ2lzdHJ5OiB7QGxpbmsgaHR0cHM6Ly93d3cudGVycmFmb3JtLmlvL2RvY3MvcHJvdmlkZXJzL2F6dXJlcm0jYXV4aWxpYXJ5X3RlbmFudF9pZHMgQXp1cmVybVByb3ZpZGVyI2F1eGlsaWFyeV90ZW5hbnRfaWRzfVxuICAqL1xuICByZWFkb25seSBhdXhpbGlhcnlUZW5hbnRJZHM/OiBzdHJpbmdbXTtcbiAgLyoqXG4gICogVGhlIHBhc3N3b3JkIGFzc29jaWF0ZWQgd2l0aCB0aGUgQ2xpZW50IENlcnRpZmljYXRlLiBGb3IgdXNlIHdoZW4gYXV0aGVudGljYXRpbmcgYXMgYSBTZXJ2aWNlIFByaW5jaXBhbCB1c2luZyBhIENsaWVudCBDZXJ0aWZpY2F0ZVxuICAqIFxuICAqIERvY3MgYXQgVGVycmFmb3JtIFJlZ2lzdHJ5OiB7QGxpbmsgaHR0cHM6Ly93d3cudGVycmFmb3JtLmlvL2RvY3MvcHJvdmlkZXJzL2F6dXJlcm0jY2xpZW50X2NlcnRpZmljYXRlX3Bhc3N3b3JkIEF6dXJlcm1Qcm92aWRlciNjbGllbnRfY2VydGlmaWNhdGVfcGFzc3dvcmR9XG4gICovXG4gIHJlYWRvbmx5IGNsaWVudENlcnRpZmljYXRlUGFzc3dvcmQ/OiBzdHJpbmc7XG4gIC8qKlxuICAqIFRoZSBwYXRoIHRvIHRoZSBDbGllbnQgQ2VydGlmaWNhdGUgYXNzb2NpYXRlZCB3aXRoIHRoZSBTZXJ2aWNlIFByaW5jaXBhbCBmb3IgdXNlIHdoZW4gYXV0aGVudGljYXRpbmcgYXMgYSBTZXJ2aWNlIFByaW5jaXBhbCB1c2luZyBhIENsaWVudCBDZXJ0aWZpY2F0ZS5cbiAgKiBcbiAgKiBEb2NzIGF0IFRlcnJhZm9ybSBSZWdpc3RyeToge0BsaW5rIGh0dHBzOi8vd3d3LnRlcnJhZm9ybS5pby9kb2NzL3Byb3ZpZGVycy9henVyZXJtI2NsaWVudF9jZXJ0aWZpY2F0ZV9wYXRoIEF6dXJlcm1Qcm92aWRlciNjbGllbnRfY2VydGlmaWNhdGVfcGF0aH1cbiAgKi9cbiAgcmVhZG9ubHkgY2xpZW50Q2VydGlmaWNhdGVQYXRoPzogc3RyaW5nO1xuICAvKipcbiAgKiBUaGUgQ2xpZW50IElEIHdoaWNoIHNob3VsZCBiZSB1c2VkLlxuICAqIFxuICAqIERvY3MgYXQgVGVycmFmb3JtIFJlZ2lzdHJ5OiB7QGxpbmsgaHR0cHM6Ly93d3cudGVycmFmb3JtLmlvL2RvY3MvcHJvdmlkZXJzL2F6dXJlcm0jY2xpZW50X2lkIEF6dXJlcm1Qcm92aWRlciNjbGllbnRfaWR9XG4gICovXG4gIHJlYWRvbmx5IGNsaWVudElkPzogc3RyaW5nO1xuICAvKipcbiAgKiBUaGUgQ2xpZW50IFNlY3JldCB3aGljaCBzaG91bGQgYmUgdXNlZC4gRm9yIHVzZSBXaGVuIGF1dGhlbnRpY2F0aW5nIGFzIGEgU2VydmljZSBQcmluY2lwYWwgdXNpbmcgYSBDbGllbnQgU2VjcmV0LlxuICAqIFxuICAqIERvY3MgYXQgVGVycmFmb3JtIFJlZ2lzdHJ5OiB7QGxpbmsgaHR0cHM6Ly93d3cudGVycmFmb3JtLmlvL2RvY3MvcHJvdmlkZXJzL2F6dXJlcm0jY2xpZW50X3NlY3JldCBBenVyZXJtUHJvdmlkZXIjY2xpZW50X3NlY3JldH1cbiAgKi9cbiAgcmVhZG9ubHkgY2xpZW50U2VjcmV0Pzogc3RyaW5nO1xuICAvKipcbiAgKiBUaGlzIHdpbGwgZGlzYWJsZSB0aGUgeC1tcy1jb3JyZWxhdGlvbi1yZXF1ZXN0LWlkIGhlYWRlci5cbiAgKiBcbiAgKiBEb2NzIGF0IFRlcnJhZm9ybSBSZWdpc3RyeToge0BsaW5rIGh0dHBzOi8vd3d3LnRlcnJhZm9ybS5pby9kb2NzL3Byb3ZpZGVycy9henVyZXJtI2Rpc2FibGVfY29ycmVsYXRpb25fcmVxdWVzdF9pZCBBenVyZXJtUHJvdmlkZXIjZGlzYWJsZV9jb3JyZWxhdGlvbl9yZXF1ZXN0X2lkfVxuICAqL1xuICByZWFkb25seSBkaXNhYmxlQ29ycmVsYXRpb25SZXF1ZXN0SWQ/OiBib29sZWFuIHwgY2RrdGYuSVJlc29sdmFibGU7XG4gIC8qKlxuICAqIFRoaXMgd2lsbCBkaXNhYmxlIHRoZSBUZXJyYWZvcm0gUGFydG5lciBJRCB3aGljaCBpcyB1c2VkIGlmIGEgY3VzdG9tIGBwYXJ0bmVyX2lkYCBpc24ndCBzcGVjaWZpZWQuXG4gICogXG4gICogRG9jcyBhdCBUZXJyYWZvcm0gUmVnaXN0cnk6IHtAbGluayBodHRwczovL3d3dy50ZXJyYWZvcm0uaW8vZG9jcy9wcm92aWRlcnMvYXp1cmVybSNkaXNhYmxlX3RlcnJhZm9ybV9wYXJ0bmVyX2lkIEF6dXJlcm1Qcm92aWRlciNkaXNhYmxlX3RlcnJhZm9ybV9wYXJ0bmVyX2lkfVxuICAqL1xuICByZWFkb25seSBkaXNhYmxlVGVycmFmb3JtUGFydG5lcklkPzogYm9vbGVhbiB8IGNka3RmLklSZXNvbHZhYmxlO1xuICAvKipcbiAgKiBUaGUgQ2xvdWQgRW52aXJvbm1lbnQgd2hpY2ggc2hvdWxkIGJlIHVzZWQuIFBvc3NpYmxlIHZhbHVlcyBhcmUgcHVibGljLCB1c2dvdmVybm1lbnQsIGFuZCBjaGluYS4gRGVmYXVsdHMgdG8gcHVibGljLlxuICAqIFxuICAqIERvY3MgYXQgVGVycmFmb3JtIFJlZ2lzdHJ5OiB7QGxpbmsgaHR0cHM6Ly93d3cudGVycmFmb3JtLmlvL2RvY3MvcHJvdmlkZXJzL2F6dXJlcm0jZW52aXJvbm1lbnQgQXp1cmVybVByb3ZpZGVyI2Vudmlyb25tZW50fVxuICAqL1xuICByZWFkb25seSBlbnZpcm9ubWVudD86IHN0cmluZztcbiAgLyoqXG4gICogVGhlIEhvc3RuYW1lIHdoaWNoIHNob3VsZCBiZSB1c2VkIGZvciB0aGUgQXp1cmUgTWV0YWRhdGEgU2VydmljZS5cbiAgKiBcbiAgKiBEb2NzIGF0IFRlcnJhZm9ybSBSZWdpc3RyeToge0BsaW5rIGh0dHBzOi8vd3d3LnRlcnJhZm9ybS5pby9kb2NzL3Byb3ZpZGVycy9henVyZXJtI21ldGFkYXRhX2hvc3QgQXp1cmVybVByb3ZpZGVyI21ldGFkYXRhX2hvc3R9XG4gICovXG4gIHJlYWRvbmx5IG1ldGFkYXRhSG9zdD86IHN0cmluZztcbiAgLyoqXG4gICogVGhlIHBhdGggdG8gYSBjdXN0b20gZW5kcG9pbnQgZm9yIE1hbmFnZWQgU2VydmljZSBJZGVudGl0eSAtIGluIG1vc3QgY2lyY3Vtc3RhbmNlcyB0aGlzIHNob3VsZCBiZSBkZXRlY3RlZCBhdXRvbWF0aWNhbGx5LiBcbiAgKiBcbiAgKiBEb2NzIGF0IFRlcnJhZm9ybSBSZWdpc3RyeToge0BsaW5rIGh0dHBzOi8vd3d3LnRlcnJhZm9ybS5pby9kb2NzL3Byb3ZpZGVycy9henVyZXJtI21zaV9lbmRwb2ludCBBenVyZXJtUHJvdmlkZXIjbXNpX2VuZHBvaW50fVxuICAqL1xuICByZWFkb25seSBtc2lFbmRwb2ludD86IHN0cmluZztcbiAgLyoqXG4gICogVGhlIGJlYXJlciB0b2tlbiBmb3IgdGhlIHJlcXVlc3QgdG8gdGhlIE9JREMgcHJvdmlkZXIuIEZvciB1c2Ugd2hlbiBhdXRoZW50aWNhdGluZyBhcyBhIFNlcnZpY2UgUHJpbmNpcGFsIHVzaW5nIE9wZW5JRCBDb25uZWN0LlxuICAqIFxuICAqIERvY3MgYXQgVGVycmFmb3JtIFJlZ2lzdHJ5OiB7QGxpbmsgaHR0cHM6Ly93d3cudGVycmFmb3JtLmlvL2RvY3MvcHJvdmlkZXJzL2F6dXJlcm0jb2lkY19yZXF1ZXN0X3Rva2VuIEF6dXJlcm1Qcm92aWRlciNvaWRjX3JlcXVlc3RfdG9rZW59XG4gICovXG4gIHJlYWRvbmx5IG9pZGNSZXF1ZXN0VG9rZW4/OiBzdHJpbmc7XG4gIC8qKlxuICAqIFRoZSBVUkwgZm9yIHRoZSBPSURDIHByb3ZpZGVyIGZyb20gd2hpY2ggdG8gcmVxdWVzdCBhbiBJRCB0b2tlbi4gRm9yIHVzZSB3aGVuIGF1dGhlbnRpY2F0aW5nIGFzIGEgU2VydmljZSBQcmluY2lwYWwgdXNpbmcgT3BlbklEIENvbm5lY3QuXG4gICogXG4gICogRG9jcyBhdCBUZXJyYWZvcm0gUmVnaXN0cnk6IHtAbGluayBodHRwczovL3d3dy50ZXJyYWZvcm0uaW8vZG9jcy9wcm92aWRlcnMvYXp1cmVybSNvaWRjX3JlcXVlc3RfdXJsIEF6dXJlcm1Qcm92aWRlciNvaWRjX3JlcXVlc3RfdXJsfVxuICAqL1xuICByZWFkb25seSBvaWRjUmVxdWVzdFVybD86IHN0cmluZztcbiAgLyoqXG4gICogVGhlIE9JREMgSUQgdG9rZW4gZm9yIHVzZSB3aGVuIGF1dGhlbnRpY2F0aW5nIGFzIGEgU2VydmljZSBQcmluY2lwYWwgdXNpbmcgT3BlbklEIENvbm5lY3QuXG4gICogXG4gICogRG9jcyBhdCBUZXJyYWZvcm0gUmVnaXN0cnk6IHtAbGluayBodHRwczovL3d3dy50ZXJyYWZvcm0uaW8vZG9jcy9wcm92aWRlcnMvYXp1cmVybSNvaWRjX3Rva2VuIEF6dXJlcm1Qcm92aWRlciNvaWRjX3Rva2VufVxuICAqL1xuICByZWFkb25seSBvaWRjVG9rZW4/OiBzdHJpbmc7XG4gIC8qKlxuICAqIEEgR1VJRC9VVUlEIHRoYXQgaXMgcmVnaXN0ZXJlZCB3aXRoIE1pY3Jvc29mdCB0byBmYWNpbGl0YXRlIHBhcnRuZXIgcmVzb3VyY2UgdXNhZ2UgYXR0cmlidXRpb24uXG4gICogXG4gICogRG9jcyBhdCBUZXJyYWZvcm0gUmVnaXN0cnk6IHtAbGluayBodHRwczovL3d3dy50ZXJyYWZvcm0uaW8vZG9jcy9wcm92aWRlcnMvYXp1cmVybSNwYXJ0bmVyX2lkIEF6dXJlcm1Qcm92aWRlciNwYXJ0bmVyX2lkfVxuICAqL1xuICByZWFkb25seSBwYXJ0bmVySWQ/OiBzdHJpbmc7XG4gIC8qKlxuICAqIFNob3VsZCB0aGUgQXp1cmVSTSBQcm92aWRlciBza2lwIHJlZ2lzdGVyaW5nIGFsbCBvZiB0aGUgUmVzb3VyY2UgUHJvdmlkZXJzIHRoYXQgaXQgc3VwcG9ydHMsIGlmIHRoZXkncmUgbm90IGFscmVhZHkgcmVnaXN0ZXJlZD9cbiAgKiBcbiAgKiBEb2NzIGF0IFRlcnJhZm9ybSBSZWdpc3RyeToge0BsaW5rIGh0dHBzOi8vd3d3LnRlcnJhZm9ybS5pby9kb2NzL3Byb3ZpZGVycy9henVyZXJtI3NraXBfcHJvdmlkZXJfcmVnaXN0cmF0aW9uIEF6dXJlcm1Qcm92aWRlciNza2lwX3Byb3ZpZGVyX3JlZ2lzdHJhdGlvbn1cbiAgKi9cbiAgcmVhZG9ubHkgc2tpcFByb3ZpZGVyUmVnaXN0cmF0aW9uPzogYm9vbGVhbiB8IGNka3RmLklSZXNvbHZhYmxlO1xuICAvKipcbiAgKiBTaG91bGQgdGhlIEF6dXJlUk0gUHJvdmlkZXIgdXNlIEF6dXJlQUQgdG8gYWNjZXNzIHRoZSBTdG9yYWdlIERhdGEgUGxhbmUgQVBJJ3M/XG4gICogXG4gICogRG9jcyBhdCBUZXJyYWZvcm0gUmVnaXN0cnk6IHtAbGluayBodHRwczovL3d3dy50ZXJyYWZvcm0uaW8vZG9jcy9wcm92aWRlcnMvYXp1cmVybSNzdG9yYWdlX3VzZV9henVyZWFkIEF6dXJlcm1Qcm92aWRlciNzdG9yYWdlX3VzZV9henVyZWFkfVxuICAqL1xuICByZWFkb25seSBzdG9yYWdlVXNlQXp1cmVhZD86IGJvb2xlYW4gfCBjZGt0Zi5JUmVzb2x2YWJsZTtcbiAgLyoqXG4gICogVGhlIFN1YnNjcmlwdGlvbiBJRCB3aGljaCBzaG91bGQgYmUgdXNlZC5cbiAgKiBcbiAgKiBEb2NzIGF0IFRlcnJhZm9ybSBSZWdpc3RyeToge0BsaW5rIGh0dHBzOi8vd3d3LnRlcnJhZm9ybS5pby9kb2NzL3Byb3ZpZGVycy9henVyZXJtI3N1YnNjcmlwdGlvbl9pZCBBenVyZXJtUHJvdmlkZXIjc3Vic2NyaXB0aW9uX2lkfVxuICAqL1xuICByZWFkb25seSBzdWJzY3JpcHRpb25JZD86IHN0cmluZztcbiAgLyoqXG4gICogVGhlIFRlbmFudCBJRCB3aGljaCBzaG91bGQgYmUgdXNlZC5cbiAgKiBcbiAgKiBEb2NzIGF0IFRlcnJhZm9ybSBSZWdpc3RyeToge0BsaW5rIGh0dHBzOi8vd3d3LnRlcnJhZm9ybS5pby9kb2NzL3Byb3ZpZGVycy9henVyZXJtI3RlbmFudF9pZCBBenVyZXJtUHJvdmlkZXIjdGVuYW50X2lkfVxuICAqL1xuICByZWFkb25seSB0ZW5hbnRJZD86IHN0cmluZztcbiAgLyoqXG4gICogQWxsb3dlZCBNYW5hZ2VkIFNlcnZpY2UgSWRlbnRpdHkgYmUgdXNlZCBmb3IgQXV0aGVudGljYXRpb24uXG4gICogXG4gICogRG9jcyBhdCBUZXJyYWZvcm0gUmVnaXN0cnk6IHtAbGluayBodHRwczovL3d3dy50ZXJyYWZvcm0uaW8vZG9jcy9wcm92aWRlcnMvYXp1cmVybSN1c2VfbXNpIEF6dXJlcm1Qcm92aWRlciN1c2VfbXNpfVxuICAqL1xuICByZWFkb25seSB1c2VNc2k/OiBib29sZWFuIHwgY2RrdGYuSVJlc29sdmFibGU7XG4gIC8qKlxuICAqIEFsbG93IE9wZW5JRCBDb25uZWN0IHRvIGJlIHVzZWQgZm9yIGF1dGhlbnRpY2F0aW9uXG4gICogXG4gICogRG9jcyBhdCBUZXJyYWZvcm0gUmVnaXN0cnk6IHtAbGluayBodHRwczovL3d3dy50ZXJyYWZvcm0uaW8vZG9jcy9wcm92aWRlcnMvYXp1cmVybSN1c2Vfb2lkYyBBenVyZXJtUHJvdmlkZXIjdXNlX29pZGN9XG4gICovXG4gIHJlYWRvbmx5IHVzZU9pZGM/OiBib29sZWFuIHwgY2RrdGYuSVJlc29sdmFibGU7XG4gIC8qKlxuICAqIEFsaWFzIG5hbWVcbiAgKiBcbiAgKiBEb2NzIGF0IFRlcnJhZm9ybSBSZWdpc3RyeToge0BsaW5rIGh0dHBzOi8vd3d3LnRlcnJhZm9ybS5pby9kb2NzL3Byb3ZpZGVycy9henVyZXJtI2FsaWFzIEF6dXJlcm1Qcm92aWRlciNhbGlhc31cbiAgKi9cbiAgcmVhZG9ubHkgYWxpYXM/OiBzdHJpbmc7XG4gIC8qKlxuICAqIGZlYXR1cmVzIGJsb2NrXG4gICogXG4gICogRG9jcyBhdCBUZXJyYWZvcm0gUmVnaXN0cnk6IHtAbGluayBodHRwczovL3d3dy50ZXJyYWZvcm0uaW8vZG9jcy9wcm92aWRlcnMvYXp1cmVybSNmZWF0dXJlcyBBenVyZXJtUHJvdmlkZXIjZmVhdHVyZXN9XG4gICovXG4gIHJlYWRvbmx5IGZlYXR1cmVzOiBBenVyZXJtUHJvdmlkZXJGZWF0dXJlcztcbn1cbmV4cG9ydCBpbnRlcmZhY2UgQXp1cmVybVByb3ZpZGVyRmVhdHVyZXNBcGlNYW5hZ2VtZW50IHtcbiAgLyoqXG4gICogRG9jcyBhdCBUZXJyYWZvcm0gUmVnaXN0cnk6IHtAbGluayBodHRwczovL3d3dy50ZXJyYWZvcm0uaW8vZG9jcy9wcm92aWRlcnMvYXp1cmVybSNwdXJnZV9zb2Z0X2RlbGV0ZV9vbl9kZXN0cm95IEF6dXJlcm1Qcm92aWRlciNwdXJnZV9zb2Z0X2RlbGV0ZV9vbl9kZXN0cm95fVxuICAqL1xuICByZWFkb25seSBwdXJnZVNvZnREZWxldGVPbkRlc3Ryb3k/OiBib29sZWFuIHwgY2RrdGYuSVJlc29sdmFibGU7XG4gIC8qKlxuICAqIERvY3MgYXQgVGVycmFmb3JtIFJlZ2lzdHJ5OiB7QGxpbmsgaHR0cHM6Ly93d3cudGVycmFmb3JtLmlvL2RvY3MvcHJvdmlkZXJzL2F6dXJlcm0jcmVjb3Zlcl9zb2Z0X2RlbGV0ZWQgQXp1cmVybVByb3ZpZGVyI3JlY292ZXJfc29mdF9kZWxldGVkfVxuICAqL1xuICByZWFkb25seSByZWNvdmVyU29mdERlbGV0ZWQ/OiBib29sZWFuIHwgY2RrdGYuSVJlc29sdmFibGU7XG59XG5cbmV4cG9ydCBmdW5jdGlvbiBhenVyZXJtUHJvdmlkZXJGZWF0dXJlc0FwaU1hbmFnZW1lbnRUb1RlcnJhZm9ybShzdHJ1Y3Q/OiBBenVyZXJtUHJvdmlkZXJGZWF0dXJlc0FwaU1hbmFnZW1lbnQpOiBhbnkge1xuICBpZiAoIWNka3RmLmNhbkluc3BlY3Qoc3RydWN0KSB8fCBjZGt0Zi5Ub2tlbml6YXRpb24uaXNSZXNvbHZhYmxlKHN0cnVjdCkpIHsgcmV0dXJuIHN0cnVjdDsgfVxuICBpZiAoY2RrdGYuaXNDb21wbGV4RWxlbWVudChzdHJ1Y3QpKSB7XG4gICAgdGhyb3cgbmV3IEVycm9yKFwiQSBjb21wbGV4IGVsZW1lbnQgd2FzIHVzZWQgYXMgY29uZmlndXJhdGlvbiwgdGhpcyBpcyBub3Qgc3VwcG9ydGVkOiBodHRwczovL2Nkay50Zi9jb21wbGV4LW9iamVjdC1hcy1jb25maWd1cmF0aW9uXCIpO1xuICB9XG4gIHJldHVybiB7XG4gICAgcHVyZ2Vfc29mdF9kZWxldGVfb25fZGVzdHJveTogY2RrdGYuYm9vbGVhblRvVGVycmFmb3JtKHN0cnVjdCEucHVyZ2VTb2Z0RGVsZXRlT25EZXN0cm95KSxcbiAgICByZWNvdmVyX3NvZnRfZGVsZXRlZDogY2RrdGYuYm9vbGVhblRvVGVycmFmb3JtKHN0cnVjdCEucmVjb3ZlclNvZnREZWxldGVkKSxcbiAgfVxufVxuXG5leHBvcnQgaW50ZXJmYWNlIEF6dXJlcm1Qcm92aWRlckZlYXR1cmVzQXBwbGljYXRpb25JbnNpZ2h0cyB7XG4gIC8qKlxuICAqIERvY3MgYXQgVGVycmFmb3JtIFJlZ2lzdHJ5OiB7QGxpbmsgaHR0cHM6Ly93d3cudGVycmFmb3JtLmlvL2RvY3MvcHJvdmlkZXJzL2F6dXJlcm0jZGlzYWJsZV9nZW5lcmF0ZWRfcnVsZSBBenVyZXJtUHJvdmlkZXIjZGlzYWJsZV9nZW5lcmF0ZWRfcnVsZX1cbiAgKi9cbiAgcmVhZG9ubHkgZGlzYWJsZUdlbmVyYXRlZFJ1bGU/OiBib29sZWFuIHwgY2RrdGYuSVJlc29sdmFibGU7XG59XG5cbmV4cG9ydCBmdW5jdGlvbiBhenVyZXJtUHJvdmlkZXJGZWF0dXJlc0FwcGxpY2F0aW9uSW5zaWdodHNUb1RlcnJhZm9ybShzdHJ1Y3Q/OiBBenVyZXJtUHJvdmlkZXJGZWF0dXJlc0FwcGxpY2F0aW9uSW5zaWdodHMpOiBhbnkge1xuICBpZiAoIWNka3RmLmNhbkluc3BlY3Qoc3RydWN0KSB8fCBjZGt0Zi5Ub2tlbml6YXRpb24uaXNSZXNvbHZhYmxlKHN0cnVjdCkpIHsgcmV0dXJuIHN0cnVjdDsgfVxuICBpZiAoY2RrdGYuaXNDb21wbGV4RWxlbWVudChzdHJ1Y3QpKSB7XG4gICAgdGhyb3cgbmV3IEVycm9yKFwiQSBjb21wbGV4IGVsZW1lbnQgd2FzIHVzZWQgYXMgY29uZmlndXJhdGlvbiwgdGhpcyBpcyBub3Qgc3VwcG9ydGVkOiBodHRwczovL2Nkay50Zi9jb21wbGV4LW9iamVjdC1hcy1jb25maWd1cmF0aW9uXCIpO1xuICB9XG4gIHJldHVybiB7XG4gICAgZGlzYWJsZV9nZW5lcmF0ZWRfcnVsZTogY2RrdGYuYm9vbGVhblRvVGVycmFmb3JtKHN0cnVjdCEuZGlzYWJsZUdlbmVyYXRlZFJ1bGUpLFxuICB9XG59XG5cbmV4cG9ydCBpbnRlcmZhY2UgQXp1cmVybVByb3ZpZGVyRmVhdHVyZXNDb2duaXRpdmVBY2NvdW50IHtcbiAgLyoqXG4gICogRG9jcyBhdCBUZXJyYWZvcm0gUmVnaXN0cnk6IHtAbGluayBodHRwczovL3d3dy50ZXJyYWZvcm0uaW8vZG9jcy9wcm92aWRlcnMvYXp1cmVybSNwdXJnZV9zb2Z0X2RlbGV0ZV9vbl9kZXN0cm95IEF6dXJlcm1Qcm92aWRlciNwdXJnZV9zb2Z0X2RlbGV0ZV9vbl9kZXN0cm95fVxuICAqL1xuICByZWFkb25seSBwdXJnZVNvZnREZWxldGVPbkRlc3Ryb3k/OiBib29sZWFuIHwgY2RrdGYuSVJlc29sdmFibGU7XG59XG5cbmV4cG9ydCBmdW5jdGlvbiBhenVyZXJtUHJvdmlkZXJGZWF0dXJlc0NvZ25pdGl2ZUFjY291bnRUb1RlcnJhZm9ybShzdHJ1Y3Q/OiBBenVyZXJtUHJvdmlkZXJGZWF0dXJlc0NvZ25pdGl2ZUFjY291bnQpOiBhbnkge1xuICBpZiAoIWNka3RmLmNhbkluc3BlY3Qoc3RydWN0KSB8fCBjZGt0Zi5Ub2tlbml6YXRpb24uaXNSZXNvbHZhYmxlKHN0cnVjdCkpIHsgcmV0dXJuIHN0cnVjdDsgfVxuICBpZiAoY2RrdGYuaXNDb21wbGV4RWxlbWVudChzdHJ1Y3QpKSB7XG4gICAgdGhyb3cgbmV3IEVycm9yKFwiQSBjb21wbGV4IGVsZW1lbnQgd2FzIHVzZWQgYXMgY29uZmlndXJhdGlvbiwgdGhpcyBpcyBub3Qgc3VwcG9ydGVkOiBodHRwczovL2Nkay50Zi9jb21wbGV4LW9iamVjdC1hcy1jb25maWd1cmF0aW9uXCIpO1xuICB9XG4gIHJldHVybiB7XG4gICAgcHVyZ2Vfc29mdF9kZWxldGVfb25fZGVzdHJveTogY2RrdGYuYm9vbGVhblRvVGVycmFmb3JtKHN0cnVjdCEucHVyZ2VTb2Z0RGVsZXRlT25EZXN0cm95KSxcbiAgfVxufVxuXG5leHBvcnQgaW50ZXJmYWNlIEF6dXJlcm1Qcm92aWRlckZlYXR1cmVzS2V5VmF1bHQge1xuICAvKipcbiAgKiBXaGVuIGVuYWJsZWQgc29mdC1kZWxldGVkIGBhenVyZXJtX2tleV92YXVsdGAgcmVzb3VyY2VzIHdpbGwgYmUgcGVybWFuZW50bHkgZGVsZXRlZCAoZS5nIHB1cmdlZCksIHdoZW4gZGVzdHJveWVkXG4gICogXG4gICogRG9jcyBhdCBUZXJyYWZvcm0gUmVnaXN0cnk6IHtAbGluayBodHRwczovL3d3dy50ZXJyYWZvcm0uaW8vZG9jcy9wcm92aWRlcnMvYXp1cmVybSNwdXJnZV9zb2Z0X2RlbGV0ZV9vbl9kZXN0cm95IEF6dXJlcm1Qcm92aWRlciNwdXJnZV9zb2Z0X2RlbGV0ZV9vbl9kZXN0cm95fVxuICAqL1xuICByZWFkb25seSBwdXJnZVNvZnREZWxldGVPbkRlc3Ryb3k/OiBib29sZWFuIHwgY2RrdGYuSVJlc29sdmFibGU7XG4gIC8qKlxuICAqIFdoZW4gZW5hYmxlZCBzb2Z0LWRlbGV0ZWQgYGF6dXJlcm1fa2V5X3ZhdWx0X2NlcnRpZmljYXRlYCByZXNvdXJjZXMgd2lsbCBiZSBwZXJtYW5lbnRseSBkZWxldGVkIChlLmcgcHVyZ2VkKSwgd2hlbiBkZXN0cm95ZWRcbiAgKiBcbiAgKiBEb2NzIGF0IFRlcnJhZm9ybSBSZWdpc3RyeToge0BsaW5rIGh0dHBzOi8vd3d3LnRlcnJhZm9ybS5pby9kb2NzL3Byb3ZpZGVycy9henVyZXJtI3B1cmdlX3NvZnRfZGVsZXRlZF9jZXJ0aWZpY2F0ZXNfb25fZGVzdHJveSBBenVyZXJtUHJvdmlkZXIjcHVyZ2Vfc29mdF9kZWxldGVkX2NlcnRpZmljYXRlc19vbl9kZXN0cm95fVxuICAqL1xuICByZWFkb25seSBwdXJnZVNvZnREZWxldGVkQ2VydGlmaWNhdGVzT25EZXN0cm95PzogYm9vbGVhbiB8IGNka3RmLklSZXNvbHZhYmxlO1xuICAvKipcbiAgKiBXaGVuIGVuYWJsZWQgc29mdC1kZWxldGVkIGBhenVyZXJtX2tleV92YXVsdF9tYW5hZ2VkX2hhcmR3YXJlX3NlY3VyaXR5X21vZHVsZWAgcmVzb3VyY2VzIHdpbGwgYmUgcGVybWFuZW50bHkgZGVsZXRlZCAoZS5nIHB1cmdlZCksIHdoZW4gZGVzdHJveWVkXG4gICogXG4gICogRG9jcyBhdCBUZXJyYWZvcm0gUmVnaXN0cnk6IHtAbGluayBodHRwczovL3d3dy50ZXJyYWZvcm0uaW8vZG9jcy9wcm92aWRlcnMvYXp1cmVybSNwdXJnZV9zb2Z0X2RlbGV0ZWRfaGFyZHdhcmVfc2VjdXJpdHlfbW9kdWxlc19vbl9kZXN0cm95IEF6dXJlcm1Qcm92aWRlciNwdXJnZV9zb2Z0X2RlbGV0ZWRfaGFyZHdhcmVfc2VjdXJpdHlfbW9kdWxlc19vbl9kZXN0cm95fVxuICAqL1xuICByZWFkb25seSBwdXJnZVNvZnREZWxldGVkSGFyZHdhcmVTZWN1cml0eU1vZHVsZXNPbkRlc3Ryb3k/OiBib29sZWFuIHwgY2RrdGYuSVJlc29sdmFibGU7XG4gIC8qKlxuICAqIFdoZW4gZW5hYmxlZCBzb2Z0LWRlbGV0ZWQgYGF6dXJlcm1fa2V5X3ZhdWx0X2tleWAgcmVzb3VyY2VzIHdpbGwgYmUgcGVybWFuZW50bHkgZGVsZXRlZCAoZS5nIHB1cmdlZCksIHdoZW4gZGVzdHJveWVkXG4gICogXG4gICogRG9jcyBhdCBUZXJyYWZvcm0gUmVnaXN0cnk6IHtAbGluayBodHRwczovL3d3dy50ZXJyYWZvcm0uaW8vZG9jcy9wcm92aWRlcnMvYXp1cmVybSNwdXJnZV9zb2Z0X2RlbGV0ZWRfa2V5c19vbl9kZXN0cm95IEF6dXJlcm1Qcm92aWRlciNwdXJnZV9zb2Z0X2RlbGV0ZWRfa2V5c19vbl9kZXN0cm95fVxuICAqL1xuICByZWFkb25seSBwdXJnZVNvZnREZWxldGVkS2V5c09uRGVzdHJveT86IGJvb2xlYW4gfCBjZGt0Zi5JUmVzb2x2YWJsZTtcbiAgLyoqXG4gICogV2hlbiBlbmFibGVkIHNvZnQtZGVsZXRlZCBgYXp1cmVybV9rZXlfdmF1bHRfc2VjcmV0YCByZXNvdXJjZXMgd2lsbCBiZSBwZXJtYW5lbnRseSBkZWxldGVkIChlLmcgcHVyZ2VkKSwgd2hlbiBkZXN0cm95ZWRcbiAgKiBcbiAgKiBEb2NzIGF0IFRlcnJhZm9ybSBSZWdpc3RyeToge0BsaW5rIGh0dHBzOi8vd3d3LnRlcnJhZm9ybS5pby9kb2NzL3Byb3ZpZGVycy9henVyZXJtI3B1cmdlX3NvZnRfZGVsZXRlZF9zZWNyZXRzX29uX2Rlc3Ryb3kgQXp1cmVybVByb3ZpZGVyI3B1cmdlX3NvZnRfZGVsZXRlZF9zZWNyZXRzX29uX2Rlc3Ryb3l9XG4gICovXG4gIHJlYWRvbmx5IHB1cmdlU29mdERlbGV0ZWRTZWNyZXRzT25EZXN0cm95PzogYm9vbGVhbiB8IGNka3RmLklSZXNvbHZhYmxlO1xuICAvKipcbiAgKiBXaGVuIGVuYWJsZWQgc29mdC1kZWxldGVkIGBhenVyZXJtX2tleV92YXVsdF9jZXJ0aWZpY2F0ZWAgcmVzb3VyY2VzIHdpbGwgYmUgcmVzdG9yZWQsIGluc3RlYWQgb2YgY3JlYXRpbmcgbmV3IG9uZXNcbiAgKiBcbiAgKiBEb2NzIGF0IFRlcnJhZm9ybSBSZWdpc3RyeToge0BsaW5rIGh0dHBzOi8vd3d3LnRlcnJhZm9ybS5pby9kb2NzL3Byb3ZpZGVycy9henVyZXJtI3JlY292ZXJfc29mdF9kZWxldGVkX2NlcnRpZmljYXRlcyBBenVyZXJtUHJvdmlkZXIjcmVjb3Zlcl9zb2Z0X2RlbGV0ZWRfY2VydGlmaWNhdGVzfVxuICAqL1xuICByZWFkb25seSByZWNvdmVyU29mdERlbGV0ZWRDZXJ0aWZpY2F0ZXM/OiBib29sZWFuIHwgY2RrdGYuSVJlc29sdmFibGU7XG4gIC8qKlxuICAqIFdoZW4gZW5hYmxlZCBzb2Z0LWRlbGV0ZWQgYGF6dXJlcm1fa2V5X3ZhdWx0YCByZXNvdXJjZXMgd2lsbCBiZSByZXN0b3JlZCwgaW5zdGVhZCBvZiBjcmVhdGluZyBuZXcgb25lc1xuICAqIFxuICAqIERvY3MgYXQgVGVycmFmb3JtIFJlZ2lzdHJ5OiB7QGxpbmsgaHR0cHM6Ly93d3cudGVycmFmb3JtLmlvL2RvY3MvcHJvdmlkZXJzL2F6dXJlcm0jcmVjb3Zlcl9zb2Z0X2RlbGV0ZWRfa2V5X3ZhdWx0cyBBenVyZXJtUHJvdmlkZXIjcmVjb3Zlcl9zb2Z0X2RlbGV0ZWRfa2V5X3ZhdWx0c31cbiAgKi9cbiAgcmVhZG9ubHkgcmVjb3ZlclNvZnREZWxldGVkS2V5VmF1bHRzPzogYm9vbGVhbiB8IGNka3RmLklSZXNvbHZhYmxlO1xuICAvKipcbiAgKiBXaGVuIGVuYWJsZWQgc29mdC1kZWxldGVkIGBhenVyZXJtX2tleV92YXVsdF9rZXlgIHJlc291cmNlcyB3aWxsIGJlIHJlc3RvcmVkLCBpbnN0ZWFkIG9mIGNyZWF0aW5nIG5ldyBvbmVzXG4gICogXG4gICogRG9jcyBhdCBUZXJyYWZvcm0gUmVnaXN0cnk6IHtAbGluayBodHRwczovL3d3dy50ZXJyYWZvcm0uaW8vZG9jcy9wcm92aWRlcnMvYXp1cmVybSNyZWNvdmVyX3NvZnRfZGVsZXRlZF9rZXlzIEF6dXJlcm1Qcm92aWRlciNyZWNvdmVyX3NvZnRfZGVsZXRlZF9rZXlzfVxuICAqL1xuICByZWFkb25seSByZWNvdmVyU29mdERlbGV0ZWRLZXlzPzogYm9vbGVhbiB8IGNka3RmLklSZXNvbHZhYmxlO1xuICAvKipcbiAgKiBXaGVuIGVuYWJsZWQgc29mdC1kZWxldGVkIGBhenVyZXJtX2tleV92YXVsdF9zZWNyZXRgIHJlc291cmNlcyB3aWxsIGJlIHJlc3RvcmVkLCBpbnN0ZWFkIG9mIGNyZWF0aW5nIG5ldyBvbmVzXG4gICogXG4gICogRG9jcyBhdCBUZXJyYWZvcm0gUmVnaXN0cnk6IHtAbGluayBodHRwczovL3d3dy50ZXJyYWZvcm0uaW8vZG9jcy9wcm92aWRlcnMvYXp1cmVybSNyZWNvdmVyX3NvZnRfZGVsZXRlZF9zZWNyZXRzIEF6dXJlcm1Qcm92aWRlciNyZWNvdmVyX3NvZnRfZGVsZXRlZF9zZWNyZXRzfVxuICAqL1xuICByZWFkb25seSByZWNvdmVyU29mdERlbGV0ZWRTZWNyZXRzPzogYm9vbGVhbiB8IGNka3RmLklSZXNvbHZhYmxlO1xufVxuXG5leHBvcnQgZnVuY3Rpb24gYXp1cmVybVByb3ZpZGVyRmVhdHVyZXNLZXlWYXVsdFRvVGVycmFmb3JtKHN0cnVjdD86IEF6dXJlcm1Qcm92aWRlckZlYXR1cmVzS2V5VmF1bHQpOiBhbnkge1xuICBpZiAoIWNka3RmLmNhbkluc3BlY3Qoc3RydWN0KSB8fCBjZGt0Zi5Ub2tlbml6YXRpb24uaXNSZXNvbHZhYmxlKHN0cnVjdCkpIHsgcmV0dXJuIHN0cnVjdDsgfVxuICBpZiAoY2RrdGYuaXNDb21wbGV4RWxlbWVudChzdHJ1Y3QpKSB7XG4gICAgdGhyb3cgbmV3IEVycm9yKFwiQSBjb21wbGV4IGVsZW1lbnQgd2FzIHVzZWQgYXMgY29uZmlndXJhdGlvbiwgdGhpcyBpcyBub3Qgc3VwcG9ydGVkOiBodHRwczovL2Nkay50Zi9jb21wbGV4LW9iamVjdC1hcy1jb25maWd1cmF0aW9uXCIpO1xuICB9XG4gIHJldHVybiB7XG4gICAgcHVyZ2Vfc29mdF9kZWxldGVfb25fZGVzdHJveTogY2RrdGYuYm9vbGVhblRvVGVycmFmb3JtKHN0cnVjdCEucHVyZ2VTb2Z0RGVsZXRlT25EZXN0cm95KSxcbiAgICBwdXJnZV9zb2Z0X2RlbGV0ZWRfY2VydGlmaWNhdGVzX29uX2Rlc3Ryb3k6IGNka3RmLmJvb2xlYW5Ub1RlcnJhZm9ybShzdHJ1Y3QhLnB1cmdlU29mdERlbGV0ZWRDZXJ0aWZpY2F0ZXNPbkRlc3Ryb3kpLFxuICAgIHB1cmdlX3NvZnRfZGVsZXRlZF9oYXJkd2FyZV9zZWN1cml0eV9tb2R1bGVzX29uX2Rlc3Ryb3k6IGNka3RmLmJvb2xlYW5Ub1RlcnJhZm9ybShzdHJ1Y3QhLnB1cmdlU29mdERlbGV0ZWRIYXJkd2FyZVNlY3VyaXR5TW9kdWxlc09uRGVzdHJveSksXG4gICAgcHVyZ2Vfc29mdF9kZWxldGVkX2tleXNfb25fZGVzdHJveTogY2RrdGYuYm9vbGVhblRvVGVycmFmb3JtKHN0cnVjdCEucHVyZ2VTb2Z0RGVsZXRlZEtleXNPbkRlc3Ryb3kpLFxuICAgIHB1cmdlX3NvZnRfZGVsZXRlZF9zZWNyZXRzX29uX2Rlc3Ryb3k6IGNka3RmLmJvb2xlYW5Ub1RlcnJhZm9ybShzdHJ1Y3QhLnB1cmdlU29mdERlbGV0ZWRTZWNyZXRzT25EZXN0cm95KSxcbiAgICByZWNvdmVyX3NvZnRfZGVsZXRlZF9jZXJ0aWZpY2F0ZXM6IGNka3RmLmJvb2xlYW5Ub1RlcnJhZm9ybShzdHJ1Y3QhLnJlY292ZXJTb2Z0RGVsZXRlZENlcnRpZmljYXRlcyksXG4gICAgcmVjb3Zlcl9zb2Z0X2RlbGV0ZWRfa2V5X3ZhdWx0czogY2RrdGYuYm9vbGVhblRvVGVycmFmb3JtKHN0cnVjdCEucmVjb3ZlclNvZnREZWxldGVkS2V5VmF1bHRzKSxcbiAgICByZWNvdmVyX3NvZnRfZGVsZXRlZF9rZXlzOiBjZGt0Zi5ib29sZWFuVG9UZXJyYWZvcm0oc3RydWN0IS5yZWNvdmVyU29mdERlbGV0ZWRLZXlzKSxcbiAgICByZWNvdmVyX3NvZnRfZGVsZXRlZF9zZWNyZXRzOiBjZGt0Zi5ib29sZWFuVG9UZXJyYWZvcm0oc3RydWN0IS5yZWNvdmVyU29mdERlbGV0ZWRTZWNyZXRzKSxcbiAgfVxufVxuXG5leHBvcnQgaW50ZXJmYWNlIEF6dXJlcm1Qcm92aWRlckZlYXR1cmVzTG9nQW5hbHl0aWNzV29ya3NwYWNlIHtcbiAgLyoqXG4gICogRG9jcyBhdCBUZXJyYWZvcm0gUmVnaXN0cnk6IHtAbGluayBodHRwczovL3d3dy50ZXJyYWZvcm0uaW8vZG9jcy9wcm92aWRlcnMvYXp1cmVybSNwZXJtYW5lbnRseV9kZWxldGVfb25fZGVzdHJveSBBenVyZXJtUHJvdmlkZXIjcGVybWFuZW50bHlfZGVsZXRlX29uX2Rlc3Ryb3l9XG4gICovXG4gIHJlYWRvbmx5IHBlcm1hbmVudGx5RGVsZXRlT25EZXN0cm95PzogYm9vbGVhbiB8IGNka3RmLklSZXNvbHZhYmxlO1xufVxuXG5leHBvcnQgZnVuY3Rpb24gYXp1cmVybVByb3ZpZGVyRmVhdHVyZXNMb2dBbmFseXRpY3NXb3Jrc3BhY2VUb1RlcnJhZm9ybShzdHJ1Y3Q/OiBBenVyZXJtUHJvdmlkZXJGZWF0dXJlc0xvZ0FuYWx5dGljc1dvcmtzcGFjZSk6IGFueSB7XG4gIGlmICghY2RrdGYuY2FuSW5zcGVjdChzdHJ1Y3QpIHx8IGNka3RmLlRva2VuaXphdGlvbi5pc1Jlc29sdmFibGUoc3RydWN0KSkgeyByZXR1cm4gc3RydWN0OyB9XG4gIGlmIChjZGt0Zi5pc0NvbXBsZXhFbGVtZW50KHN0cnVjdCkpIHtcbiAgICB0aHJvdyBuZXcgRXJyb3IoXCJBIGNvbXBsZXggZWxlbWVudCB3YXMgdXNlZCBhcyBjb25maWd1cmF0aW9uLCB0aGlzIGlzIG5vdCBzdXBwb3J0ZWQ6IGh0dHBzOi8vY2RrLnRmL2NvbXBsZXgtb2JqZWN0LWFzLWNvbmZpZ3VyYXRpb25cIik7XG4gIH1cbiAgcmV0dXJuIHtcbiAgICBwZXJtYW5lbnRseV9kZWxldGVfb25fZGVzdHJveTogY2RrdGYuYm9vbGVhblRvVGVycmFmb3JtKHN0cnVjdCEucGVybWFuZW50bHlEZWxldGVPbkRlc3Ryb3kpLFxuICB9XG59XG5cbmV4cG9ydCBpbnRlcmZhY2UgQXp1cmVybVByb3ZpZGVyRmVhdHVyZXNOZXR3b3JrIHtcbiAgLyoqXG4gICogRG9jcyBhdCBUZXJyYWZvcm0gUmVnaXN0cnk6IHtAbGluayBodHRwczovL3d3dy50ZXJyYWZvcm0uaW8vZG9jcy9wcm92aWRlcnMvYXp1cmVybSNyZWxheGVkX2xvY2tpbmcgQXp1cmVybVByb3ZpZGVyI3JlbGF4ZWRfbG9ja2luZ31cbiAgKi9cbiAgcmVhZG9ubHkgcmVsYXhlZExvY2tpbmc6IGJvb2xlYW4gfCBjZGt0Zi5JUmVzb2x2YWJsZTtcbn1cblxuZXhwb3J0IGZ1bmN0aW9uIGF6dXJlcm1Qcm92aWRlckZlYXR1cmVzTmV0d29ya1RvVGVycmFmb3JtKHN0cnVjdD86IEF6dXJlcm1Qcm92aWRlckZlYXR1cmVzTmV0d29yayk6IGFueSB7XG4gIGlmICghY2RrdGYuY2FuSW5zcGVjdChzdHJ1Y3QpIHx8IGNka3RmLlRva2VuaXphdGlvbi5pc1Jlc29sdmFibGUoc3RydWN0KSkgeyByZXR1cm4gc3RydWN0OyB9XG4gIGlmIChjZGt0Zi5pc0NvbXBsZXhFbGVtZW50KHN0cnVjdCkpIHtcbiAgICB0aHJvdyBuZXcgRXJyb3IoXCJBIGNvbXBsZXggZWxlbWVudCB3YXMgdXNlZCBhcyBjb25maWd1cmF0aW9uLCB0aGlzIGlzIG5vdCBzdXBwb3J0ZWQ6IGh0dHBzOi8vY2RrLnRmL2NvbXBsZXgtb2JqZWN0LWFzLWNvbmZpZ3VyYXRpb25cIik7XG4gIH1cbiAgcmV0dXJuIHtcbiAgICByZWxheGVkX2xvY2tpbmc6IGNka3RmLmJvb2xlYW5Ub1RlcnJhZm9ybShzdHJ1Y3QhLnJlbGF4ZWRMb2NraW5nKSxcbiAgfVxufVxuXG5leHBvcnQgaW50ZXJmYWNlIEF6dXJlcm1Qcm92aWRlckZlYXR1cmVzUmVzb3VyY2VHcm91cCB7XG4gIC8qKlxuICAqIERvY3MgYXQgVGVycmFmb3JtIFJlZ2lzdHJ5OiB7QGxpbmsgaHR0cHM6Ly93d3cudGVycmFmb3JtLmlvL2RvY3MvcHJvdmlkZXJzL2F6dXJlcm0jcHJldmVudF9kZWxldGlvbl9pZl9jb250YWluc19yZXNvdXJjZXMgQXp1cmVybVByb3ZpZGVyI3ByZXZlbnRfZGVsZXRpb25faWZfY29udGFpbnNfcmVzb3VyY2VzfVxuICAqL1xuICByZWFkb25seSBwcmV2ZW50RGVsZXRpb25JZkNvbnRhaW5zUmVzb3VyY2VzPzogYm9vbGVhbiB8IGNka3RmLklSZXNvbHZhYmxlO1xufVxuXG5leHBvcnQgZnVuY3Rpb24gYXp1cmVybVByb3ZpZGVyRmVhdHVyZXNSZXNvdXJjZUdyb3VwVG9UZXJyYWZvcm0oc3RydWN0PzogQXp1cmVybVByb3ZpZGVyRmVhdHVyZXNSZXNvdXJjZUdyb3VwKTogYW55IHtcbiAgaWYgKCFjZGt0Zi5jYW5JbnNwZWN0KHN0cnVjdCkgfHwgY2RrdGYuVG9rZW5pemF0aW9uLmlzUmVzb2x2YWJsZShzdHJ1Y3QpKSB7IHJldHVybiBzdHJ1Y3Q7IH1cbiAgaWYgKGNka3RmLmlzQ29tcGxleEVsZW1lbnQoc3RydWN0KSkge1xuICAgIHRocm93IG5ldyBFcnJvcihcIkEgY29tcGxleCBlbGVtZW50IHdhcyB1c2VkIGFzIGNvbmZpZ3VyYXRpb24sIHRoaXMgaXMgbm90IHN1cHBvcnRlZDogaHR0cHM6Ly9jZGsudGYvY29tcGxleC1vYmplY3QtYXMtY29uZmlndXJhdGlvblwiKTtcbiAgfVxuICByZXR1cm4ge1xuICAgIHByZXZlbnRfZGVsZXRpb25faWZfY29udGFpbnNfcmVzb3VyY2VzOiBjZGt0Zi5ib29sZWFuVG9UZXJyYWZvcm0oc3RydWN0IS5wcmV2ZW50RGVsZXRpb25JZkNvbnRhaW5zUmVzb3VyY2VzKSxcbiAgfVxufVxuXG5leHBvcnQgaW50ZXJmYWNlIEF6dXJlcm1Qcm92aWRlckZlYXR1cmVzVGVtcGxhdGVEZXBsb3ltZW50IHtcbiAgLyoqXG4gICogRG9jcyBhdCBUZXJyYWZvcm0gUmVnaXN0cnk6IHtAbGluayBodHRwczovL3d3dy50ZXJyYWZvcm0uaW8vZG9jcy9wcm92aWRlcnMvYXp1cmVybSNkZWxldGVfbmVzdGVkX2l0ZW1zX2R1cmluZ19kZWxldGlvbiBBenVyZXJtUHJvdmlkZXIjZGVsZXRlX25lc3RlZF9pdGVtc19kdXJpbmdfZGVsZXRpb259XG4gICovXG4gIHJlYWRvbmx5IGRlbGV0ZU5lc3RlZEl0ZW1zRHVyaW5nRGVsZXRpb246IGJvb2xlYW4gfCBjZGt0Zi5JUmVzb2x2YWJsZTtcbn1cblxuZXhwb3J0IGZ1bmN0aW9uIGF6dXJlcm1Qcm92aWRlckZlYXR1cmVzVGVtcGxhdGVEZXBsb3ltZW50VG9UZXJyYWZvcm0oc3RydWN0PzogQXp1cmVybVByb3ZpZGVyRmVhdHVyZXNUZW1wbGF0ZURlcGxveW1lbnQpOiBhbnkge1xuICBpZiAoIWNka3RmLmNhbkluc3BlY3Qoc3RydWN0KSB8fCBjZGt0Zi5Ub2tlbml6YXRpb24uaXNSZXNvbHZhYmxlKHN0cnVjdCkpIHsgcmV0dXJuIHN0cnVjdDsgfVxuICBpZiAoY2RrdGYuaXNDb21wbGV4RWxlbWVudChzdHJ1Y3QpKSB7XG4gICAgdGhyb3cgbmV3IEVycm9yKFwiQSBjb21wbGV4IGVsZW1lbnQgd2FzIHVzZWQgYXMgY29uZmlndXJhdGlvbiwgdGhpcyBpcyBub3Qgc3VwcG9ydGVkOiBodHRwczovL2Nkay50Zi9jb21wbGV4LW9iamVjdC1hcy1jb25maWd1cmF0aW9uXCIpO1xuICB9XG4gIHJldHVybiB7XG4gICAgZGVsZXRlX25lc3RlZF9pdGVtc19kdXJpbmdfZGVsZXRpb246IGNka3RmLmJvb2xlYW5Ub1RlcnJhZm9ybShzdHJ1Y3QhLmRlbGV0ZU5lc3RlZEl0ZW1zRHVyaW5nRGVsZXRpb24pLFxuICB9XG59XG5cbmV4cG9ydCBpbnRlcmZhY2UgQXp1cmVybVByb3ZpZGVyRmVhdHVyZXNWaXJ0dWFsTWFjaGluZSB7XG4gIC8qKlxuICAqIERvY3MgYXQgVGVycmFmb3JtIFJlZ2lzdHJ5OiB7QGxpbmsgaHR0cHM6Ly93d3cudGVycmFmb3JtLmlvL2RvY3MvcHJvdmlkZXJzL2F6dXJlcm0jZGVsZXRlX29zX2Rpc2tfb25fZGVsZXRpb24gQXp1cmVybVByb3ZpZGVyI2RlbGV0ZV9vc19kaXNrX29uX2RlbGV0aW9ufVxuICAqL1xuICByZWFkb25seSBkZWxldGVPc0Rpc2tPbkRlbGV0aW9uPzogYm9vbGVhbiB8IGNka3RmLklSZXNvbHZhYmxlO1xuICAvKipcbiAgKiBEb2NzIGF0IFRlcnJhZm9ybSBSZWdpc3RyeToge0BsaW5rIGh0dHBzOi8vd3d3LnRlcnJhZm9ybS5pby9kb2NzL3Byb3ZpZGVycy9henVyZXJtI2dyYWNlZnVsX3NodXRkb3duIEF6dXJlcm1Qcm92aWRlciNncmFjZWZ1bF9zaHV0ZG93bn1cbiAgKi9cbiAgcmVhZG9ubHkgZ3JhY2VmdWxTaHV0ZG93bj86IGJvb2xlYW4gfCBjZGt0Zi5JUmVzb2x2YWJsZTtcbiAgLyoqXG4gICogRG9jcyBhdCBUZXJyYWZvcm0gUmVnaXN0cnk6IHtAbGluayBodHRwczovL3d3dy50ZXJyYWZvcm0uaW8vZG9jcy9wcm92aWRlcnMvYXp1cmVybSNza2lwX3NodXRkb3duX2FuZF9mb3JjZV9kZWxldGUgQXp1cmVybVByb3ZpZGVyI3NraXBfc2h1dGRvd25fYW5kX2ZvcmNlX2RlbGV0ZX1cbiAgKi9cbiAgcmVhZG9ubHkgc2tpcFNodXRkb3duQW5kRm9yY2VEZWxldGU/OiBib29sZWFuIHwgY2RrdGYuSVJlc29sdmFibGU7XG59XG5cbmV4cG9ydCBmdW5jdGlvbiBhenVyZXJtUHJvdmlkZXJGZWF0dXJlc1ZpcnR1YWxNYWNoaW5lVG9UZXJyYWZvcm0oc3RydWN0PzogQXp1cmVybVByb3ZpZGVyRmVhdHVyZXNWaXJ0dWFsTWFjaGluZSk6IGFueSB7XG4gIGlmICghY2RrdGYuY2FuSW5zcGVjdChzdHJ1Y3QpIHx8IGNka3RmLlRva2VuaXphdGlvbi5pc1Jlc29sdmFibGUoc3RydWN0KSkgeyByZXR1cm4gc3RydWN0OyB9XG4gIGlmIChjZGt0Zi5pc0NvbXBsZXhFbGVtZW50KHN0cnVjdCkpIHtcbiAgICB0aHJvdyBuZXcgRXJyb3IoXCJBIGNvbXBsZXggZWxlbWVudCB3YXMgdXNlZCBhcyBjb25maWd1cmF0aW9uLCB0aGlzIGlzIG5vdCBzdXBwb3J0ZWQ6IGh0dHBzOi8vY2RrLnRmL2NvbXBsZXgtb2JqZWN0LWFzLWNvbmZpZ3VyYXRpb25cIik7XG4gIH1cbiAgcmV0dXJuIHtcbiAgICBkZWxldGVfb3NfZGlza19vbl9kZWxldGlvbjogY2RrdGYuYm9vbGVhblRvVGVycmFmb3JtKHN0cnVjdCEuZGVsZXRlT3NEaXNrT25EZWxldGlvbiksXG4gICAgZ3JhY2VmdWxfc2h1dGRvd246IGNka3RmLmJvb2xlYW5Ub1RlcnJhZm9ybShzdHJ1Y3QhLmdyYWNlZnVsU2h1dGRvd24pLFxuICAgIHNraXBfc2h1dGRvd25fYW5kX2ZvcmNlX2RlbGV0ZTogY2RrdGYuYm9vbGVhblRvVGVycmFmb3JtKHN0cnVjdCEuc2tpcFNodXRkb3duQW5kRm9yY2VEZWxldGUpLFxuICB9XG59XG5cbmV4cG9ydCBpbnRlcmZhY2UgQXp1cmVybVByb3ZpZGVyRmVhdHVyZXNWaXJ0dWFsTWFjaGluZVNjYWxlU2V0IHtcbiAgLyoqXG4gICogRG9jcyBhdCBUZXJyYWZvcm0gUmVnaXN0cnk6IHtAbGluayBodHRwczovL3d3dy50ZXJyYWZvcm0uaW8vZG9jcy9wcm92aWRlcnMvYXp1cmVybSNmb3JjZV9kZWxldGUgQXp1cmVybVByb3ZpZGVyI2ZvcmNlX2RlbGV0ZX1cbiAgKi9cbiAgcmVhZG9ubHkgZm9yY2VEZWxldGU/OiBib29sZWFuIHwgY2RrdGYuSVJlc29sdmFibGU7XG4gIC8qKlxuICAqIERvY3MgYXQgVGVycmFmb3JtIFJlZ2lzdHJ5OiB7QGxpbmsgaHR0cHM6Ly93d3cudGVycmFmb3JtLmlvL2RvY3MvcHJvdmlkZXJzL2F6dXJlcm0jcm9sbF9pbnN0YW5jZXNfd2hlbl9yZXF1aXJlZCBBenVyZXJtUHJvdmlkZXIjcm9sbF9pbnN0YW5jZXNfd2hlbl9yZXF1aXJlZH1cbiAgKi9cbiAgcmVhZG9ubHkgcm9sbEluc3RhbmNlc1doZW5SZXF1aXJlZDogYm9vbGVhbiB8IGNka3RmLklSZXNvbHZhYmxlO1xuICAvKipcbiAgKiBEb2NzIGF0IFRlcnJhZm9ybSBSZWdpc3RyeToge0BsaW5rIGh0dHBzOi8vd3d3LnRlcnJhZm9ybS5pby9kb2NzL3Byb3ZpZGVycy9henVyZXJtI3NjYWxlX3RvX3plcm9fYmVmb3JlX2RlbGV0aW9uIEF6dXJlcm1Qcm92aWRlciNzY2FsZV90b196ZXJvX2JlZm9yZV9kZWxldGlvbn1cbiAgKi9cbiAgcmVhZG9ubHkgc2NhbGVUb1plcm9CZWZvcmVEZWxldGlvbj86IGJvb2xlYW4gfCBjZGt0Zi5JUmVzb2x2YWJsZTtcbn1cblxuZXhwb3J0IGZ1bmN0aW9uIGF6dXJlcm1Qcm92aWRlckZlYXR1cmVzVmlydHVhbE1hY2hpbmVTY2FsZVNldFRvVGVycmFmb3JtKHN0cnVjdD86IEF6dXJlcm1Qcm92aWRlckZlYXR1cmVzVmlydHVhbE1hY2hpbmVTY2FsZVNldCk6IGFueSB7XG4gIGlmICghY2RrdGYuY2FuSW5zcGVjdChzdHJ1Y3QpIHx8IGNka3RmLlRva2VuaXphdGlvbi5pc1Jlc29sdmFibGUoc3RydWN0KSkgeyByZXR1cm4gc3RydWN0OyB9XG4gIGlmIChjZGt0Zi5pc0NvbXBsZXhFbGVtZW50KHN0cnVjdCkpIHtcbiAgICB0aHJvdyBuZXcgRXJyb3IoXCJBIGNvbXBsZXggZWxlbWVudCB3YXMgdXNlZCBhcyBjb25maWd1cmF0aW9uLCB0aGlzIGlzIG5vdCBzdXBwb3J0ZWQ6IGh0dHBzOi8vY2RrLnRmL2NvbXBsZXgtb2JqZWN0LWFzLWNvbmZpZ3VyYXRpb25cIik7XG4gIH1cbiAgcmV0dXJuIHtcbiAgICBmb3JjZV9kZWxldGU6IGNka3RmLmJvb2xlYW5Ub1RlcnJhZm9ybShzdHJ1Y3QhLmZvcmNlRGVsZXRlKSxcbiAgICByb2xsX2luc3RhbmNlc193aGVuX3JlcXVpcmVkOiBjZGt0Zi5ib29sZWFuVG9UZXJyYWZvcm0oc3RydWN0IS5yb2xsSW5zdGFuY2VzV2hlblJlcXVpcmVkKSxcbiAgICBzY2FsZV90b196ZXJvX2JlZm9yZV9kZWxldGlvbjogY2RrdGYuYm9vbGVhblRvVGVycmFmb3JtKHN0cnVjdCEuc2NhbGVUb1plcm9CZWZvcmVEZWxldGlvbiksXG4gIH1cbn1cblxuZXhwb3J0IGludGVyZmFjZSBBenVyZXJtUHJvdmlkZXJGZWF0dXJlcyB7XG4gIC8qKlxuICAqIGFwaV9tYW5hZ2VtZW50IGJsb2NrXG4gICogXG4gICogRG9jcyBhdCBUZXJyYWZvcm0gUmVnaXN0cnk6IHtAbGluayBodHRwczovL3d3dy50ZXJyYWZvcm0uaW8vZG9jcy9wcm92aWRlcnMvYXp1cmVybSNhcGlfbWFuYWdlbWVudCBBenVyZXJtUHJvdmlkZXIjYXBpX21hbmFnZW1lbnR9XG4gICovXG4gIHJlYWRvbmx5IGFwaU1hbmFnZW1lbnQ/OiBBenVyZXJtUHJvdmlkZXJGZWF0dXJlc0FwaU1hbmFnZW1lbnQ7XG4gIC8qKlxuICAqIGFwcGxpY2F0aW9uX2luc2lnaHRzIGJsb2NrXG4gICogXG4gICogRG9jcyBhdCBUZXJyYWZvcm0gUmVnaXN0cnk6IHtAbGluayBodHRwczovL3d3dy50ZXJyYWZvcm0uaW8vZG9jcy9wcm92aWRlcnMvYXp1cmVybSNhcHBsaWNhdGlvbl9pbnNpZ2h0cyBBenVyZXJtUHJvdmlkZXIjYXBwbGljYXRpb25faW5zaWdodHN9XG4gICovXG4gIHJlYWRvbmx5IGFwcGxpY2F0aW9uSW5zaWdodHM/OiBBenVyZXJtUHJvdmlkZXJGZWF0dXJlc0FwcGxpY2F0aW9uSW5zaWdodHM7XG4gIC8qKlxuICAqIGNvZ25pdGl2ZV9hY2NvdW50IGJsb2NrXG4gICogXG4gICogRG9jcyBhdCBUZXJyYWZvcm0gUmVnaXN0cnk6IHtAbGluayBodHRwczovL3d3dy50ZXJyYWZvcm0uaW8vZG9jcy9wcm92aWRlcnMvYXp1cmVybSNjb2duaXRpdmVfYWNjb3VudCBBenVyZXJtUHJvdmlkZXIjY29nbml0aXZlX2FjY291bnR9XG4gICovXG4gIHJlYWRvbmx5IGNvZ25pdGl2ZUFjY291bnQ/OiBBenVyZXJtUHJvdmlkZXJGZWF0dXJlc0NvZ25pdGl2ZUFjY291bnQ7XG4gIC8qKlxuICAqIGtleV92YXVsdCBibG9ja1xuICAqIFxuICAqIERvY3MgYXQgVGVycmFmb3JtIFJlZ2lzdHJ5OiB7QGxpbmsgaHR0cHM6Ly93d3cudGVycmFmb3JtLmlvL2RvY3MvcHJvdmlkZXJzL2F6dXJlcm0ja2V5X3ZhdWx0IEF6dXJlcm1Qcm92aWRlciNrZXlfdmF1bHR9XG4gICovXG4gIHJlYWRvbmx5IGtleVZhdWx0PzogQXp1cmVybVByb3ZpZGVyRmVhdHVyZXNLZXlWYXVsdDtcbiAgLyoqXG4gICogbG9nX2FuYWx5dGljc193b3Jrc3BhY2UgYmxvY2tcbiAgKiBcbiAgKiBEb2NzIGF0IFRlcnJhZm9ybSBSZWdpc3RyeToge0BsaW5rIGh0dHBzOi8vd3d3LnRlcnJhZm9ybS5pby9kb2NzL3Byb3ZpZGVycy9henVyZXJtI2xvZ19hbmFseXRpY3Nfd29ya3NwYWNlIEF6dXJlcm1Qcm92aWRlciNsb2dfYW5hbHl0aWNzX3dvcmtzcGFjZX1cbiAgKi9cbiAgcmVhZG9ubHkgbG9nQW5hbHl0aWNzV29ya3NwYWNlPzogQXp1cmVybVByb3ZpZGVyRmVhdHVyZXNMb2dBbmFseXRpY3NXb3Jrc3BhY2U7XG4gIC8qKlxuICAqIG5ldHdvcmsgYmxvY2tcbiAgKiBcbiAgKiBEb2NzIGF0IFRlcnJhZm9ybSBSZWdpc3RyeToge0BsaW5rIGh0dHBzOi8vd3d3LnRlcnJhZm9ybS5pby9kb2NzL3Byb3ZpZGVycy9henVyZXJtI25ldHdvcmsgQXp1cmVybVByb3ZpZGVyI25ldHdvcmt9XG4gICovXG4gIHJlYWRvbmx5IG5ldHdvcms/OiBBenVyZXJtUHJvdmlkZXJGZWF0dXJlc05ldHdvcms7XG4gIC8qKlxuICAqIHJlc291cmNlX2dyb3VwIGJsb2NrXG4gICogXG4gICogRG9jcyBhdCBUZXJyYWZvcm0gUmVnaXN0cnk6IHtAbGluayBodHRwczovL3d3dy50ZXJyYWZvcm0uaW8vZG9jcy9wcm92aWRlcnMvYXp1cmVybSNyZXNvdXJjZV9ncm91cCBBenVyZXJtUHJvdmlkZXIjcmVzb3VyY2VfZ3JvdXB9XG4gICovXG4gIHJlYWRvbmx5IHJlc291cmNlR3JvdXA/OiBBenVyZXJtUHJvdmlkZXJGZWF0dXJlc1Jlc291cmNlR3JvdXA7XG4gIC8qKlxuICAqIHRlbXBsYXRlX2RlcGxveW1lbnQgYmxvY2tcbiAgKiBcbiAgKiBEb2NzIGF0IFRlcnJhZm9ybSBSZWdpc3RyeToge0BsaW5rIGh0dHBzOi8vd3d3LnRlcnJhZm9ybS5pby9kb2NzL3Byb3ZpZGVycy9henVyZXJtI3RlbXBsYXRlX2RlcGxveW1lbnQgQXp1cmVybVByb3ZpZGVyI3RlbXBsYXRlX2RlcGxveW1lbnR9XG4gICovXG4gIHJlYWRvbmx5IHRlbXBsYXRlRGVwbG95bWVudD86IEF6dXJlcm1Qcm92aWRlckZlYXR1cmVzVGVtcGxhdGVEZXBsb3ltZW50O1xuICAvKipcbiAgKiB2aXJ0dWFsX21hY2hpbmUgYmxvY2tcbiAgKiBcbiAgKiBEb2NzIGF0IFRlcnJhZm9ybSBSZWdpc3RyeToge0BsaW5rIGh0dHBzOi8vd3d3LnRlcnJhZm9ybS5pby9kb2NzL3Byb3ZpZGVycy9henVyZXJtI3ZpcnR1YWxfbWFjaGluZSBBenVyZXJtUHJvdmlkZXIjdmlydHVhbF9tYWNoaW5lfVxuICAqL1xuICByZWFkb25seSB2aXJ0dWFsTWFjaGluZT86IEF6dXJlcm1Qcm92aWRlckZlYXR1cmVzVmlydHVhbE1hY2hpbmU7XG4gIC8qKlxuICAqIHZpcnR1YWxfbWFjaGluZV9zY2FsZV9zZXQgYmxvY2tcbiAgKiBcbiAgKiBEb2NzIGF0IFRlcnJhZm9ybSBSZWdpc3RyeToge0BsaW5rIGh0dHBzOi8vd3d3LnRlcnJhZm9ybS5pby9kb2NzL3Byb3ZpZGVycy9henVyZXJtI3ZpcnR1YWxfbWFjaGluZV9zY2FsZV9zZXQgQXp1cmVybVByb3ZpZGVyI3ZpcnR1YWxfbWFjaGluZV9zY2FsZV9zZXR9XG4gICovXG4gIHJlYWRvbmx5IHZpcnR1YWxNYWNoaW5lU2NhbGVTZXQ/OiBBenVyZXJtUHJvdmlkZXJGZWF0dXJlc1ZpcnR1YWxNYWNoaW5lU2NhbGVTZXQ7XG59XG5cbmV4cG9ydCBmdW5jdGlvbiBhenVyZXJtUHJvdmlkZXJGZWF0dXJlc1RvVGVycmFmb3JtKHN0cnVjdD86IEF6dXJlcm1Qcm92aWRlckZlYXR1cmVzKTogYW55IHtcbiAgaWYgKCFjZGt0Zi5jYW5JbnNwZWN0KHN0cnVjdCkgfHwgY2RrdGYuVG9rZW5pemF0aW9uLmlzUmVzb2x2YWJsZShzdHJ1Y3QpKSB7IHJldHVybiBzdHJ1Y3Q7IH1cbiAgaWYgKGNka3RmLmlzQ29tcGxleEVsZW1lbnQoc3RydWN0KSkge1xuICAgIHRocm93IG5ldyBFcnJvcihcIkEgY29tcGxleCBlbGVtZW50IHdhcyB1c2VkIGFzIGNvbmZpZ3VyYXRpb24sIHRoaXMgaXMgbm90IHN1cHBvcnRlZDogaHR0cHM6Ly9jZGsudGYvY29tcGxleC1vYmplY3QtYXMtY29uZmlndXJhdGlvblwiKTtcbiAgfVxuICByZXR1cm4ge1xuICAgIGFwaV9tYW5hZ2VtZW50OiBhenVyZXJtUHJvdmlkZXJGZWF0dXJlc0FwaU1hbmFnZW1lbnRUb1RlcnJhZm9ybShzdHJ1Y3QhLmFwaU1hbmFnZW1lbnQpLFxuICAgIGFwcGxpY2F0aW9uX2luc2lnaHRzOiBhenVyZXJtUHJvdmlkZXJGZWF0dXJlc0FwcGxpY2F0aW9uSW5zaWdodHNUb1RlcnJhZm9ybShzdHJ1Y3QhLmFwcGxpY2F0aW9uSW5zaWdodHMpLFxuICAgIGNvZ25pdGl2ZV9hY2NvdW50OiBhenVyZXJtUHJvdmlkZXJGZWF0dXJlc0NvZ25pdGl2ZUFjY291bnRUb1RlcnJhZm9ybShzdHJ1Y3QhLmNvZ25pdGl2ZUFjY291bnQpLFxuICAgIGtleV92YXVsdDogYXp1cmVybVByb3ZpZGVyRmVhdHVyZXNLZXlWYXVsdFRvVGVycmFmb3JtKHN0cnVjdCEua2V5VmF1bHQpLFxuICAgIGxvZ19hbmFseXRpY3Nfd29ya3NwYWNlOiBhenVyZXJtUHJvdmlkZXJGZWF0dXJlc0xvZ0FuYWx5dGljc1dvcmtzcGFjZVRvVGVycmFmb3JtKHN0cnVjdCEubG9nQW5hbHl0aWNzV29ya3NwYWNlKSxcbiAgICBuZXR3b3JrOiBhenVyZXJtUHJvdmlkZXJGZWF0dXJlc05ldHdvcmtUb1RlcnJhZm9ybShzdHJ1Y3QhLm5ldHdvcmspLFxuICAgIHJlc291cmNlX2dyb3VwOiBhenVyZXJtUHJvdmlkZXJGZWF0dXJlc1Jlc291cmNlR3JvdXBUb1RlcnJhZm9ybShzdHJ1Y3QhLnJlc291cmNlR3JvdXApLFxuICAgIHRlbXBsYXRlX2RlcGxveW1lbnQ6IGF6dXJlcm1Qcm92aWRlckZlYXR1cmVzVGVtcGxhdGVEZXBsb3ltZW50VG9UZXJyYWZvcm0oc3RydWN0IS50ZW1wbGF0ZURlcGxveW1lbnQpLFxuICAgIHZpcnR1YWxfbWFjaGluZTogYXp1cmVybVByb3ZpZGVyRmVhdHVyZXNWaXJ0dWFsTWFjaGluZVRvVGVycmFmb3JtKHN0cnVjdCEudmlydHVhbE1hY2hpbmUpLFxuICAgIHZpcnR1YWxfbWFjaGluZV9zY2FsZV9zZXQ6IGF6dXJlcm1Qcm92aWRlckZlYXR1cmVzVmlydHVhbE1hY2hpbmVTY2FsZVNldFRvVGVycmFmb3JtKHN0cnVjdCEudmlydHVhbE1hY2hpbmVTY2FsZVNldCksXG4gIH1cbn1cblxuXG4vKipcbiogUmVwcmVzZW50cyBhIHtAbGluayBodHRwczovL3d3dy50ZXJyYWZvcm0uaW8vZG9jcy9wcm92aWRlcnMvYXp1cmVybSBhenVyZXJtfVxuKi9cbmV4cG9ydCBjbGFzcyBBenVyZXJtUHJvdmlkZXIgZXh0ZW5kcyBjZGt0Zi5UZXJyYWZvcm1Qcm92aWRlciB7XG5cbiAgLy8gPT09PT09PT09PT09PT09PT1cbiAgLy8gU1RBVElDIFBST1BFUlRJRVNcbiAgLy8gPT09PT09PT09PT09PT09PT1cbiAgcHVibGljIHN0YXRpYyByZWFkb25seSB0ZlJlc291cmNlVHlwZSA9IFwiYXp1cmVybVwiO1xuXG4gIC8vID09PT09PT09PT09XG4gIC8vIElOSVRJQUxJWkVSXG4gIC8vID09PT09PT09PT09XG5cbiAgLyoqXG4gICogQ3JlYXRlIGEgbmV3IHtAbGluayBodHRwczovL3d3dy50ZXJyYWZvcm0uaW8vZG9jcy9wcm92aWRlcnMvYXp1cmVybSBhenVyZXJtfSBSZXNvdXJjZVxuICAqXG4gICogQHBhcmFtIHNjb3BlIFRoZSBzY29wZSBpbiB3aGljaCB0byBkZWZpbmUgdGhpcyBjb25zdHJ1Y3RcbiAgKiBAcGFyYW0gaWQgVGhlIHNjb3BlZCBjb25zdHJ1Y3QgSUQuIE11c3QgYmUgdW5pcXVlIGFtb25nc3Qgc2libGluZ3MgaW4gdGhlIHNhbWUgc2NvcGVcbiAgKiBAcGFyYW0gb3B0aW9ucyBBenVyZXJtUHJvdmlkZXJDb25maWdcbiAgKi9cbiAgcHVibGljIGNvbnN0cnVjdG9yKHNjb3BlOiBDb25zdHJ1Y3QsIGlkOiBzdHJpbmcsIGNvbmZpZzogQXp1cmVybVByb3ZpZGVyQ29uZmlnKSB7XG4gICAgc3VwZXIoc2NvcGUsIGlkLCB7XG4gICAgICB0ZXJyYWZvcm1SZXNvdXJjZVR5cGU6ICdhenVyZXJtJyxcbiAgICAgIHRlcnJhZm9ybUdlbmVyYXRvck1ldGFkYXRhOiB7XG4gICAgICAgIHByb3ZpZGVyTmFtZTogJ2F6dXJlcm0nLFxuICAgICAgICBwcm92aWRlclZlcnNpb246ICczLjI0LjAnLFxuICAgICAgICBwcm92aWRlclZlcnNpb25Db25zdHJhaW50OiAnfj4gMy4xMCdcbiAgICAgIH0sXG4gICAgICB0ZXJyYWZvcm1Qcm92aWRlclNvdXJjZTogJ2F6dXJlcm0nXG4gICAgfSk7XG4gICAgdGhpcy5fYXV4aWxpYXJ5VGVuYW50SWRzID0gY29uZmlnLmF1eGlsaWFyeVRlbmFudElkcztcbiAgICB0aGlzLl9jbGllbnRDZXJ0aWZpY2F0ZVBhc3N3b3JkID0gY29uZmlnLmNsaWVudENlcnRpZmljYXRlUGFzc3dvcmQ7XG4gICAgdGhpcy5fY2xpZW50Q2VydGlmaWNhdGVQYXRoID0gY29uZmlnLmNsaWVudENlcnRpZmljYXRlUGF0aDtcbiAgICB0aGlzLl9jbGllbnRJZCA9IGNvbmZpZy5jbGllbnRJZDtcbiAgICB0aGlzLl9jbGllbnRTZWNyZXQgPSBjb25maWcuY2xpZW50U2VjcmV0O1xuICAgIHRoaXMuX2Rpc2FibGVDb3JyZWxhdGlvblJlcXVlc3RJZCA9IGNvbmZpZy5kaXNhYmxlQ29ycmVsYXRpb25SZXF1ZXN0SWQ7XG4gICAgdGhpcy5fZGlzYWJsZVRlcnJhZm9ybVBhcnRuZXJJZCA9IGNvbmZpZy5kaXNhYmxlVGVycmFmb3JtUGFydG5lcklkO1xuICAgIHRoaXMuX2Vudmlyb25tZW50ID0gY29uZmlnLmVudmlyb25tZW50O1xuICAgIHRoaXMuX21ldGFkYXRhSG9zdCA9IGNvbmZpZy5tZXRhZGF0YUhvc3Q7XG4gICAgdGhpcy5fbXNpRW5kcG9pbnQgPSBjb25maWcubXNpRW5kcG9pbnQ7XG4gICAgdGhpcy5fb2lkY1JlcXVlc3RUb2tlbiA9IGNvbmZpZy5vaWRjUmVxdWVzdFRva2VuO1xuICAgIHRoaXMuX29pZGNSZXF1ZXN0VXJsID0gY29uZmlnLm9pZGNSZXF1ZXN0VXJsO1xuICAgIHRoaXMuX29pZGNUb2tlbiA9IGNvbmZpZy5vaWRjVG9rZW47XG4gICAgdGhpcy5fcGFydG5lcklkID0gY29uZmlnLnBhcnRuZXJJZDtcbiAgICB0aGlzLl9za2lwUHJvdmlkZXJSZWdpc3RyYXRpb24gPSBjb25maWcuc2tpcFByb3ZpZGVyUmVnaXN0cmF0aW9uO1xuICAgIHRoaXMuX3N0b3JhZ2VVc2VBenVyZWFkID0gY29uZmlnLnN0b3JhZ2VVc2VBenVyZWFkO1xuICAgIHRoaXMuX3N1YnNjcmlwdGlvbklkID0gY29uZmlnLnN1YnNjcmlwdGlvbklkO1xuICAgIHRoaXMuX3RlbmFudElkID0gY29uZmlnLnRlbmFudElkO1xuICAgIHRoaXMuX3VzZU1zaSA9IGNvbmZpZy51c2VNc2k7XG4gICAgdGhpcy5fdXNlT2lkYyA9IGNvbmZpZy51c2VPaWRjO1xuICAgIHRoaXMuX2FsaWFzID0gY29uZmlnLmFsaWFzO1xuICAgIHRoaXMuX2ZlYXR1cmVzID0gY29uZmlnLmZlYXR1cmVzO1xuICB9XG5cbiAgLy8gPT09PT09PT09PVxuICAvLyBBVFRSSUJVVEVTXG4gIC8vID09PT09PT09PT1cblxuICAvLyBhdXhpbGlhcnlfdGVuYW50X2lkcyAtIGNvbXB1dGVkOiBmYWxzZSwgb3B0aW9uYWw6IHRydWUsIHJlcXVpcmVkOiBmYWxzZVxuICBwcml2YXRlIF9hdXhpbGlhcnlUZW5hbnRJZHM/OiBzdHJpbmdbXTsgXG4gIHB1YmxpYyBnZXQgYXV4aWxpYXJ5VGVuYW50SWRzKCkge1xuICAgIHJldHVybiB0aGlzLl9hdXhpbGlhcnlUZW5hbnRJZHM7XG4gIH1cbiAgcHVibGljIHNldCBhdXhpbGlhcnlUZW5hbnRJZHModmFsdWU6IHN0cmluZ1tdIHwgdW5kZWZpbmVkKSB7XG4gICAgdGhpcy5fYXV4aWxpYXJ5VGVuYW50SWRzID0gdmFsdWU7XG4gIH1cbiAgcHVibGljIHJlc2V0QXV4aWxpYXJ5VGVuYW50SWRzKCkge1xuICAgIHRoaXMuX2F1eGlsaWFyeVRlbmFudElkcyA9IHVuZGVmaW5lZDtcbiAgfVxuICAvLyBUZW1wb3JhcmlseSBleHBvc2UgaW5wdXQgdmFsdWUuIFVzZSB3aXRoIGNhdXRpb24uXG4gIHB1YmxpYyBnZXQgYXV4aWxpYXJ5VGVuYW50SWRzSW5wdXQoKSB7XG4gICAgcmV0dXJuIHRoaXMuX2F1eGlsaWFyeVRlbmFudElkcztcbiAgfVxuXG4gIC8vIGNsaWVudF9jZXJ0aWZpY2F0ZV9wYXNzd29yZCAtIGNvbXB1dGVkOiBmYWxzZSwgb3B0aW9uYWw6IHRydWUsIHJlcXVpcmVkOiBmYWxzZVxuICBwcml2YXRlIF9jbGllbnRDZXJ0aWZpY2F0ZVBhc3N3b3JkPzogc3RyaW5nOyBcbiAgcHVibGljIGdldCBjbGllbnRDZXJ0aWZpY2F0ZVBhc3N3b3JkKCkge1xuICAgIHJldHVybiB0aGlzLl9jbGllbnRDZXJ0aWZpY2F0ZVBhc3N3b3JkO1xuICB9XG4gIHB1YmxpYyBzZXQgY2xpZW50Q2VydGlmaWNhdGVQYXNzd29yZCh2YWx1ZTogc3RyaW5nIHwgdW5kZWZpbmVkKSB7XG4gICAgdGhpcy5fY2xpZW50Q2VydGlmaWNhdGVQYXNzd29yZCA9IHZhbHVlO1xuICB9XG4gIHB1YmxpYyByZXNldENsaWVudENlcnRpZmljYXRlUGFzc3dvcmQoKSB7XG4gICAgdGhpcy5fY2xpZW50Q2VydGlmaWNhdGVQYXNzd29yZCA9IHVuZGVmaW5lZDtcbiAgfVxuICAvLyBUZW1wb3JhcmlseSBleHBvc2UgaW5wdXQgdmFsdWUuIFVzZSB3aXRoIGNhdXRpb24uXG4gIHB1YmxpYyBnZXQgY2xpZW50Q2VydGlmaWNhdGVQYXNzd29yZElucHV0KCkge1xuICAgIHJldHVybiB0aGlzLl9jbGllbnRDZXJ0aWZpY2F0ZVBhc3N3b3JkO1xuICB9XG5cbiAgLy8gY2xpZW50X2NlcnRpZmljYXRlX3BhdGggLSBjb21wdXRlZDogZmFsc2UsIG9wdGlvbmFsOiB0cnVlLCByZXF1aXJlZDogZmFsc2VcbiAgcHJpdmF0ZSBfY2xpZW50Q2VydGlmaWNhdGVQYXRoPzogc3RyaW5nOyBcbiAgcHVibGljIGdldCBjbGllbnRDZXJ0aWZpY2F0ZVBhdGgoKSB7XG4gICAgcmV0dXJuIHRoaXMuX2NsaWVudENlcnRpZmljYXRlUGF0aDtcbiAgfVxuICBwdWJsaWMgc2V0IGNsaWVudENlcnRpZmljYXRlUGF0aCh2YWx1ZTogc3RyaW5nIHwgdW5kZWZpbmVkKSB7XG4gICAgdGhpcy5fY2xpZW50Q2VydGlmaWNhdGVQYXRoID0gdmFsdWU7XG4gIH1cbiAgcHVibGljIHJlc2V0Q2xpZW50Q2VydGlmaWNhdGVQYXRoKCkge1xuICAgIHRoaXMuX2NsaWVudENlcnRpZmljYXRlUGF0aCA9IHVuZGVmaW5lZDtcbiAgfVxuICAvLyBUZW1wb3JhcmlseSBleHBvc2UgaW5wdXQgdmFsdWUuIFVzZSB3aXRoIGNhdXRpb24uXG4gIHB1YmxpYyBnZXQgY2xpZW50Q2VydGlmaWNhdGVQYXRoSW5wdXQoKSB7XG4gICAgcmV0dXJuIHRoaXMuX2NsaWVudENlcnRpZmljYXRlUGF0aDtcbiAgfVxuXG4gIC8vIGNsaWVudF9pZCAtIGNvbXB1dGVkOiBmYWxzZSwgb3B0aW9uYWw6IHRydWUsIHJlcXVpcmVkOiBmYWxzZVxuICBwcml2YXRlIF9jbGllbnRJZD86IHN0cmluZzsgXG4gIHB1YmxpYyBnZXQgY2xpZW50SWQoKSB7XG4gICAgcmV0dXJuIHRoaXMuX2NsaWVudElkO1xuICB9XG4gIHB1YmxpYyBzZXQgY2xpZW50SWQodmFsdWU6IHN0cmluZyB8IHVuZGVmaW5lZCkge1xuICAgIHRoaXMuX2NsaWVudElkID0gdmFsdWU7XG4gIH1cbiAgcHVibGljIHJlc2V0Q2xpZW50SWQoKSB7XG4gICAgdGhpcy5fY2xpZW50SWQgPSB1bmRlZmluZWQ7XG4gIH1cbiAgLy8gVGVtcG9yYXJpbHkgZXhwb3NlIGlucHV0IHZhbHVlLiBVc2Ugd2l0aCBjYXV0aW9uLlxuICBwdWJsaWMgZ2V0IGNsaWVudElkSW5wdXQoKSB7XG4gICAgcmV0dXJuIHRoaXMuX2NsaWVudElkO1xuICB9XG5cbiAgLy8gY2xpZW50X3NlY3JldCAtIGNvbXB1dGVkOiBmYWxzZSwgb3B0aW9uYWw6IHRydWUsIHJlcXVpcmVkOiBmYWxzZVxuICBwcml2YXRlIF9jbGllbnRTZWNyZXQ/OiBzdHJpbmc7IFxuICBwdWJsaWMgZ2V0IGNsaWVudFNlY3JldCgpIHtcbiAgICByZXR1cm4gdGhpcy5fY2xpZW50U2VjcmV0O1xuICB9XG4gIHB1YmxpYyBzZXQgY2xpZW50U2VjcmV0KHZhbHVlOiBzdHJpbmcgfCB1bmRlZmluZWQpIHtcbiAgICB0aGlzLl9jbGllbnRTZWNyZXQgPSB2YWx1ZTtcbiAgfVxuICBwdWJsaWMgcmVzZXRDbGllbnRTZWNyZXQoKSB7XG4gICAgdGhpcy5fY2xpZW50U2VjcmV0ID0gdW5kZWZpbmVkO1xuICB9XG4gIC8vIFRlbXBvcmFyaWx5IGV4cG9zZSBpbnB1dCB2YWx1ZS4gVXNlIHdpdGggY2F1dGlvbi5cbiAgcHVibGljIGdldCBjbGllbnRTZWNyZXRJbnB1dCgpIHtcbiAgICByZXR1cm4gdGhpcy5fY2xpZW50U2VjcmV0O1xuICB9XG5cbiAgLy8gZGlzYWJsZV9jb3JyZWxhdGlvbl9yZXF1ZXN0X2lkIC0gY29tcHV0ZWQ6IGZhbHNlLCBvcHRpb25hbDogdHJ1ZSwgcmVxdWlyZWQ6IGZhbHNlXG4gIHByaXZhdGUgX2Rpc2FibGVDb3JyZWxhdGlvblJlcXVlc3RJZD86IGJvb2xlYW4gfCBjZGt0Zi5JUmVzb2x2YWJsZTsgXG4gIHB1YmxpYyBnZXQgZGlzYWJsZUNvcnJlbGF0aW9uUmVxdWVzdElkKCkge1xuICAgIHJldHVybiB0aGlzLl9kaXNhYmxlQ29ycmVsYXRpb25SZXF1ZXN0SWQ7XG4gIH1cbiAgcHVibGljIHNldCBkaXNhYmxlQ29ycmVsYXRpb25SZXF1ZXN0SWQodmFsdWU6IGJvb2xlYW4gfCBjZGt0Zi5JUmVzb2x2YWJsZSB8IHVuZGVmaW5lZCkge1xuICAgIHRoaXMuX2Rpc2FibGVDb3JyZWxhdGlvblJlcXVlc3RJZCA9IHZhbHVlO1xuICB9XG4gIHB1YmxpYyByZXNldERpc2FibGVDb3JyZWxhdGlvblJlcXVlc3RJZCgpIHtcbiAgICB0aGlzLl9kaXNhYmxlQ29ycmVsYXRpb25SZXF1ZXN0SWQgPSB1bmRlZmluZWQ7XG4gIH1cbiAgLy8gVGVtcG9yYXJpbHkgZXhwb3NlIGlucHV0IHZhbHVlLiBVc2Ugd2l0aCBjYXV0aW9uLlxuICBwdWJsaWMgZ2V0IGRpc2FibGVDb3JyZWxhdGlvblJlcXVlc3RJZElucHV0KCkge1xuICAgIHJldHVybiB0aGlzLl9kaXNhYmxlQ29ycmVsYXRpb25SZXF1ZXN0SWQ7XG4gIH1cblxuICAvLyBkaXNhYmxlX3RlcnJhZm9ybV9wYXJ0bmVyX2lkIC0gY29tcHV0ZWQ6IGZhbHNlLCBvcHRpb25hbDogdHJ1ZSwgcmVxdWlyZWQ6IGZhbHNlXG4gIHByaXZhdGUgX2Rpc2FibGVUZXJyYWZvcm1QYXJ0bmVySWQ/OiBib29sZWFuIHwgY2RrdGYuSVJlc29sdmFibGU7IFxuICBwdWJsaWMgZ2V0IGRpc2FibGVUZXJyYWZvcm1QYXJ0bmVySWQoKSB7XG4gICAgcmV0dXJuIHRoaXMuX2Rpc2FibGVUZXJyYWZvcm1QYXJ0bmVySWQ7XG4gIH1cbiAgcHVibGljIHNldCBkaXNhYmxlVGVycmFmb3JtUGFydG5lcklkKHZhbHVlOiBib29sZWFuIHwgY2RrdGYuSVJlc29sdmFibGUgfCB1bmRlZmluZWQpIHtcbiAgICB0aGlzLl9kaXNhYmxlVGVycmFmb3JtUGFydG5lcklkID0gdmFsdWU7XG4gIH1cbiAgcHVibGljIHJlc2V0RGlzYWJsZVRlcnJhZm9ybVBhcnRuZXJJZCgpIHtcbiAgICB0aGlzLl9kaXNhYmxlVGVycmFmb3JtUGFydG5lcklkID0gdW5kZWZpbmVkO1xuICB9XG4gIC8vIFRlbXBvcmFyaWx5IGV4cG9zZSBpbnB1dCB2YWx1ZS4gVXNlIHdpdGggY2F1dGlvbi5cbiAgcHVibGljIGdldCBkaXNhYmxlVGVycmFmb3JtUGFydG5lcklkSW5wdXQoKSB7XG4gICAgcmV0dXJuIHRoaXMuX2Rpc2FibGVUZXJyYWZvcm1QYXJ0bmVySWQ7XG4gIH1cblxuICAvLyBlbnZpcm9ubWVudCAtIGNvbXB1dGVkOiBmYWxzZSwgb3B0aW9uYWw6IHRydWUsIHJlcXVpcmVkOiBmYWxzZVxuICBwcml2YXRlIF9lbnZpcm9ubWVudD86IHN0cmluZzsgXG4gIHB1YmxpYyBnZXQgZW52aXJvbm1lbnQoKSB7XG4gICAgcmV0dXJuIHRoaXMuX2Vudmlyb25tZW50O1xuICB9XG4gIHB1YmxpYyBzZXQgZW52aXJvbm1lbnQodmFsdWU6IHN0cmluZyB8IHVuZGVmaW5lZCkge1xuICAgIHRoaXMuX2Vudmlyb25tZW50ID0gdmFsdWU7XG4gIH1cbiAgcHVibGljIHJlc2V0RW52aXJvbm1lbnQoKSB7XG4gICAgdGhpcy5fZW52aXJvbm1lbnQgPSB1bmRlZmluZWQ7XG4gIH1cbiAgLy8gVGVtcG9yYXJpbHkgZXhwb3NlIGlucHV0IHZhbHVlLiBVc2Ugd2l0aCBjYXV0aW9uLlxuICBwdWJsaWMgZ2V0IGVudmlyb25tZW50SW5wdXQoKSB7XG4gICAgcmV0dXJuIHRoaXMuX2Vudmlyb25tZW50O1xuICB9XG5cbiAgLy8gbWV0YWRhdGFfaG9zdCAtIGNvbXB1dGVkOiBmYWxzZSwgb3B0aW9uYWw6IHRydWUsIHJlcXVpcmVkOiBmYWxzZVxuICBwcml2YXRlIF9tZXRhZGF0YUhvc3Q/OiBzdHJpbmc7IFxuICBwdWJsaWMgZ2V0IG1ldGFkYXRhSG9zdCgpIHtcbiAgICByZXR1cm4gdGhpcy5fbWV0YWRhdGFIb3N0O1xuICB9XG4gIHB1YmxpYyBzZXQgbWV0YWRhdGFIb3N0KHZhbHVlOiBzdHJpbmcgfCB1bmRlZmluZWQpIHtcbiAgICB0aGlzLl9tZXRhZGF0YUhvc3QgPSB2YWx1ZTtcbiAgfVxuICBwdWJsaWMgcmVzZXRNZXRhZGF0YUhvc3QoKSB7XG4gICAgdGhpcy5fbWV0YWRhdGFIb3N0ID0gdW5kZWZpbmVkO1xuICB9XG4gIC8vIFRlbXBvcmFyaWx5IGV4cG9zZSBpbnB1dCB2YWx1ZS4gVXNlIHdpdGggY2F1dGlvbi5cbiAgcHVibGljIGdldCBtZXRhZGF0YUhvc3RJbnB1dCgpIHtcbiAgICByZXR1cm4gdGhpcy5fbWV0YWRhdGFIb3N0O1xuICB9XG5cbiAgLy8gbXNpX2VuZHBvaW50IC0gY29tcHV0ZWQ6IGZhbHNlLCBvcHRpb25hbDogdHJ1ZSwgcmVxdWlyZWQ6IGZhbHNlXG4gIHByaXZhdGUgX21zaUVuZHBvaW50Pzogc3RyaW5nOyBcbiAgcHVibGljIGdldCBtc2lFbmRwb2ludCgpIHtcbiAgICByZXR1cm4gdGhpcy5fbXNpRW5kcG9pbnQ7XG4gIH1cbiAgcHVibGljIHNldCBtc2lFbmRwb2ludCh2YWx1ZTogc3RyaW5nIHwgdW5kZWZpbmVkKSB7XG4gICAgdGhpcy5fbXNpRW5kcG9pbnQgPSB2YWx1ZTtcbiAgfVxuICBwdWJsaWMgcmVzZXRNc2lFbmRwb2ludCgpIHtcbiAgICB0aGlzLl9tc2lFbmRwb2ludCA9IHVuZGVmaW5lZDtcbiAgfVxuICAvLyBUZW1wb3JhcmlseSBleHBvc2UgaW5wdXQgdmFsdWUuIFVzZSB3aXRoIGNhdXRpb24uXG4gIHB1YmxpYyBnZXQgbXNpRW5kcG9pbnRJbnB1dCgpIHtcbiAgICByZXR1cm4gdGhpcy5fbXNpRW5kcG9pbnQ7XG4gIH1cblxuICAvLyBvaWRjX3JlcXVlc3RfdG9rZW4gLSBjb21wdXRlZDogZmFsc2UsIG9wdGlvbmFsOiB0cnVlLCByZXF1aXJlZDogZmFsc2VcbiAgcHJpdmF0ZSBfb2lkY1JlcXVlc3RUb2tlbj86IHN0cmluZzsgXG4gIHB1YmxpYyBnZXQgb2lkY1JlcXVlc3RUb2tlbigpIHtcbiAgICByZXR1cm4gdGhpcy5fb2lkY1JlcXVlc3RUb2tlbjtcbiAgfVxuICBwdWJsaWMgc2V0IG9pZGNSZXF1ZXN0VG9rZW4odmFsdWU6IHN0cmluZyB8IHVuZGVmaW5lZCkge1xuICAgIHRoaXMuX29pZGNSZXF1ZXN0VG9rZW4gPSB2YWx1ZTtcbiAgfVxuICBwdWJsaWMgcmVzZXRPaWRjUmVxdWVzdFRva2VuKCkge1xuICAgIHRoaXMuX29pZGNSZXF1ZXN0VG9rZW4gPSB1bmRlZmluZWQ7XG4gIH1cbiAgLy8gVGVtcG9yYXJpbHkgZXhwb3NlIGlucHV0IHZhbHVlLiBVc2Ugd2l0aCBjYXV0aW9uLlxuICBwdWJsaWMgZ2V0IG9pZGNSZXF1ZXN0VG9rZW5JbnB1dCgpIHtcbiAgICByZXR1cm4gdGhpcy5fb2lkY1JlcXVlc3RUb2tlbjtcbiAgfVxuXG4gIC8vIG9pZGNfcmVxdWVzdF91cmwgLSBjb21wdXRlZDogZmFsc2UsIG9wdGlvbmFsOiB0cnVlLCByZXF1aXJlZDogZmFsc2VcbiAgcHJpdmF0ZSBfb2lkY1JlcXVlc3RVcmw/OiBzdHJpbmc7IFxuICBwdWJsaWMgZ2V0IG9pZGNSZXF1ZXN0VXJsKCkge1xuICAgIHJldHVybiB0aGlzLl9vaWRjUmVxdWVzdFVybDtcbiAgfVxuICBwdWJsaWMgc2V0IG9pZGNSZXF1ZXN0VXJsKHZhbHVlOiBzdHJpbmcgfCB1bmRlZmluZWQpIHtcbiAgICB0aGlzLl9vaWRjUmVxdWVzdFVybCA9IHZhbHVlO1xuICB9XG4gIHB1YmxpYyByZXNldE9pZGNSZXF1ZXN0VXJsKCkge1xuICAgIHRoaXMuX29pZGNSZXF1ZXN0VXJsID0gdW5kZWZpbmVkO1xuICB9XG4gIC8vIFRlbXBvcmFyaWx5IGV4cG9zZSBpbnB1dCB2YWx1ZS4gVXNlIHdpdGggY2F1dGlvbi5cbiAgcHVibGljIGdldCBvaWRjUmVxdWVzdFVybElucHV0KCkge1xuICAgIHJldHVybiB0aGlzLl9vaWRjUmVxdWVzdFVybDtcbiAgfVxuXG4gIC8vIG9pZGNfdG9rZW4gLSBjb21wdXRlZDogZmFsc2UsIG9wdGlvbmFsOiB0cnVlLCByZXF1aXJlZDogZmFsc2VcbiAgcHJpdmF0ZSBfb2lkY1Rva2VuPzogc3RyaW5nOyBcbiAgcHVibGljIGdldCBvaWRjVG9rZW4oKSB7XG4gICAgcmV0dXJuIHRoaXMuX29pZGNUb2tlbjtcbiAgfVxuICBwdWJsaWMgc2V0IG9pZGNUb2tlbih2YWx1ZTogc3RyaW5nIHwgdW5kZWZpbmVkKSB7XG4gICAgdGhpcy5fb2lkY1Rva2VuID0gdmFsdWU7XG4gIH1cbiAgcHVibGljIHJlc2V0T2lkY1Rva2VuKCkge1xuICAgIHRoaXMuX29pZGNUb2tlbiA9IHVuZGVmaW5lZDtcbiAgfVxuICAvLyBUZW1wb3JhcmlseSBleHBvc2UgaW5wdXQgdmFsdWUuIFVzZSB3aXRoIGNhdXRpb24uXG4gIHB1YmxpYyBnZXQgb2lkY1Rva2VuSW5wdXQoKSB7XG4gICAgcmV0dXJuIHRoaXMuX29pZGNUb2tlbjtcbiAgfVxuXG4gIC8vIHBhcnRuZXJfaWQgLSBjb21wdXRlZDogZmFsc2UsIG9wdGlvbmFsOiB0cnVlLCByZXF1aXJlZDogZmFsc2VcbiAgcHJpdmF0ZSBfcGFydG5lcklkPzogc3RyaW5nOyBcbiAgcHVibGljIGdldCBwYXJ0bmVySWQoKSB7XG4gICAgcmV0dXJuIHRoaXMuX3BhcnRuZXJJZDtcbiAgfVxuICBwdWJsaWMgc2V0IHBhcnRuZXJJZCh2YWx1ZTogc3RyaW5nIHwgdW5kZWZpbmVkKSB7XG4gICAgdGhpcy5fcGFydG5lcklkID0gdmFsdWU7XG4gIH1cbiAgcHVibGljIHJlc2V0UGFydG5lcklkKCkge1xuICAgIHRoaXMuX3BhcnRuZXJJZCA9IHVuZGVmaW5lZDtcbiAgfVxuICAvLyBUZW1wb3JhcmlseSBleHBvc2UgaW5wdXQgdmFsdWUuIFVzZSB3aXRoIGNhdXRpb24uXG4gIHB1YmxpYyBnZXQgcGFydG5lcklkSW5wdXQoKSB7XG4gICAgcmV0dXJuIHRoaXMuX3BhcnRuZXJJZDtcbiAgfVxuXG4gIC8vIHNraXBfcHJvdmlkZXJfcmVnaXN0cmF0aW9uIC0gY29tcHV0ZWQ6IGZhbHNlLCBvcHRpb25hbDogdHJ1ZSwgcmVxdWlyZWQ6IGZhbHNlXG4gIHByaXZhdGUgX3NraXBQcm92aWRlclJlZ2lzdHJhdGlvbj86IGJvb2xlYW4gfCBjZGt0Zi5JUmVzb2x2YWJsZTsgXG4gIHB1YmxpYyBnZXQgc2tpcFByb3ZpZGVyUmVnaXN0cmF0aW9uKCkge1xuICAgIHJldHVybiB0aGlzLl9za2lwUHJvdmlkZXJSZWdpc3RyYXRpb247XG4gIH1cbiAgcHVibGljIHNldCBza2lwUHJvdmlkZXJSZWdpc3RyYXRpb24odmFsdWU6IGJvb2xlYW4gfCBjZGt0Zi5JUmVzb2x2YWJsZSB8IHVuZGVmaW5lZCkge1xuICAgIHRoaXMuX3NraXBQcm92aWRlclJlZ2lzdHJhdGlvbiA9IHZhbHVlO1xuICB9XG4gIHB1YmxpYyByZXNldFNraXBQcm92aWRlclJlZ2lzdHJhdGlvbigpIHtcbiAgICB0aGlzLl9za2lwUHJvdmlkZXJSZWdpc3RyYXRpb24gPSB1bmRlZmluZWQ7XG4gIH1cbiAgLy8gVGVtcG9yYXJpbHkgZXhwb3NlIGlucHV0IHZhbHVlLiBVc2Ugd2l0aCBjYXV0aW9uLlxuICBwdWJsaWMgZ2V0IHNraXBQcm92aWRlclJlZ2lzdHJhdGlvbklucHV0KCkge1xuICAgIHJldHVybiB0aGlzLl9za2lwUHJvdmlkZXJSZWdpc3RyYXRpb247XG4gIH1cblxuICAvLyBzdG9yYWdlX3VzZV9henVyZWFkIC0gY29tcHV0ZWQ6IGZhbHNlLCBvcHRpb25hbDogdHJ1ZSwgcmVxdWlyZWQ6IGZhbHNlXG4gIHByaXZhdGUgX3N0b3JhZ2VVc2VBenVyZWFkPzogYm9vbGVhbiB8IGNka3RmLklSZXNvbHZhYmxlOyBcbiAgcHVibGljIGdldCBzdG9yYWdlVXNlQXp1cmVhZCgpIHtcbiAgICByZXR1cm4gdGhpcy5fc3RvcmFnZVVzZUF6dXJlYWQ7XG4gIH1cbiAgcHVibGljIHNldCBzdG9yYWdlVXNlQXp1cmVhZCh2YWx1ZTogYm9vbGVhbiB8IGNka3RmLklSZXNvbHZhYmxlIHwgdW5kZWZpbmVkKSB7XG4gICAgdGhpcy5fc3RvcmFnZVVzZUF6dXJlYWQgPSB2YWx1ZTtcbiAgfVxuICBwdWJsaWMgcmVzZXRTdG9yYWdlVXNlQXp1cmVhZCgpIHtcbiAgICB0aGlzLl9zdG9yYWdlVXNlQXp1cmVhZCA9IHVuZGVmaW5lZDtcbiAgfVxuICAvLyBUZW1wb3JhcmlseSBleHBvc2UgaW5wdXQgdmFsdWUuIFVzZSB3aXRoIGNhdXRpb24uXG4gIHB1YmxpYyBnZXQgc3RvcmFnZVVzZUF6dXJlYWRJbnB1dCgpIHtcbiAgICByZXR1cm4gdGhpcy5fc3RvcmFnZVVzZUF6dXJlYWQ7XG4gIH1cblxuICAvLyBzdWJzY3JpcHRpb25faWQgLSBjb21wdXRlZDogZmFsc2UsIG9wdGlvbmFsOiB0cnVlLCByZXF1aXJlZDogZmFsc2VcbiAgcHJpdmF0ZSBfc3Vic2NyaXB0aW9uSWQ/OiBzdHJpbmc7IFxuICBwdWJsaWMgZ2V0IHN1YnNjcmlwdGlvbklkKCkge1xuICAgIHJldHVybiB0aGlzLl9zdWJzY3JpcHRpb25JZDtcbiAgfVxuICBwdWJsaWMgc2V0IHN1YnNjcmlwdGlvbklkKHZhbHVlOiBzdHJpbmcgfCB1bmRlZmluZWQpIHtcbiAgICB0aGlzLl9zdWJzY3JpcHRpb25JZCA9IHZhbHVlO1xuICB9XG4gIHB1YmxpYyByZXNldFN1YnNjcmlwdGlvbklkKCkge1xuICAgIHRoaXMuX3N1YnNjcmlwdGlvbklkID0gdW5kZWZpbmVkO1xuICB9XG4gIC8vIFRlbXBvcmFyaWx5IGV4cG9zZSBpbnB1dCB2YWx1ZS4gVXNlIHdpdGggY2F1dGlvbi5cbiAgcHVibGljIGdldCBzdWJzY3JpcHRpb25JZElucHV0KCkge1xuICAgIHJldHVybiB0aGlzLl9zdWJzY3JpcHRpb25JZDtcbiAgfVxuXG4gIC8vIHRlbmFudF9pZCAtIGNvbXB1dGVkOiBmYWxzZSwgb3B0aW9uYWw6IHRydWUsIHJlcXVpcmVkOiBmYWxzZVxuICBwcml2YXRlIF90ZW5hbnRJZD86IHN0cmluZzsgXG4gIHB1YmxpYyBnZXQgdGVuYW50SWQoKSB7XG4gICAgcmV0dXJuIHRoaXMuX3RlbmFudElkO1xuICB9XG4gIHB1YmxpYyBzZXQgdGVuYW50SWQodmFsdWU6IHN0cmluZyB8IHVuZGVmaW5lZCkge1xuICAgIHRoaXMuX3RlbmFudElkID0gdmFsdWU7XG4gIH1cbiAgcHVibGljIHJlc2V0VGVuYW50SWQoKSB7XG4gICAgdGhpcy5fdGVuYW50SWQgPSB1bmRlZmluZWQ7XG4gIH1cbiAgLy8gVGVtcG9yYXJpbHkgZXhwb3NlIGlucHV0IHZhbHVlLiBVc2Ugd2l0aCBjYXV0aW9uLlxuICBwdWJsaWMgZ2V0IHRlbmFudElkSW5wdXQoKSB7XG4gICAgcmV0dXJuIHRoaXMuX3RlbmFudElkO1xuICB9XG5cbiAgLy8gdXNlX21zaSAtIGNvbXB1dGVkOiBmYWxzZSwgb3B0aW9uYWw6IHRydWUsIHJlcXVpcmVkOiBmYWxzZVxuICBwcml2YXRlIF91c2VNc2k/OiBib29sZWFuIHwgY2RrdGYuSVJlc29sdmFibGU7IFxuICBwdWJsaWMgZ2V0IHVzZU1zaSgpIHtcbiAgICByZXR1cm4gdGhpcy5fdXNlTXNpO1xuICB9XG4gIHB1YmxpYyBzZXQgdXNlTXNpKHZhbHVlOiBib29sZWFuIHwgY2RrdGYuSVJlc29sdmFibGUgfCB1bmRlZmluZWQpIHtcbiAgICB0aGlzLl91c2VNc2kgPSB2YWx1ZTtcbiAgfVxuICBwdWJsaWMgcmVzZXRVc2VNc2koKSB7XG4gICAgdGhpcy5fdXNlTXNpID0gdW5kZWZpbmVkO1xuICB9XG4gIC8vIFRlbXBvcmFyaWx5IGV4cG9zZSBpbnB1dCB2YWx1ZS4gVXNlIHdpdGggY2F1dGlvbi5cbiAgcHVibGljIGdldCB1c2VNc2lJbnB1dCgpIHtcbiAgICByZXR1cm4gdGhpcy5fdXNlTXNpO1xuICB9XG5cbiAgLy8gdXNlX29pZGMgLSBjb21wdXRlZDogZmFsc2UsIG9wdGlvbmFsOiB0cnVlLCByZXF1aXJlZDogZmFsc2VcbiAgcHJpdmF0ZSBfdXNlT2lkYz86IGJvb2xlYW4gfCBjZGt0Zi5JUmVzb2x2YWJsZTsgXG4gIHB1YmxpYyBnZXQgdXNlT2lkYygpIHtcbiAgICByZXR1cm4gdGhpcy5fdXNlT2lkYztcbiAgfVxuICBwdWJsaWMgc2V0IHVzZU9pZGModmFsdWU6IGJvb2xlYW4gfCBjZGt0Zi5JUmVzb2x2YWJsZSB8IHVuZGVmaW5lZCkge1xuICAgIHRoaXMuX3VzZU9pZGMgPSB2YWx1ZTtcbiAgfVxuICBwdWJsaWMgcmVzZXRVc2VPaWRjKCkge1xuICAgIHRoaXMuX3VzZU9pZGMgPSB1bmRlZmluZWQ7XG4gIH1cbiAgLy8gVGVtcG9yYXJpbHkgZXhwb3NlIGlucHV0IHZhbHVlLiBVc2Ugd2l0aCBjYXV0aW9uLlxuICBwdWJsaWMgZ2V0IHVzZU9pZGNJbnB1dCgpIHtcbiAgICByZXR1cm4gdGhpcy5fdXNlT2lkYztcbiAgfVxuXG4gIC8vIGFsaWFzIC0gY29tcHV0ZWQ6IGZhbHNlLCBvcHRpb25hbDogdHJ1ZSwgcmVxdWlyZWQ6IGZhbHNlXG4gIHByaXZhdGUgX2FsaWFzPzogc3RyaW5nOyBcbiAgcHVibGljIGdldCBhbGlhcygpIHtcbiAgICByZXR1cm4gdGhpcy5fYWxpYXM7XG4gIH1cbiAgcHVibGljIHNldCBhbGlhcyh2YWx1ZTogc3RyaW5nIHwgdW5kZWZpbmVkKSB7XG4gICAgdGhpcy5fYWxpYXMgPSB2YWx1ZTtcbiAgfVxuICBwdWJsaWMgcmVzZXRBbGlhcygpIHtcbiAgICB0aGlzLl9hbGlhcyA9IHVuZGVmaW5lZDtcbiAgfVxuICAvLyBUZW1wb3JhcmlseSBleHBvc2UgaW5wdXQgdmFsdWUuIFVzZSB3aXRoIGNhdXRpb24uXG4gIHB1YmxpYyBnZXQgYWxpYXNJbnB1dCgpIHtcbiAgICByZXR1cm4gdGhpcy5fYWxpYXM7XG4gIH1cblxuICAvLyBmZWF0dXJlcyAtIGNvbXB1dGVkOiBmYWxzZSwgb3B0aW9uYWw6IGZhbHNlLCByZXF1aXJlZDogdHJ1ZVxuICBwcml2YXRlIF9mZWF0dXJlcz86IEF6dXJlcm1Qcm92aWRlckZlYXR1cmVzOyBcbiAgcHVibGljIGdldCBmZWF0dXJlcygpIHtcbiAgICByZXR1cm4gdGhpcy5fZmVhdHVyZXM7XG4gIH1cbiAgcHVibGljIHNldCBmZWF0dXJlcyh2YWx1ZTogQXp1cmVybVByb3ZpZGVyRmVhdHVyZXMgfCB1bmRlZmluZWQpIHtcbiAgICB0aGlzLl9mZWF0dXJlcyA9IHZhbHVlO1xuICB9XG4gIC8vIFRlbXBvcmFyaWx5IGV4cG9zZSBpbnB1dCB2YWx1ZS4gVXNlIHdpdGggY2F1dGlvbi5cbiAgcHVibGljIGdldCBmZWF0dXJlc0lucHV0KCkge1xuICAgIHJldHVybiB0aGlzLl9mZWF0dXJlcztcbiAgfVxuXG4gIC8vID09PT09PT09PVxuICAvLyBTWU5USEVTSVNcbiAgLy8gPT09PT09PT09XG5cbiAgcHJvdGVjdGVkIHN5bnRoZXNpemVBdHRyaWJ1dGVzKCk6IHsgW25hbWU6IHN0cmluZ106IGFueSB9IHtcbiAgICByZXR1cm4ge1xuICAgICAgYXV4aWxpYXJ5X3RlbmFudF9pZHM6IGNka3RmLmxpc3RNYXBwZXIoY2RrdGYuc3RyaW5nVG9UZXJyYWZvcm0sIGZhbHNlKSh0aGlzLl9hdXhpbGlhcnlUZW5hbnRJZHMpLFxuICAgICAgY2xpZW50X2NlcnRpZmljYXRlX3Bhc3N3b3JkOiBjZGt0Zi5zdHJpbmdUb1RlcnJhZm9ybSh0aGlzLl9jbGllbnRDZXJ0aWZpY2F0ZVBhc3N3b3JkKSxcbiAgICAgIGNsaWVudF9jZXJ0aWZpY2F0ZV9wYXRoOiBjZGt0Zi5zdHJpbmdUb1RlcnJhZm9ybSh0aGlzLl9jbGllbnRDZXJ0aWZpY2F0ZVBhdGgpLFxuICAgICAgY2xpZW50X2lkOiBjZGt0Zi5zdHJpbmdUb1RlcnJhZm9ybSh0aGlzLl9jbGllbnRJZCksXG4gICAgICBjbGllbnRfc2VjcmV0OiBjZGt0Zi5zdHJpbmdUb1RlcnJhZm9ybSh0aGlzLl9jbGllbnRTZWNyZXQpLFxuICAgICAgZGlzYWJsZV9jb3JyZWxhdGlvbl9yZXF1ZXN0X2lkOiBjZGt0Zi5ib29sZWFuVG9UZXJyYWZvcm0odGhpcy5fZGlzYWJsZUNvcnJlbGF0aW9uUmVxdWVzdElkKSxcbiAgICAgIGRpc2FibGVfdGVycmFmb3JtX3BhcnRuZXJfaWQ6IGNka3RmLmJvb2xlYW5Ub1RlcnJhZm9ybSh0aGlzLl9kaXNhYmxlVGVycmFmb3JtUGFydG5lcklkKSxcbiAgICAgIGVudmlyb25tZW50OiBjZGt0Zi5zdHJpbmdUb1RlcnJhZm9ybSh0aGlzLl9lbnZpcm9ubWVudCksXG4gICAgICBtZXRhZGF0YV9ob3N0OiBjZGt0Zi5zdHJpbmdUb1RlcnJhZm9ybSh0aGlzLl9tZXRhZGF0YUhvc3QpLFxuICAgICAgbXNpX2VuZHBvaW50OiBjZGt0Zi5zdHJpbmdUb1RlcnJhZm9ybSh0aGlzLl9tc2lFbmRwb2ludCksXG4gICAgICBvaWRjX3JlcXVlc3RfdG9rZW46IGNka3RmLnN0cmluZ1RvVGVycmFmb3JtKHRoaXMuX29pZGNSZXF1ZXN0VG9rZW4pLFxuICAgICAgb2lkY19yZXF1ZXN0X3VybDogY2RrdGYuc3RyaW5nVG9UZXJyYWZvcm0odGhpcy5fb2lkY1JlcXVlc3RVcmwpLFxuICAgICAgb2lkY190b2tlbjogY2RrdGYuc3RyaW5nVG9UZXJyYWZvcm0odGhpcy5fb2lkY1Rva2VuKSxcbiAgICAgIHBhcnRuZXJfaWQ6IGNka3RmLnN0cmluZ1RvVGVycmFmb3JtKHRoaXMuX3BhcnRuZXJJZCksXG4gICAgICBza2lwX3Byb3ZpZGVyX3JlZ2lzdHJhdGlvbjogY2RrdGYuYm9vbGVhblRvVGVycmFmb3JtKHRoaXMuX3NraXBQcm92aWRlclJlZ2lzdHJhdGlvbiksXG4gICAgICBzdG9yYWdlX3VzZV9henVyZWFkOiBjZGt0Zi5ib29sZWFuVG9UZXJyYWZvcm0odGhpcy5fc3RvcmFnZVVzZUF6dXJlYWQpLFxuICAgICAgc3Vic2NyaXB0aW9uX2lkOiBjZGt0Zi5zdHJpbmdUb1RlcnJhZm9ybSh0aGlzLl9zdWJzY3JpcHRpb25JZCksXG4gICAgICB0ZW5hbnRfaWQ6IGNka3RmLnN0cmluZ1RvVGVycmFmb3JtKHRoaXMuX3RlbmFudElkKSxcbiAgICAgIHVzZV9tc2k6IGNka3RmLmJvb2xlYW5Ub1RlcnJhZm9ybSh0aGlzLl91c2VNc2kpLFxuICAgICAgdXNlX29pZGM6IGNka3RmLmJvb2xlYW5Ub1RlcnJhZm9ybSh0aGlzLl91c2VPaWRjKSxcbiAgICAgIGFsaWFzOiBjZGt0Zi5zdHJpbmdUb1RlcnJhZm9ybSh0aGlzLl9hbGlhcyksXG4gICAgICBmZWF0dXJlczogYXp1cmVybVByb3ZpZGVyRmVhdHVyZXNUb1RlcnJhZm9ybSh0aGlzLl9mZWF0dXJlcyksXG4gICAgfTtcbiAgfVxufVxuIl19