import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface ContainerRegistryTokenConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/container_registry_token#container_registry_name ContainerRegistryToken#container_registry_name}
    */
    readonly containerRegistryName: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/container_registry_token#enabled ContainerRegistryToken#enabled}
    */
    readonly enabled?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/container_registry_token#id ContainerRegistryToken#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/container_registry_token#name ContainerRegistryToken#name}
    */
    readonly name: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/container_registry_token#resource_group_name ContainerRegistryToken#resource_group_name}
    */
    readonly resourceGroupName: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/container_registry_token#scope_map_id ContainerRegistryToken#scope_map_id}
    */
    readonly scopeMapId: string;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/container_registry_token#timeouts ContainerRegistryToken#timeouts}
    */
    readonly timeouts?: ContainerRegistryTokenTimeouts;
}
export interface ContainerRegistryTokenTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/container_registry_token#create ContainerRegistryToken#create}
    */
    readonly create?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/container_registry_token#delete ContainerRegistryToken#delete}
    */
    readonly delete?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/container_registry_token#read ContainerRegistryToken#read}
    */
    readonly read?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/container_registry_token#update ContainerRegistryToken#update}
    */
    readonly update?: string;
}
export declare function containerRegistryTokenTimeoutsToTerraform(struct?: ContainerRegistryTokenTimeoutsOutputReference | ContainerRegistryTokenTimeouts | cdktf.IResolvable): any;
export declare class ContainerRegistryTokenTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): ContainerRegistryTokenTimeouts | cdktf.IResolvable | undefined;
    set internalValue(value: ContainerRegistryTokenTimeouts | cdktf.IResolvable | undefined);
    private _create?;
    get create(): string;
    set create(value: string);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _delete?;
    get delete(): string;
    set delete(value: string);
    resetDelete(): void;
    get deleteInput(): string | undefined;
    private _read?;
    get read(): string;
    set read(value: string);
    resetRead(): void;
    get readInput(): string | undefined;
    private _update?;
    get update(): string;
    set update(value: string);
    resetUpdate(): void;
    get updateInput(): string | undefined;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/azurerm/r/container_registry_token azurerm_container_registry_token}
*/
export declare class ContainerRegistryToken extends cdktf.TerraformResource {
    static readonly tfResourceType = "azurerm_container_registry_token";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/azurerm/r/container_registry_token azurerm_container_registry_token} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options ContainerRegistryTokenConfig
    */
    constructor(scope: Construct, id: string, config: ContainerRegistryTokenConfig);
    private _containerRegistryName?;
    get containerRegistryName(): string;
    set containerRegistryName(value: string);
    get containerRegistryNameInput(): string | undefined;
    private _enabled?;
    get enabled(): boolean | cdktf.IResolvable;
    set enabled(value: boolean | cdktf.IResolvable);
    resetEnabled(): void;
    get enabledInput(): boolean | cdktf.IResolvable | undefined;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _resourceGroupName?;
    get resourceGroupName(): string;
    set resourceGroupName(value: string);
    get resourceGroupNameInput(): string | undefined;
    private _scopeMapId?;
    get scopeMapId(): string;
    set scopeMapId(value: string);
    get scopeMapIdInput(): string | undefined;
    private _timeouts;
    get timeouts(): ContainerRegistryTokenTimeoutsOutputReference;
    putTimeouts(value: ContainerRegistryTokenTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): cdktf.IResolvable | ContainerRegistryTokenTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
