import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface EventhubNamespaceSchemaGroupConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/eventhub_namespace_schema_group#id EventhubNamespaceSchemaGroup#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/eventhub_namespace_schema_group#name EventhubNamespaceSchemaGroup#name}
    */
    readonly name: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/eventhub_namespace_schema_group#namespace_id EventhubNamespaceSchemaGroup#namespace_id}
    */
    readonly namespaceId: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/eventhub_namespace_schema_group#schema_compatibility EventhubNamespaceSchemaGroup#schema_compatibility}
    */
    readonly schemaCompatibility: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/eventhub_namespace_schema_group#schema_type EventhubNamespaceSchemaGroup#schema_type}
    */
    readonly schemaType: string;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/eventhub_namespace_schema_group#timeouts EventhubNamespaceSchemaGroup#timeouts}
    */
    readonly timeouts?: EventhubNamespaceSchemaGroupTimeouts;
}
export interface EventhubNamespaceSchemaGroupTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/eventhub_namespace_schema_group#create EventhubNamespaceSchemaGroup#create}
    */
    readonly create?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/eventhub_namespace_schema_group#delete EventhubNamespaceSchemaGroup#delete}
    */
    readonly delete?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/eventhub_namespace_schema_group#read EventhubNamespaceSchemaGroup#read}
    */
    readonly read?: string;
}
export declare function eventhubNamespaceSchemaGroupTimeoutsToTerraform(struct?: EventhubNamespaceSchemaGroupTimeoutsOutputReference | EventhubNamespaceSchemaGroupTimeouts | cdktf.IResolvable): any;
export declare class EventhubNamespaceSchemaGroupTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): EventhubNamespaceSchemaGroupTimeouts | cdktf.IResolvable | undefined;
    set internalValue(value: EventhubNamespaceSchemaGroupTimeouts | cdktf.IResolvable | undefined);
    private _create?;
    get create(): string;
    set create(value: string);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _delete?;
    get delete(): string;
    set delete(value: string);
    resetDelete(): void;
    get deleteInput(): string | undefined;
    private _read?;
    get read(): string;
    set read(value: string);
    resetRead(): void;
    get readInput(): string | undefined;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/azurerm/r/eventhub_namespace_schema_group azurerm_eventhub_namespace_schema_group}
*/
export declare class EventhubNamespaceSchemaGroup extends cdktf.TerraformResource {
    static readonly tfResourceType = "azurerm_eventhub_namespace_schema_group";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/azurerm/r/eventhub_namespace_schema_group azurerm_eventhub_namespace_schema_group} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options EventhubNamespaceSchemaGroupConfig
    */
    constructor(scope: Construct, id: string, config: EventhubNamespaceSchemaGroupConfig);
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _namespaceId?;
    get namespaceId(): string;
    set namespaceId(value: string);
    get namespaceIdInput(): string | undefined;
    private _schemaCompatibility?;
    get schemaCompatibility(): string;
    set schemaCompatibility(value: string);
    get schemaCompatibilityInput(): string | undefined;
    private _schemaType?;
    get schemaType(): string;
    set schemaType(value: string);
    get schemaTypeInput(): string | undefined;
    private _timeouts;
    get timeouts(): EventhubNamespaceSchemaGroupTimeoutsOutputReference;
    putTimeouts(value: EventhubNamespaceSchemaGroupTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): cdktf.IResolvable | EventhubNamespaceSchemaGroupTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
