import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface HpcCacheBlobTargetConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/hpc_cache_blob_target#access_policy_name HpcCacheBlobTarget#access_policy_name}
    */
    readonly accessPolicyName?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/hpc_cache_blob_target#cache_name HpcCacheBlobTarget#cache_name}
    */
    readonly cacheName: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/hpc_cache_blob_target#id HpcCacheBlobTarget#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/hpc_cache_blob_target#name HpcCacheBlobTarget#name}
    */
    readonly name: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/hpc_cache_blob_target#namespace_path HpcCacheBlobTarget#namespace_path}
    */
    readonly namespacePath: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/hpc_cache_blob_target#resource_group_name HpcCacheBlobTarget#resource_group_name}
    */
    readonly resourceGroupName: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/hpc_cache_blob_target#storage_container_id HpcCacheBlobTarget#storage_container_id}
    */
    readonly storageContainerId: string;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/hpc_cache_blob_target#timeouts HpcCacheBlobTarget#timeouts}
    */
    readonly timeouts?: HpcCacheBlobTargetTimeouts;
}
export interface HpcCacheBlobTargetTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/hpc_cache_blob_target#create HpcCacheBlobTarget#create}
    */
    readonly create?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/hpc_cache_blob_target#delete HpcCacheBlobTarget#delete}
    */
    readonly delete?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/hpc_cache_blob_target#read HpcCacheBlobTarget#read}
    */
    readonly read?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/hpc_cache_blob_target#update HpcCacheBlobTarget#update}
    */
    readonly update?: string;
}
export declare function hpcCacheBlobTargetTimeoutsToTerraform(struct?: HpcCacheBlobTargetTimeoutsOutputReference | HpcCacheBlobTargetTimeouts | cdktf.IResolvable): any;
export declare class HpcCacheBlobTargetTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): HpcCacheBlobTargetTimeouts | cdktf.IResolvable | undefined;
    set internalValue(value: HpcCacheBlobTargetTimeouts | cdktf.IResolvable | undefined);
    private _create?;
    get create(): string;
    set create(value: string);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _delete?;
    get delete(): string;
    set delete(value: string);
    resetDelete(): void;
    get deleteInput(): string | undefined;
    private _read?;
    get read(): string;
    set read(value: string);
    resetRead(): void;
    get readInput(): string | undefined;
    private _update?;
    get update(): string;
    set update(value: string);
    resetUpdate(): void;
    get updateInput(): string | undefined;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/azurerm/r/hpc_cache_blob_target azurerm_hpc_cache_blob_target}
*/
export declare class HpcCacheBlobTarget extends cdktf.TerraformResource {
    static readonly tfResourceType = "azurerm_hpc_cache_blob_target";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/azurerm/r/hpc_cache_blob_target azurerm_hpc_cache_blob_target} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options HpcCacheBlobTargetConfig
    */
    constructor(scope: Construct, id: string, config: HpcCacheBlobTargetConfig);
    private _accessPolicyName?;
    get accessPolicyName(): string;
    set accessPolicyName(value: string);
    resetAccessPolicyName(): void;
    get accessPolicyNameInput(): string | undefined;
    private _cacheName?;
    get cacheName(): string;
    set cacheName(value: string);
    get cacheNameInput(): string | undefined;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _namespacePath?;
    get namespacePath(): string;
    set namespacePath(value: string);
    get namespacePathInput(): string | undefined;
    private _resourceGroupName?;
    get resourceGroupName(): string;
    set resourceGroupName(value: string);
    get resourceGroupNameInput(): string | undefined;
    private _storageContainerId?;
    get storageContainerId(): string;
    set storageContainerId(value: string);
    get storageContainerIdInput(): string | undefined;
    private _timeouts;
    get timeouts(): HpcCacheBlobTargetTimeoutsOutputReference;
    putTimeouts(value: HpcCacheBlobTargetTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): cdktf.IResolvable | HpcCacheBlobTargetTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
