import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface KeyVaultConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/key_vault#access_policy KeyVault#access_policy}
    */
    readonly accessPolicy?: KeyVaultAccessPolicy[] | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/key_vault#enable_rbac_authorization KeyVault#enable_rbac_authorization}
    */
    readonly enableRbacAuthorization?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/key_vault#enabled_for_deployment KeyVault#enabled_for_deployment}
    */
    readonly enabledForDeployment?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/key_vault#enabled_for_disk_encryption KeyVault#enabled_for_disk_encryption}
    */
    readonly enabledForDiskEncryption?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/key_vault#enabled_for_template_deployment KeyVault#enabled_for_template_deployment}
    */
    readonly enabledForTemplateDeployment?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/key_vault#id KeyVault#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/key_vault#location KeyVault#location}
    */
    readonly location: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/key_vault#name KeyVault#name}
    */
    readonly name: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/key_vault#public_network_access_enabled KeyVault#public_network_access_enabled}
    */
    readonly publicNetworkAccessEnabled?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/key_vault#purge_protection_enabled KeyVault#purge_protection_enabled}
    */
    readonly purgeProtectionEnabled?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/key_vault#resource_group_name KeyVault#resource_group_name}
    */
    readonly resourceGroupName: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/key_vault#sku_name KeyVault#sku_name}
    */
    readonly skuName: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/key_vault#soft_delete_retention_days KeyVault#soft_delete_retention_days}
    */
    readonly softDeleteRetentionDays?: number;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/key_vault#tags KeyVault#tags}
    */
    readonly tags?: {
        [key: string]: string;
    };
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/key_vault#tenant_id KeyVault#tenant_id}
    */
    readonly tenantId: string;
    /**
    * contact block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/key_vault#contact KeyVault#contact}
    */
    readonly contact?: KeyVaultContact[] | cdktf.IResolvable;
    /**
    * network_acls block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/key_vault#network_acls KeyVault#network_acls}
    */
    readonly networkAcls?: KeyVaultNetworkAcls;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/key_vault#timeouts KeyVault#timeouts}
    */
    readonly timeouts?: KeyVaultTimeouts;
}
export interface KeyVaultAccessPolicy {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/key_vault#application_id KeyVault#application_id}
    */
    readonly applicationId?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/key_vault#certificate_permissions KeyVault#certificate_permissions}
    */
    readonly certificatePermissions?: string[];
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/key_vault#key_permissions KeyVault#key_permissions}
    */
    readonly keyPermissions?: string[];
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/key_vault#object_id KeyVault#object_id}
    */
    readonly objectId?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/key_vault#secret_permissions KeyVault#secret_permissions}
    */
    readonly secretPermissions?: string[];
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/key_vault#storage_permissions KeyVault#storage_permissions}
    */
    readonly storagePermissions?: string[];
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/key_vault#tenant_id KeyVault#tenant_id}
    */
    readonly tenantId?: string;
}
export declare function keyVaultAccessPolicyToTerraform(struct?: KeyVaultAccessPolicy | cdktf.IResolvable): any;
export declare class KeyVaultAccessPolicyOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): KeyVaultAccessPolicy | cdktf.IResolvable | undefined;
    set internalValue(value: KeyVaultAccessPolicy | cdktf.IResolvable | undefined);
    private _applicationId?;
    get applicationId(): string;
    set applicationId(value: string);
    resetApplicationId(): void;
    get applicationIdInput(): string | undefined;
    private _certificatePermissions?;
    get certificatePermissions(): string[];
    set certificatePermissions(value: string[]);
    resetCertificatePermissions(): void;
    get certificatePermissionsInput(): string[] | undefined;
    private _keyPermissions?;
    get keyPermissions(): string[];
    set keyPermissions(value: string[]);
    resetKeyPermissions(): void;
    get keyPermissionsInput(): string[] | undefined;
    private _objectId?;
    get objectId(): string;
    set objectId(value: string);
    resetObjectId(): void;
    get objectIdInput(): string | undefined;
    private _secretPermissions?;
    get secretPermissions(): string[];
    set secretPermissions(value: string[]);
    resetSecretPermissions(): void;
    get secretPermissionsInput(): string[] | undefined;
    private _storagePermissions?;
    get storagePermissions(): string[];
    set storagePermissions(value: string[]);
    resetStoragePermissions(): void;
    get storagePermissionsInput(): string[] | undefined;
    private _tenantId?;
    get tenantId(): string;
    set tenantId(value: string);
    resetTenantId(): void;
    get tenantIdInput(): string | undefined;
}
export declare class KeyVaultAccessPolicyList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: KeyVaultAccessPolicy[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): KeyVaultAccessPolicyOutputReference;
}
export interface KeyVaultContact {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/key_vault#email KeyVault#email}
    */
    readonly email: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/key_vault#name KeyVault#name}
    */
    readonly name?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/key_vault#phone KeyVault#phone}
    */
    readonly phone?: string;
}
export declare function keyVaultContactToTerraform(struct?: KeyVaultContact | cdktf.IResolvable): any;
export declare class KeyVaultContactOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): KeyVaultContact | cdktf.IResolvable | undefined;
    set internalValue(value: KeyVaultContact | cdktf.IResolvable | undefined);
    private _email?;
    get email(): string;
    set email(value: string);
    get emailInput(): string | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    resetName(): void;
    get nameInput(): string | undefined;
    private _phone?;
    get phone(): string;
    set phone(value: string);
    resetPhone(): void;
    get phoneInput(): string | undefined;
}
export declare class KeyVaultContactList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: KeyVaultContact[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): KeyVaultContactOutputReference;
}
export interface KeyVaultNetworkAcls {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/key_vault#bypass KeyVault#bypass}
    */
    readonly bypass: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/key_vault#default_action KeyVault#default_action}
    */
    readonly defaultAction: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/key_vault#ip_rules KeyVault#ip_rules}
    */
    readonly ipRules?: string[];
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/key_vault#virtual_network_subnet_ids KeyVault#virtual_network_subnet_ids}
    */
    readonly virtualNetworkSubnetIds?: string[];
}
export declare function keyVaultNetworkAclsToTerraform(struct?: KeyVaultNetworkAclsOutputReference | KeyVaultNetworkAcls): any;
export declare class KeyVaultNetworkAclsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): KeyVaultNetworkAcls | undefined;
    set internalValue(value: KeyVaultNetworkAcls | undefined);
    private _bypass?;
    get bypass(): string;
    set bypass(value: string);
    get bypassInput(): string | undefined;
    private _defaultAction?;
    get defaultAction(): string;
    set defaultAction(value: string);
    get defaultActionInput(): string | undefined;
    private _ipRules?;
    get ipRules(): string[];
    set ipRules(value: string[]);
    resetIpRules(): void;
    get ipRulesInput(): string[] | undefined;
    private _virtualNetworkSubnetIds?;
    get virtualNetworkSubnetIds(): string[];
    set virtualNetworkSubnetIds(value: string[]);
    resetVirtualNetworkSubnetIds(): void;
    get virtualNetworkSubnetIdsInput(): string[] | undefined;
}
export interface KeyVaultTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/key_vault#create KeyVault#create}
    */
    readonly create?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/key_vault#delete KeyVault#delete}
    */
    readonly delete?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/key_vault#read KeyVault#read}
    */
    readonly read?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/key_vault#update KeyVault#update}
    */
    readonly update?: string;
}
export declare function keyVaultTimeoutsToTerraform(struct?: KeyVaultTimeoutsOutputReference | KeyVaultTimeouts | cdktf.IResolvable): any;
export declare class KeyVaultTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): KeyVaultTimeouts | cdktf.IResolvable | undefined;
    set internalValue(value: KeyVaultTimeouts | cdktf.IResolvable | undefined);
    private _create?;
    get create(): string;
    set create(value: string);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _delete?;
    get delete(): string;
    set delete(value: string);
    resetDelete(): void;
    get deleteInput(): string | undefined;
    private _read?;
    get read(): string;
    set read(value: string);
    resetRead(): void;
    get readInput(): string | undefined;
    private _update?;
    get update(): string;
    set update(value: string);
    resetUpdate(): void;
    get updateInput(): string | undefined;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/azurerm/r/key_vault azurerm_key_vault}
*/
export declare class KeyVault extends cdktf.TerraformResource {
    static readonly tfResourceType = "azurerm_key_vault";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/azurerm/r/key_vault azurerm_key_vault} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options KeyVaultConfig
    */
    constructor(scope: Construct, id: string, config: KeyVaultConfig);
    private _accessPolicy;
    get accessPolicy(): KeyVaultAccessPolicyList;
    putAccessPolicy(value: KeyVaultAccessPolicy[] | cdktf.IResolvable): void;
    resetAccessPolicy(): void;
    get accessPolicyInput(): cdktf.IResolvable | KeyVaultAccessPolicy[] | undefined;
    private _enableRbacAuthorization?;
    get enableRbacAuthorization(): boolean | cdktf.IResolvable;
    set enableRbacAuthorization(value: boolean | cdktf.IResolvable);
    resetEnableRbacAuthorization(): void;
    get enableRbacAuthorizationInput(): boolean | cdktf.IResolvable | undefined;
    private _enabledForDeployment?;
    get enabledForDeployment(): boolean | cdktf.IResolvable;
    set enabledForDeployment(value: boolean | cdktf.IResolvable);
    resetEnabledForDeployment(): void;
    get enabledForDeploymentInput(): boolean | cdktf.IResolvable | undefined;
    private _enabledForDiskEncryption?;
    get enabledForDiskEncryption(): boolean | cdktf.IResolvable;
    set enabledForDiskEncryption(value: boolean | cdktf.IResolvable);
    resetEnabledForDiskEncryption(): void;
    get enabledForDiskEncryptionInput(): boolean | cdktf.IResolvable | undefined;
    private _enabledForTemplateDeployment?;
    get enabledForTemplateDeployment(): boolean | cdktf.IResolvable;
    set enabledForTemplateDeployment(value: boolean | cdktf.IResolvable);
    resetEnabledForTemplateDeployment(): void;
    get enabledForTemplateDeploymentInput(): boolean | cdktf.IResolvable | undefined;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _location?;
    get location(): string;
    set location(value: string);
    get locationInput(): string | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _publicNetworkAccessEnabled?;
    get publicNetworkAccessEnabled(): boolean | cdktf.IResolvable;
    set publicNetworkAccessEnabled(value: boolean | cdktf.IResolvable);
    resetPublicNetworkAccessEnabled(): void;
    get publicNetworkAccessEnabledInput(): boolean | cdktf.IResolvable | undefined;
    private _purgeProtectionEnabled?;
    get purgeProtectionEnabled(): boolean | cdktf.IResolvable;
    set purgeProtectionEnabled(value: boolean | cdktf.IResolvable);
    resetPurgeProtectionEnabled(): void;
    get purgeProtectionEnabledInput(): boolean | cdktf.IResolvable | undefined;
    private _resourceGroupName?;
    get resourceGroupName(): string;
    set resourceGroupName(value: string);
    get resourceGroupNameInput(): string | undefined;
    private _skuName?;
    get skuName(): string;
    set skuName(value: string);
    get skuNameInput(): string | undefined;
    private _softDeleteRetentionDays?;
    get softDeleteRetentionDays(): number;
    set softDeleteRetentionDays(value: number);
    resetSoftDeleteRetentionDays(): void;
    get softDeleteRetentionDaysInput(): number | undefined;
    private _tags?;
    get tags(): {
        [key: string]: string;
    };
    set tags(value: {
        [key: string]: string;
    });
    resetTags(): void;
    get tagsInput(): {
        [key: string]: string;
    } | undefined;
    private _tenantId?;
    get tenantId(): string;
    set tenantId(value: string);
    get tenantIdInput(): string | undefined;
    get vaultUri(): string;
    private _contact;
    get contact(): KeyVaultContactList;
    putContact(value: KeyVaultContact[] | cdktf.IResolvable): void;
    resetContact(): void;
    get contactInput(): cdktf.IResolvable | KeyVaultContact[] | undefined;
    private _networkAcls;
    get networkAcls(): KeyVaultNetworkAclsOutputReference;
    putNetworkAcls(value: KeyVaultNetworkAcls): void;
    resetNetworkAcls(): void;
    get networkAclsInput(): KeyVaultNetworkAcls | undefined;
    private _timeouts;
    get timeouts(): KeyVaultTimeoutsOutputReference;
    putTimeouts(value: KeyVaultTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): cdktf.IResolvable | KeyVaultTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
