"use strict";
var _a, _b, _c, _d, _e;
Object.defineProperty(exports, "__esModule", { value: true });
exports.MssqlDatabase = exports.MssqlDatabaseTimeoutsOutputReference = exports.mssqlDatabaseTimeoutsToTerraform = exports.MssqlDatabaseThreatDetectionPolicyOutputReference = exports.mssqlDatabaseThreatDetectionPolicyToTerraform = exports.MssqlDatabaseShortTermRetentionPolicyOutputReference = exports.mssqlDatabaseShortTermRetentionPolicyToTerraform = exports.MssqlDatabaseLongTermRetentionPolicyOutputReference = exports.mssqlDatabaseLongTermRetentionPolicyToTerraform = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const cdktf = require("cdktf");
function mssqlDatabaseLongTermRetentionPolicyToTerraform(struct) {
    if (!cdktf.canInspect(struct) || cdktf.Tokenization.isResolvable(struct)) {
        return struct;
    }
    if (cdktf.isComplexElement(struct)) {
        throw new Error("A complex element was used as configuration, this is not supported: https://cdk.tf/complex-object-as-configuration");
    }
    return {
        monthly_retention: cdktf.stringToTerraform(struct.monthlyRetention),
        week_of_year: cdktf.numberToTerraform(struct.weekOfYear),
        weekly_retention: cdktf.stringToTerraform(struct.weeklyRetention),
        yearly_retention: cdktf.stringToTerraform(struct.yearlyRetention),
    };
}
exports.mssqlDatabaseLongTermRetentionPolicyToTerraform = mssqlDatabaseLongTermRetentionPolicyToTerraform;
class MssqlDatabaseLongTermRetentionPolicyOutputReference extends cdktf.ComplexObject {
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource, terraformAttribute) {
        super(terraformResource, terraformAttribute, false, 0);
        this.isEmptyObject = false;
    }
    get internalValue() {
        let hasAnyValues = this.isEmptyObject;
        const internalValueResult = {};
        if (this._monthlyRetention !== undefined) {
            hasAnyValues = true;
            internalValueResult.monthlyRetention = this._monthlyRetention;
        }
        if (this._weekOfYear !== undefined) {
            hasAnyValues = true;
            internalValueResult.weekOfYear = this._weekOfYear;
        }
        if (this._weeklyRetention !== undefined) {
            hasAnyValues = true;
            internalValueResult.weeklyRetention = this._weeklyRetention;
        }
        if (this._yearlyRetention !== undefined) {
            hasAnyValues = true;
            internalValueResult.yearlyRetention = this._yearlyRetention;
        }
        return hasAnyValues ? internalValueResult : undefined;
    }
    set internalValue(value) {
        if (value === undefined) {
            this.isEmptyObject = false;
            this._monthlyRetention = undefined;
            this._weekOfYear = undefined;
            this._weeklyRetention = undefined;
            this._yearlyRetention = undefined;
        }
        else {
            this.isEmptyObject = Object.keys(value).length === 0;
            this._monthlyRetention = value.monthlyRetention;
            this._weekOfYear = value.weekOfYear;
            this._weeklyRetention = value.weeklyRetention;
            this._yearlyRetention = value.yearlyRetention;
        }
    }
    get monthlyRetention() {
        return this.getStringAttribute('monthly_retention');
    }
    set monthlyRetention(value) {
        this._monthlyRetention = value;
    }
    resetMonthlyRetention() {
        this._monthlyRetention = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get monthlyRetentionInput() {
        return this._monthlyRetention;
    }
    get weekOfYear() {
        return this.getNumberAttribute('week_of_year');
    }
    set weekOfYear(value) {
        this._weekOfYear = value;
    }
    resetWeekOfYear() {
        this._weekOfYear = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get weekOfYearInput() {
        return this._weekOfYear;
    }
    get weeklyRetention() {
        return this.getStringAttribute('weekly_retention');
    }
    set weeklyRetention(value) {
        this._weeklyRetention = value;
    }
    resetWeeklyRetention() {
        this._weeklyRetention = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get weeklyRetentionInput() {
        return this._weeklyRetention;
    }
    get yearlyRetention() {
        return this.getStringAttribute('yearly_retention');
    }
    set yearlyRetention(value) {
        this._yearlyRetention = value;
    }
    resetYearlyRetention() {
        this._yearlyRetention = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get yearlyRetentionInput() {
        return this._yearlyRetention;
    }
}
exports.MssqlDatabaseLongTermRetentionPolicyOutputReference = MssqlDatabaseLongTermRetentionPolicyOutputReference;
_a = JSII_RTTI_SYMBOL_1;
MssqlDatabaseLongTermRetentionPolicyOutputReference[_a] = { fqn: "@cdktf/provider-azurerm.MssqlDatabaseLongTermRetentionPolicyOutputReference", version: "2.0.15" };
function mssqlDatabaseShortTermRetentionPolicyToTerraform(struct) {
    if (!cdktf.canInspect(struct) || cdktf.Tokenization.isResolvable(struct)) {
        return struct;
    }
    if (cdktf.isComplexElement(struct)) {
        throw new Error("A complex element was used as configuration, this is not supported: https://cdk.tf/complex-object-as-configuration");
    }
    return {
        backup_interval_in_hours: cdktf.numberToTerraform(struct.backupIntervalInHours),
        retention_days: cdktf.numberToTerraform(struct.retentionDays),
    };
}
exports.mssqlDatabaseShortTermRetentionPolicyToTerraform = mssqlDatabaseShortTermRetentionPolicyToTerraform;
class MssqlDatabaseShortTermRetentionPolicyOutputReference extends cdktf.ComplexObject {
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource, terraformAttribute) {
        super(terraformResource, terraformAttribute, false, 0);
        this.isEmptyObject = false;
    }
    get internalValue() {
        let hasAnyValues = this.isEmptyObject;
        const internalValueResult = {};
        if (this._backupIntervalInHours !== undefined) {
            hasAnyValues = true;
            internalValueResult.backupIntervalInHours = this._backupIntervalInHours;
        }
        if (this._retentionDays !== undefined) {
            hasAnyValues = true;
            internalValueResult.retentionDays = this._retentionDays;
        }
        return hasAnyValues ? internalValueResult : undefined;
    }
    set internalValue(value) {
        if (value === undefined) {
            this.isEmptyObject = false;
            this._backupIntervalInHours = undefined;
            this._retentionDays = undefined;
        }
        else {
            this.isEmptyObject = Object.keys(value).length === 0;
            this._backupIntervalInHours = value.backupIntervalInHours;
            this._retentionDays = value.retentionDays;
        }
    }
    get backupIntervalInHours() {
        return this.getNumberAttribute('backup_interval_in_hours');
    }
    set backupIntervalInHours(value) {
        this._backupIntervalInHours = value;
    }
    resetBackupIntervalInHours() {
        this._backupIntervalInHours = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get backupIntervalInHoursInput() {
        return this._backupIntervalInHours;
    }
    get retentionDays() {
        return this.getNumberAttribute('retention_days');
    }
    set retentionDays(value) {
        this._retentionDays = value;
    }
    // Temporarily expose input value. Use with caution.
    get retentionDaysInput() {
        return this._retentionDays;
    }
}
exports.MssqlDatabaseShortTermRetentionPolicyOutputReference = MssqlDatabaseShortTermRetentionPolicyOutputReference;
_b = JSII_RTTI_SYMBOL_1;
MssqlDatabaseShortTermRetentionPolicyOutputReference[_b] = { fqn: "@cdktf/provider-azurerm.MssqlDatabaseShortTermRetentionPolicyOutputReference", version: "2.0.15" };
function mssqlDatabaseThreatDetectionPolicyToTerraform(struct) {
    if (!cdktf.canInspect(struct) || cdktf.Tokenization.isResolvable(struct)) {
        return struct;
    }
    if (cdktf.isComplexElement(struct)) {
        throw new Error("A complex element was used as configuration, this is not supported: https://cdk.tf/complex-object-as-configuration");
    }
    return {
        disabled_alerts: cdktf.listMapper(cdktf.stringToTerraform, false)(struct.disabledAlerts),
        email_account_admins: cdktf.stringToTerraform(struct.emailAccountAdmins),
        email_addresses: cdktf.listMapper(cdktf.stringToTerraform, false)(struct.emailAddresses),
        retention_days: cdktf.numberToTerraform(struct.retentionDays),
        state: cdktf.stringToTerraform(struct.state),
        storage_account_access_key: cdktf.stringToTerraform(struct.storageAccountAccessKey),
        storage_endpoint: cdktf.stringToTerraform(struct.storageEndpoint),
    };
}
exports.mssqlDatabaseThreatDetectionPolicyToTerraform = mssqlDatabaseThreatDetectionPolicyToTerraform;
class MssqlDatabaseThreatDetectionPolicyOutputReference extends cdktf.ComplexObject {
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource, terraformAttribute) {
        super(terraformResource, terraformAttribute, false, 0);
        this.isEmptyObject = false;
    }
    get internalValue() {
        let hasAnyValues = this.isEmptyObject;
        const internalValueResult = {};
        if (this._disabledAlerts !== undefined) {
            hasAnyValues = true;
            internalValueResult.disabledAlerts = this._disabledAlerts;
        }
        if (this._emailAccountAdmins !== undefined) {
            hasAnyValues = true;
            internalValueResult.emailAccountAdmins = this._emailAccountAdmins;
        }
        if (this._emailAddresses !== undefined) {
            hasAnyValues = true;
            internalValueResult.emailAddresses = this._emailAddresses;
        }
        if (this._retentionDays !== undefined) {
            hasAnyValues = true;
            internalValueResult.retentionDays = this._retentionDays;
        }
        if (this._state !== undefined) {
            hasAnyValues = true;
            internalValueResult.state = this._state;
        }
        if (this._storageAccountAccessKey !== undefined) {
            hasAnyValues = true;
            internalValueResult.storageAccountAccessKey = this._storageAccountAccessKey;
        }
        if (this._storageEndpoint !== undefined) {
            hasAnyValues = true;
            internalValueResult.storageEndpoint = this._storageEndpoint;
        }
        return hasAnyValues ? internalValueResult : undefined;
    }
    set internalValue(value) {
        if (value === undefined) {
            this.isEmptyObject = false;
            this._disabledAlerts = undefined;
            this._emailAccountAdmins = undefined;
            this._emailAddresses = undefined;
            this._retentionDays = undefined;
            this._state = undefined;
            this._storageAccountAccessKey = undefined;
            this._storageEndpoint = undefined;
        }
        else {
            this.isEmptyObject = Object.keys(value).length === 0;
            this._disabledAlerts = value.disabledAlerts;
            this._emailAccountAdmins = value.emailAccountAdmins;
            this._emailAddresses = value.emailAddresses;
            this._retentionDays = value.retentionDays;
            this._state = value.state;
            this._storageAccountAccessKey = value.storageAccountAccessKey;
            this._storageEndpoint = value.storageEndpoint;
        }
    }
    get disabledAlerts() {
        return cdktf.Fn.tolist(this.getListAttribute('disabled_alerts'));
    }
    set disabledAlerts(value) {
        this._disabledAlerts = value;
    }
    resetDisabledAlerts() {
        this._disabledAlerts = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get disabledAlertsInput() {
        return this._disabledAlerts;
    }
    get emailAccountAdmins() {
        return this.getStringAttribute('email_account_admins');
    }
    set emailAccountAdmins(value) {
        this._emailAccountAdmins = value;
    }
    resetEmailAccountAdmins() {
        this._emailAccountAdmins = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get emailAccountAdminsInput() {
        return this._emailAccountAdmins;
    }
    get emailAddresses() {
        return cdktf.Fn.tolist(this.getListAttribute('email_addresses'));
    }
    set emailAddresses(value) {
        this._emailAddresses = value;
    }
    resetEmailAddresses() {
        this._emailAddresses = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get emailAddressesInput() {
        return this._emailAddresses;
    }
    get retentionDays() {
        return this.getNumberAttribute('retention_days');
    }
    set retentionDays(value) {
        this._retentionDays = value;
    }
    resetRetentionDays() {
        this._retentionDays = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get retentionDaysInput() {
        return this._retentionDays;
    }
    get state() {
        return this.getStringAttribute('state');
    }
    set state(value) {
        this._state = value;
    }
    resetState() {
        this._state = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get stateInput() {
        return this._state;
    }
    get storageAccountAccessKey() {
        return this.getStringAttribute('storage_account_access_key');
    }
    set storageAccountAccessKey(value) {
        this._storageAccountAccessKey = value;
    }
    resetStorageAccountAccessKey() {
        this._storageAccountAccessKey = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get storageAccountAccessKeyInput() {
        return this._storageAccountAccessKey;
    }
    get storageEndpoint() {
        return this.getStringAttribute('storage_endpoint');
    }
    set storageEndpoint(value) {
        this._storageEndpoint = value;
    }
    resetStorageEndpoint() {
        this._storageEndpoint = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get storageEndpointInput() {
        return this._storageEndpoint;
    }
}
exports.MssqlDatabaseThreatDetectionPolicyOutputReference = MssqlDatabaseThreatDetectionPolicyOutputReference;
_c = JSII_RTTI_SYMBOL_1;
MssqlDatabaseThreatDetectionPolicyOutputReference[_c] = { fqn: "@cdktf/provider-azurerm.MssqlDatabaseThreatDetectionPolicyOutputReference", version: "2.0.15" };
function mssqlDatabaseTimeoutsToTerraform(struct) {
    if (!cdktf.canInspect(struct) || cdktf.Tokenization.isResolvable(struct)) {
        return struct;
    }
    if (cdktf.isComplexElement(struct)) {
        throw new Error("A complex element was used as configuration, this is not supported: https://cdk.tf/complex-object-as-configuration");
    }
    return {
        create: cdktf.stringToTerraform(struct.create),
        delete: cdktf.stringToTerraform(struct.delete),
        read: cdktf.stringToTerraform(struct.read),
        update: cdktf.stringToTerraform(struct.update),
    };
}
exports.mssqlDatabaseTimeoutsToTerraform = mssqlDatabaseTimeoutsToTerraform;
class MssqlDatabaseTimeoutsOutputReference extends cdktf.ComplexObject {
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource, terraformAttribute) {
        super(terraformResource, terraformAttribute, false, 0);
        this.isEmptyObject = false;
    }
    get internalValue() {
        if (this.resolvableValue) {
            return this.resolvableValue;
        }
        let hasAnyValues = this.isEmptyObject;
        const internalValueResult = {};
        if (this._create !== undefined) {
            hasAnyValues = true;
            internalValueResult.create = this._create;
        }
        if (this._delete !== undefined) {
            hasAnyValues = true;
            internalValueResult.delete = this._delete;
        }
        if (this._read !== undefined) {
            hasAnyValues = true;
            internalValueResult.read = this._read;
        }
        if (this._update !== undefined) {
            hasAnyValues = true;
            internalValueResult.update = this._update;
        }
        return hasAnyValues ? internalValueResult : undefined;
    }
    set internalValue(value) {
        if (value === undefined) {
            this.isEmptyObject = false;
            this.resolvableValue = undefined;
            this._create = undefined;
            this._delete = undefined;
            this._read = undefined;
            this._update = undefined;
        }
        else if (cdktf.Tokenization.isResolvable(value)) {
            this.isEmptyObject = false;
            this.resolvableValue = value;
        }
        else {
            this.isEmptyObject = Object.keys(value).length === 0;
            this.resolvableValue = undefined;
            this._create = value.create;
            this._delete = value.delete;
            this._read = value.read;
            this._update = value.update;
        }
    }
    get create() {
        return this.getStringAttribute('create');
    }
    set create(value) {
        this._create = value;
    }
    resetCreate() {
        this._create = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get createInput() {
        return this._create;
    }
    get delete() {
        return this.getStringAttribute('delete');
    }
    set delete(value) {
        this._delete = value;
    }
    resetDelete() {
        this._delete = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get deleteInput() {
        return this._delete;
    }
    get read() {
        return this.getStringAttribute('read');
    }
    set read(value) {
        this._read = value;
    }
    resetRead() {
        this._read = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get readInput() {
        return this._read;
    }
    get update() {
        return this.getStringAttribute('update');
    }
    set update(value) {
        this._update = value;
    }
    resetUpdate() {
        this._update = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get updateInput() {
        return this._update;
    }
}
exports.MssqlDatabaseTimeoutsOutputReference = MssqlDatabaseTimeoutsOutputReference;
_d = JSII_RTTI_SYMBOL_1;
MssqlDatabaseTimeoutsOutputReference[_d] = { fqn: "@cdktf/provider-azurerm.MssqlDatabaseTimeoutsOutputReference", version: "2.0.15" };
/**
* Represents a {@link https://www.terraform.io/docs/providers/azurerm/r/mssql_database azurerm_mssql_database}
*/
class MssqlDatabase extends cdktf.TerraformResource {
    // ===========
    // INITIALIZER
    // ===========
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/azurerm/r/mssql_database azurerm_mssql_database} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options MssqlDatabaseConfig
    */
    constructor(scope, id, config) {
        super(scope, id, {
            terraformResourceType: 'azurerm_mssql_database',
            terraformGeneratorMetadata: {
                providerName: 'azurerm',
                providerVersion: '3.24.0',
                providerVersionConstraint: '~> 3.10'
            },
            provider: config.provider,
            dependsOn: config.dependsOn,
            count: config.count,
            lifecycle: config.lifecycle,
            provisioners: config.provisioners,
            connection: config.connection,
            forEach: config.forEach
        });
        // long_term_retention_policy - computed: false, optional: true, required: false
        this._longTermRetentionPolicy = new MssqlDatabaseLongTermRetentionPolicyOutputReference(this, "long_term_retention_policy");
        // short_term_retention_policy - computed: false, optional: true, required: false
        this._shortTermRetentionPolicy = new MssqlDatabaseShortTermRetentionPolicyOutputReference(this, "short_term_retention_policy");
        // threat_detection_policy - computed: false, optional: true, required: false
        this._threatDetectionPolicy = new MssqlDatabaseThreatDetectionPolicyOutputReference(this, "threat_detection_policy");
        // timeouts - computed: false, optional: true, required: false
        this._timeouts = new MssqlDatabaseTimeoutsOutputReference(this, "timeouts");
        this._autoPauseDelayInMinutes = config.autoPauseDelayInMinutes;
        this._collation = config.collation;
        this._createMode = config.createMode;
        this._creationSourceDatabaseId = config.creationSourceDatabaseId;
        this._elasticPoolId = config.elasticPoolId;
        this._geoBackupEnabled = config.geoBackupEnabled;
        this._id = config.id;
        this._ledgerEnabled = config.ledgerEnabled;
        this._licenseType = config.licenseType;
        this._maintenanceConfigurationName = config.maintenanceConfigurationName;
        this._maxSizeGb = config.maxSizeGb;
        this._minCapacity = config.minCapacity;
        this._name = config.name;
        this._readReplicaCount = config.readReplicaCount;
        this._readScale = config.readScale;
        this._recoverDatabaseId = config.recoverDatabaseId;
        this._restoreDroppedDatabaseId = config.restoreDroppedDatabaseId;
        this._restorePointInTime = config.restorePointInTime;
        this._sampleName = config.sampleName;
        this._serverId = config.serverId;
        this._skuName = config.skuName;
        this._storageAccountType = config.storageAccountType;
        this._tags = config.tags;
        this._transparentDataEncryptionEnabled = config.transparentDataEncryptionEnabled;
        this._zoneRedundant = config.zoneRedundant;
        this._longTermRetentionPolicy.internalValue = config.longTermRetentionPolicy;
        this._shortTermRetentionPolicy.internalValue = config.shortTermRetentionPolicy;
        this._threatDetectionPolicy.internalValue = config.threatDetectionPolicy;
        this._timeouts.internalValue = config.timeouts;
    }
    get autoPauseDelayInMinutes() {
        return this.getNumberAttribute('auto_pause_delay_in_minutes');
    }
    set autoPauseDelayInMinutes(value) {
        this._autoPauseDelayInMinutes = value;
    }
    resetAutoPauseDelayInMinutes() {
        this._autoPauseDelayInMinutes = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get autoPauseDelayInMinutesInput() {
        return this._autoPauseDelayInMinutes;
    }
    get collation() {
        return this.getStringAttribute('collation');
    }
    set collation(value) {
        this._collation = value;
    }
    resetCollation() {
        this._collation = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get collationInput() {
        return this._collation;
    }
    get createMode() {
        return this.getStringAttribute('create_mode');
    }
    set createMode(value) {
        this._createMode = value;
    }
    resetCreateMode() {
        this._createMode = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get createModeInput() {
        return this._createMode;
    }
    get creationSourceDatabaseId() {
        return this.getStringAttribute('creation_source_database_id');
    }
    set creationSourceDatabaseId(value) {
        this._creationSourceDatabaseId = value;
    }
    resetCreationSourceDatabaseId() {
        this._creationSourceDatabaseId = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get creationSourceDatabaseIdInput() {
        return this._creationSourceDatabaseId;
    }
    get elasticPoolId() {
        return this.getStringAttribute('elastic_pool_id');
    }
    set elasticPoolId(value) {
        this._elasticPoolId = value;
    }
    resetElasticPoolId() {
        this._elasticPoolId = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get elasticPoolIdInput() {
        return this._elasticPoolId;
    }
    get geoBackupEnabled() {
        return this.getBooleanAttribute('geo_backup_enabled');
    }
    set geoBackupEnabled(value) {
        this._geoBackupEnabled = value;
    }
    resetGeoBackupEnabled() {
        this._geoBackupEnabled = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get geoBackupEnabledInput() {
        return this._geoBackupEnabled;
    }
    get id() {
        return this.getStringAttribute('id');
    }
    set id(value) {
        this._id = value;
    }
    resetId() {
        this._id = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get idInput() {
        return this._id;
    }
    get ledgerEnabled() {
        return this.getBooleanAttribute('ledger_enabled');
    }
    set ledgerEnabled(value) {
        this._ledgerEnabled = value;
    }
    resetLedgerEnabled() {
        this._ledgerEnabled = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get ledgerEnabledInput() {
        return this._ledgerEnabled;
    }
    get licenseType() {
        return this.getStringAttribute('license_type');
    }
    set licenseType(value) {
        this._licenseType = value;
    }
    resetLicenseType() {
        this._licenseType = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get licenseTypeInput() {
        return this._licenseType;
    }
    get maintenanceConfigurationName() {
        return this.getStringAttribute('maintenance_configuration_name');
    }
    set maintenanceConfigurationName(value) {
        this._maintenanceConfigurationName = value;
    }
    resetMaintenanceConfigurationName() {
        this._maintenanceConfigurationName = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get maintenanceConfigurationNameInput() {
        return this._maintenanceConfigurationName;
    }
    get maxSizeGb() {
        return this.getNumberAttribute('max_size_gb');
    }
    set maxSizeGb(value) {
        this._maxSizeGb = value;
    }
    resetMaxSizeGb() {
        this._maxSizeGb = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get maxSizeGbInput() {
        return this._maxSizeGb;
    }
    get minCapacity() {
        return this.getNumberAttribute('min_capacity');
    }
    set minCapacity(value) {
        this._minCapacity = value;
    }
    resetMinCapacity() {
        this._minCapacity = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get minCapacityInput() {
        return this._minCapacity;
    }
    get name() {
        return this.getStringAttribute('name');
    }
    set name(value) {
        this._name = value;
    }
    // Temporarily expose input value. Use with caution.
    get nameInput() {
        return this._name;
    }
    get readReplicaCount() {
        return this.getNumberAttribute('read_replica_count');
    }
    set readReplicaCount(value) {
        this._readReplicaCount = value;
    }
    resetReadReplicaCount() {
        this._readReplicaCount = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get readReplicaCountInput() {
        return this._readReplicaCount;
    }
    get readScale() {
        return this.getBooleanAttribute('read_scale');
    }
    set readScale(value) {
        this._readScale = value;
    }
    resetReadScale() {
        this._readScale = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get readScaleInput() {
        return this._readScale;
    }
    get recoverDatabaseId() {
        return this.getStringAttribute('recover_database_id');
    }
    set recoverDatabaseId(value) {
        this._recoverDatabaseId = value;
    }
    resetRecoverDatabaseId() {
        this._recoverDatabaseId = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get recoverDatabaseIdInput() {
        return this._recoverDatabaseId;
    }
    get restoreDroppedDatabaseId() {
        return this.getStringAttribute('restore_dropped_database_id');
    }
    set restoreDroppedDatabaseId(value) {
        this._restoreDroppedDatabaseId = value;
    }
    resetRestoreDroppedDatabaseId() {
        this._restoreDroppedDatabaseId = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get restoreDroppedDatabaseIdInput() {
        return this._restoreDroppedDatabaseId;
    }
    get restorePointInTime() {
        return this.getStringAttribute('restore_point_in_time');
    }
    set restorePointInTime(value) {
        this._restorePointInTime = value;
    }
    resetRestorePointInTime() {
        this._restorePointInTime = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get restorePointInTimeInput() {
        return this._restorePointInTime;
    }
    get sampleName() {
        return this.getStringAttribute('sample_name');
    }
    set sampleName(value) {
        this._sampleName = value;
    }
    resetSampleName() {
        this._sampleName = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get sampleNameInput() {
        return this._sampleName;
    }
    get serverId() {
        return this.getStringAttribute('server_id');
    }
    set serverId(value) {
        this._serverId = value;
    }
    // Temporarily expose input value. Use with caution.
    get serverIdInput() {
        return this._serverId;
    }
    get skuName() {
        return this.getStringAttribute('sku_name');
    }
    set skuName(value) {
        this._skuName = value;
    }
    resetSkuName() {
        this._skuName = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get skuNameInput() {
        return this._skuName;
    }
    get storageAccountType() {
        return this.getStringAttribute('storage_account_type');
    }
    set storageAccountType(value) {
        this._storageAccountType = value;
    }
    resetStorageAccountType() {
        this._storageAccountType = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get storageAccountTypeInput() {
        return this._storageAccountType;
    }
    get tags() {
        return this.getStringMapAttribute('tags');
    }
    set tags(value) {
        this._tags = value;
    }
    resetTags() {
        this._tags = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get tagsInput() {
        return this._tags;
    }
    get transparentDataEncryptionEnabled() {
        return this.getBooleanAttribute('transparent_data_encryption_enabled');
    }
    set transparentDataEncryptionEnabled(value) {
        this._transparentDataEncryptionEnabled = value;
    }
    resetTransparentDataEncryptionEnabled() {
        this._transparentDataEncryptionEnabled = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get transparentDataEncryptionEnabledInput() {
        return this._transparentDataEncryptionEnabled;
    }
    get zoneRedundant() {
        return this.getBooleanAttribute('zone_redundant');
    }
    set zoneRedundant(value) {
        this._zoneRedundant = value;
    }
    resetZoneRedundant() {
        this._zoneRedundant = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get zoneRedundantInput() {
        return this._zoneRedundant;
    }
    get longTermRetentionPolicy() {
        return this._longTermRetentionPolicy;
    }
    putLongTermRetentionPolicy(value) {
        this._longTermRetentionPolicy.internalValue = value;
    }
    resetLongTermRetentionPolicy() {
        this._longTermRetentionPolicy.internalValue = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get longTermRetentionPolicyInput() {
        return this._longTermRetentionPolicy.internalValue;
    }
    get shortTermRetentionPolicy() {
        return this._shortTermRetentionPolicy;
    }
    putShortTermRetentionPolicy(value) {
        this._shortTermRetentionPolicy.internalValue = value;
    }
    resetShortTermRetentionPolicy() {
        this._shortTermRetentionPolicy.internalValue = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get shortTermRetentionPolicyInput() {
        return this._shortTermRetentionPolicy.internalValue;
    }
    get threatDetectionPolicy() {
        return this._threatDetectionPolicy;
    }
    putThreatDetectionPolicy(value) {
        this._threatDetectionPolicy.internalValue = value;
    }
    resetThreatDetectionPolicy() {
        this._threatDetectionPolicy.internalValue = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get threatDetectionPolicyInput() {
        return this._threatDetectionPolicy.internalValue;
    }
    get timeouts() {
        return this._timeouts;
    }
    putTimeouts(value) {
        this._timeouts.internalValue = value;
    }
    resetTimeouts() {
        this._timeouts.internalValue = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get timeoutsInput() {
        return this._timeouts.internalValue;
    }
    // =========
    // SYNTHESIS
    // =========
    synthesizeAttributes() {
        return {
            auto_pause_delay_in_minutes: cdktf.numberToTerraform(this._autoPauseDelayInMinutes),
            collation: cdktf.stringToTerraform(this._collation),
            create_mode: cdktf.stringToTerraform(this._createMode),
            creation_source_database_id: cdktf.stringToTerraform(this._creationSourceDatabaseId),
            elastic_pool_id: cdktf.stringToTerraform(this._elasticPoolId),
            geo_backup_enabled: cdktf.booleanToTerraform(this._geoBackupEnabled),
            id: cdktf.stringToTerraform(this._id),
            ledger_enabled: cdktf.booleanToTerraform(this._ledgerEnabled),
            license_type: cdktf.stringToTerraform(this._licenseType),
            maintenance_configuration_name: cdktf.stringToTerraform(this._maintenanceConfigurationName),
            max_size_gb: cdktf.numberToTerraform(this._maxSizeGb),
            min_capacity: cdktf.numberToTerraform(this._minCapacity),
            name: cdktf.stringToTerraform(this._name),
            read_replica_count: cdktf.numberToTerraform(this._readReplicaCount),
            read_scale: cdktf.booleanToTerraform(this._readScale),
            recover_database_id: cdktf.stringToTerraform(this._recoverDatabaseId),
            restore_dropped_database_id: cdktf.stringToTerraform(this._restoreDroppedDatabaseId),
            restore_point_in_time: cdktf.stringToTerraform(this._restorePointInTime),
            sample_name: cdktf.stringToTerraform(this._sampleName),
            server_id: cdktf.stringToTerraform(this._serverId),
            sku_name: cdktf.stringToTerraform(this._skuName),
            storage_account_type: cdktf.stringToTerraform(this._storageAccountType),
            tags: cdktf.hashMapper(cdktf.stringToTerraform)(this._tags),
            transparent_data_encryption_enabled: cdktf.booleanToTerraform(this._transparentDataEncryptionEnabled),
            zone_redundant: cdktf.booleanToTerraform(this._zoneRedundant),
            long_term_retention_policy: mssqlDatabaseLongTermRetentionPolicyToTerraform(this._longTermRetentionPolicy.internalValue),
            short_term_retention_policy: mssqlDatabaseShortTermRetentionPolicyToTerraform(this._shortTermRetentionPolicy.internalValue),
            threat_detection_policy: mssqlDatabaseThreatDetectionPolicyToTerraform(this._threatDetectionPolicy.internalValue),
            timeouts: mssqlDatabaseTimeoutsToTerraform(this._timeouts.internalValue),
        };
    }
}
exports.MssqlDatabase = MssqlDatabase;
_e = JSII_RTTI_SYMBOL_1;
MssqlDatabase[_e] = { fqn: "@cdktf/provider-azurerm.MssqlDatabase", version: "2.0.15" };
// =================
// STATIC PROPERTIES
// =================
MssqlDatabase.tfResourceType = "azurerm_mssql_database";
//# sourceMappingURL=data:application/json;base64,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