"""Add table Studio

Revision ID: 1bb55759146f
Revises: be56dc0fb760
Create Date: 2024-05-31 15:30:17.189541

"""

from alembic import op
import sqlalchemy as sa
import sqlalchemy_utils
import sqlalchemy_utils
import uuid

# revision identifiers, used by Alembic.
revision = "1bb55759146f"
down_revision = "be56dc0fb760"
branch_labels = None
depends_on = None


def upgrade():
    # ### commands auto generated by Alembic - please adjust! ###
    op.create_table(
        "studio",
        sa.Column("name", sa.String(length=80), nullable=False),
        sa.Column("color", sa.String(length=7), nullable=False),
        sa.Column("archived", sa.Boolean(), nullable=True),
        sa.Column(
            "id",
            sqlalchemy_utils.types.uuid.UUIDType(binary=False),
            default=uuid.uuid4,
            nullable=False,
        ),
        sa.Column("created_at", sa.DateTime(), nullable=True),
        sa.Column("updated_at", sa.DateTime(), nullable=True),
        sa.PrimaryKeyConstraint("id"),
        sa.UniqueConstraint("name"),
    )
    with op.batch_alter_table("person", schema=None) as batch_op:
        batch_op.add_column(
            sa.Column(
                "studio_id",
                sqlalchemy_utils.types.uuid.UUIDType(binary=False),
                default=uuid.uuid4,
                nullable=True,
            )
        )
        batch_op.create_index(
            batch_op.f("ix_person_studio_id"), ["studio_id"], unique=False
        )
        batch_op.create_foreign_key(
            "person_studio_id_fkey", "studio", ["studio_id"], ["id"]
        )

    # ### end Alembic commands ###


def downgrade():
    # ### commands auto generated by Alembic - please adjust! ###
    with op.batch_alter_table("person", schema=None) as batch_op:
        batch_op.drop_constraint("person_studio_id_fkey", type_="foreignkey")
        batch_op.drop_index(batch_op.f("ix_person_studio_id"))
        batch_op.drop_column("studio_id")

    op.drop_table("studio")
    # ### end Alembic commands ###
