#
#
#  BLIS
#  An object-based framework for developing high-performance BLAS-like
#  libraries.
#
#  Copyright (C) 2014, The University of Texas at Austin
#
#  Redistribution and use in source and binary forms, with or without
#  modification, are permitted provided that the following conditions are
#  met:
#   - Redistributions of source code must retain the above copyright
#     notice, this list of conditions and the following disclaimer.
#   - Redistributions in binary form must reproduce the above copyright
#     notice, this list of conditions and the following disclaimer in the
#     documentation and/or other materials provided with the distribution.
#   - Neither the name of The University of Texas at Austin nor the names
#     of its contributors may be used to endorse or promote products
#     derived from this software without specific prior written permission.
#
#  THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
#  "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
#  LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
#  A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT
#  HOLDER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
#  SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
#  LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
#  DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
#  THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
#  (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
#  OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
#
#

# Only include this block of code once
ifndef CONFIG_MK_INCLUDED
CONFIG_MK_INCLUDED := yes

# The version string. This could be the official string or a custom
# string forced at configure-time.
VERSION         := 0.2.2-53

# The name of the configuration sub-directory.
CONFIG_NAME     := carrizo

# The operatin g system name, which should be either 'Linux' or 'Darwin'.
OS_NAME         := $(shell uname -s)

# The directory path to the top level of the source distribution.
DIST_PATH       := .

# The level of debugging info to generate.
DEBUG_TYPE      := off

# The C compiler.
CC              := 

# The requested threading model.
THREADING_MODEL := openmp

# The install prefix tell us where to install the libraries and header file
# directory. Notice that we support the use of DESTDIR so that advanced users
# may install to a temporary location.
INSTALL_PREFIX := $(DESTDIR)../_ext

# Variables corresponding to other configure-time options.
BLIS_ENABLE_VERBOSE_MAKE_OUTPUT := no
BLIS_ENABLE_STATIC_BUILD        := yes
BLIS_ENABLE_DYNAMIC_BUILD       := no

# The status of BLAS and CBLAS compatibility layers
BLIS_ENABLE_BLAS2BLIS := yes
BLIS_ENABLE_CBLAS     := no

# end of ifndef CONFIG_MK_INCLUDED conditional block
endif
