"""Media player based on moviepy"""

author = 'Daniel Schreij'
category = 'Visual stimuli'
icon = 'os-media_player_mpy'
controls = [
  {'name': 'video_file',
   'label': 'Video file',
   'type': 'filepool',
   'var': 'video_src'},
  {'name': 'play_audio',
   'label': 'Play audio',
   'options': ['yes', 'no'],
   'type': 'combobox',
   'var': 'playaudio'},
  {'name': 'sound_renderer',
   'label': 'Sound renderer',
   'options': ['pygame', 'pyaudio', 'sounddevice'],
   'info': 'The library to use for sound rendering (recommended: sounddevice)',
   'type': 'combobox',
   'var': 'soundrenderer'},
  {'name': 'loop_video',
   'label': 'Loop',
   'options': ['yes', 'no'],
   'info': 'Restart the video after it ends',
   'type': 'combobox',
   'var': 'loop'},
  {'name': 'resize_video',
   'label': 'Fit video to screen',
   'options': ['yes', 'no'],
   'info': 'Maintains the aspect ratio',
   'type': 'combobox',
   'var': 'resizeVideo'},
  {'name': 'combobox_event_handler_trigger',
   'label': 'Call custom Python code',
   'options': ['on keypress', 'after every frame'],
   'info': 'When to call custom event handling code (if any)',
   'type': 'combobox',
   'var': 'event_handler_trigger'},
  {'label': 'Duration',
   'name': 'line_edit_duration',
   'info': "A value in milliseconds, 'sound', 'mouseclick', or 'keypress'",
   'type': 'line_edit',
   'var': 'duration',
   'validator': 'duration'},
  {'name': 'custom_python_code',
   'label': 'Custom Python code (See Help for more information)',
   'syntax': True,
   'tooltip': 'Specify how you would like to handle events like mouse clicks or keypresses. When set, this overrides the Duration attribute',
   'type': 'editor',
   'var': 'event_handler'},
  {'name': 'info_label',
   'label': '<small><b>Media Player OpenSesame Plugin, Copyright (2015-2023) Daniel Schreij</b></small>',
   'type': 'text'}]
