#!python
# distutils: define_macros=NPY_NO_DEPRECATED_API=NPY_1_7_API_VERSION
# cython: language_level=3
# cython: cpow=True
# cython: boundscheck=False
# cython: wraparound=False
# cython: initializedcheck=False
# cython: cdivision=True
from typing import Optional
import numpy
cimport numpy
from libc.math cimport exp, fabs, log, sin, cos, tan, tanh, asin, acos, atan, isnan, isinf
from libc.math cimport NAN as nan
from libc.math cimport INFINITY as inf
import cython
from cpython.mem cimport PyMem_Malloc
from cpython.mem cimport PyMem_Realloc
from cpython.mem cimport PyMem_Free
from hydpy.cythons.autogen cimport configutils
from hydpy.cythons.autogen cimport interfaceutils
from hydpy.cythons.autogen cimport interputils
from hydpy.cythons.autogen import pointerutils
from hydpy.cythons.autogen cimport pointerutils
from hydpy.cythons.autogen cimport quadutils
from hydpy.cythons.autogen cimport rootutils
from hydpy.cythons.autogen cimport smoothutils
from hydpy.cythons.autogen cimport masterinterface


cdef void do_nothing(Model model)  noexcept nogil:
    pass

cpdef get_wrapper():
    cdef CallbackWrapper wrapper = CallbackWrapper()
    wrapper.callback = do_nothing
    return wrapper

cdef public numpy.npy_bool TYPE_CHECKING = False
@cython.final
cdef class Parameters:
    pass
@cython.final
cdef class ControlParameters:
    pass
@cython.final
cdef class DerivedParameters:
    pass
@cython.final
cdef class SolverParameters:
    pass
@cython.final
cdef class Sequences:
    pass
@cython.final
cdef class InletSequences:
    cpdef inline void load_data(self, numpy.int64_t idx)  noexcept nogil:
        cdef numpy.int64_t jdx0
        cdef numpy.int64_t k
        if self._q_diskflag_reading:
            k = 0
            for jdx0 in range(self._q_length_0):
                self.q[jdx0] = self._q_ncarray[k]
                k += 1
        elif self._q_ramflag:
            for jdx0 in range(self._q_length_0):
                self.q[jdx0] = self._q_array[idx, jdx0]
    cpdef inline void save_data(self, numpy.int64_t idx)  noexcept nogil:
        cdef numpy.int64_t jdx0
        cdef numpy.int64_t k
        if self._q_diskflag_writing:
            k = 0
            for jdx0 in range(self._q_length_0):
                self._q_ncarray[k] = self.q[jdx0]
                k += 1
        if self._q_ramflag:
            for jdx0 in range(self._q_length_0):
                self._q_array[idx, jdx0] = self.q[jdx0]
    cpdef inline alloc_pointer(self, name, numpy.int64_t length):
        if name == "q":
            self._q_length_0 = length
            self._q_ready = numpy.full(length, 0, dtype=numpy.int64)
            self._q_pointer = <double**> PyMem_Malloc(length * sizeof(double*))
    cpdef inline dealloc_pointer(self, name):
        if name == "q":
            PyMem_Free(self._q_pointer)
    cpdef inline set_pointer1d(self, str name, pointerutils.Double value, numpy.int64_t idx):
        cdef pointerutils.PDouble pointer = pointerutils.PDouble(value)
        if name == "q":
            self._q_pointer[idx] = pointer.p_value
            self._q_ready[idx] = 1
    cpdef get_pointervalue(self, str name):
        cdef numpy.int64_t idx
        if name == "q":
            values = numpy.empty(self.len_q)
            for idx in range(self.len_q):
                pointerutils.check0(self._q_length_0)
                if self._q_ready[idx] == 0:
                    pointerutils.check1(self._q_length_0, idx)
                    pointerutils.check2(self._q_ready, idx)
                values[idx] = self._q_pointer[idx][0]
            return values
    cpdef set_value(self, str name, value):
        if name == "q":
            for idx in range(self.len_q):
                pointerutils.check0(self._q_length_0)
                if self._q_ready[idx] == 0:
                    pointerutils.check1(self._q_length_0, idx)
                    pointerutils.check2(self._q_ready, idx)
                self._q_pointer[idx][0] = value[idx]
@cython.final
cdef class FactorSequences:
    cpdef inline void load_data(self, numpy.int64_t idx)  noexcept nogil:
        cdef numpy.int64_t jdx0
        cdef numpy.int64_t k
        if self._waterdepth_diskflag_reading:
            k = 0
            for jdx0 in range(self._waterdepth_length_0):
                self.waterdepth[jdx0] = self._waterdepth_ncarray[k]
                k += 1
        elif self._waterdepth_ramflag:
            for jdx0 in range(self._waterdepth_length_0):
                self.waterdepth[jdx0] = self._waterdepth_array[idx, jdx0]
    cpdef inline void save_data(self, numpy.int64_t idx)  noexcept nogil:
        cdef numpy.int64_t jdx0
        cdef numpy.int64_t k
        if self._waterdepth_diskflag_writing:
            k = 0
            for jdx0 in range(self._waterdepth_length_0):
                self._waterdepth_ncarray[k] = self.waterdepth[jdx0]
                k += 1
        if self._waterdepth_ramflag:
            for jdx0 in range(self._waterdepth_length_0):
                self._waterdepth_array[idx, jdx0] = self.waterdepth[jdx0]
    cpdef inline set_pointeroutput(self, str name, pointerutils.PDouble value):
        pass
    cpdef inline void update_outputs(self) noexcept nogil:
        pass
@cython.final
cdef class FluxSequences:
    cpdef inline void load_data(self, numpy.int64_t idx)  noexcept nogil:
        cdef numpy.int64_t jdx0
        cdef numpy.int64_t k
        if self._inflow_diskflag_reading:
            self.inflow = self._inflow_ncarray[0]
        elif self._inflow_ramflag:
            self.inflow = self._inflow_array[idx]
        if self._internalflow_diskflag_reading:
            k = 0
            for jdx0 in range(self._internalflow_length_0):
                self.internalflow[jdx0] = self._internalflow_ncarray[k]
                k += 1
        elif self._internalflow_ramflag:
            for jdx0 in range(self._internalflow_length_0):
                self.internalflow[jdx0] = self._internalflow_array[idx, jdx0]
        if self._outflow_diskflag_reading:
            self.outflow = self._outflow_ncarray[0]
        elif self._outflow_ramflag:
            self.outflow = self._outflow_array[idx]
    cpdef inline void save_data(self, numpy.int64_t idx)  noexcept nogil:
        cdef numpy.int64_t jdx0
        cdef numpy.int64_t k
        if self._inflow_diskflag_writing:
            self._inflow_ncarray[0] = self.inflow
        if self._inflow_ramflag:
            self._inflow_array[idx] = self.inflow
        if self._internalflow_diskflag_writing:
            k = 0
            for jdx0 in range(self._internalflow_length_0):
                self._internalflow_ncarray[k] = self.internalflow[jdx0]
                k += 1
        if self._internalflow_ramflag:
            for jdx0 in range(self._internalflow_length_0):
                self._internalflow_array[idx, jdx0] = self.internalflow[jdx0]
        if self._outflow_diskflag_writing:
            self._outflow_ncarray[0] = self.outflow
        if self._outflow_ramflag:
            self._outflow_array[idx] = self.outflow
    cpdef inline set_pointeroutput(self, str name, pointerutils.PDouble value):
        if name == "inflow":
            self._inflow_outputpointer = value.p_value
        if name == "outflow":
            self._outflow_outputpointer = value.p_value
    cpdef inline void update_outputs(self) noexcept nogil:
        if self._inflow_outputflag:
            self._inflow_outputpointer[0] = self.inflow
        if self._outflow_outputflag:
            self._outflow_outputpointer[0] = self.outflow
@cython.final
cdef class StateSequences:
    cpdef inline void load_data(self, numpy.int64_t idx)  noexcept nogil:
        cdef numpy.int64_t jdx0
        cdef numpy.int64_t k
        if self._watervolume_diskflag_reading:
            k = 0
            for jdx0 in range(self._watervolume_length_0):
                self.watervolume[jdx0] = self._watervolume_ncarray[k]
                k += 1
        elif self._watervolume_ramflag:
            for jdx0 in range(self._watervolume_length_0):
                self.watervolume[jdx0] = self._watervolume_array[idx, jdx0]
    cpdef inline void save_data(self, numpy.int64_t idx)  noexcept nogil:
        cdef numpy.int64_t jdx0
        cdef numpy.int64_t k
        if self._watervolume_diskflag_writing:
            k = 0
            for jdx0 in range(self._watervolume_length_0):
                self._watervolume_ncarray[k] = self.watervolume[jdx0]
                k += 1
        if self._watervolume_ramflag:
            for jdx0 in range(self._watervolume_length_0):
                self._watervolume_array[idx, jdx0] = self.watervolume[jdx0]
    cpdef inline set_pointeroutput(self, str name, pointerutils.PDouble value):
        pass
    cpdef inline void update_outputs(self) noexcept nogil:
        pass
@cython.final
cdef class OutletSequences:
    cpdef inline void load_data(self, numpy.int64_t idx)  noexcept nogil:
        cdef numpy.int64_t k
        if self._q_diskflag_reading:
            self.q = self._q_ncarray[0]
        elif self._q_ramflag:
            self.q = self._q_array[idx]
    cpdef inline void save_data(self, numpy.int64_t idx)  noexcept nogil:
        cdef numpy.int64_t k
        if self._q_diskflag_writing:
            self._q_ncarray[0] = self.q
        if self._q_ramflag:
            self._q_array[idx] = self.q
    cpdef inline set_pointer0d(self, str name, pointerutils.Double value):
        cdef pointerutils.PDouble pointer = pointerutils.PDouble(value)
        if name == "q":
            self._q_pointer = pointer.p_value
    cpdef get_pointervalue(self, str name):
        cdef numpy.int64_t idx
        if name == "q":
            return self._q_pointer[0]
    cpdef set_value(self, str name, value):
        if name == "q":
            self._q_pointer[0] = value
@cython.final
cdef class PegasusImplicitEuler(rootutils.PegasusBase):
    def __init__(self, Model model):
        self.model = model
    cpdef double apply_method0(self, double x)  noexcept nogil:
        return self.model.return_volumeerror_v1(x)
@cython.final
cdef class Model:
    def __init__(self):
        super().__init__()
        self.wqmodel = None
        self.wqmodel_is_mainmodel = False
        self.pegasusimpliciteuler = PegasusImplicitEuler(self)
    def get_wqmodel(self) -> masterinterface.MasterInterface | None:
        return self.wqmodel
    def set_wqmodel(self, wqmodel: masterinterface.MasterInterface | None) -> None:
        self.wqmodel = wqmodel
    cpdef inline void simulate(self, numpy.int64_t idx)  noexcept nogil:
        self.idx_sim = idx
        self.reset_reuseflags()
        self.load_data(idx)
        self.update_inlets()
        self.update_observers()
        self.run()
        self.new2old()
        self.update_outlets()
        self.update_outputs()
    cpdef void simulate_period(self, numpy.int64_t i0, numpy.int64_t i1)  noexcept nogil:
        cdef numpy.int64_t i
        with nogil:
            for i in range(i0, i1):
                self.simulate(i)
                self.update_senders(i)
                self.update_receivers(i)
                self.save_data(i)
    cpdef void reset_reuseflags(self) noexcept nogil:
        if (self.wqmodel is not None) and not self.wqmodel_is_mainmodel:
            self.wqmodel.reset_reuseflags()
    cpdef void load_data(self, numpy.int64_t idx) noexcept nogil:
        self.idx_sim = idx
        self.sequences.inlets.load_data(idx)
        if (self.wqmodel is not None) and not self.wqmodel_is_mainmodel:
            self.wqmodel.load_data(idx)
    cpdef void save_data(self, numpy.int64_t idx) noexcept nogil:
        self.idx_sim = idx
        self.sequences.inlets.save_data(idx)
        self.sequences.factors.save_data(idx)
        self.sequences.fluxes.save_data(idx)
        self.sequences.states.save_data(idx)
        self.sequences.outlets.save_data(idx)
        if (self.wqmodel is not None) and not self.wqmodel_is_mainmodel:
            self.wqmodel.save_data(idx)
    cpdef void new2old(self) noexcept nogil:
        cdef numpy.int64_t jdx0
        for jdx0 in range(self.sequences.states._watervolume_length_0):
            self.sequences.old_states.watervolume[jdx0] = self.sequences.new_states.watervolume[jdx0]
        if (self.wqmodel is not None) and not self.wqmodel_is_mainmodel:
            self.wqmodel.new2old()
    cpdef inline void run(self) noexcept nogil:
        cdef numpy.int64_t idx_segment, idx_run
        for idx_segment in range(self.parameters.control.nmbsegments):
            self.idx_segment = idx_segment
            for idx_run in range(self.parameters.solver.nmbruns):
                self.idx_run = idx_run
                self.update_watervolume_v1()
                self.calc_waterdepth_v1()
                self.update_watervolume_v2()
                self.calc_internalflow_outflow_v1()
    cpdef void update_inlets(self) noexcept nogil:
        if (self.wqmodel is not None) and not self.wqmodel_is_mainmodel:
            self.wqmodel.update_inlets()
        cdef numpy.int64_t i
        if not self.threading:
            for i in range(self.sequences.inlets._q_length_0):
                if self.sequences.inlets._q_ready[i]:
                    self.sequences.inlets.q[i] = self.sequences.inlets._q_pointer[i][0]
                else:
                    self.sequences.inlets.q[i] = nan
        self.pick_inflow_v1()
    cpdef void update_outlets(self) noexcept nogil:
        if (self.wqmodel is not None) and not self.wqmodel_is_mainmodel:
            self.wqmodel.update_outlets()
        self.calc_outflow_v1()
        self.pass_outflow_v1()
        cdef numpy.int64_t i
        if not self.threading:
            self.sequences.outlets._q_pointer[0] = self.sequences.outlets._q_pointer[0] + self.sequences.outlets.q
    cpdef void update_observers(self) noexcept nogil:
        if (self.wqmodel is not None) and not self.wqmodel_is_mainmodel:
            self.wqmodel.update_observers()
        cdef numpy.int64_t i
    cpdef void update_receivers(self, numpy.int64_t idx) noexcept nogil:
        self.idx_sim = idx
        if (self.wqmodel is not None) and not self.wqmodel_is_mainmodel:
            self.wqmodel.update_receivers(idx)
        cdef numpy.int64_t i
    cpdef void update_senders(self, numpy.int64_t idx) noexcept nogil:
        self.idx_sim = idx
        if (self.wqmodel is not None) and not self.wqmodel_is_mainmodel:
            self.wqmodel.update_senders(idx)
        cdef numpy.int64_t i
    cpdef void update_outputs(self) noexcept nogil:
        if not self.threading:
            self.sequences.fluxes.update_outputs()
        if (self.wqmodel is not None) and not self.wqmodel_is_mainmodel:
            self.wqmodel.update_outputs()
    cpdef inline void pick_inflow_v1(self) noexcept nogil:
        cdef numpy.int64_t idx
        self.sequences.fluxes.inflow = 0.0
        for idx in range(self.sequences.inlets.len_q):
            self.sequences.fluxes.inflow = self.sequences.fluxes.inflow + (self.sequences.inlets.q[idx])
    cpdef inline void update_watervolume_v1(self) noexcept nogil:
        cdef double q
        cdef numpy.int64_t i
        i = self.idx_segment
        q = self.sequences.fluxes.inflow if (i == 0) else self.sequences.fluxes.internalflow[i - 1]
        self.sequences.old_states.watervolume[i] = self.sequences.old_states.watervolume[i] + (q * self.parameters.derived.seconds / 1e6)
    cpdef inline void calc_waterdepth_v1(self) noexcept nogil:
        cdef double tol
        cdef numpy.int64_t j
        cdef double d1
        cdef double d0
        cdef numpy.int64_t i
        i = self.idx_segment
        d0 = 0.0
        if self.parameters.derived.nmbdiscontinuities == 0:
            d1 = 10.0
        else:
            for j in range(self.parameters.derived.nmbdiscontinuities):
                d1 = self.parameters.derived.finaldepth2initialvolume[j, 0]
                if self.sequences.old_states.watervolume[i] <= self.parameters.derived.finaldepth2initialvolume[j, 1]:
                    break
                d0 = d1
            else:
                d1 = d0 + 10.0
        tol = self.sequences.old_states.watervolume[i] * self.parameters.solver.watervolumetolerance
        self.sequences.factors.waterdepth[i] = self.pegasusimpliciteuler.find_x(            d0, d1, 0.0, 1000.0, self.parameters.solver.waterdepthtolerance, tol, 1000        )
    cpdef inline void update_watervolume_v2(self) noexcept nogil:
        cdef numpy.int64_t i
        i = self.idx_segment
        if (self.sequences.factors.waterdepth[i] == 0.0) or (self.parameters.control.length == 0.0):
            self.sequences.new_states.watervolume[i] = 0.0
        else:
            self.sequences.new_states.watervolume[i] = (                self.wqmodel.get_wettedarea() * self.parameters.control.length / self.parameters.control.nmbsegments / 1e3            )
    cpdef inline void calc_internalflow_outflow_v1(self) noexcept nogil:
        cdef double q
        cdef numpy.int64_t i
        i = self.idx_segment
        q = (self.sequences.old_states.watervolume[i] - self.sequences.new_states.watervolume[i]) / self.parameters.derived.seconds * 1e6
        if i + 1 < self.parameters.control.nmbsegments:
            self.sequences.fluxes.internalflow[i] = q
        else:
            self.sequences.fluxes.outflow = q
    cpdef inline double return_initialwatervolume_v1(self, double waterdepth) noexcept nogil:
        cdef double sublength
        self.wqmodel.use_waterdepth(waterdepth)
        sublength = self.parameters.control.length / self.parameters.control.nmbsegments if self.parameters.control.nmbsegments > 0 else 0.0
        return (            self.wqmodel.get_wettedarea() * sublength / 1e3            + self.wqmodel.get_discharge() * self.parameters.derived.seconds / 1e6        )
    cpdef inline double return_volumeerror_v1(self, double waterdepth) noexcept nogil:
        cdef double v
        v = self.sequences.old_states.watervolume[self.idx_segment]
        if waterdepth == 0.0:
            return v
        return v - self.return_initialwatervolume_v1(waterdepth)
    cpdef inline void calc_outflow_v1(self) noexcept nogil:
        if self.parameters.control.nmbsegments == 0:
            self.sequences.fluxes.outflow = self.sequences.fluxes.inflow
    cpdef inline void pass_outflow_v1(self) noexcept nogil:
        self.sequences.outlets.q = self.sequences.fluxes.outflow
    cpdef inline void pick_inflow(self) noexcept nogil:
        cdef numpy.int64_t idx
        self.sequences.fluxes.inflow = 0.0
        for idx in range(self.sequences.inlets.len_q):
            self.sequences.fluxes.inflow = self.sequences.fluxes.inflow + (self.sequences.inlets.q[idx])
    cpdef inline void calc_waterdepth(self) noexcept nogil:
        cdef double tol
        cdef numpy.int64_t j
        cdef double d1
        cdef double d0
        cdef numpy.int64_t i
        i = self.idx_segment
        d0 = 0.0
        if self.parameters.derived.nmbdiscontinuities == 0:
            d1 = 10.0
        else:
            for j in range(self.parameters.derived.nmbdiscontinuities):
                d1 = self.parameters.derived.finaldepth2initialvolume[j, 0]
                if self.sequences.old_states.watervolume[i] <= self.parameters.derived.finaldepth2initialvolume[j, 1]:
                    break
                d0 = d1
            else:
                d1 = d0 + 10.0
        tol = self.sequences.old_states.watervolume[i] * self.parameters.solver.watervolumetolerance
        self.sequences.factors.waterdepth[i] = self.pegasusimpliciteuler.find_x(            d0, d1, 0.0, 1000.0, self.parameters.solver.waterdepthtolerance, tol, 1000        )
    cpdef inline void calc_internalflow_outflow(self) noexcept nogil:
        cdef double q
        cdef numpy.int64_t i
        i = self.idx_segment
        q = (self.sequences.old_states.watervolume[i] - self.sequences.new_states.watervolume[i]) / self.parameters.derived.seconds * 1e6
        if i + 1 < self.parameters.control.nmbsegments:
            self.sequences.fluxes.internalflow[i] = q
        else:
            self.sequences.fluxes.outflow = q
    cpdef inline double return_initialwatervolume(self, double waterdepth) noexcept nogil:
        cdef double sublength
        self.wqmodel.use_waterdepth(waterdepth)
        sublength = self.parameters.control.length / self.parameters.control.nmbsegments if self.parameters.control.nmbsegments > 0 else 0.0
        return (            self.wqmodel.get_wettedarea() * sublength / 1e3            + self.wqmodel.get_discharge() * self.parameters.derived.seconds / 1e6        )
    cpdef inline double return_volumeerror(self, double waterdepth) noexcept nogil:
        cdef double v
        v = self.sequences.old_states.watervolume[self.idx_segment]
        if waterdepth == 0.0:
            return v
        return v - self.return_initialwatervolume_v1(waterdepth)
    cpdef inline void calc_outflow(self) noexcept nogil:
        if self.parameters.control.nmbsegments == 0:
            self.sequences.fluxes.outflow = self.sequences.fluxes.inflow
    cpdef inline void pass_outflow(self) noexcept nogil:
        self.sequences.outlets.q = self.sequences.fluxes.outflow
