#!python
# distutils: define_macros=NPY_NO_DEPRECATED_API=NPY_1_7_API_VERSION
# cython: language_level=3
# cython: cpow=True
# cython: boundscheck=False
# cython: wraparound=False
# cython: initializedcheck=False
# cython: cdivision=True
from typing import Optional
import numpy
cimport numpy
from libc.math cimport exp, fabs, log, sin, cos, tan, tanh, asin, acos, atan, isnan, isinf
from libc.math cimport NAN as nan
from libc.math cimport INFINITY as inf
import cython
from cpython.mem cimport PyMem_Malloc
from cpython.mem cimport PyMem_Realloc
from cpython.mem cimport PyMem_Free
from hydpy.cythons.autogen cimport configutils
from hydpy.cythons.autogen cimport interfaceutils
from hydpy.cythons.autogen cimport interputils
from hydpy.cythons.autogen import pointerutils
from hydpy.cythons.autogen cimport pointerutils
from hydpy.cythons.autogen cimport quadutils
from hydpy.cythons.autogen cimport rootutils
from hydpy.cythons.autogen cimport smoothutils
from hydpy.cythons.autogen cimport masterinterface


cdef void do_nothing(Model model)  noexcept nogil:
    pass

cpdef get_wrapper():
    cdef CallbackWrapper wrapper = CallbackWrapper()
    wrapper.callback = do_nothing
    return wrapper

cdef public numpy.npy_bool TYPE_CHECKING = False
cdef public numpy.int64_t SIED_D = 1
cdef public numpy.int64_t SIED_L = 2
cdef public numpy.int64_t VERS = 3
cdef public numpy.int64_t ACKER = 4
cdef public numpy.int64_t WEINB = 5
cdef public numpy.int64_t OBSTB = 6
cdef public numpy.int64_t BODEN = 7
cdef public numpy.int64_t GLETS = 8
cdef public numpy.int64_t GRUE_I = 9
cdef public numpy.int64_t FEUCHT = 10
cdef public numpy.int64_t GRUE_E = 11
cdef public numpy.int64_t BAUMB = 12
cdef public numpy.int64_t NADELW = 13
cdef public numpy.int64_t LAUBW = 14
cdef public numpy.int64_t MISCHW = 15
cdef public numpy.int64_t WASSER = 16
cdef public numpy.int64_t FLUSS = 17
cdef public numpy.int64_t SEE = 18
@cython.final
cdef class Parameters:
    pass
@cython.final
cdef class ControlParameters:
    pass
@cython.final
cdef class DerivedParameters:
    pass
@cython.final
cdef class FixedParameters:
    pass
@cython.final
cdef class Sequences:
    pass
@cython.final
cdef class InletSequences:
    cpdef inline void load_data(self, numpy.int64_t idx)  noexcept nogil:
        cdef numpy.int64_t jdx0
        cdef numpy.int64_t k
        if self._q_diskflag_reading:
            k = 0
            for jdx0 in range(self._q_length_0):
                self.q[jdx0] = self._q_ncarray[k]
                k += 1
        elif self._q_ramflag:
            for jdx0 in range(self._q_length_0):
                self.q[jdx0] = self._q_array[idx, jdx0]
    cpdef inline void save_data(self, numpy.int64_t idx)  noexcept nogil:
        cdef numpy.int64_t jdx0
        cdef numpy.int64_t k
        if self._q_diskflag_writing:
            k = 0
            for jdx0 in range(self._q_length_0):
                self._q_ncarray[k] = self.q[jdx0]
                k += 1
        if self._q_ramflag:
            for jdx0 in range(self._q_length_0):
                self._q_array[idx, jdx0] = self.q[jdx0]
    cpdef inline alloc_pointer(self, name, numpy.int64_t length):
        if name == "q":
            self._q_length_0 = length
            self._q_ready = numpy.full(length, 0, dtype=numpy.int64)
            self._q_pointer = <double**> PyMem_Malloc(length * sizeof(double*))
    cpdef inline dealloc_pointer(self, name):
        if name == "q":
            PyMem_Free(self._q_pointer)
    cpdef inline set_pointer1d(self, str name, pointerutils.Double value, numpy.int64_t idx):
        cdef pointerutils.PDouble pointer = pointerutils.PDouble(value)
        if name == "q":
            self._q_pointer[idx] = pointer.p_value
            self._q_ready[idx] = 1
    cpdef get_pointervalue(self, str name):
        cdef numpy.int64_t idx
        if name == "q":
            values = numpy.empty(self.len_q)
            for idx in range(self.len_q):
                pointerutils.check0(self._q_length_0)
                if self._q_ready[idx] == 0:
                    pointerutils.check1(self._q_length_0, idx)
                    pointerutils.check2(self._q_ready, idx)
                values[idx] = self._q_pointer[idx][0]
            return values
    cpdef set_value(self, str name, value):
        if name == "q":
            for idx in range(self.len_q):
                pointerutils.check0(self._q_length_0)
                if self._q_ready[idx] == 0:
                    pointerutils.check1(self._q_length_0, idx)
                    pointerutils.check2(self._q_ready, idx)
                self._q_pointer[idx][0] = value[idx]
@cython.final
cdef class InputSequences:
    cpdef inline void load_data(self, numpy.int64_t idx)  noexcept nogil:
        cdef numpy.int64_t k
        if self._nied_inputflag:
            self.nied = self._nied_inputpointer[0]
        elif self._nied_diskflag_reading:
            self.nied = self._nied_ncarray[0]
        elif self._nied_ramflag:
            self.nied = self._nied_array[idx]
        if self._teml_inputflag:
            self.teml = self._teml_inputpointer[0]
        elif self._teml_diskflag_reading:
            self.teml = self._teml_ncarray[0]
        elif self._teml_ramflag:
            self.teml = self._teml_array[idx]
    cpdef inline void save_data(self, numpy.int64_t idx)  noexcept nogil:
        cdef numpy.int64_t k
        if self._nied_diskflag_writing:
            self._nied_ncarray[0] = self.nied
        if self._nied_ramflag:
            self._nied_array[idx] = self.nied
        if self._teml_diskflag_writing:
            self._teml_ncarray[0] = self.teml
        if self._teml_ramflag:
            self._teml_array[idx] = self.teml
    cpdef inline set_pointerinput(self, str name, pointerutils.PDouble value):
        if name == "nied":
            self._nied_inputpointer = value.p_value
        if name == "teml":
            self._teml_inputpointer = value.p_value
@cython.final
cdef class FluxSequences:
    cpdef inline void load_data(self, numpy.int64_t idx)  noexcept nogil:
        cdef numpy.int64_t jdx0
        cdef numpy.int64_t k
        if self._qz_diskflag_reading:
            self.qz = self._qz_ncarray[0]
        elif self._qz_ramflag:
            self.qz = self._qz_array[idx]
        if self._qzh_diskflag_reading:
            self.qzh = self._qzh_ncarray[0]
        elif self._qzh_ramflag:
            self.qzh = self._qzh_array[idx]
        if self._nkor_diskflag_reading:
            k = 0
            for jdx0 in range(self._nkor_length_0):
                self.nkor[jdx0] = self._nkor_ncarray[k]
                k += 1
        elif self._nkor_ramflag:
            for jdx0 in range(self._nkor_length_0):
                self.nkor[jdx0] = self._nkor_array[idx, jdx0]
        if self._tkor_diskflag_reading:
            k = 0
            for jdx0 in range(self._tkor_length_0):
                self.tkor[jdx0] = self._tkor_ncarray[k]
                k += 1
        elif self._tkor_ramflag:
            for jdx0 in range(self._tkor_length_0):
                self.tkor[jdx0] = self._tkor_array[idx, jdx0]
        if self._atkor_diskflag_reading:
            k = 0
            for jdx0 in range(self._atkor_length_0):
                self.atkor[jdx0] = self._atkor_ncarray[k]
                k += 1
        elif self._atkor_ramflag:
            for jdx0 in range(self._atkor_length_0):
                self.atkor[jdx0] = self._atkor_array[idx, jdx0]
        if self._nbes_diskflag_reading:
            k = 0
            for jdx0 in range(self._nbes_length_0):
                self.nbes[jdx0] = self._nbes_ncarray[k]
                k += 1
        elif self._nbes_ramflag:
            for jdx0 in range(self._nbes_length_0):
                self.nbes[jdx0] = self._nbes_array[idx, jdx0]
        if self._sbes_diskflag_reading:
            k = 0
            for jdx0 in range(self._sbes_length_0):
                self.sbes[jdx0] = self._sbes_ncarray[k]
                k += 1
        elif self._sbes_ramflag:
            for jdx0 in range(self._sbes_length_0):
                self.sbes[jdx0] = self._sbes_array[idx, jdx0]
        if self._evi_diskflag_reading:
            k = 0
            for jdx0 in range(self._evi_length_0):
                self.evi[jdx0] = self._evi_ncarray[k]
                k += 1
        elif self._evi_ramflag:
            for jdx0 in range(self._evi_length_0):
                self.evi[jdx0] = self._evi_array[idx, jdx0]
        if self._evb_diskflag_reading:
            k = 0
            for jdx0 in range(self._evb_length_0):
                self.evb[jdx0] = self._evb_ncarray[k]
                k += 1
        elif self._evb_ramflag:
            for jdx0 in range(self._evb_length_0):
                self.evb[jdx0] = self._evb_array[idx, jdx0]
        if self._wgtf_diskflag_reading:
            k = 0
            for jdx0 in range(self._wgtf_length_0):
                self.wgtf[jdx0] = self._wgtf_ncarray[k]
                k += 1
        elif self._wgtf_ramflag:
            for jdx0 in range(self._wgtf_length_0):
                self.wgtf[jdx0] = self._wgtf_array[idx, jdx0]
        if self._usg_diskflag_reading:
            k = 0
            for jdx0 in range(self._usg_length_0):
                self.usg[jdx0] = self._usg_ncarray[k]
                k += 1
        elif self._usg_ramflag:
            for jdx0 in range(self._usg_length_0):
                self.usg[jdx0] = self._usg_array[idx, jdx0]
        if self._awgtf_diskflag_reading:
            k = 0
            for jdx0 in range(self._awgtf_length_0):
                self.awgtf[jdx0] = self._awgtf_ncarray[k]
                k += 1
        elif self._awgtf_ramflag:
            for jdx0 in range(self._awgtf_length_0):
                self.awgtf[jdx0] = self._awgtf_array[idx, jdx0]
        if self._wnied_diskflag_reading:
            k = 0
            for jdx0 in range(self._wnied_length_0):
                self.wnied[jdx0] = self._wnied_ncarray[k]
                k += 1
        elif self._wnied_ramflag:
            for jdx0 in range(self._wnied_length_0):
                self.wnied[jdx0] = self._wnied_array[idx, jdx0]
        if self._awnied_diskflag_reading:
            k = 0
            for jdx0 in range(self._awnied_length_0):
                self.awnied[jdx0] = self._awnied_ncarray[k]
                k += 1
        elif self._awnied_ramflag:
            for jdx0 in range(self._awnied_length_0):
                self.awnied[jdx0] = self._awnied_array[idx, jdx0]
        if self._schmpot_diskflag_reading:
            k = 0
            for jdx0 in range(self._schmpot_length_0):
                self.schmpot[jdx0] = self._schmpot_ncarray[k]
                k += 1
        elif self._schmpot_ramflag:
            for jdx0 in range(self._schmpot_length_0):
                self.schmpot[jdx0] = self._schmpot_array[idx, jdx0]
        if self._schmpotgl_diskflag_reading:
            k = 0
            for jdx0 in range(self._schmpotgl_length_0):
                self.schmpotgl[jdx0] = self._schmpotgl_ncarray[k]
                k += 1
        elif self._schmpotgl_ramflag:
            for jdx0 in range(self._schmpotgl_length_0):
                self.schmpotgl[jdx0] = self._schmpotgl_array[idx, jdx0]
        if self._schm_diskflag_reading:
            k = 0
            for jdx0 in range(self._schm_length_0):
                self.schm[jdx0] = self._schm_ncarray[k]
                k += 1
        elif self._schm_ramflag:
            for jdx0 in range(self._schm_length_0):
                self.schm[jdx0] = self._schm_array[idx, jdx0]
        if self._schmgl_diskflag_reading:
            k = 0
            for jdx0 in range(self._schmgl_length_0):
                self.schmgl[jdx0] = self._schmgl_ncarray[k]
                k += 1
        elif self._schmgl_ramflag:
            for jdx0 in range(self._schmgl_length_0):
                self.schmgl[jdx0] = self._schmgl_array[idx, jdx0]
        if self._wada_diskflag_reading:
            k = 0
            for jdx0 in range(self._wada_length_0):
                self.wada[jdx0] = self._wada_ncarray[k]
                k += 1
        elif self._wada_ramflag:
            for jdx0 in range(self._wada_length_0):
                self.wada[jdx0] = self._wada_array[idx, jdx0]
        if self._qdb_diskflag_reading:
            k = 0
            for jdx0 in range(self._qdb_length_0):
                self.qdb[jdx0] = self._qdb_ncarray[k]
                k += 1
        elif self._qdb_ramflag:
            for jdx0 in range(self._qdb_length_0):
                self.qdb[jdx0] = self._qdb_array[idx, jdx0]
        if self._qib1_diskflag_reading:
            k = 0
            for jdx0 in range(self._qib1_length_0):
                self.qib1[jdx0] = self._qib1_ncarray[k]
                k += 1
        elif self._qib1_ramflag:
            for jdx0 in range(self._qib1_length_0):
                self.qib1[jdx0] = self._qib1_array[idx, jdx0]
        if self._qib2_diskflag_reading:
            k = 0
            for jdx0 in range(self._qib2_length_0):
                self.qib2[jdx0] = self._qib2_ncarray[k]
                k += 1
        elif self._qib2_ramflag:
            for jdx0 in range(self._qib2_length_0):
                self.qib2[jdx0] = self._qib2_array[idx, jdx0]
        if self._qbb_diskflag_reading:
            k = 0
            for jdx0 in range(self._qbb_length_0):
                self.qbb[jdx0] = self._qbb_ncarray[k]
                k += 1
        elif self._qbb_ramflag:
            for jdx0 in range(self._qbb_length_0):
                self.qbb[jdx0] = self._qbb_array[idx, jdx0]
        if self._qkap_diskflag_reading:
            k = 0
            for jdx0 in range(self._qkap_length_0):
                self.qkap[jdx0] = self._qkap_ncarray[k]
                k += 1
        elif self._qkap_ramflag:
            for jdx0 in range(self._qkap_length_0):
                self.qkap[jdx0] = self._qkap_array[idx, jdx0]
        if self._qdgz_diskflag_reading:
            self.qdgz = self._qdgz_ncarray[0]
        elif self._qdgz_ramflag:
            self.qdgz = self._qdgz_array[idx]
        if self._qdgz1_diskflag_reading:
            self.qdgz1 = self._qdgz1_ncarray[0]
        elif self._qdgz1_ramflag:
            self.qdgz1 = self._qdgz1_array[idx]
        if self._qdgz2_diskflag_reading:
            self.qdgz2 = self._qdgz2_ncarray[0]
        elif self._qdgz2_ramflag:
            self.qdgz2 = self._qdgz2_array[idx]
        if self._qigz1_diskflag_reading:
            self.qigz1 = self._qigz1_ncarray[0]
        elif self._qigz1_ramflag:
            self.qigz1 = self._qigz1_array[idx]
        if self._qigz2_diskflag_reading:
            self.qigz2 = self._qigz2_ncarray[0]
        elif self._qigz2_ramflag:
            self.qigz2 = self._qigz2_array[idx]
        if self._qbgz_diskflag_reading:
            self.qbgz = self._qbgz_ncarray[0]
        elif self._qbgz_ramflag:
            self.qbgz = self._qbgz_array[idx]
        if self._qdga1_diskflag_reading:
            self.qdga1 = self._qdga1_ncarray[0]
        elif self._qdga1_ramflag:
            self.qdga1 = self._qdga1_array[idx]
        if self._qdga2_diskflag_reading:
            self.qdga2 = self._qdga2_ncarray[0]
        elif self._qdga2_ramflag:
            self.qdga2 = self._qdga2_array[idx]
        if self._qiga1_diskflag_reading:
            self.qiga1 = self._qiga1_ncarray[0]
        elif self._qiga1_ramflag:
            self.qiga1 = self._qiga1_array[idx]
        if self._qiga2_diskflag_reading:
            self.qiga2 = self._qiga2_ncarray[0]
        elif self._qiga2_ramflag:
            self.qiga2 = self._qiga2_array[idx]
        if self._qbga_diskflag_reading:
            self.qbga = self._qbga_ncarray[0]
        elif self._qbga_ramflag:
            self.qbga = self._qbga_array[idx]
        if self._qah_diskflag_reading:
            self.qah = self._qah_ncarray[0]
        elif self._qah_ramflag:
            self.qah = self._qah_array[idx]
        if self._qa_diskflag_reading:
            self.qa = self._qa_ncarray[0]
        elif self._qa_ramflag:
            self.qa = self._qa_array[idx]
    cpdef inline void save_data(self, numpy.int64_t idx)  noexcept nogil:
        cdef numpy.int64_t jdx0
        cdef numpy.int64_t k
        if self._qz_diskflag_writing:
            self._qz_ncarray[0] = self.qz
        if self._qz_ramflag:
            self._qz_array[idx] = self.qz
        if self._qzh_diskflag_writing:
            self._qzh_ncarray[0] = self.qzh
        if self._qzh_ramflag:
            self._qzh_array[idx] = self.qzh
        if self._nkor_diskflag_writing:
            k = 0
            for jdx0 in range(self._nkor_length_0):
                self._nkor_ncarray[k] = self.nkor[jdx0]
                k += 1
        if self._nkor_ramflag:
            for jdx0 in range(self._nkor_length_0):
                self._nkor_array[idx, jdx0] = self.nkor[jdx0]
        if self._tkor_diskflag_writing:
            k = 0
            for jdx0 in range(self._tkor_length_0):
                self._tkor_ncarray[k] = self.tkor[jdx0]
                k += 1
        if self._tkor_ramflag:
            for jdx0 in range(self._tkor_length_0):
                self._tkor_array[idx, jdx0] = self.tkor[jdx0]
        if self._atkor_diskflag_writing:
            k = 0
            for jdx0 in range(self._atkor_length_0):
                self._atkor_ncarray[k] = self.atkor[jdx0]
                k += 1
        if self._atkor_ramflag:
            for jdx0 in range(self._atkor_length_0):
                self._atkor_array[idx, jdx0] = self.atkor[jdx0]
        if self._nbes_diskflag_writing:
            k = 0
            for jdx0 in range(self._nbes_length_0):
                self._nbes_ncarray[k] = self.nbes[jdx0]
                k += 1
        if self._nbes_ramflag:
            for jdx0 in range(self._nbes_length_0):
                self._nbes_array[idx, jdx0] = self.nbes[jdx0]
        if self._sbes_diskflag_writing:
            k = 0
            for jdx0 in range(self._sbes_length_0):
                self._sbes_ncarray[k] = self.sbes[jdx0]
                k += 1
        if self._sbes_ramflag:
            for jdx0 in range(self._sbes_length_0):
                self._sbes_array[idx, jdx0] = self.sbes[jdx0]
        if self._evi_diskflag_writing:
            k = 0
            for jdx0 in range(self._evi_length_0):
                self._evi_ncarray[k] = self.evi[jdx0]
                k += 1
        if self._evi_ramflag:
            for jdx0 in range(self._evi_length_0):
                self._evi_array[idx, jdx0] = self.evi[jdx0]
        if self._evb_diskflag_writing:
            k = 0
            for jdx0 in range(self._evb_length_0):
                self._evb_ncarray[k] = self.evb[jdx0]
                k += 1
        if self._evb_ramflag:
            for jdx0 in range(self._evb_length_0):
                self._evb_array[idx, jdx0] = self.evb[jdx0]
        if self._wgtf_diskflag_writing:
            k = 0
            for jdx0 in range(self._wgtf_length_0):
                self._wgtf_ncarray[k] = self.wgtf[jdx0]
                k += 1
        if self._wgtf_ramflag:
            for jdx0 in range(self._wgtf_length_0):
                self._wgtf_array[idx, jdx0] = self.wgtf[jdx0]
        if self._usg_diskflag_writing:
            k = 0
            for jdx0 in range(self._usg_length_0):
                self._usg_ncarray[k] = self.usg[jdx0]
                k += 1
        if self._usg_ramflag:
            for jdx0 in range(self._usg_length_0):
                self._usg_array[idx, jdx0] = self.usg[jdx0]
        if self._awgtf_diskflag_writing:
            k = 0
            for jdx0 in range(self._awgtf_length_0):
                self._awgtf_ncarray[k] = self.awgtf[jdx0]
                k += 1
        if self._awgtf_ramflag:
            for jdx0 in range(self._awgtf_length_0):
                self._awgtf_array[idx, jdx0] = self.awgtf[jdx0]
        if self._wnied_diskflag_writing:
            k = 0
            for jdx0 in range(self._wnied_length_0):
                self._wnied_ncarray[k] = self.wnied[jdx0]
                k += 1
        if self._wnied_ramflag:
            for jdx0 in range(self._wnied_length_0):
                self._wnied_array[idx, jdx0] = self.wnied[jdx0]
        if self._awnied_diskflag_writing:
            k = 0
            for jdx0 in range(self._awnied_length_0):
                self._awnied_ncarray[k] = self.awnied[jdx0]
                k += 1
        if self._awnied_ramflag:
            for jdx0 in range(self._awnied_length_0):
                self._awnied_array[idx, jdx0] = self.awnied[jdx0]
        if self._schmpot_diskflag_writing:
            k = 0
            for jdx0 in range(self._schmpot_length_0):
                self._schmpot_ncarray[k] = self.schmpot[jdx0]
                k += 1
        if self._schmpot_ramflag:
            for jdx0 in range(self._schmpot_length_0):
                self._schmpot_array[idx, jdx0] = self.schmpot[jdx0]
        if self._schmpotgl_diskflag_writing:
            k = 0
            for jdx0 in range(self._schmpotgl_length_0):
                self._schmpotgl_ncarray[k] = self.schmpotgl[jdx0]
                k += 1
        if self._schmpotgl_ramflag:
            for jdx0 in range(self._schmpotgl_length_0):
                self._schmpotgl_array[idx, jdx0] = self.schmpotgl[jdx0]
        if self._schm_diskflag_writing:
            k = 0
            for jdx0 in range(self._schm_length_0):
                self._schm_ncarray[k] = self.schm[jdx0]
                k += 1
        if self._schm_ramflag:
            for jdx0 in range(self._schm_length_0):
                self._schm_array[idx, jdx0] = self.schm[jdx0]
        if self._schmgl_diskflag_writing:
            k = 0
            for jdx0 in range(self._schmgl_length_0):
                self._schmgl_ncarray[k] = self.schmgl[jdx0]
                k += 1
        if self._schmgl_ramflag:
            for jdx0 in range(self._schmgl_length_0):
                self._schmgl_array[idx, jdx0] = self.schmgl[jdx0]
        if self._wada_diskflag_writing:
            k = 0
            for jdx0 in range(self._wada_length_0):
                self._wada_ncarray[k] = self.wada[jdx0]
                k += 1
        if self._wada_ramflag:
            for jdx0 in range(self._wada_length_0):
                self._wada_array[idx, jdx0] = self.wada[jdx0]
        if self._qdb_diskflag_writing:
            k = 0
            for jdx0 in range(self._qdb_length_0):
                self._qdb_ncarray[k] = self.qdb[jdx0]
                k += 1
        if self._qdb_ramflag:
            for jdx0 in range(self._qdb_length_0):
                self._qdb_array[idx, jdx0] = self.qdb[jdx0]
        if self._qib1_diskflag_writing:
            k = 0
            for jdx0 in range(self._qib1_length_0):
                self._qib1_ncarray[k] = self.qib1[jdx0]
                k += 1
        if self._qib1_ramflag:
            for jdx0 in range(self._qib1_length_0):
                self._qib1_array[idx, jdx0] = self.qib1[jdx0]
        if self._qib2_diskflag_writing:
            k = 0
            for jdx0 in range(self._qib2_length_0):
                self._qib2_ncarray[k] = self.qib2[jdx0]
                k += 1
        if self._qib2_ramflag:
            for jdx0 in range(self._qib2_length_0):
                self._qib2_array[idx, jdx0] = self.qib2[jdx0]
        if self._qbb_diskflag_writing:
            k = 0
            for jdx0 in range(self._qbb_length_0):
                self._qbb_ncarray[k] = self.qbb[jdx0]
                k += 1
        if self._qbb_ramflag:
            for jdx0 in range(self._qbb_length_0):
                self._qbb_array[idx, jdx0] = self.qbb[jdx0]
        if self._qkap_diskflag_writing:
            k = 0
            for jdx0 in range(self._qkap_length_0):
                self._qkap_ncarray[k] = self.qkap[jdx0]
                k += 1
        if self._qkap_ramflag:
            for jdx0 in range(self._qkap_length_0):
                self._qkap_array[idx, jdx0] = self.qkap[jdx0]
        if self._qdgz_diskflag_writing:
            self._qdgz_ncarray[0] = self.qdgz
        if self._qdgz_ramflag:
            self._qdgz_array[idx] = self.qdgz
        if self._qdgz1_diskflag_writing:
            self._qdgz1_ncarray[0] = self.qdgz1
        if self._qdgz1_ramflag:
            self._qdgz1_array[idx] = self.qdgz1
        if self._qdgz2_diskflag_writing:
            self._qdgz2_ncarray[0] = self.qdgz2
        if self._qdgz2_ramflag:
            self._qdgz2_array[idx] = self.qdgz2
        if self._qigz1_diskflag_writing:
            self._qigz1_ncarray[0] = self.qigz1
        if self._qigz1_ramflag:
            self._qigz1_array[idx] = self.qigz1
        if self._qigz2_diskflag_writing:
            self._qigz2_ncarray[0] = self.qigz2
        if self._qigz2_ramflag:
            self._qigz2_array[idx] = self.qigz2
        if self._qbgz_diskflag_writing:
            self._qbgz_ncarray[0] = self.qbgz
        if self._qbgz_ramflag:
            self._qbgz_array[idx] = self.qbgz
        if self._qdga1_diskflag_writing:
            self._qdga1_ncarray[0] = self.qdga1
        if self._qdga1_ramflag:
            self._qdga1_array[idx] = self.qdga1
        if self._qdga2_diskflag_writing:
            self._qdga2_ncarray[0] = self.qdga2
        if self._qdga2_ramflag:
            self._qdga2_array[idx] = self.qdga2
        if self._qiga1_diskflag_writing:
            self._qiga1_ncarray[0] = self.qiga1
        if self._qiga1_ramflag:
            self._qiga1_array[idx] = self.qiga1
        if self._qiga2_diskflag_writing:
            self._qiga2_ncarray[0] = self.qiga2
        if self._qiga2_ramflag:
            self._qiga2_array[idx] = self.qiga2
        if self._qbga_diskflag_writing:
            self._qbga_ncarray[0] = self.qbga
        if self._qbga_ramflag:
            self._qbga_array[idx] = self.qbga
        if self._qah_diskflag_writing:
            self._qah_ncarray[0] = self.qah
        if self._qah_ramflag:
            self._qah_array[idx] = self.qah
        if self._qa_diskflag_writing:
            self._qa_ncarray[0] = self.qa
        if self._qa_ramflag:
            self._qa_array[idx] = self.qa
    cpdef inline set_pointeroutput(self, str name, pointerutils.PDouble value):
        if name == "qz":
            self._qz_outputpointer = value.p_value
        if name == "qzh":
            self._qzh_outputpointer = value.p_value
        if name == "qdgz":
            self._qdgz_outputpointer = value.p_value
        if name == "qdgz1":
            self._qdgz1_outputpointer = value.p_value
        if name == "qdgz2":
            self._qdgz2_outputpointer = value.p_value
        if name == "qigz1":
            self._qigz1_outputpointer = value.p_value
        if name == "qigz2":
            self._qigz2_outputpointer = value.p_value
        if name == "qbgz":
            self._qbgz_outputpointer = value.p_value
        if name == "qdga1":
            self._qdga1_outputpointer = value.p_value
        if name == "qdga2":
            self._qdga2_outputpointer = value.p_value
        if name == "qiga1":
            self._qiga1_outputpointer = value.p_value
        if name == "qiga2":
            self._qiga2_outputpointer = value.p_value
        if name == "qbga":
            self._qbga_outputpointer = value.p_value
        if name == "qah":
            self._qah_outputpointer = value.p_value
        if name == "qa":
            self._qa_outputpointer = value.p_value
    cpdef inline void update_outputs(self) noexcept nogil:
        if self._qz_outputflag:
            self._qz_outputpointer[0] = self.qz
        if self._qzh_outputflag:
            self._qzh_outputpointer[0] = self.qzh
        if self._qdgz_outputflag:
            self._qdgz_outputpointer[0] = self.qdgz
        if self._qdgz1_outputflag:
            self._qdgz1_outputpointer[0] = self.qdgz1
        if self._qdgz2_outputflag:
            self._qdgz2_outputpointer[0] = self.qdgz2
        if self._qigz1_outputflag:
            self._qigz1_outputpointer[0] = self.qigz1
        if self._qigz2_outputflag:
            self._qigz2_outputpointer[0] = self.qigz2
        if self._qbgz_outputflag:
            self._qbgz_outputpointer[0] = self.qbgz
        if self._qdga1_outputflag:
            self._qdga1_outputpointer[0] = self.qdga1
        if self._qdga2_outputflag:
            self._qdga2_outputpointer[0] = self.qdga2
        if self._qiga1_outputflag:
            self._qiga1_outputpointer[0] = self.qiga1
        if self._qiga2_outputflag:
            self._qiga2_outputpointer[0] = self.qiga2
        if self._qbga_outputflag:
            self._qbga_outputpointer[0] = self.qbga
        if self._qah_outputflag:
            self._qah_outputpointer[0] = self.qah
        if self._qa_outputflag:
            self._qa_outputpointer[0] = self.qa
@cython.final
cdef class StateSequences:
    cpdef inline void load_data(self, numpy.int64_t idx)  noexcept nogil:
        cdef numpy.int64_t jdx0
        cdef numpy.int64_t k
        if self._inzp_diskflag_reading:
            k = 0
            for jdx0 in range(self._inzp_length_0):
                self.inzp[jdx0] = self._inzp_ncarray[k]
                k += 1
        elif self._inzp_ramflag:
            for jdx0 in range(self._inzp_length_0):
                self.inzp[jdx0] = self._inzp_array[idx, jdx0]
        if self._wats_diskflag_reading:
            k = 0
            for jdx0 in range(self._wats_length_0):
                self.wats[jdx0] = self._wats_ncarray[k]
                k += 1
        elif self._wats_ramflag:
            for jdx0 in range(self._wats_length_0):
                self.wats[jdx0] = self._wats_array[idx, jdx0]
        if self._waes_diskflag_reading:
            k = 0
            for jdx0 in range(self._waes_length_0):
                self.waes[jdx0] = self._waes_ncarray[k]
                k += 1
        elif self._waes_ramflag:
            for jdx0 in range(self._waes_length_0):
                self.waes[jdx0] = self._waes_array[idx, jdx0]
        if self._bowa_diskflag_reading:
            k = 0
            for jdx0 in range(self._bowa_length_0):
                self.bowa[jdx0] = self._bowa_ncarray[k]
                k += 1
        elif self._bowa_ramflag:
            for jdx0 in range(self._bowa_length_0):
                self.bowa[jdx0] = self._bowa_array[idx, jdx0]
        if self._sdg1_diskflag_reading:
            self.sdg1 = self._sdg1_ncarray[0]
        elif self._sdg1_ramflag:
            self.sdg1 = self._sdg1_array[idx]
        if self._sdg2_diskflag_reading:
            self.sdg2 = self._sdg2_ncarray[0]
        elif self._sdg2_ramflag:
            self.sdg2 = self._sdg2_array[idx]
        if self._sig1_diskflag_reading:
            self.sig1 = self._sig1_ncarray[0]
        elif self._sig1_ramflag:
            self.sig1 = self._sig1_array[idx]
        if self._sig2_diskflag_reading:
            self.sig2 = self._sig2_ncarray[0]
        elif self._sig2_ramflag:
            self.sig2 = self._sig2_array[idx]
        if self._sbg_diskflag_reading:
            self.sbg = self._sbg_ncarray[0]
        elif self._sbg_ramflag:
            self.sbg = self._sbg_array[idx]
    cpdef inline void save_data(self, numpy.int64_t idx)  noexcept nogil:
        cdef numpy.int64_t jdx0
        cdef numpy.int64_t k
        if self._inzp_diskflag_writing:
            k = 0
            for jdx0 in range(self._inzp_length_0):
                self._inzp_ncarray[k] = self.inzp[jdx0]
                k += 1
        if self._inzp_ramflag:
            for jdx0 in range(self._inzp_length_0):
                self._inzp_array[idx, jdx0] = self.inzp[jdx0]
        if self._wats_diskflag_writing:
            k = 0
            for jdx0 in range(self._wats_length_0):
                self._wats_ncarray[k] = self.wats[jdx0]
                k += 1
        if self._wats_ramflag:
            for jdx0 in range(self._wats_length_0):
                self._wats_array[idx, jdx0] = self.wats[jdx0]
        if self._waes_diskflag_writing:
            k = 0
            for jdx0 in range(self._waes_length_0):
                self._waes_ncarray[k] = self.waes[jdx0]
                k += 1
        if self._waes_ramflag:
            for jdx0 in range(self._waes_length_0):
                self._waes_array[idx, jdx0] = self.waes[jdx0]
        if self._bowa_diskflag_writing:
            k = 0
            for jdx0 in range(self._bowa_length_0):
                self._bowa_ncarray[k] = self.bowa[jdx0]
                k += 1
        if self._bowa_ramflag:
            for jdx0 in range(self._bowa_length_0):
                self._bowa_array[idx, jdx0] = self.bowa[jdx0]
        if self._sdg1_diskflag_writing:
            self._sdg1_ncarray[0] = self.sdg1
        if self._sdg1_ramflag:
            self._sdg1_array[idx] = self.sdg1
        if self._sdg2_diskflag_writing:
            self._sdg2_ncarray[0] = self.sdg2
        if self._sdg2_ramflag:
            self._sdg2_array[idx] = self.sdg2
        if self._sig1_diskflag_writing:
            self._sig1_ncarray[0] = self.sig1
        if self._sig1_ramflag:
            self._sig1_array[idx] = self.sig1
        if self._sig2_diskflag_writing:
            self._sig2_ncarray[0] = self.sig2
        if self._sig2_ramflag:
            self._sig2_array[idx] = self.sig2
        if self._sbg_diskflag_writing:
            self._sbg_ncarray[0] = self.sbg
        if self._sbg_ramflag:
            self._sbg_array[idx] = self.sbg
    cpdef inline set_pointeroutput(self, str name, pointerutils.PDouble value):
        if name == "sdg1":
            self._sdg1_outputpointer = value.p_value
        if name == "sdg2":
            self._sdg2_outputpointer = value.p_value
        if name == "sig1":
            self._sig1_outputpointer = value.p_value
        if name == "sig2":
            self._sig2_outputpointer = value.p_value
        if name == "sbg":
            self._sbg_outputpointer = value.p_value
    cpdef inline void update_outputs(self) noexcept nogil:
        if self._sdg1_outputflag:
            self._sdg1_outputpointer[0] = self.sdg1
        if self._sdg2_outputflag:
            self._sdg2_outputpointer[0] = self.sdg2
        if self._sig1_outputflag:
            self._sig1_outputpointer[0] = self.sig1
        if self._sig2_outputflag:
            self._sig2_outputpointer[0] = self.sig2
        if self._sbg_outputflag:
            self._sbg_outputpointer[0] = self.sbg
@cython.final
cdef class AideSequences:
    pass
@cython.final
cdef class OutletSequences:
    cpdef inline void load_data(self, numpy.int64_t idx)  noexcept nogil:
        cdef numpy.int64_t k
        if self._q_diskflag_reading:
            self.q = self._q_ncarray[0]
        elif self._q_ramflag:
            self.q = self._q_array[idx]
    cpdef inline void save_data(self, numpy.int64_t idx)  noexcept nogil:
        cdef numpy.int64_t k
        if self._q_diskflag_writing:
            self._q_ncarray[0] = self.q
        if self._q_ramflag:
            self._q_array[idx] = self.q
    cpdef inline set_pointer0d(self, str name, pointerutils.Double value):
        cdef pointerutils.PDouble pointer = pointerutils.PDouble(value)
        if name == "q":
            self._q_pointer = pointer.p_value
    cpdef get_pointervalue(self, str name):
        cdef numpy.int64_t idx
        if name == "q":
            return self._q_pointer[0]
    cpdef set_value(self, str name, value):
        if name == "q":
            self._q_pointer[0] = value
@cython.final
cdef class Model(masterinterface.MasterInterface):
    def __init__(self):
        super().__init__()
        self.aetmodel = None
        self.aetmodel_is_mainmodel = False
        self.soilmodel = None
        self.soilmodel_is_mainmodel = False
    def get_aetmodel(self) -> masterinterface.MasterInterface | None:
        return self.aetmodel
    def set_aetmodel(self, aetmodel: masterinterface.MasterInterface | None) -> None:
        self.aetmodel = aetmodel
    def get_soilmodel(self) -> masterinterface.MasterInterface | None:
        return self.soilmodel
    def set_soilmodel(self, soilmodel: masterinterface.MasterInterface | None) -> None:
        self.soilmodel = soilmodel
    cpdef inline void simulate(self, numpy.int64_t idx)  noexcept nogil:
        self.idx_sim = idx
        self.reset_reuseflags()
        self.load_data(idx)
        self.update_inlets()
        self.update_observers()
        self.run()
        self.new2old()
        self.update_outlets()
        self.update_outputs()
    cpdef void simulate_period(self, numpy.int64_t i0, numpy.int64_t i1)  noexcept nogil:
        cdef numpy.int64_t i
        with nogil:
            for i in range(i0, i1):
                self.simulate(i)
                self.update_senders(i)
                self.update_receivers(i)
                self.save_data(i)
    cpdef void reset_reuseflags(self) noexcept nogil:
        if (self.aetmodel is not None) and not self.aetmodel_is_mainmodel:
            self.aetmodel.reset_reuseflags()
        if (self.soilmodel is not None) and not self.soilmodel_is_mainmodel:
            self.soilmodel.reset_reuseflags()
    cpdef void load_data(self, numpy.int64_t idx) noexcept nogil:
        self.idx_sim = idx
        self.sequences.inlets.load_data(idx)
        self.sequences.inputs.load_data(idx)
        if (self.aetmodel is not None) and not self.aetmodel_is_mainmodel:
            self.aetmodel.load_data(idx)
        if (self.soilmodel is not None) and not self.soilmodel_is_mainmodel:
            self.soilmodel.load_data(idx)
    cpdef void save_data(self, numpy.int64_t idx) noexcept nogil:
        self.idx_sim = idx
        self.sequences.inlets.save_data(idx)
        self.sequences.inputs.save_data(idx)
        self.sequences.fluxes.save_data(idx)
        self.sequences.states.save_data(idx)
        self.sequences.outlets.save_data(idx)
        if (self.aetmodel is not None) and not self.aetmodel_is_mainmodel:
            self.aetmodel.save_data(idx)
        if (self.soilmodel is not None) and not self.soilmodel_is_mainmodel:
            self.soilmodel.save_data(idx)
    cpdef void new2old(self) noexcept nogil:
        cdef numpy.int64_t jdx0
        for jdx0 in range(self.sequences.states._inzp_length_0):
            self.sequences.old_states.inzp[jdx0] = self.sequences.new_states.inzp[jdx0]
        for jdx0 in range(self.sequences.states._wats_length_0):
            self.sequences.old_states.wats[jdx0] = self.sequences.new_states.wats[jdx0]
        for jdx0 in range(self.sequences.states._waes_length_0):
            self.sequences.old_states.waes[jdx0] = self.sequences.new_states.waes[jdx0]
        for jdx0 in range(self.sequences.states._bowa_length_0):
            self.sequences.old_states.bowa[jdx0] = self.sequences.new_states.bowa[jdx0]
        self.sequences.old_states.sdg1 = self.sequences.new_states.sdg1
        self.sequences.old_states.sdg2 = self.sequences.new_states.sdg2
        self.sequences.old_states.sig1 = self.sequences.new_states.sig1
        self.sequences.old_states.sig2 = self.sequences.new_states.sig2
        self.sequences.old_states.sbg = self.sequences.new_states.sbg
        if (self.aetmodel is not None) and not self.aetmodel_is_mainmodel:
            self.aetmodel.new2old()
        if (self.soilmodel is not None) and not self.soilmodel_is_mainmodel:
            self.soilmodel.new2old()
    cpdef inline void run(self) noexcept nogil:
        self.calc_qzh_v1()
        self.calc_nkor_v1()
        self.calc_tkor_v1()
        self.calc_atkor_v1()
        self.calc_nbes_inzp_v1()
        self.calc_snratio_v1()
        self.calc_sbes_v1()
        self.calc_wats_v1()
        self.calc_usg_wats_waes_v1()
        self.calc_wgtf_v1()
        self.calc_awgtf_v1()
        self.calc_wnied_v1()
        self.calc_awnied_v1()
        self.calc_schmpot_v1()
        self.calc_schmpotgl_v1()
        self.calc_schm_wats_v1()
        self.calc_schmgl_v1()
        self.calc_wada_waes_v1()
        self.update_wada_v1()
        self.calc_evi_inzp_v1()
        self.calc_evb_v1()
        self.calc_qkap_v1()
        self.calc_qbb_v1()
        self.calc_qib1_v1()
        self.calc_qib2_v1()
        self.calc_qdb_v1()
        self.calc_bowa_v1()
        self.calc_qbgz_v1()
        self.calc_qigz1_v1()
        self.calc_qigz2_v1()
        self.calc_qdgz_v1()
        self.calc_qbga_sbg_qbgz_qdgz_v1()
        self.calc_qiga1_sig1_v1()
        self.calc_qiga2_sig2_v1()
        self.calc_qdgz1_qdgz2_v1()
        self.calc_qdga1_sdg1_v1()
        self.calc_qdga2_sdg2_v1()
        self.calc_qah_v1()
        self.calc_qa_v1()
    cpdef void update_inlets(self) noexcept nogil:
        if (self.aetmodel is not None) and not self.aetmodel_is_mainmodel:
            self.aetmodel.update_inlets()
        if (self.soilmodel is not None) and not self.soilmodel_is_mainmodel:
            self.soilmodel.update_inlets()
        cdef numpy.int64_t i
        if not self.threading:
            for i in range(self.sequences.inlets._q_length_0):
                if self.sequences.inlets._q_ready[i]:
                    self.sequences.inlets.q[i] = self.sequences.inlets._q_pointer[i][0]
                else:
                    self.sequences.inlets.q[i] = nan
        self.pick_qz_v1()
    cpdef void update_outlets(self) noexcept nogil:
        if (self.aetmodel is not None) and not self.aetmodel_is_mainmodel:
            self.aetmodel.update_outlets()
        if (self.soilmodel is not None) and not self.soilmodel_is_mainmodel:
            self.soilmodel.update_outlets()
        self.pass_qa_v1()
        cdef numpy.int64_t i
        if not self.threading:
            self.sequences.outlets._q_pointer[0] = self.sequences.outlets._q_pointer[0] + self.sequences.outlets.q
    cpdef void update_observers(self) noexcept nogil:
        if (self.aetmodel is not None) and not self.aetmodel_is_mainmodel:
            self.aetmodel.update_observers()
        if (self.soilmodel is not None) and not self.soilmodel_is_mainmodel:
            self.soilmodel.update_observers()
        cdef numpy.int64_t i
    cpdef void update_receivers(self, numpy.int64_t idx) noexcept nogil:
        self.idx_sim = idx
        if (self.aetmodel is not None) and not self.aetmodel_is_mainmodel:
            self.aetmodel.update_receivers(idx)
        if (self.soilmodel is not None) and not self.soilmodel_is_mainmodel:
            self.soilmodel.update_receivers(idx)
        cdef numpy.int64_t i
    cpdef void update_senders(self, numpy.int64_t idx) noexcept nogil:
        self.idx_sim = idx
        if (self.aetmodel is not None) and not self.aetmodel_is_mainmodel:
            self.aetmodel.update_senders(idx)
        if (self.soilmodel is not None) and not self.soilmodel_is_mainmodel:
            self.soilmodel.update_senders(idx)
        cdef numpy.int64_t i
    cpdef void update_outputs(self) noexcept nogil:
        if not self.threading:
            self.sequences.fluxes.update_outputs()
            self.sequences.states.update_outputs()
        if (self.aetmodel is not None) and not self.aetmodel_is_mainmodel:
            self.aetmodel.update_outputs()
        if (self.soilmodel is not None) and not self.soilmodel_is_mainmodel:
            self.soilmodel.update_outputs()
    cpdef inline void pick_qz_v1(self) noexcept nogil:
        cdef numpy.int64_t idx
        self.sequences.fluxes.qz = 0.0
        for idx in range(self.sequences.inlets.len_q):
            self.sequences.fluxes.qz = self.sequences.fluxes.qz + (self.sequences.inlets.q[idx])
    cpdef inline void calc_qzh_v1(self) noexcept nogil:
        self.sequences.fluxes.qzh = self.sequences.fluxes.qz / self.parameters.derived.qfactor
    cpdef inline void calc_nkor_v1(self) noexcept nogil:
        cdef numpy.int64_t k
        for k in range(self.parameters.control.nhru):
            self.sequences.fluxes.nkor[k] = self.parameters.control.kg[k] * self.sequences.inputs.nied
    cpdef inline void calc_tkor_v1(self) noexcept nogil:
        cdef numpy.int64_t k
        for k in range(self.parameters.control.nhru):
            self.sequences.fluxes.tkor[k] = self.sequences.inputs.teml + self.parameters.control.atg * (self.parameters.control.gh[k] - self.parameters.derived.mgh) / 100.0 + self.parameters.control.kt[k]
    cpdef inline void calc_atkor_v1(self) noexcept nogil:
        cdef numpy.int64_t k
        for k in range(self.parameters.control.nhru):
            self.sequences.fluxes.atkor[k] = self.sequences.fluxes.tkor[k]
            if self.parameters.control.gh[k] > self.parameters.control.aggh:
                self.sequences.fluxes.atkor[k] = self.sequences.fluxes.atkor[k] - (self.parameters.control.atg * (self.parameters.control.gh[k] - self.parameters.control.aggh) / 100.0)
    cpdef inline void calc_nbes_inzp_v1(self) noexcept nogil:
        cdef numpy.int64_t k
        for k in range(self.parameters.control.nhru):
            if self.parameters.control.lnk[k] in (WASSER, FLUSS, SEE):
                self.sequences.fluxes.nbes[k] = 0.0
                self.sequences.states.inzp[k] = 0.0
            else:
                self.sequences.fluxes.nbes[k] = max(                    self.sequences.fluxes.nkor[k]                    + self.sequences.states.inzp[k]                    - self.parameters.derived.kinz[self.parameters.control.lnk[k] - 1, self.parameters.derived.moy[self.idx_sim]],                    0.0,                )
                self.sequences.states.inzp[k] = self.sequences.states.inzp[k] + (self.sequences.fluxes.nkor[k] - self.sequences.fluxes.nbes[k])
    cpdef inline void calc_snratio_v1(self) noexcept nogil:
        cdef numpy.int64_t k
        for k in range(self.parameters.control.nhru):
            if self.sequences.fluxes.tkor[k] >= (self.parameters.control.tgr[k] + self.parameters.control.tsp[k] / 2.0):
                self.sequences.aides.snratio[k] = 0.0
            elif self.sequences.fluxes.tkor[k] <= (self.parameters.control.tgr[k] - self.parameters.control.tsp[k] / 2.0):
                self.sequences.aides.snratio[k] = 1.0
            else:
                self.sequences.aides.snratio[k] = (                    (self.parameters.control.tgr[k] + self.parameters.control.tsp[k] / 2.0) - self.sequences.fluxes.tkor[k]                ) / self.parameters.control.tsp[k]
    cpdef inline void calc_sbes_v1(self) noexcept nogil:
        cdef numpy.int64_t k
        for k in range(self.parameters.control.nhru):
            self.sequences.fluxes.sbes[k] = self.sequences.aides.snratio[k] * self.sequences.fluxes.nbes[k]
    cpdef inline void calc_wats_v1(self) noexcept nogil:
        cdef numpy.int64_t k
        for k in range(self.parameters.control.nhru):
            if self.parameters.control.lnk[k] in (WASSER, FLUSS, SEE):
                self.sequences.states.wats[k] = 0.0
            else:
                self.sequences.states.wats[k] = self.sequences.states.wats[k] + (self.sequences.fluxes.sbes[k])
    cpdef inline void calc_usg_wats_waes_v1(self) noexcept nogil:
        cdef numpy.int64_t k
        for k in range(self.parameters.control.nhru):
            if self.parameters.control.lnk[k] == GLETS:
                self.sequences.fluxes.usg[k] = self.parameters.control.feis[k] * self.sequences.states.waes[k]
                self.sequences.states.waes[k] = self.sequences.states.waes[k] - (self.sequences.fluxes.usg[k])
                self.sequences.states.wats[k] = max(self.sequences.states.wats[k] - self.sequences.fluxes.usg[k], 0.0)
            else:
                self.sequences.fluxes.usg[k] = 0.0
    cpdef inline void calc_wgtf_v1(self) noexcept nogil:
        cdef numpy.int64_t k
        for k in range(self.parameters.control.nhru):
            if self.parameters.control.lnk[k] in (WASSER, FLUSS, SEE):
                self.sequences.fluxes.wgtf[k] = 0.0
            else:
                self.sequences.fluxes.wgtf[k] = self.parameters.control.gtf[k] * (self.sequences.fluxes.tkor[k] - self.parameters.control.treft[k]) * self.parameters.fixed.rschmelz
    cpdef inline void calc_awgtf_v1(self) noexcept nogil:
        cdef numpy.int64_t k
        for k in range(self.parameters.control.nhru):
            if self.parameters.control.lnk[k] in (WASSER, FLUSS, SEE):
                self.sequences.fluxes.awgtf[k] = 0.0
            else:
                self.sequences.fluxes.awgtf[k] = self.parameters.control.gtf[k] * (self.sequences.fluxes.atkor[k] - self.parameters.control.treft[k]) * self.parameters.fixed.rschmelz
    cpdef inline void calc_wnied_v1(self) noexcept nogil:
        cdef double d_water
        cdef double d_ice
        cdef numpy.int64_t k
        for k in range(self.parameters.control.nhru):
            if self.parameters.control.lnk[k] in (WASSER, FLUSS, SEE):
                self.sequences.fluxes.wnied[k] = 0.0
            else:
                d_ice = self.parameters.fixed.cpeis * self.sequences.fluxes.sbes[k]
                d_water = self.parameters.fixed.cpwasser * (self.sequences.fluxes.nbes[k] - self.sequences.fluxes.sbes[k])
                self.sequences.fluxes.wnied[k] = (self.sequences.fluxes.tkor[k] - self.parameters.control.trefn[k]) * (d_ice + d_water)
    cpdef inline void calc_awnied_v1(self) noexcept nogil:
        cdef double d_water
        cdef double d_ice
        cdef numpy.int64_t k
        for k in range(self.parameters.control.nhru):
            if self.parameters.control.lnk[k] in (WASSER, FLUSS, SEE):
                self.sequences.fluxes.awnied[k] = 0.0
            else:
                d_ice = self.parameters.fixed.cpeis * self.sequences.fluxes.sbes[k]
                d_water = self.parameters.fixed.cpwasser * (self.sequences.fluxes.nbes[k] - self.sequences.fluxes.sbes[k])
                self.sequences.fluxes.awnied[k] = (self.sequences.fluxes.atkor[k] - self.parameters.control.trefn[k]) * (d_ice + d_water)
    cpdef inline void calc_schmpot_v1(self) noexcept nogil:
        cdef double w1
        cdef double p2
        cdef double p1
        cdef numpy.int64_t k
        for k in range(self.parameters.control.nhru):
            p1 = max((self.sequences.fluxes.wgtf[k] + self.sequences.fluxes.wnied[k]) / self.parameters.fixed.rschmelz, 0.0)
            if self.sequences.states.waes[k] > self.parameters.control.agsh:
                p2 = max((self.sequences.fluxes.awgtf[k] + self.sequences.fluxes.awnied[k]) / self.parameters.fixed.rschmelz, 0.0)
                w1 = self.parameters.control.agsh / self.sequences.states.waes[k]
                self.sequences.fluxes.schmpot[k] = w1 * p1 + (1.0 - w1) * p2
            else:
                self.sequences.fluxes.schmpot[k] = p1
    cpdef inline void calc_schmpotgl_v1(self) noexcept nogil:
        cdef numpy.int64_t k
        for k in range(self.parameters.control.nhru):
            if self.parameters.control.lnk[k] == GLETS:
                self.sequences.fluxes.schmpotgl[k] = max(                    self.parameters.control.gsf * (self.sequences.fluxes.wgtf[k] + self.sequences.fluxes.wnied[k]) / self.parameters.fixed.rschmelz, 0.0                )
            else:
                self.sequences.fluxes.schmpotgl[k] = 0.0
    cpdef inline void calc_schm_wats_v1(self) noexcept nogil:
        cdef numpy.int64_t k
        for k in range(self.parameters.control.nhru):
            if self.parameters.control.lnk[k] in (WASSER, FLUSS, SEE):
                self.sequences.fluxes.schm[k] = 0.0
            else:
                self.sequences.fluxes.schm[k] = min(self.sequences.fluxes.schmpot[k], self.sequences.states.wats[k])
                self.sequences.states.wats[k] = self.sequences.states.wats[k] - (self.sequences.fluxes.schm[k])
    cpdef inline void calc_schmgl_v1(self) noexcept nogil:
        cdef double w
        cdef numpy.int64_t k
        for k in range(self.parameters.control.nhru):
            if (self.parameters.control.lnk[k] == GLETS) and (self.sequences.fluxes.schmpot[k] > 0.0):
                w = max(1.0 - self.sequences.fluxes.schm[k] / self.sequences.fluxes.schmpot[k], 0.0)
                self.sequences.fluxes.schmgl[k] = w * self.sequences.fluxes.schmpotgl[k]
            else:
                self.sequences.fluxes.schmgl[k] = 0.0
    cpdef inline void calc_wada_waes_v1(self) noexcept nogil:
        cdef numpy.int64_t k
        for k in range(self.parameters.control.nhru):
            if self.parameters.control.lnk[k] in (WASSER, FLUSS, SEE):
                self.sequences.states.waes[k] = 0.0
                self.sequences.fluxes.wada[k] = self.sequences.fluxes.nbes[k]
            else:
                self.sequences.states.waes[k] = self.sequences.states.waes[k] + (self.sequences.fluxes.nbes[k])
                self.sequences.fluxes.wada[k] = max(self.sequences.states.waes[k] - self.parameters.control.pwmax[k] * self.sequences.states.wats[k], 0.0)
                self.sequences.states.waes[k] = self.sequences.states.waes[k] - (self.sequences.fluxes.wada[k])
    cpdef inline void update_wada_v1(self) noexcept nogil:
        cdef numpy.int64_t k
        for k in range(self.parameters.control.nhru):
            if self.parameters.control.lnk[k] == GLETS:
                self.sequences.fluxes.wada[k] = self.sequences.fluxes.wada[k] + (self.sequences.fluxes.schmgl[k])
    cpdef inline void calc_evi_inzp_v1(self) noexcept nogil:
        if self.aetmodel_typeid == 1:
            self.calc_evi_inzp_aetmodel_v1(                (<masterinterface.MasterInterface>self.aetmodel)            )
    cpdef inline void calc_evb_v1(self) noexcept nogil:
        if self.aetmodel_typeid == 1:
            self.calc_evb_aetmodel_v1((<masterinterface.MasterInterface>self.aetmodel))
    cpdef inline void calc_qkap_v1(self) noexcept nogil:
        cdef numpy.int64_t k
        for k in range(self.parameters.control.nhru):
            if (self.parameters.control.lnk[k] in (VERS, WASSER, FLUSS, SEE)) or (self.parameters.control.wmax[k] <= 0.0):
                self.sequences.fluxes.qkap[k] = 0.0
            elif self.sequences.states.bowa[k] <= self.parameters.control.kapgrenz[k, 0]:
                self.sequences.fluxes.qkap[k] = self.parameters.control.kapmax[k]
            elif self.sequences.states.bowa[k] <= self.parameters.control.kapgrenz[k, 1]:
                self.sequences.fluxes.qkap[k] = self.parameters.control.kapmax[k] * (                    1.0                    - (self.sequences.states.bowa[k] - self.parameters.control.kapgrenz[k, 0])                    / (self.parameters.control.kapgrenz[k, 1] - self.parameters.control.kapgrenz[k, 0])                )
            else:
                self.sequences.fluxes.qkap[k] = 0
    cpdef inline void calc_qbb_v1(self) noexcept nogil:
        cdef numpy.int64_t k
        for k in range(self.parameters.control.nhru):
            if (                (self.parameters.control.lnk[k] in (VERS, WASSER, FLUSS, SEE))                or (self.sequences.states.bowa[k] <= self.parameters.control.pwp[k])                or (self.parameters.control.wmax[k] <= 0.0)            ):
                self.sequences.fluxes.qbb[k] = 0.0
            elif self.sequences.states.bowa[k] <= self.parameters.control.fk[k]:
                if self.parameters.control.rbeta:
                    self.sequences.fluxes.qbb[k] = 0.0
                else:
                    self.sequences.fluxes.qbb[k] = self.parameters.control.beta[k] * (self.sequences.states.bowa[k] - self.parameters.control.pwp[k])
            else:
                self.sequences.fluxes.qbb[k] = (                    self.parameters.control.beta[k]                    * (self.sequences.states.bowa[k] - self.parameters.control.pwp[k])                    * (                        1.0                        + (self.parameters.control.fbeta[k] - 1.0)                        * (self.sequences.states.bowa[k] - self.parameters.control.fk[k])                        / (self.parameters.control.wmax[k] - self.parameters.control.fk[k])                    )                )
    cpdef inline void calc_qib1_v1(self) noexcept nogil:
        cdef numpy.int64_t k
        for k in range(self.parameters.control.nhru):
            if (self.parameters.control.lnk[k] in (VERS, WASSER, FLUSS, SEE)) or (                self.sequences.states.bowa[k] <= self.parameters.control.pwp[k]            ):
                self.sequences.fluxes.qib1[k] = 0.0
            else:
                self.sequences.fluxes.qib1[k] = self.parameters.control.dmin[k] * (self.sequences.states.bowa[k] / self.parameters.control.wmax[k])
    cpdef inline void calc_qib2_v1(self) noexcept nogil:
        cdef numpy.int64_t k
        for k in range(self.parameters.control.nhru):
            if (                (self.parameters.control.lnk[k] in (VERS, WASSER, FLUSS, SEE))                or (self.sequences.states.bowa[k] <= self.parameters.control.fk[k])                or (self.parameters.control.wmax[k] <= self.parameters.control.fk[k])            ):
                self.sequences.fluxes.qib2[k] = 0.0
            else:
                self.sequences.fluxes.qib2[k] = (self.parameters.control.dmax[k] - self.parameters.control.dmin[k]) * (                    (self.sequences.states.bowa[k] - self.parameters.control.fk[k]) / (self.parameters.control.wmax[k] - self.parameters.control.fk[k])                ) ** 1.5
    cpdef inline void calc_qdb_v1(self) noexcept nogil:
        cdef double sfa
        cdef double wmax
        cdef double bowa
        cdef numpy.int64_t k
        for k in range(self.parameters.control.nhru):
            if self.parameters.control.lnk[k] == WASSER:
                self.sequences.fluxes.qdb[k] = 0.0
            elif (self.parameters.control.lnk[k] in (VERS, FLUSS, SEE)) or (self.parameters.control.wmax[k] <= 0.0):
                self.sequences.fluxes.qdb[k] = self.sequences.fluxes.wada[k]
            else:
                bowa = self.sequences.states.bowa[k] - (self.parameters.control.bsf0[k] * self.parameters.control.wmax[k])
                wmax = (1.0 - self.parameters.control.bsf0[k]) * self.parameters.control.wmax[k]
                self.sequences.fluxes.qdb[k] = bowa + self.sequences.fluxes.wada[k] - wmax
                if bowa < wmax:
                    sfa = (1.0 - bowa / wmax) ** (1.0 / (self.parameters.control.bsf[k] + 1.0)) - (                        self.sequences.fluxes.wada[k] / ((self.parameters.control.bsf[k] + 1.0) * wmax)                    )
                    if sfa > 0.0:
                        self.sequences.fluxes.qdb[k] = self.sequences.fluxes.qdb[k] + (sfa ** (self.parameters.control.bsf[k] + 1.0) * wmax)
                self.sequences.fluxes.qdb[k] = max(self.sequences.fluxes.qdb[k], 0.0)
    cpdef inline void calc_bowa_v1(self) noexcept nogil:
        if self.soilmodel is None:
            self.calc_bowa_default_v1()
        elif self.soilmodel_typeid == 1:
            self.calc_bowa_soilmodel_v1(                (<masterinterface.MasterInterface>self.soilmodel)            )
    cpdef inline void calc_qbgz_v1(self) noexcept nogil:
        cdef numpy.int64_t k
        self.sequences.fluxes.qbgz = 0.0
        for k in range(self.parameters.control.nhru):
            if self.parameters.control.lnk[k] == SEE:
                self.sequences.fluxes.qbgz = self.sequences.fluxes.qbgz + (self.parameters.control.fhru[k] * (self.sequences.fluxes.nkor[k] - self.sequences.fluxes.evi[k]))
            elif self.parameters.control.lnk[k] not in (WASSER, FLUSS, VERS):
                self.sequences.fluxes.qbgz = self.sequences.fluxes.qbgz + (self.parameters.control.fhru[k] * (self.sequences.fluxes.qbb[k] - self.sequences.fluxes.qkap[k]))
    cpdef inline void calc_qigz1_v1(self) noexcept nogil:
        cdef numpy.int64_t k
        self.sequences.fluxes.qigz1 = 0.0
        for k in range(self.parameters.control.nhru):
            self.sequences.fluxes.qigz1 = self.sequences.fluxes.qigz1 + (self.parameters.control.fhru[k] * self.sequences.fluxes.qib1[k])
    cpdef inline void calc_qigz2_v1(self) noexcept nogil:
        cdef numpy.int64_t k
        self.sequences.fluxes.qigz2 = 0.0
        for k in range(self.parameters.control.nhru):
            self.sequences.fluxes.qigz2 = self.sequences.fluxes.qigz2 + (self.parameters.control.fhru[k] * self.sequences.fluxes.qib2[k])
    cpdef inline void calc_qdgz_v1(self) noexcept nogil:
        cdef numpy.int64_t k
        self.sequences.fluxes.qdgz = 0.0
        for k in range(self.parameters.control.nhru):
            if self.parameters.control.lnk[k] == FLUSS:
                self.sequences.fluxes.qdgz = self.sequences.fluxes.qdgz + (self.parameters.control.fhru[k] * (self.sequences.fluxes.nkor[k] - self.sequences.fluxes.evi[k]))
            elif self.parameters.control.lnk[k] not in (WASSER, SEE):
                self.sequences.fluxes.qdgz = self.sequences.fluxes.qdgz + (self.parameters.control.fhru[k] * self.sequences.fluxes.qdb[k])
    cpdef inline void calc_qbga_sbg_qbgz_qdgz_v1(self) noexcept nogil:
        cdef double qbgz
        cdef double tt
        cdef double c2
        cdef double c1
        cdef double st
        cdef double fraction
        cdef double t
        cdef double excess
        cdef double z
        cdef double s0
        cdef double g2
        cdef double g1
        cdef double sm
        cdef double k
        k = self.parameters.derived.kb
        sm = self.parameters.control.gsbmax * self.parameters.control.volbmax
        g1 = self.parameters.control.gsbgrad1
        g2 = self.parameters.control.gsbgrad2
        s0 = self.sequences.old_states.sbg
        z = self.sequences.fluxes.qbgz
        if s0 > sm:
            excess = s0 - sm
            s0 = sm
        else:
            excess = 0.0
        if k == 0.0:
            self.sequences.new_states.sbg = 0.0
            self.sequences.fluxes.qbga = s0 + self.sequences.fluxes.qbgz
        elif z - s0 / k <= g1:
            if isinf(k):
                self.sequences.new_states.sbg = min(s0 + z, sm)
                self.sequences.fluxes.qbga = 0.0
            else:
                if isinf(sm):
                    t = 1.0
                else:
                    fraction = (k * z - sm) / (k * z - s0)
                    if fraction > 0.0:
                        t = -k * log(fraction)
                    else:
                        t = 1.0
                if t < 1.0:
                    self.sequences.new_states.sbg = sm
                    self.sequences.fluxes.qbga = s0 - sm + t * self.sequences.fluxes.qbgz
                    self.sequences.fluxes.qbga = self.sequences.fluxes.qbga + ((1.0 - t) * sm / k)
                else:
                    self.sequences.new_states.sbg = self.return_sg_v1(k, s0, z, 1.0)
                    self.sequences.fluxes.qbga = s0 - self.sequences.new_states.sbg + self.sequences.fluxes.qbgz
        elif g2 == 0.0:
            self.sequences.fluxes.qbga = s0 / k
            self.sequences.new_states.sbg = s0
        else:
            if isinf(k) and (g2 > g1):
                self.sequences.fluxes.qbga = 0.0
                self.sequences.new_states.sbg = s0 + g2 / ((g2 - g1) / z + 1.0)
            else:
                st = min(k * (z - g1), sm)
                if g1 == g2:
                    t = min((st - s0) / g1, 1.0)
                    self.sequences.fluxes.qbga = t * (g1 * t + 2.0 * s0) / (2.0 * k)
                else:
                    c1 = (g2 - g1) / (g1 - g2 - z)
                    c2 = (g2 * k * z) / (g1 - g2)
                    t = min(k / c1 * log((st + c2) / (s0 + c2)), 1.0)
                    self.sequences.fluxes.qbga = (s0 + c2) * (                        exp(c1 * t / k) - 1.0                    ) / c1 - c2 * t / k
                if t < 1.0:
                    if st == sm:
                        self.sequences.new_states.sbg = sm
                        self.sequences.fluxes.qbga = self.sequences.fluxes.qbga + ((1.0 - t) * sm / k)
                    else:
                        fraction = (k * z - sm) / (k * z - st)
                        if fraction > 0.0:
                            tt = -k * log(fraction)
                        else:
                            tt = 1.0
                        if t + tt < 1.0:
                            self.sequences.new_states.sbg = sm
                            self.sequences.fluxes.qbga = self.sequences.fluxes.qbga + (st - sm + tt * self.sequences.fluxes.qbgz)
                            self.sequences.fluxes.qbga = self.sequences.fluxes.qbga + ((1.0 - t - tt) * sm / k)
                        else:
                            self.sequences.new_states.sbg = self.return_sg_v1(k, st, z, 1.0 - t)
                            self.sequences.fluxes.qbga = self.sequences.fluxes.qbga + (st - self.sequences.new_states.sbg + (1.0 - t) * self.sequences.fluxes.qbgz)
                elif g1 == g2:
                    self.sequences.new_states.sbg = s0 + g1
                else:
                    self.sequences.new_states.sbg = (s0 + c2) * exp(1.0 / k * c1) - c2
        qbgz = self.sequences.fluxes.qbgz
        self.sequences.fluxes.qbgz = self.sequences.new_states.sbg - s0 + self.sequences.fluxes.qbga
        self.sequences.fluxes.qdgz = self.sequences.fluxes.qdgz + (qbgz - self.sequences.fluxes.qbgz)
        self.sequences.fluxes.qbga = self.sequences.fluxes.qbga + (excess)
    cpdef inline void calc_qiga1_sig1_v1(self) noexcept nogil:
        self.sequences.new_states.sig1 = self.return_sg_v1(self.parameters.derived.ki1, self.sequences.old_states.sig1, self.sequences.fluxes.qigz1, 1.0)
        self.sequences.fluxes.qiga1 = self.sequences.old_states.sig1 - self.sequences.new_states.sig1 + self.sequences.fluxes.qigz1
    cpdef inline void calc_qiga2_sig2_v1(self) noexcept nogil:
        self.sequences.new_states.sig2 = self.return_sg_v1(self.parameters.derived.ki2, self.sequences.old_states.sig2, self.sequences.fluxes.qigz2, 1.0)
        self.sequences.fluxes.qiga2 = self.sequences.old_states.sig2 - self.sequences.new_states.sig2 + self.sequences.fluxes.qigz2
    cpdef inline void calc_qdgz1_qdgz2_v1(self) noexcept nogil:
        if self.sequences.fluxes.qdgz > self.parameters.control.a2:
            self.sequences.fluxes.qdgz2 = (self.sequences.fluxes.qdgz - self.parameters.control.a2) ** 2 / (self.sequences.fluxes.qdgz + self.parameters.control.a1 - self.parameters.control.a2)
            self.sequences.fluxes.qdgz1 = self.sequences.fluxes.qdgz - self.sequences.fluxes.qdgz2
        else:
            self.sequences.fluxes.qdgz2 = 0.0
            self.sequences.fluxes.qdgz1 = self.sequences.fluxes.qdgz
    cpdef inline void calc_qdga1_sdg1_v1(self) noexcept nogil:
        self.sequences.new_states.sdg1 = self.return_sg_v1(self.parameters.derived.kd1, self.sequences.old_states.sdg1, self.sequences.fluxes.qdgz1, 1.0)
        self.sequences.fluxes.qdga1 = self.sequences.old_states.sdg1 - self.sequences.new_states.sdg1 + self.sequences.fluxes.qdgz1
    cpdef inline void calc_qdga2_sdg2_v1(self) noexcept nogil:
        self.sequences.new_states.sdg2 = self.return_sg_v1(self.parameters.derived.kd2, self.sequences.old_states.sdg2, self.sequences.fluxes.qdgz2, 1.0)
        self.sequences.fluxes.qdga2 = self.sequences.old_states.sdg2 - self.sequences.new_states.sdg2 + self.sequences.fluxes.qdgz2
    cpdef inline void calc_qah_v1(self) noexcept nogil:
        cdef double d_epw
        cdef numpy.int64_t k
        cdef double d_area
        self.sequences.fluxes.qah = self.sequences.fluxes.qzh + self.sequences.fluxes.qbga + self.sequences.fluxes.qiga1 + self.sequences.fluxes.qiga2 + self.sequences.fluxes.qdga1 + self.sequences.fluxes.qdga2
        if (not self.parameters.control.negq) and (self.sequences.fluxes.qah < 0.0):
            d_area = 0.0
            for k in range(self.parameters.control.nhru):
                if self.parameters.control.lnk[k] in (FLUSS, SEE):
                    d_area = d_area + (self.parameters.control.fhru[k])
            if d_area > 0.0:
                for k in range(self.parameters.control.nhru):
                    if self.parameters.control.lnk[k] in (FLUSS, SEE):
                        self.sequences.fluxes.evi[k] = self.sequences.fluxes.evi[k] + (self.sequences.fluxes.qah / d_area)
            self.sequences.fluxes.qah = 0.0
        d_epw = 0.0
        for k in range(self.parameters.control.nhru):
            if self.parameters.control.lnk[k] == WASSER:
                self.sequences.fluxes.qah = self.sequences.fluxes.qah + (self.parameters.control.fhru[k] * self.sequences.fluxes.nkor[k])
                d_epw = d_epw + (self.parameters.control.fhru[k] * self.sequences.fluxes.evi[k])
        if (self.sequences.fluxes.qah > d_epw) or self.parameters.control.negq:
            self.sequences.fluxes.qah = self.sequences.fluxes.qah - (d_epw)
        elif d_epw > 0.0:
            for k in range(self.parameters.control.nhru):
                if self.parameters.control.lnk[k] == WASSER:
                    self.sequences.fluxes.evi[k] = self.sequences.fluxes.evi[k] * (self.sequences.fluxes.qah / d_epw)
            self.sequences.fluxes.qah = 0.0
    cpdef inline void calc_qa_v1(self) noexcept nogil:
        self.sequences.fluxes.qa = self.parameters.derived.qfactor * self.sequences.fluxes.qah
    cpdef inline void calc_evi_inzp_aetmodel_v1(self, masterinterface.MasterInterface submodel) noexcept nogil:
        cdef numpy.int64_t k
        submodel.determine_interceptionevaporation()
        submodel.determine_waterevaporation()
        for k in range(self.parameters.control.nhru):
            if self.parameters.control.lnk[k] in (WASSER, FLUSS, SEE):
                self.sequences.fluxes.evi[k] = submodel.get_waterevaporation(k)
                self.sequences.states.inzp[k] = 0.0
            else:
                self.sequences.fluxes.evi[k] = min(submodel.get_interceptionevaporation(k), self.sequences.states.inzp[k])
                self.sequences.states.inzp[k] = self.sequences.states.inzp[k] - (self.sequences.fluxes.evi[k])
    cpdef inline void calc_evb_aetmodel_v1(self, masterinterface.MasterInterface submodel) noexcept nogil:
        cdef numpy.int64_t k
        submodel.determine_soilevapotranspiration()
        for k in range(self.parameters.control.nhru):
            if self.parameters.control.lnk[k] in (VERS, WASSER, FLUSS, SEE):
                self.sequences.fluxes.evb[k] = 0.0
            else:
                self.sequences.fluxes.evb[k] = submodel.get_soilevapotranspiration(k)
    cpdef inline double return_sg_v1(self, double k, double s, double qz, double dt) noexcept nogil:
        if k <= 0.0:
            return 0.0
        if isinf(k):
            return s + qz
        return k * qz - (k * qz - s) * exp(-dt / k)
    cpdef inline void calc_bowa_default_v1(self) noexcept nogil:
        cdef double d_factor
        cdef double d_rvl
        cdef double d_incr
        cdef double d_decr
        cdef numpy.int64_t k
        for k in range(self.parameters.control.nhru):
            if self.parameters.control.lnk[k] in (VERS, WASSER, FLUSS, SEE):
                self.sequences.states.bowa[k] = 0.0
            else:
                d_decr = self.sequences.fluxes.qbb[k] + self.sequences.fluxes.qib1[k] + self.sequences.fluxes.qib2[k] + self.sequences.fluxes.qdb[k]
                d_incr = self.sequences.fluxes.wada[k] + self.sequences.fluxes.qkap[k]
                if self.sequences.fluxes.evb[k] > 0.0:
                    d_decr = d_decr + (self.sequences.fluxes.evb[k])
                else:
                    d_incr = d_incr - (self.sequences.fluxes.evb[k])
                if d_decr > self.sequences.states.bowa[k] + d_incr:
                    d_rvl = (self.sequences.states.bowa[k] + d_incr) / d_decr
                    if self.sequences.fluxes.evb[k] > 0.0:
                        self.sequences.fluxes.evb[k] = self.sequences.fluxes.evb[k] * (d_rvl)
                    self.sequences.fluxes.qbb[k] = self.sequences.fluxes.qbb[k] * (d_rvl)
                    self.sequences.fluxes.qib1[k] = self.sequences.fluxes.qib1[k] * (d_rvl)
                    self.sequences.fluxes.qib2[k] = self.sequences.fluxes.qib2[k] * (d_rvl)
                    self.sequences.fluxes.qdb[k] = self.sequences.fluxes.qdb[k] * (d_rvl)
                    self.sequences.states.bowa[k] = 0.0
                else:
                    self.sequences.states.bowa[k] = (self.sequences.states.bowa[k] + d_incr) - d_decr
                    if self.sequences.states.bowa[k] > self.parameters.control.wmax[k]:
                        d_factor = (self.sequences.states.bowa[k] - self.parameters.control.wmax[k]) / d_incr
                        if self.sequences.fluxes.evb[k] < 0.0:
                            self.sequences.fluxes.evb[k] = self.sequences.fluxes.evb[k] * (d_factor)
                        self.sequences.fluxes.wada[k] = self.sequences.fluxes.wada[k] * (d_factor)
                        self.sequences.fluxes.qkap[k] = self.sequences.fluxes.qkap[k] * (d_factor)
                        self.sequences.states.bowa[k] = self.parameters.control.wmax[k]
    cpdef inline void calc_bowa_soilmodel_v1(self, masterinterface.MasterInterface submodel) noexcept nogil:
        cdef double removal
        cdef double demand
        cdef double factor
        cdef double addition
        cdef double supply
        cdef double qbb_soilmodel
        cdef double infiltration
        cdef numpy.int64_t k
        for k in range(self.parameters.control.nhru):
            if self.parameters.control.lnk[k] in (VERS, WASSER, FLUSS, SEE):
                self.sequences.states.bowa[k] = 0.0
            else:
                submodel.set_initialsurfacewater(k, self.sequences.fluxes.wada[k])
                submodel.set_actualsurfacewater(k, self.sequences.fluxes.wada[k] - self.sequences.fluxes.qdb[k])
                submodel.set_soilwatersupply(k, 0.0)
                submodel.set_soilwaterdemand(k, 0.0)
                submodel.execute_infiltration(k)
                infiltration = submodel.get_infiltration(k)
                self.sequences.fluxes.qdb[k] = self.sequences.fluxes.qdb[k] + ((self.sequences.fluxes.wada[k] - self.sequences.fluxes.qdb[k]) - infiltration)
                qbb_soilmodel = submodel.get_percolation(k)
                supply = self.sequences.fluxes.qkap[k]
                if self.sequences.fluxes.evb[k] < 0.0:
                    supply = supply - (self.sequences.fluxes.evb[k])
                submodel.set_soilwatersupply(k, supply)
                submodel.add_soilwater(k)
                addition = submodel.get_soilwateraddition(k)
                if addition < supply:
                    factor = addition / supply
                    self.sequences.fluxes.qkap[k] = self.sequences.fluxes.qkap[k] * (factor)
                    if self.sequences.fluxes.evb[k] < 0.0:
                        self.sequences.fluxes.evb[k] = self.sequences.fluxes.evb[k] * (factor)
                demand = self.sequences.fluxes.qbb[k] + self.sequences.fluxes.qib1[k] + self.sequences.fluxes.qib2[k]
                if self.sequences.fluxes.evb[k] > 0.0:
                    demand = demand + (self.sequences.fluxes.evb[k])
                submodel.set_soilwaterdemand(k, demand)
                submodel.remove_soilwater(k)
                removal = submodel.get_soilwaterremoval(k)
                if removal < demand:
                    factor = removal / demand
                    self.sequences.fluxes.qbb[k] = self.sequences.fluxes.qbb[k] * (factor)
                    self.sequences.fluxes.qib1[k] = self.sequences.fluxes.qib1[k] * (factor)
                    self.sequences.fluxes.qib2[k] = self.sequences.fluxes.qib2[k] * (factor)
                    if self.sequences.fluxes.evb[k] > 0.0:
                        self.sequences.fluxes.evb[k] = self.sequences.fluxes.evb[k] * (factor)
                self.sequences.states.bowa[k] = submodel.get_soilwatercontent(k)
                self.sequences.fluxes.qbb[k] = self.sequences.fluxes.qbb[k] + (qbb_soilmodel)
    cpdef inline void pass_qa_v1(self) noexcept nogil:
        self.sequences.outlets.q = self.sequences.fluxes.qa
    cpdef double get_temperature_v1(self, numpy.int64_t s) noexcept nogil:
        return self.sequences.fluxes.tkor[s]
    cpdef double get_meantemperature_v1(self) noexcept nogil:
        return self.sequences.inputs.teml
    cpdef double get_precipitation_v1(self, numpy.int64_t s) noexcept nogil:
        return self.sequences.fluxes.nkor[s]
    cpdef double get_interceptedwater_v1(self, numpy.int64_t k) noexcept nogil:
        return self.sequences.states.inzp[k]
    cpdef double get_soilwater_v1(self, numpy.int64_t k) noexcept nogil:
        return self.sequences.states.bowa[k]
    cpdef double get_snowcover_v1(self, numpy.int64_t k) noexcept nogil:
        if self.sequences.states.wats[k] > 0.0:
            return 1.0
        return 0.0
    cpdef inline void pick_qz(self) noexcept nogil:
        cdef numpy.int64_t idx
        self.sequences.fluxes.qz = 0.0
        for idx in range(self.sequences.inlets.len_q):
            self.sequences.fluxes.qz = self.sequences.fluxes.qz + (self.sequences.inlets.q[idx])
    cpdef inline void calc_qzh(self) noexcept nogil:
        self.sequences.fluxes.qzh = self.sequences.fluxes.qz / self.parameters.derived.qfactor
    cpdef inline void calc_nkor(self) noexcept nogil:
        cdef numpy.int64_t k
        for k in range(self.parameters.control.nhru):
            self.sequences.fluxes.nkor[k] = self.parameters.control.kg[k] * self.sequences.inputs.nied
    cpdef inline void calc_tkor(self) noexcept nogil:
        cdef numpy.int64_t k
        for k in range(self.parameters.control.nhru):
            self.sequences.fluxes.tkor[k] = self.sequences.inputs.teml + self.parameters.control.atg * (self.parameters.control.gh[k] - self.parameters.derived.mgh) / 100.0 + self.parameters.control.kt[k]
    cpdef inline void calc_atkor(self) noexcept nogil:
        cdef numpy.int64_t k
        for k in range(self.parameters.control.nhru):
            self.sequences.fluxes.atkor[k] = self.sequences.fluxes.tkor[k]
            if self.parameters.control.gh[k] > self.parameters.control.aggh:
                self.sequences.fluxes.atkor[k] = self.sequences.fluxes.atkor[k] - (self.parameters.control.atg * (self.parameters.control.gh[k] - self.parameters.control.aggh) / 100.0)
    cpdef inline void calc_nbes_inzp(self) noexcept nogil:
        cdef numpy.int64_t k
        for k in range(self.parameters.control.nhru):
            if self.parameters.control.lnk[k] in (WASSER, FLUSS, SEE):
                self.sequences.fluxes.nbes[k] = 0.0
                self.sequences.states.inzp[k] = 0.0
            else:
                self.sequences.fluxes.nbes[k] = max(                    self.sequences.fluxes.nkor[k]                    + self.sequences.states.inzp[k]                    - self.parameters.derived.kinz[self.parameters.control.lnk[k] - 1, self.parameters.derived.moy[self.idx_sim]],                    0.0,                )
                self.sequences.states.inzp[k] = self.sequences.states.inzp[k] + (self.sequences.fluxes.nkor[k] - self.sequences.fluxes.nbes[k])
    cpdef inline void calc_snratio(self) noexcept nogil:
        cdef numpy.int64_t k
        for k in range(self.parameters.control.nhru):
            if self.sequences.fluxes.tkor[k] >= (self.parameters.control.tgr[k] + self.parameters.control.tsp[k] / 2.0):
                self.sequences.aides.snratio[k] = 0.0
            elif self.sequences.fluxes.tkor[k] <= (self.parameters.control.tgr[k] - self.parameters.control.tsp[k] / 2.0):
                self.sequences.aides.snratio[k] = 1.0
            else:
                self.sequences.aides.snratio[k] = (                    (self.parameters.control.tgr[k] + self.parameters.control.tsp[k] / 2.0) - self.sequences.fluxes.tkor[k]                ) / self.parameters.control.tsp[k]
    cpdef inline void calc_sbes(self) noexcept nogil:
        cdef numpy.int64_t k
        for k in range(self.parameters.control.nhru):
            self.sequences.fluxes.sbes[k] = self.sequences.aides.snratio[k] * self.sequences.fluxes.nbes[k]
    cpdef inline void calc_wats(self) noexcept nogil:
        cdef numpy.int64_t k
        for k in range(self.parameters.control.nhru):
            if self.parameters.control.lnk[k] in (WASSER, FLUSS, SEE):
                self.sequences.states.wats[k] = 0.0
            else:
                self.sequences.states.wats[k] = self.sequences.states.wats[k] + (self.sequences.fluxes.sbes[k])
    cpdef inline void calc_usg_wats_waes(self) noexcept nogil:
        cdef numpy.int64_t k
        for k in range(self.parameters.control.nhru):
            if self.parameters.control.lnk[k] == GLETS:
                self.sequences.fluxes.usg[k] = self.parameters.control.feis[k] * self.sequences.states.waes[k]
                self.sequences.states.waes[k] = self.sequences.states.waes[k] - (self.sequences.fluxes.usg[k])
                self.sequences.states.wats[k] = max(self.sequences.states.wats[k] - self.sequences.fluxes.usg[k], 0.0)
            else:
                self.sequences.fluxes.usg[k] = 0.0
    cpdef inline void calc_wgtf(self) noexcept nogil:
        cdef numpy.int64_t k
        for k in range(self.parameters.control.nhru):
            if self.parameters.control.lnk[k] in (WASSER, FLUSS, SEE):
                self.sequences.fluxes.wgtf[k] = 0.0
            else:
                self.sequences.fluxes.wgtf[k] = self.parameters.control.gtf[k] * (self.sequences.fluxes.tkor[k] - self.parameters.control.treft[k]) * self.parameters.fixed.rschmelz
    cpdef inline void calc_awgtf(self) noexcept nogil:
        cdef numpy.int64_t k
        for k in range(self.parameters.control.nhru):
            if self.parameters.control.lnk[k] in (WASSER, FLUSS, SEE):
                self.sequences.fluxes.awgtf[k] = 0.0
            else:
                self.sequences.fluxes.awgtf[k] = self.parameters.control.gtf[k] * (self.sequences.fluxes.atkor[k] - self.parameters.control.treft[k]) * self.parameters.fixed.rschmelz
    cpdef inline void calc_wnied(self) noexcept nogil:
        cdef double d_water
        cdef double d_ice
        cdef numpy.int64_t k
        for k in range(self.parameters.control.nhru):
            if self.parameters.control.lnk[k] in (WASSER, FLUSS, SEE):
                self.sequences.fluxes.wnied[k] = 0.0
            else:
                d_ice = self.parameters.fixed.cpeis * self.sequences.fluxes.sbes[k]
                d_water = self.parameters.fixed.cpwasser * (self.sequences.fluxes.nbes[k] - self.sequences.fluxes.sbes[k])
                self.sequences.fluxes.wnied[k] = (self.sequences.fluxes.tkor[k] - self.parameters.control.trefn[k]) * (d_ice + d_water)
    cpdef inline void calc_awnied(self) noexcept nogil:
        cdef double d_water
        cdef double d_ice
        cdef numpy.int64_t k
        for k in range(self.parameters.control.nhru):
            if self.parameters.control.lnk[k] in (WASSER, FLUSS, SEE):
                self.sequences.fluxes.awnied[k] = 0.0
            else:
                d_ice = self.parameters.fixed.cpeis * self.sequences.fluxes.sbes[k]
                d_water = self.parameters.fixed.cpwasser * (self.sequences.fluxes.nbes[k] - self.sequences.fluxes.sbes[k])
                self.sequences.fluxes.awnied[k] = (self.sequences.fluxes.atkor[k] - self.parameters.control.trefn[k]) * (d_ice + d_water)
    cpdef inline void calc_schmpot(self) noexcept nogil:
        cdef double w1
        cdef double p2
        cdef double p1
        cdef numpy.int64_t k
        for k in range(self.parameters.control.nhru):
            p1 = max((self.sequences.fluxes.wgtf[k] + self.sequences.fluxes.wnied[k]) / self.parameters.fixed.rschmelz, 0.0)
            if self.sequences.states.waes[k] > self.parameters.control.agsh:
                p2 = max((self.sequences.fluxes.awgtf[k] + self.sequences.fluxes.awnied[k]) / self.parameters.fixed.rschmelz, 0.0)
                w1 = self.parameters.control.agsh / self.sequences.states.waes[k]
                self.sequences.fluxes.schmpot[k] = w1 * p1 + (1.0 - w1) * p2
            else:
                self.sequences.fluxes.schmpot[k] = p1
    cpdef inline void calc_schmpotgl(self) noexcept nogil:
        cdef numpy.int64_t k
        for k in range(self.parameters.control.nhru):
            if self.parameters.control.lnk[k] == GLETS:
                self.sequences.fluxes.schmpotgl[k] = max(                    self.parameters.control.gsf * (self.sequences.fluxes.wgtf[k] + self.sequences.fluxes.wnied[k]) / self.parameters.fixed.rschmelz, 0.0                )
            else:
                self.sequences.fluxes.schmpotgl[k] = 0.0
    cpdef inline void calc_schm_wats(self) noexcept nogil:
        cdef numpy.int64_t k
        for k in range(self.parameters.control.nhru):
            if self.parameters.control.lnk[k] in (WASSER, FLUSS, SEE):
                self.sequences.fluxes.schm[k] = 0.0
            else:
                self.sequences.fluxes.schm[k] = min(self.sequences.fluxes.schmpot[k], self.sequences.states.wats[k])
                self.sequences.states.wats[k] = self.sequences.states.wats[k] - (self.sequences.fluxes.schm[k])
    cpdef inline void calc_schmgl(self) noexcept nogil:
        cdef double w
        cdef numpy.int64_t k
        for k in range(self.parameters.control.nhru):
            if (self.parameters.control.lnk[k] == GLETS) and (self.sequences.fluxes.schmpot[k] > 0.0):
                w = max(1.0 - self.sequences.fluxes.schm[k] / self.sequences.fluxes.schmpot[k], 0.0)
                self.sequences.fluxes.schmgl[k] = w * self.sequences.fluxes.schmpotgl[k]
            else:
                self.sequences.fluxes.schmgl[k] = 0.0
    cpdef inline void calc_wada_waes(self) noexcept nogil:
        cdef numpy.int64_t k
        for k in range(self.parameters.control.nhru):
            if self.parameters.control.lnk[k] in (WASSER, FLUSS, SEE):
                self.sequences.states.waes[k] = 0.0
                self.sequences.fluxes.wada[k] = self.sequences.fluxes.nbes[k]
            else:
                self.sequences.states.waes[k] = self.sequences.states.waes[k] + (self.sequences.fluxes.nbes[k])
                self.sequences.fluxes.wada[k] = max(self.sequences.states.waes[k] - self.parameters.control.pwmax[k] * self.sequences.states.wats[k], 0.0)
                self.sequences.states.waes[k] = self.sequences.states.waes[k] - (self.sequences.fluxes.wada[k])
    cpdef inline void update_wada(self) noexcept nogil:
        cdef numpy.int64_t k
        for k in range(self.parameters.control.nhru):
            if self.parameters.control.lnk[k] == GLETS:
                self.sequences.fluxes.wada[k] = self.sequences.fluxes.wada[k] + (self.sequences.fluxes.schmgl[k])
    cpdef inline void calc_evi_inzp(self) noexcept nogil:
        if self.aetmodel_typeid == 1:
            self.calc_evi_inzp_aetmodel_v1(                (<masterinterface.MasterInterface>self.aetmodel)            )
    cpdef inline void calc_evb(self) noexcept nogil:
        if self.aetmodel_typeid == 1:
            self.calc_evb_aetmodel_v1((<masterinterface.MasterInterface>self.aetmodel))
    cpdef inline void calc_qkap(self) noexcept nogil:
        cdef numpy.int64_t k
        for k in range(self.parameters.control.nhru):
            if (self.parameters.control.lnk[k] in (VERS, WASSER, FLUSS, SEE)) or (self.parameters.control.wmax[k] <= 0.0):
                self.sequences.fluxes.qkap[k] = 0.0
            elif self.sequences.states.bowa[k] <= self.parameters.control.kapgrenz[k, 0]:
                self.sequences.fluxes.qkap[k] = self.parameters.control.kapmax[k]
            elif self.sequences.states.bowa[k] <= self.parameters.control.kapgrenz[k, 1]:
                self.sequences.fluxes.qkap[k] = self.parameters.control.kapmax[k] * (                    1.0                    - (self.sequences.states.bowa[k] - self.parameters.control.kapgrenz[k, 0])                    / (self.parameters.control.kapgrenz[k, 1] - self.parameters.control.kapgrenz[k, 0])                )
            else:
                self.sequences.fluxes.qkap[k] = 0
    cpdef inline void calc_qbb(self) noexcept nogil:
        cdef numpy.int64_t k
        for k in range(self.parameters.control.nhru):
            if (                (self.parameters.control.lnk[k] in (VERS, WASSER, FLUSS, SEE))                or (self.sequences.states.bowa[k] <= self.parameters.control.pwp[k])                or (self.parameters.control.wmax[k] <= 0.0)            ):
                self.sequences.fluxes.qbb[k] = 0.0
            elif self.sequences.states.bowa[k] <= self.parameters.control.fk[k]:
                if self.parameters.control.rbeta:
                    self.sequences.fluxes.qbb[k] = 0.0
                else:
                    self.sequences.fluxes.qbb[k] = self.parameters.control.beta[k] * (self.sequences.states.bowa[k] - self.parameters.control.pwp[k])
            else:
                self.sequences.fluxes.qbb[k] = (                    self.parameters.control.beta[k]                    * (self.sequences.states.bowa[k] - self.parameters.control.pwp[k])                    * (                        1.0                        + (self.parameters.control.fbeta[k] - 1.0)                        * (self.sequences.states.bowa[k] - self.parameters.control.fk[k])                        / (self.parameters.control.wmax[k] - self.parameters.control.fk[k])                    )                )
    cpdef inline void calc_qib1(self) noexcept nogil:
        cdef numpy.int64_t k
        for k in range(self.parameters.control.nhru):
            if (self.parameters.control.lnk[k] in (VERS, WASSER, FLUSS, SEE)) or (                self.sequences.states.bowa[k] <= self.parameters.control.pwp[k]            ):
                self.sequences.fluxes.qib1[k] = 0.0
            else:
                self.sequences.fluxes.qib1[k] = self.parameters.control.dmin[k] * (self.sequences.states.bowa[k] / self.parameters.control.wmax[k])
    cpdef inline void calc_qib2(self) noexcept nogil:
        cdef numpy.int64_t k
        for k in range(self.parameters.control.nhru):
            if (                (self.parameters.control.lnk[k] in (VERS, WASSER, FLUSS, SEE))                or (self.sequences.states.bowa[k] <= self.parameters.control.fk[k])                or (self.parameters.control.wmax[k] <= self.parameters.control.fk[k])            ):
                self.sequences.fluxes.qib2[k] = 0.0
            else:
                self.sequences.fluxes.qib2[k] = (self.parameters.control.dmax[k] - self.parameters.control.dmin[k]) * (                    (self.sequences.states.bowa[k] - self.parameters.control.fk[k]) / (self.parameters.control.wmax[k] - self.parameters.control.fk[k])                ) ** 1.5
    cpdef inline void calc_qdb(self) noexcept nogil:
        cdef double sfa
        cdef double wmax
        cdef double bowa
        cdef numpy.int64_t k
        for k in range(self.parameters.control.nhru):
            if self.parameters.control.lnk[k] == WASSER:
                self.sequences.fluxes.qdb[k] = 0.0
            elif (self.parameters.control.lnk[k] in (VERS, FLUSS, SEE)) or (self.parameters.control.wmax[k] <= 0.0):
                self.sequences.fluxes.qdb[k] = self.sequences.fluxes.wada[k]
            else:
                bowa = self.sequences.states.bowa[k] - (self.parameters.control.bsf0[k] * self.parameters.control.wmax[k])
                wmax = (1.0 - self.parameters.control.bsf0[k]) * self.parameters.control.wmax[k]
                self.sequences.fluxes.qdb[k] = bowa + self.sequences.fluxes.wada[k] - wmax
                if bowa < wmax:
                    sfa = (1.0 - bowa / wmax) ** (1.0 / (self.parameters.control.bsf[k] + 1.0)) - (                        self.sequences.fluxes.wada[k] / ((self.parameters.control.bsf[k] + 1.0) * wmax)                    )
                    if sfa > 0.0:
                        self.sequences.fluxes.qdb[k] = self.sequences.fluxes.qdb[k] + (sfa ** (self.parameters.control.bsf[k] + 1.0) * wmax)
                self.sequences.fluxes.qdb[k] = max(self.sequences.fluxes.qdb[k], 0.0)
    cpdef inline void calc_bowa(self) noexcept nogil:
        if self.soilmodel is None:
            self.calc_bowa_default_v1()
        elif self.soilmodel_typeid == 1:
            self.calc_bowa_soilmodel_v1(                (<masterinterface.MasterInterface>self.soilmodel)            )
    cpdef inline void calc_qbgz(self) noexcept nogil:
        cdef numpy.int64_t k
        self.sequences.fluxes.qbgz = 0.0
        for k in range(self.parameters.control.nhru):
            if self.parameters.control.lnk[k] == SEE:
                self.sequences.fluxes.qbgz = self.sequences.fluxes.qbgz + (self.parameters.control.fhru[k] * (self.sequences.fluxes.nkor[k] - self.sequences.fluxes.evi[k]))
            elif self.parameters.control.lnk[k] not in (WASSER, FLUSS, VERS):
                self.sequences.fluxes.qbgz = self.sequences.fluxes.qbgz + (self.parameters.control.fhru[k] * (self.sequences.fluxes.qbb[k] - self.sequences.fluxes.qkap[k]))
    cpdef inline void calc_qigz1(self) noexcept nogil:
        cdef numpy.int64_t k
        self.sequences.fluxes.qigz1 = 0.0
        for k in range(self.parameters.control.nhru):
            self.sequences.fluxes.qigz1 = self.sequences.fluxes.qigz1 + (self.parameters.control.fhru[k] * self.sequences.fluxes.qib1[k])
    cpdef inline void calc_qigz2(self) noexcept nogil:
        cdef numpy.int64_t k
        self.sequences.fluxes.qigz2 = 0.0
        for k in range(self.parameters.control.nhru):
            self.sequences.fluxes.qigz2 = self.sequences.fluxes.qigz2 + (self.parameters.control.fhru[k] * self.sequences.fluxes.qib2[k])
    cpdef inline void calc_qdgz(self) noexcept nogil:
        cdef numpy.int64_t k
        self.sequences.fluxes.qdgz = 0.0
        for k in range(self.parameters.control.nhru):
            if self.parameters.control.lnk[k] == FLUSS:
                self.sequences.fluxes.qdgz = self.sequences.fluxes.qdgz + (self.parameters.control.fhru[k] * (self.sequences.fluxes.nkor[k] - self.sequences.fluxes.evi[k]))
            elif self.parameters.control.lnk[k] not in (WASSER, SEE):
                self.sequences.fluxes.qdgz = self.sequences.fluxes.qdgz + (self.parameters.control.fhru[k] * self.sequences.fluxes.qdb[k])
    cpdef inline void calc_qbga_sbg_qbgz_qdgz(self) noexcept nogil:
        cdef double qbgz
        cdef double tt
        cdef double c2
        cdef double c1
        cdef double st
        cdef double fraction
        cdef double t
        cdef double excess
        cdef double z
        cdef double s0
        cdef double g2
        cdef double g1
        cdef double sm
        cdef double k
        k = self.parameters.derived.kb
        sm = self.parameters.control.gsbmax * self.parameters.control.volbmax
        g1 = self.parameters.control.gsbgrad1
        g2 = self.parameters.control.gsbgrad2
        s0 = self.sequences.old_states.sbg
        z = self.sequences.fluxes.qbgz
        if s0 > sm:
            excess = s0 - sm
            s0 = sm
        else:
            excess = 0.0
        if k == 0.0:
            self.sequences.new_states.sbg = 0.0
            self.sequences.fluxes.qbga = s0 + self.sequences.fluxes.qbgz
        elif z - s0 / k <= g1:
            if isinf(k):
                self.sequences.new_states.sbg = min(s0 + z, sm)
                self.sequences.fluxes.qbga = 0.0
            else:
                if isinf(sm):
                    t = 1.0
                else:
                    fraction = (k * z - sm) / (k * z - s0)
                    if fraction > 0.0:
                        t = -k * log(fraction)
                    else:
                        t = 1.0
                if t < 1.0:
                    self.sequences.new_states.sbg = sm
                    self.sequences.fluxes.qbga = s0 - sm + t * self.sequences.fluxes.qbgz
                    self.sequences.fluxes.qbga = self.sequences.fluxes.qbga + ((1.0 - t) * sm / k)
                else:
                    self.sequences.new_states.sbg = self.return_sg_v1(k, s0, z, 1.0)
                    self.sequences.fluxes.qbga = s0 - self.sequences.new_states.sbg + self.sequences.fluxes.qbgz
        elif g2 == 0.0:
            self.sequences.fluxes.qbga = s0 / k
            self.sequences.new_states.sbg = s0
        else:
            if isinf(k) and (g2 > g1):
                self.sequences.fluxes.qbga = 0.0
                self.sequences.new_states.sbg = s0 + g2 / ((g2 - g1) / z + 1.0)
            else:
                st = min(k * (z - g1), sm)
                if g1 == g2:
                    t = min((st - s0) / g1, 1.0)
                    self.sequences.fluxes.qbga = t * (g1 * t + 2.0 * s0) / (2.0 * k)
                else:
                    c1 = (g2 - g1) / (g1 - g2 - z)
                    c2 = (g2 * k * z) / (g1 - g2)
                    t = min(k / c1 * log((st + c2) / (s0 + c2)), 1.0)
                    self.sequences.fluxes.qbga = (s0 + c2) * (                        exp(c1 * t / k) - 1.0                    ) / c1 - c2 * t / k
                if t < 1.0:
                    if st == sm:
                        self.sequences.new_states.sbg = sm
                        self.sequences.fluxes.qbga = self.sequences.fluxes.qbga + ((1.0 - t) * sm / k)
                    else:
                        fraction = (k * z - sm) / (k * z - st)
                        if fraction > 0.0:
                            tt = -k * log(fraction)
                        else:
                            tt = 1.0
                        if t + tt < 1.0:
                            self.sequences.new_states.sbg = sm
                            self.sequences.fluxes.qbga = self.sequences.fluxes.qbga + (st - sm + tt * self.sequences.fluxes.qbgz)
                            self.sequences.fluxes.qbga = self.sequences.fluxes.qbga + ((1.0 - t - tt) * sm / k)
                        else:
                            self.sequences.new_states.sbg = self.return_sg_v1(k, st, z, 1.0 - t)
                            self.sequences.fluxes.qbga = self.sequences.fluxes.qbga + (st - self.sequences.new_states.sbg + (1.0 - t) * self.sequences.fluxes.qbgz)
                elif g1 == g2:
                    self.sequences.new_states.sbg = s0 + g1
                else:
                    self.sequences.new_states.sbg = (s0 + c2) * exp(1.0 / k * c1) - c2
        qbgz = self.sequences.fluxes.qbgz
        self.sequences.fluxes.qbgz = self.sequences.new_states.sbg - s0 + self.sequences.fluxes.qbga
        self.sequences.fluxes.qdgz = self.sequences.fluxes.qdgz + (qbgz - self.sequences.fluxes.qbgz)
        self.sequences.fluxes.qbga = self.sequences.fluxes.qbga + (excess)
    cpdef inline void calc_qiga1_sig1(self) noexcept nogil:
        self.sequences.new_states.sig1 = self.return_sg_v1(self.parameters.derived.ki1, self.sequences.old_states.sig1, self.sequences.fluxes.qigz1, 1.0)
        self.sequences.fluxes.qiga1 = self.sequences.old_states.sig1 - self.sequences.new_states.sig1 + self.sequences.fluxes.qigz1
    cpdef inline void calc_qiga2_sig2(self) noexcept nogil:
        self.sequences.new_states.sig2 = self.return_sg_v1(self.parameters.derived.ki2, self.sequences.old_states.sig2, self.sequences.fluxes.qigz2, 1.0)
        self.sequences.fluxes.qiga2 = self.sequences.old_states.sig2 - self.sequences.new_states.sig2 + self.sequences.fluxes.qigz2
    cpdef inline void calc_qdgz1_qdgz2(self) noexcept nogil:
        if self.sequences.fluxes.qdgz > self.parameters.control.a2:
            self.sequences.fluxes.qdgz2 = (self.sequences.fluxes.qdgz - self.parameters.control.a2) ** 2 / (self.sequences.fluxes.qdgz + self.parameters.control.a1 - self.parameters.control.a2)
            self.sequences.fluxes.qdgz1 = self.sequences.fluxes.qdgz - self.sequences.fluxes.qdgz2
        else:
            self.sequences.fluxes.qdgz2 = 0.0
            self.sequences.fluxes.qdgz1 = self.sequences.fluxes.qdgz
    cpdef inline void calc_qdga1_sdg1(self) noexcept nogil:
        self.sequences.new_states.sdg1 = self.return_sg_v1(self.parameters.derived.kd1, self.sequences.old_states.sdg1, self.sequences.fluxes.qdgz1, 1.0)
        self.sequences.fluxes.qdga1 = self.sequences.old_states.sdg1 - self.sequences.new_states.sdg1 + self.sequences.fluxes.qdgz1
    cpdef inline void calc_qdga2_sdg2(self) noexcept nogil:
        self.sequences.new_states.sdg2 = self.return_sg_v1(self.parameters.derived.kd2, self.sequences.old_states.sdg2, self.sequences.fluxes.qdgz2, 1.0)
        self.sequences.fluxes.qdga2 = self.sequences.old_states.sdg2 - self.sequences.new_states.sdg2 + self.sequences.fluxes.qdgz2
    cpdef inline void calc_qah(self) noexcept nogil:
        cdef double d_epw
        cdef numpy.int64_t k
        cdef double d_area
        self.sequences.fluxes.qah = self.sequences.fluxes.qzh + self.sequences.fluxes.qbga + self.sequences.fluxes.qiga1 + self.sequences.fluxes.qiga2 + self.sequences.fluxes.qdga1 + self.sequences.fluxes.qdga2
        if (not self.parameters.control.negq) and (self.sequences.fluxes.qah < 0.0):
            d_area = 0.0
            for k in range(self.parameters.control.nhru):
                if self.parameters.control.lnk[k] in (FLUSS, SEE):
                    d_area = d_area + (self.parameters.control.fhru[k])
            if d_area > 0.0:
                for k in range(self.parameters.control.nhru):
                    if self.parameters.control.lnk[k] in (FLUSS, SEE):
                        self.sequences.fluxes.evi[k] = self.sequences.fluxes.evi[k] + (self.sequences.fluxes.qah / d_area)
            self.sequences.fluxes.qah = 0.0
        d_epw = 0.0
        for k in range(self.parameters.control.nhru):
            if self.parameters.control.lnk[k] == WASSER:
                self.sequences.fluxes.qah = self.sequences.fluxes.qah + (self.parameters.control.fhru[k] * self.sequences.fluxes.nkor[k])
                d_epw = d_epw + (self.parameters.control.fhru[k] * self.sequences.fluxes.evi[k])
        if (self.sequences.fluxes.qah > d_epw) or self.parameters.control.negq:
            self.sequences.fluxes.qah = self.sequences.fluxes.qah - (d_epw)
        elif d_epw > 0.0:
            for k in range(self.parameters.control.nhru):
                if self.parameters.control.lnk[k] == WASSER:
                    self.sequences.fluxes.evi[k] = self.sequences.fluxes.evi[k] * (self.sequences.fluxes.qah / d_epw)
            self.sequences.fluxes.qah = 0.0
    cpdef inline void calc_qa(self) noexcept nogil:
        self.sequences.fluxes.qa = self.parameters.derived.qfactor * self.sequences.fluxes.qah
    cpdef inline void calc_evi_inzp_aetmodel(self, masterinterface.MasterInterface submodel) noexcept nogil:
        cdef numpy.int64_t k
        submodel.determine_interceptionevaporation()
        submodel.determine_waterevaporation()
        for k in range(self.parameters.control.nhru):
            if self.parameters.control.lnk[k] in (WASSER, FLUSS, SEE):
                self.sequences.fluxes.evi[k] = submodel.get_waterevaporation(k)
                self.sequences.states.inzp[k] = 0.0
            else:
                self.sequences.fluxes.evi[k] = min(submodel.get_interceptionevaporation(k), self.sequences.states.inzp[k])
                self.sequences.states.inzp[k] = self.sequences.states.inzp[k] - (self.sequences.fluxes.evi[k])
    cpdef inline void calc_evb_aetmodel(self, masterinterface.MasterInterface submodel) noexcept nogil:
        cdef numpy.int64_t k
        submodel.determine_soilevapotranspiration()
        for k in range(self.parameters.control.nhru):
            if self.parameters.control.lnk[k] in (VERS, WASSER, FLUSS, SEE):
                self.sequences.fluxes.evb[k] = 0.0
            else:
                self.sequences.fluxes.evb[k] = submodel.get_soilevapotranspiration(k)
    cpdef inline double return_sg(self, double k, double s, double qz, double dt) noexcept nogil:
        if k <= 0.0:
            return 0.0
        if isinf(k):
            return s + qz
        return k * qz - (k * qz - s) * exp(-dt / k)
    cpdef inline void calc_bowa_default(self) noexcept nogil:
        cdef double d_factor
        cdef double d_rvl
        cdef double d_incr
        cdef double d_decr
        cdef numpy.int64_t k
        for k in range(self.parameters.control.nhru):
            if self.parameters.control.lnk[k] in (VERS, WASSER, FLUSS, SEE):
                self.sequences.states.bowa[k] = 0.0
            else:
                d_decr = self.sequences.fluxes.qbb[k] + self.sequences.fluxes.qib1[k] + self.sequences.fluxes.qib2[k] + self.sequences.fluxes.qdb[k]
                d_incr = self.sequences.fluxes.wada[k] + self.sequences.fluxes.qkap[k]
                if self.sequences.fluxes.evb[k] > 0.0:
                    d_decr = d_decr + (self.sequences.fluxes.evb[k])
                else:
                    d_incr = d_incr - (self.sequences.fluxes.evb[k])
                if d_decr > self.sequences.states.bowa[k] + d_incr:
                    d_rvl = (self.sequences.states.bowa[k] + d_incr) / d_decr
                    if self.sequences.fluxes.evb[k] > 0.0:
                        self.sequences.fluxes.evb[k] = self.sequences.fluxes.evb[k] * (d_rvl)
                    self.sequences.fluxes.qbb[k] = self.sequences.fluxes.qbb[k] * (d_rvl)
                    self.sequences.fluxes.qib1[k] = self.sequences.fluxes.qib1[k] * (d_rvl)
                    self.sequences.fluxes.qib2[k] = self.sequences.fluxes.qib2[k] * (d_rvl)
                    self.sequences.fluxes.qdb[k] = self.sequences.fluxes.qdb[k] * (d_rvl)
                    self.sequences.states.bowa[k] = 0.0
                else:
                    self.sequences.states.bowa[k] = (self.sequences.states.bowa[k] + d_incr) - d_decr
                    if self.sequences.states.bowa[k] > self.parameters.control.wmax[k]:
                        d_factor = (self.sequences.states.bowa[k] - self.parameters.control.wmax[k]) / d_incr
                        if self.sequences.fluxes.evb[k] < 0.0:
                            self.sequences.fluxes.evb[k] = self.sequences.fluxes.evb[k] * (d_factor)
                        self.sequences.fluxes.wada[k] = self.sequences.fluxes.wada[k] * (d_factor)
                        self.sequences.fluxes.qkap[k] = self.sequences.fluxes.qkap[k] * (d_factor)
                        self.sequences.states.bowa[k] = self.parameters.control.wmax[k]
    cpdef inline void calc_bowa_soilmodel(self, masterinterface.MasterInterface submodel) noexcept nogil:
        cdef double removal
        cdef double demand
        cdef double factor
        cdef double addition
        cdef double supply
        cdef double qbb_soilmodel
        cdef double infiltration
        cdef numpy.int64_t k
        for k in range(self.parameters.control.nhru):
            if self.parameters.control.lnk[k] in (VERS, WASSER, FLUSS, SEE):
                self.sequences.states.bowa[k] = 0.0
            else:
                submodel.set_initialsurfacewater(k, self.sequences.fluxes.wada[k])
                submodel.set_actualsurfacewater(k, self.sequences.fluxes.wada[k] - self.sequences.fluxes.qdb[k])
                submodel.set_soilwatersupply(k, 0.0)
                submodel.set_soilwaterdemand(k, 0.0)
                submodel.execute_infiltration(k)
                infiltration = submodel.get_infiltration(k)
                self.sequences.fluxes.qdb[k] = self.sequences.fluxes.qdb[k] + ((self.sequences.fluxes.wada[k] - self.sequences.fluxes.qdb[k]) - infiltration)
                qbb_soilmodel = submodel.get_percolation(k)
                supply = self.sequences.fluxes.qkap[k]
                if self.sequences.fluxes.evb[k] < 0.0:
                    supply = supply - (self.sequences.fluxes.evb[k])
                submodel.set_soilwatersupply(k, supply)
                submodel.add_soilwater(k)
                addition = submodel.get_soilwateraddition(k)
                if addition < supply:
                    factor = addition / supply
                    self.sequences.fluxes.qkap[k] = self.sequences.fluxes.qkap[k] * (factor)
                    if self.sequences.fluxes.evb[k] < 0.0:
                        self.sequences.fluxes.evb[k] = self.sequences.fluxes.evb[k] * (factor)
                demand = self.sequences.fluxes.qbb[k] + self.sequences.fluxes.qib1[k] + self.sequences.fluxes.qib2[k]
                if self.sequences.fluxes.evb[k] > 0.0:
                    demand = demand + (self.sequences.fluxes.evb[k])
                submodel.set_soilwaterdemand(k, demand)
                submodel.remove_soilwater(k)
                removal = submodel.get_soilwaterremoval(k)
                if removal < demand:
                    factor = removal / demand
                    self.sequences.fluxes.qbb[k] = self.sequences.fluxes.qbb[k] * (factor)
                    self.sequences.fluxes.qib1[k] = self.sequences.fluxes.qib1[k] * (factor)
                    self.sequences.fluxes.qib2[k] = self.sequences.fluxes.qib2[k] * (factor)
                    if self.sequences.fluxes.evb[k] > 0.0:
                        self.sequences.fluxes.evb[k] = self.sequences.fluxes.evb[k] * (factor)
                self.sequences.states.bowa[k] = submodel.get_soilwatercontent(k)
                self.sequences.fluxes.qbb[k] = self.sequences.fluxes.qbb[k] + (qbb_soilmodel)
    cpdef inline void pass_qa(self) noexcept nogil:
        self.sequences.outlets.q = self.sequences.fluxes.qa
    cpdef double get_temperature(self, numpy.int64_t s) noexcept nogil:
        return self.sequences.fluxes.tkor[s]
    cpdef double get_meantemperature(self) noexcept nogil:
        return self.sequences.inputs.teml
    cpdef double get_precipitation(self, numpy.int64_t s) noexcept nogil:
        return self.sequences.fluxes.nkor[s]
    cpdef double get_interceptedwater(self, numpy.int64_t k) noexcept nogil:
        return self.sequences.states.inzp[k]
    cpdef double get_soilwater(self, numpy.int64_t k) noexcept nogil:
        return self.sequences.states.bowa[k]
    cpdef double get_snowcover(self, numpy.int64_t k) noexcept nogil:
        if self.sequences.states.wats[k] > 0.0:
            return 1.0
        return 0.0
