#!python
# distutils: define_macros=NPY_NO_DEPRECATED_API=NPY_1_7_API_VERSION
# cython: language_level=3
# cython: cpow=True
# cython: boundscheck=False
# cython: wraparound=False
# cython: initializedcheck=False
# cython: cdivision=True
from typing import Optional
import numpy
cimport numpy
from libc.math cimport exp, fabs, log, sin, cos, tan, tanh, asin, acos, atan, isnan, isinf
from libc.math cimport NAN as nan
from libc.math cimport INFINITY as inf
import cython
from cpython.mem cimport PyMem_Malloc
from cpython.mem cimport PyMem_Realloc
from cpython.mem cimport PyMem_Free
from hydpy.cythons.autogen cimport configutils
from hydpy.cythons.autogen cimport interfaceutils
from hydpy.cythons.autogen cimport interputils
from hydpy.cythons.autogen import pointerutils
from hydpy.cythons.autogen cimport pointerutils
from hydpy.cythons.autogen cimport quadutils
from hydpy.cythons.autogen cimport rootutils
from hydpy.cythons.autogen cimport smoothutils
from hydpy.cythons.autogen cimport masterinterface


cdef void do_nothing(Model model)  noexcept nogil:
    pass

cpdef get_wrapper():
    cdef CallbackWrapper wrapper = CallbackWrapper()
    wrapper.callback = do_nothing
    return wrapper

@cython.final
cdef class Parameters:
    pass
@cython.final
cdef class ControlParameters:
    pass
@cython.final
cdef class DerivedParameters:
    pass
@cython.final
cdef class Sequences:
    pass
@cython.final
cdef class FactorSequences:
    cpdef inline void load_data(self, numpy.int64_t idx)  noexcept nogil:
        cdef numpy.int64_t jdx0
        cdef numpy.int64_t k
        if self._waterdepth_diskflag_reading:
            self.waterdepth = self._waterdepth_ncarray[0]
        elif self._waterdepth_ramflag:
            self.waterdepth = self._waterdepth_array[idx]
        if self._waterlevel_diskflag_reading:
            self.waterlevel = self._waterlevel_ncarray[0]
        elif self._waterlevel_ramflag:
            self.waterlevel = self._waterlevel_array[idx]
        if self._flowareas_diskflag_reading:
            k = 0
            for jdx0 in range(self._flowareas_length_0):
                self.flowareas[jdx0] = self._flowareas_ncarray[k]
                k += 1
        elif self._flowareas_ramflag:
            for jdx0 in range(self._flowareas_length_0):
                self.flowareas[jdx0] = self._flowareas_array[idx, jdx0]
        if self._flowarea_diskflag_reading:
            self.flowarea = self._flowarea_ncarray[0]
        elif self._flowarea_ramflag:
            self.flowarea = self._flowarea_array[idx]
        if self._totalareas_diskflag_reading:
            k = 0
            for jdx0 in range(self._totalareas_length_0):
                self.totalareas[jdx0] = self._totalareas_ncarray[k]
                k += 1
        elif self._totalareas_ramflag:
            for jdx0 in range(self._totalareas_length_0):
                self.totalareas[jdx0] = self._totalareas_array[idx, jdx0]
        if self._totalarea_diskflag_reading:
            self.totalarea = self._totalarea_ncarray[0]
        elif self._totalarea_ramflag:
            self.totalarea = self._totalarea_array[idx]
        if self._flowperimeters_diskflag_reading:
            k = 0
            for jdx0 in range(self._flowperimeters_length_0):
                self.flowperimeters[jdx0] = self._flowperimeters_ncarray[k]
                k += 1
        elif self._flowperimeters_ramflag:
            for jdx0 in range(self._flowperimeters_length_0):
                self.flowperimeters[jdx0] = self._flowperimeters_array[idx, jdx0]
        if self._flowperimeterderivatives_diskflag_reading:
            k = 0
            for jdx0 in range(self._flowperimeterderivatives_length_0):
                self.flowperimeterderivatives[jdx0] = self._flowperimeterderivatives_ncarray[k]
                k += 1
        elif self._flowperimeterderivatives_ramflag:
            for jdx0 in range(self._flowperimeterderivatives_length_0):
                self.flowperimeterderivatives[jdx0] = self._flowperimeterderivatives_array[idx, jdx0]
        if self._flowwidths_diskflag_reading:
            k = 0
            for jdx0 in range(self._flowwidths_length_0):
                self.flowwidths[jdx0] = self._flowwidths_ncarray[k]
                k += 1
        elif self._flowwidths_ramflag:
            for jdx0 in range(self._flowwidths_length_0):
                self.flowwidths[jdx0] = self._flowwidths_array[idx, jdx0]
        if self._totalwidths_diskflag_reading:
            k = 0
            for jdx0 in range(self._totalwidths_length_0):
                self.totalwidths[jdx0] = self._totalwidths_ncarray[k]
                k += 1
        elif self._totalwidths_ramflag:
            for jdx0 in range(self._totalwidths_length_0):
                self.totalwidths[jdx0] = self._totalwidths_array[idx, jdx0]
        if self._totalwidth_diskflag_reading:
            self.totalwidth = self._totalwidth_ncarray[0]
        elif self._totalwidth_ramflag:
            self.totalwidth = self._totalwidth_array[idx]
        if self._dischargederivatives_diskflag_reading:
            k = 0
            for jdx0 in range(self._dischargederivatives_length_0):
                self.dischargederivatives[jdx0] = self._dischargederivatives_ncarray[k]
                k += 1
        elif self._dischargederivatives_ramflag:
            for jdx0 in range(self._dischargederivatives_length_0):
                self.dischargederivatives[jdx0] = self._dischargederivatives_array[idx, jdx0]
        if self._dischargederivative_diskflag_reading:
            self.dischargederivative = self._dischargederivative_ncarray[0]
        elif self._dischargederivative_ramflag:
            self.dischargederivative = self._dischargederivative_array[idx]
        if self._celerity_diskflag_reading:
            self.celerity = self._celerity_ncarray[0]
        elif self._celerity_ramflag:
            self.celerity = self._celerity_array[idx]
    cpdef inline void save_data(self, numpy.int64_t idx)  noexcept nogil:
        cdef numpy.int64_t jdx0
        cdef numpy.int64_t k
        if self._waterdepth_diskflag_writing:
            self._waterdepth_ncarray[0] = self.waterdepth
        if self._waterdepth_ramflag:
            self._waterdepth_array[idx] = self.waterdepth
        if self._waterlevel_diskflag_writing:
            self._waterlevel_ncarray[0] = self.waterlevel
        if self._waterlevel_ramflag:
            self._waterlevel_array[idx] = self.waterlevel
        if self._flowareas_diskflag_writing:
            k = 0
            for jdx0 in range(self._flowareas_length_0):
                self._flowareas_ncarray[k] = self.flowareas[jdx0]
                k += 1
        if self._flowareas_ramflag:
            for jdx0 in range(self._flowareas_length_0):
                self._flowareas_array[idx, jdx0] = self.flowareas[jdx0]
        if self._flowarea_diskflag_writing:
            self._flowarea_ncarray[0] = self.flowarea
        if self._flowarea_ramflag:
            self._flowarea_array[idx] = self.flowarea
        if self._totalareas_diskflag_writing:
            k = 0
            for jdx0 in range(self._totalareas_length_0):
                self._totalareas_ncarray[k] = self.totalareas[jdx0]
                k += 1
        if self._totalareas_ramflag:
            for jdx0 in range(self._totalareas_length_0):
                self._totalareas_array[idx, jdx0] = self.totalareas[jdx0]
        if self._totalarea_diskflag_writing:
            self._totalarea_ncarray[0] = self.totalarea
        if self._totalarea_ramflag:
            self._totalarea_array[idx] = self.totalarea
        if self._flowperimeters_diskflag_writing:
            k = 0
            for jdx0 in range(self._flowperimeters_length_0):
                self._flowperimeters_ncarray[k] = self.flowperimeters[jdx0]
                k += 1
        if self._flowperimeters_ramflag:
            for jdx0 in range(self._flowperimeters_length_0):
                self._flowperimeters_array[idx, jdx0] = self.flowperimeters[jdx0]
        if self._flowperimeterderivatives_diskflag_writing:
            k = 0
            for jdx0 in range(self._flowperimeterderivatives_length_0):
                self._flowperimeterderivatives_ncarray[k] = self.flowperimeterderivatives[jdx0]
                k += 1
        if self._flowperimeterderivatives_ramflag:
            for jdx0 in range(self._flowperimeterderivatives_length_0):
                self._flowperimeterderivatives_array[idx, jdx0] = self.flowperimeterderivatives[jdx0]
        if self._flowwidths_diskflag_writing:
            k = 0
            for jdx0 in range(self._flowwidths_length_0):
                self._flowwidths_ncarray[k] = self.flowwidths[jdx0]
                k += 1
        if self._flowwidths_ramflag:
            for jdx0 in range(self._flowwidths_length_0):
                self._flowwidths_array[idx, jdx0] = self.flowwidths[jdx0]
        if self._totalwidths_diskflag_writing:
            k = 0
            for jdx0 in range(self._totalwidths_length_0):
                self._totalwidths_ncarray[k] = self.totalwidths[jdx0]
                k += 1
        if self._totalwidths_ramflag:
            for jdx0 in range(self._totalwidths_length_0):
                self._totalwidths_array[idx, jdx0] = self.totalwidths[jdx0]
        if self._totalwidth_diskflag_writing:
            self._totalwidth_ncarray[0] = self.totalwidth
        if self._totalwidth_ramflag:
            self._totalwidth_array[idx] = self.totalwidth
        if self._dischargederivatives_diskflag_writing:
            k = 0
            for jdx0 in range(self._dischargederivatives_length_0):
                self._dischargederivatives_ncarray[k] = self.dischargederivatives[jdx0]
                k += 1
        if self._dischargederivatives_ramflag:
            for jdx0 in range(self._dischargederivatives_length_0):
                self._dischargederivatives_array[idx, jdx0] = self.dischargederivatives[jdx0]
        if self._dischargederivative_diskflag_writing:
            self._dischargederivative_ncarray[0] = self.dischargederivative
        if self._dischargederivative_ramflag:
            self._dischargederivative_array[idx] = self.dischargederivative
        if self._celerity_diskflag_writing:
            self._celerity_ncarray[0] = self.celerity
        if self._celerity_ramflag:
            self._celerity_array[idx] = self.celerity
    cpdef inline set_pointeroutput(self, str name, pointerutils.PDouble value):
        if name == "waterdepth":
            self._waterdepth_outputpointer = value.p_value
        if name == "waterlevel":
            self._waterlevel_outputpointer = value.p_value
        if name == "flowarea":
            self._flowarea_outputpointer = value.p_value
        if name == "totalarea":
            self._totalarea_outputpointer = value.p_value
        if name == "totalwidth":
            self._totalwidth_outputpointer = value.p_value
        if name == "dischargederivative":
            self._dischargederivative_outputpointer = value.p_value
        if name == "celerity":
            self._celerity_outputpointer = value.p_value
    cpdef inline void update_outputs(self) noexcept nogil:
        if self._waterdepth_outputflag:
            self._waterdepth_outputpointer[0] = self.waterdepth
        if self._waterlevel_outputflag:
            self._waterlevel_outputpointer[0] = self.waterlevel
        if self._flowarea_outputflag:
            self._flowarea_outputpointer[0] = self.flowarea
        if self._totalarea_outputflag:
            self._totalarea_outputpointer[0] = self.totalarea
        if self._totalwidth_outputflag:
            self._totalwidth_outputpointer[0] = self.totalwidth
        if self._dischargederivative_outputflag:
            self._dischargederivative_outputpointer[0] = self.dischargederivative
        if self._celerity_outputflag:
            self._celerity_outputpointer[0] = self.celerity
@cython.final
cdef class FluxSequences:
    cpdef inline void load_data(self, numpy.int64_t idx)  noexcept nogil:
        cdef numpy.int64_t jdx0
        cdef numpy.int64_t k
        if self._discharges_diskflag_reading:
            k = 0
            for jdx0 in range(self._discharges_length_0):
                self.discharges[jdx0] = self._discharges_ncarray[k]
                k += 1
        elif self._discharges_ramflag:
            for jdx0 in range(self._discharges_length_0):
                self.discharges[jdx0] = self._discharges_array[idx, jdx0]
        if self._discharge_diskflag_reading:
            self.discharge = self._discharge_ncarray[0]
        elif self._discharge_ramflag:
            self.discharge = self._discharge_array[idx]
    cpdef inline void save_data(self, numpy.int64_t idx)  noexcept nogil:
        cdef numpy.int64_t jdx0
        cdef numpy.int64_t k
        if self._discharges_diskflag_writing:
            k = 0
            for jdx0 in range(self._discharges_length_0):
                self._discharges_ncarray[k] = self.discharges[jdx0]
                k += 1
        if self._discharges_ramflag:
            for jdx0 in range(self._discharges_length_0):
                self._discharges_array[idx, jdx0] = self.discharges[jdx0]
        if self._discharge_diskflag_writing:
            self._discharge_ncarray[0] = self.discharge
        if self._discharge_ramflag:
            self._discharge_array[idx] = self.discharge
    cpdef inline set_pointeroutput(self, str name, pointerutils.PDouble value):
        if name == "discharge":
            self._discharge_outputpointer = value.p_value
    cpdef inline void update_outputs(self) noexcept nogil:
        if self._discharge_outputflag:
            self._discharge_outputpointer[0] = self.discharge
@cython.final
cdef class AideSequences:
    pass
@cython.final
cdef class Model(masterinterface.MasterInterface):
    cpdef inline void simulate(self, numpy.int64_t idx)  noexcept nogil:
        self.idx_sim = idx
        self.run()
        self.update_outputs()
    cpdef void simulate_period(self, numpy.int64_t i0, numpy.int64_t i1)  noexcept nogil:
        cdef numpy.int64_t i
        with nogil:
            for i in range(i0, i1):
                self.simulate(i)
                self.update_senders(i)
                self.update_receivers(i)
                self.save_data(i)
    cpdef void reset_reuseflags(self) noexcept nogil:
        pass
    cpdef void save_data(self, numpy.int64_t idx) noexcept nogil:
        self.idx_sim = idx
        self.sequences.factors.save_data(idx)
        self.sequences.fluxes.save_data(idx)
    cpdef inline void run(self) noexcept nogil:
        pass
    cpdef void update_inlets(self) noexcept nogil:
        cdef numpy.int64_t i
        pass
    cpdef void update_outlets(self) noexcept nogil:
        pass
        cdef numpy.int64_t i
    cpdef void update_observers(self) noexcept nogil:
        cdef numpy.int64_t i
        pass
    cpdef void update_receivers(self, numpy.int64_t idx) noexcept nogil:
        self.idx_sim = idx
        cdef numpy.int64_t i
        pass
    cpdef void update_senders(self, numpy.int64_t idx) noexcept nogil:
        self.idx_sim = idx
        pass
        cdef numpy.int64_t i
    cpdef void update_outputs(self) noexcept nogil:
        if not self.threading:
            self.sequences.factors.update_outputs()
            self.sequences.fluxes.update_outputs()
    cpdef inline void set_waterdepth_v1(self, double waterdepth) noexcept nogil:
        self.sequences.factors.waterdepth = waterdepth
    cpdef inline void set_waterlevel_v1(self, double waterlevel) noexcept nogil:
        self.sequences.factors.waterlevel = waterlevel
    cpdef inline void calc_waterdepth_v3(self) noexcept nogil:
        self.sequences.factors.waterdepth = max(self.sequences.factors.waterlevel - self.parameters.control.heights[0], 0.0)
    cpdef inline void calc_waterlevel_v2(self) noexcept nogil:
        self.sequences.factors.waterlevel = self.sequences.factors.waterdepth + self.parameters.control.heights[0]
    cpdef inline void calc_index_excess_weight_v1(self) noexcept nogil:
        cdef numpy.int64_t i
        if self.sequences.factors.waterlevel <= self.parameters.control.heights[0]:
            self.sequences.aides.index = 0.0
            self.sequences.aides.weight = 0.0
            self.sequences.aides.excess = 0.0
        else:
            for i in range(self.parameters.control.nmbwidths - 1):
                if self.sequences.factors.waterlevel < self.parameters.control.heights[i + 1]:
                    self.sequences.aides.index = i
                    self.sequences.aides.excess = self.sequences.factors.waterlevel - self.parameters.control.heights[i]
                    self.sequences.aides.weight = self.sequences.aides.excess / (self.parameters.control.heights[i + 1] - self.parameters.control.heights[i])
                    break
            else:
                self.sequences.aides.index = self.parameters.control.nmbwidths - 1
                self.sequences.aides.excess = self.sequences.factors.waterlevel - self.parameters.control.heights[self.parameters.control.nmbwidths - 1]
                self.sequences.aides.weight = nan
    cpdef inline void calc_flowwidths_v1(self) noexcept nogil:
        cdef numpy.int64_t i
        cdef numpy.int64_t j
        j = int(self.sequences.aides.index)
        if isnan(self.sequences.aides.weight):
            for i in range(self.parameters.control.nmbsectors):
                self.sequences.factors.flowwidths[i] = self.parameters.derived.sectorflowwidths[i, j]
        else:
            for i in range(self.parameters.control.nmbsectors):
                self.sequences.factors.flowwidths[i] = (1.0 - self.sequences.aides.weight) * self.parameters.derived.sectorflowwidths[                    i, j                ] + self.sequences.aides.weight * self.parameters.derived.sectorflowwidths[i, j + 1]
    cpdef inline void calc_totalwidths_v1(self) noexcept nogil:
        cdef numpy.int64_t i
        cdef numpy.int64_t j
        j = int(self.sequences.aides.index)
        if isnan(self.sequences.aides.weight):
            for i in range(self.parameters.control.nmbsectors):
                self.sequences.factors.totalwidths[i] = self.parameters.derived.sectortotalwidths[i, j]
        else:
            for i in range(self.parameters.control.nmbsectors):
                self.sequences.factors.totalwidths[i] = (1.0 - self.sequences.aides.weight) * self.parameters.derived.sectortotalwidths[                    i, j                ] + self.sequences.aides.weight * self.parameters.derived.sectortotalwidths[i, j + 1]
    cpdef inline void calc_totalwidth_v1(self) noexcept nogil:
        cdef numpy.int64_t i
        self.sequences.factors.totalwidth = 0.0
        for i in range(self.parameters.control.nmbsectors):
            self.sequences.factors.totalwidth = self.sequences.factors.totalwidth + (self.sequences.factors.totalwidths[i])
    cpdef inline void calc_flowareas_v1(self) noexcept nogil:
        cdef numpy.int64_t i
        cdef numpy.int64_t j
        j = int(self.sequences.aides.index)
        for i in range(self.parameters.control.nmbsectors):
            self.sequences.factors.flowareas[i] = self.parameters.derived.sectorflowareas[i, j] + (                self.sequences.aides.excess * (self.parameters.derived.sectorflowwidths[i, j] + self.sequences.factors.flowwidths[i]) / 2.0            )
    cpdef inline void calc_totalareas_v1(self) noexcept nogil:
        cdef numpy.int64_t i
        cdef numpy.int64_t j
        j = int(self.sequences.aides.index)
        for i in range(self.parameters.control.nmbsectors):
            self.sequences.factors.totalareas[i] = self.parameters.derived.sectortotalareas[i, j] + (                self.sequences.aides.excess * (self.parameters.derived.sectortotalwidths[i, j] + self.sequences.factors.totalwidths[i]) / 2.0            )
    cpdef inline void calc_flowperimeters_v1(self) noexcept nogil:
        cdef double w
        cdef numpy.int64_t i
        cdef numpy.int64_t j
        j = int(self.sequences.aides.index)
        if isnan(self.sequences.aides.weight):
            for i in range(self.parameters.control.nmbsectors):
                self.sequences.factors.flowperimeters[i] = (                    self.parameters.derived.sectorflowperimeters[i, j] + 2.0 * self.sequences.aides.excess                )
        else:
            for i in range(self.parameters.control.nmbsectors):
                w = self.sequences.aides.weight
                self.sequences.factors.flowperimeters[i] = (1.0 - w) * self.parameters.derived.sectorflowperimeters[                    i, j                ] + w * self.parameters.derived.sectorflowperimeters[i, j + 1]
    cpdef inline void calc_flowperimeterderivatives_v1(self) noexcept nogil:
        cdef numpy.int64_t i
        cdef numpy.int64_t j
        j = int(self.sequences.aides.index)
        for i in range(self.parameters.control.nmbsectors):
            self.sequences.factors.flowperimeterderivatives[i] = self.parameters.derived.sectorflowperimeterderivatives[i, j]
    cpdef inline void calc_flowarea_v1(self) noexcept nogil:
        cdef numpy.int64_t i
        self.sequences.factors.flowarea = 0.0
        for i in range(self.parameters.control.nmbsectors):
            self.sequences.factors.flowarea = self.sequences.factors.flowarea + (self.sequences.factors.flowareas[i])
    cpdef inline void calc_totalarea_v1(self) noexcept nogil:
        cdef numpy.int64_t i
        self.sequences.factors.totalarea = 0.0
        for i in range(self.parameters.control.nmbsectors):
            self.sequences.factors.totalarea = self.sequences.factors.totalarea + (self.sequences.factors.totalareas[i])
    cpdef inline void calc_discharges_v2(self) noexcept nogil:
        cdef numpy.int64_t i
        for i in range(self.parameters.control.nmbsectors):
            if self.sequences.factors.flowareas[i] > 0.0:
                self.sequences.fluxes.discharges[i] = (                    self.parameters.control.stricklercoefficients[i]                    * self.parameters.control.bottomslope**0.5                    * self.sequences.factors.flowareas[i] ** (5.0 / 3.0)                    / self.sequences.factors.flowperimeters[i] ** (2.0 / 3.0)                )
            else:
                self.sequences.fluxes.discharges[i] = 0.0
    cpdef inline void calc_discharge_v3(self) noexcept nogil:
        cdef numpy.int64_t i
        self.sequences.fluxes.discharge = 0.0
        for i in range(self.parameters.control.nmbsectors):
            self.sequences.fluxes.discharge = self.sequences.fluxes.discharge + (self.sequences.fluxes.discharges[i])
    cpdef inline void calc_dischargederivatives_v2(self) noexcept nogil:
        cdef double dp
        cdef double p
        cdef double da
        cdef double a
        cdef numpy.int64_t t
        cdef numpy.int64_t i
        for i in range(self.parameters.control.nmbsectors):
            t = 0 if i == 0 else int(self.parameters.control.transitions[i - 1])
            if self.sequences.factors.waterlevel > self.parameters.control.heights[t]:
                a = self.sequences.factors.flowareas[i]
                da = self.sequences.factors.flowwidths[i]
                p = self.sequences.factors.flowperimeters[i]
                dp = self.sequences.factors.flowperimeterderivatives[i]
                self.sequences.factors.dischargederivatives[i] = (                    self.parameters.control.stricklercoefficients[i]                    * self.parameters.control.bottomslope**0.5                    * (a / p) ** (2.0 / 3.0)                    * (5.0 * p * da - 2.0 * a * dp)                    / (3.0 * p)                )
            else:
                self.sequences.factors.dischargederivatives[i] = 0.0
    cpdef inline void calc_dischargederivative_v2(self) noexcept nogil:
        cdef numpy.int64_t i
        self.sequences.factors.dischargederivative = 0.0
        for i in range(self.parameters.control.nmbsectors):
            self.sequences.factors.dischargederivative = self.sequences.factors.dischargederivative + (self.sequences.factors.dischargederivatives[i])
    cpdef inline void calc_celerity_v2(self) noexcept nogil:
        if self.sequences.factors.totalwidth > 0.0:
            self.sequences.factors.celerity = self.sequences.factors.dischargederivative / self.sequences.factors.totalwidth
        else:
            self.sequences.factors.celerity = nan
    cpdef double get_wettedarea_v2(self) noexcept nogil:
        return self.sequences.factors.totalarea
    cpdef double get_surfacewidth_v2(self) noexcept nogil:
        return self.sequences.factors.totalwidth
    cpdef double get_discharge_v1(self) noexcept nogil:
        return self.sequences.fluxes.discharge
    cpdef double get_celerity_v1(self) noexcept nogil:
        return self.sequences.factors.celerity
    cpdef inline void set_waterdepth(self, double waterdepth) noexcept nogil:
        self.sequences.factors.waterdepth = waterdepth
    cpdef inline void set_waterlevel(self, double waterlevel) noexcept nogil:
        self.sequences.factors.waterlevel = waterlevel
    cpdef inline void calc_waterdepth(self) noexcept nogil:
        self.sequences.factors.waterdepth = max(self.sequences.factors.waterlevel - self.parameters.control.heights[0], 0.0)
    cpdef inline void calc_waterlevel(self) noexcept nogil:
        self.sequences.factors.waterlevel = self.sequences.factors.waterdepth + self.parameters.control.heights[0]
    cpdef inline void calc_index_excess_weight(self) noexcept nogil:
        cdef numpy.int64_t i
        if self.sequences.factors.waterlevel <= self.parameters.control.heights[0]:
            self.sequences.aides.index = 0.0
            self.sequences.aides.weight = 0.0
            self.sequences.aides.excess = 0.0
        else:
            for i in range(self.parameters.control.nmbwidths - 1):
                if self.sequences.factors.waterlevel < self.parameters.control.heights[i + 1]:
                    self.sequences.aides.index = i
                    self.sequences.aides.excess = self.sequences.factors.waterlevel - self.parameters.control.heights[i]
                    self.sequences.aides.weight = self.sequences.aides.excess / (self.parameters.control.heights[i + 1] - self.parameters.control.heights[i])
                    break
            else:
                self.sequences.aides.index = self.parameters.control.nmbwidths - 1
                self.sequences.aides.excess = self.sequences.factors.waterlevel - self.parameters.control.heights[self.parameters.control.nmbwidths - 1]
                self.sequences.aides.weight = nan
    cpdef inline void calc_flowwidths(self) noexcept nogil:
        cdef numpy.int64_t i
        cdef numpy.int64_t j
        j = int(self.sequences.aides.index)
        if isnan(self.sequences.aides.weight):
            for i in range(self.parameters.control.nmbsectors):
                self.sequences.factors.flowwidths[i] = self.parameters.derived.sectorflowwidths[i, j]
        else:
            for i in range(self.parameters.control.nmbsectors):
                self.sequences.factors.flowwidths[i] = (1.0 - self.sequences.aides.weight) * self.parameters.derived.sectorflowwidths[                    i, j                ] + self.sequences.aides.weight * self.parameters.derived.sectorflowwidths[i, j + 1]
    cpdef inline void calc_totalwidths(self) noexcept nogil:
        cdef numpy.int64_t i
        cdef numpy.int64_t j
        j = int(self.sequences.aides.index)
        if isnan(self.sequences.aides.weight):
            for i in range(self.parameters.control.nmbsectors):
                self.sequences.factors.totalwidths[i] = self.parameters.derived.sectortotalwidths[i, j]
        else:
            for i in range(self.parameters.control.nmbsectors):
                self.sequences.factors.totalwidths[i] = (1.0 - self.sequences.aides.weight) * self.parameters.derived.sectortotalwidths[                    i, j                ] + self.sequences.aides.weight * self.parameters.derived.sectortotalwidths[i, j + 1]
    cpdef inline void calc_totalwidth(self) noexcept nogil:
        cdef numpy.int64_t i
        self.sequences.factors.totalwidth = 0.0
        for i in range(self.parameters.control.nmbsectors):
            self.sequences.factors.totalwidth = self.sequences.factors.totalwidth + (self.sequences.factors.totalwidths[i])
    cpdef inline void calc_flowareas(self) noexcept nogil:
        cdef numpy.int64_t i
        cdef numpy.int64_t j
        j = int(self.sequences.aides.index)
        for i in range(self.parameters.control.nmbsectors):
            self.sequences.factors.flowareas[i] = self.parameters.derived.sectorflowareas[i, j] + (                self.sequences.aides.excess * (self.parameters.derived.sectorflowwidths[i, j] + self.sequences.factors.flowwidths[i]) / 2.0            )
    cpdef inline void calc_totalareas(self) noexcept nogil:
        cdef numpy.int64_t i
        cdef numpy.int64_t j
        j = int(self.sequences.aides.index)
        for i in range(self.parameters.control.nmbsectors):
            self.sequences.factors.totalareas[i] = self.parameters.derived.sectortotalareas[i, j] + (                self.sequences.aides.excess * (self.parameters.derived.sectortotalwidths[i, j] + self.sequences.factors.totalwidths[i]) / 2.0            )
    cpdef inline void calc_flowperimeters(self) noexcept nogil:
        cdef double w
        cdef numpy.int64_t i
        cdef numpy.int64_t j
        j = int(self.sequences.aides.index)
        if isnan(self.sequences.aides.weight):
            for i in range(self.parameters.control.nmbsectors):
                self.sequences.factors.flowperimeters[i] = (                    self.parameters.derived.sectorflowperimeters[i, j] + 2.0 * self.sequences.aides.excess                )
        else:
            for i in range(self.parameters.control.nmbsectors):
                w = self.sequences.aides.weight
                self.sequences.factors.flowperimeters[i] = (1.0 - w) * self.parameters.derived.sectorflowperimeters[                    i, j                ] + w * self.parameters.derived.sectorflowperimeters[i, j + 1]
    cpdef inline void calc_flowperimeterderivatives(self) noexcept nogil:
        cdef numpy.int64_t i
        cdef numpy.int64_t j
        j = int(self.sequences.aides.index)
        for i in range(self.parameters.control.nmbsectors):
            self.sequences.factors.flowperimeterderivatives[i] = self.parameters.derived.sectorflowperimeterderivatives[i, j]
    cpdef inline void calc_flowarea(self) noexcept nogil:
        cdef numpy.int64_t i
        self.sequences.factors.flowarea = 0.0
        for i in range(self.parameters.control.nmbsectors):
            self.sequences.factors.flowarea = self.sequences.factors.flowarea + (self.sequences.factors.flowareas[i])
    cpdef inline void calc_totalarea(self) noexcept nogil:
        cdef numpy.int64_t i
        self.sequences.factors.totalarea = 0.0
        for i in range(self.parameters.control.nmbsectors):
            self.sequences.factors.totalarea = self.sequences.factors.totalarea + (self.sequences.factors.totalareas[i])
    cpdef inline void calc_discharges(self) noexcept nogil:
        cdef numpy.int64_t i
        for i in range(self.parameters.control.nmbsectors):
            if self.sequences.factors.flowareas[i] > 0.0:
                self.sequences.fluxes.discharges[i] = (                    self.parameters.control.stricklercoefficients[i]                    * self.parameters.control.bottomslope**0.5                    * self.sequences.factors.flowareas[i] ** (5.0 / 3.0)                    / self.sequences.factors.flowperimeters[i] ** (2.0 / 3.0)                )
            else:
                self.sequences.fluxes.discharges[i] = 0.0
    cpdef inline void calc_discharge(self) noexcept nogil:
        cdef numpy.int64_t i
        self.sequences.fluxes.discharge = 0.0
        for i in range(self.parameters.control.nmbsectors):
            self.sequences.fluxes.discharge = self.sequences.fluxes.discharge + (self.sequences.fluxes.discharges[i])
    cpdef inline void calc_dischargederivatives(self) noexcept nogil:
        cdef double dp
        cdef double p
        cdef double da
        cdef double a
        cdef numpy.int64_t t
        cdef numpy.int64_t i
        for i in range(self.parameters.control.nmbsectors):
            t = 0 if i == 0 else int(self.parameters.control.transitions[i - 1])
            if self.sequences.factors.waterlevel > self.parameters.control.heights[t]:
                a = self.sequences.factors.flowareas[i]
                da = self.sequences.factors.flowwidths[i]
                p = self.sequences.factors.flowperimeters[i]
                dp = self.sequences.factors.flowperimeterderivatives[i]
                self.sequences.factors.dischargederivatives[i] = (                    self.parameters.control.stricklercoefficients[i]                    * self.parameters.control.bottomslope**0.5                    * (a / p) ** (2.0 / 3.0)                    * (5.0 * p * da - 2.0 * a * dp)                    / (3.0 * p)                )
            else:
                self.sequences.factors.dischargederivatives[i] = 0.0
    cpdef inline void calc_dischargederivative(self) noexcept nogil:
        cdef numpy.int64_t i
        self.sequences.factors.dischargederivative = 0.0
        for i in range(self.parameters.control.nmbsectors):
            self.sequences.factors.dischargederivative = self.sequences.factors.dischargederivative + (self.sequences.factors.dischargederivatives[i])
    cpdef inline void calc_celerity(self) noexcept nogil:
        if self.sequences.factors.totalwidth > 0.0:
            self.sequences.factors.celerity = self.sequences.factors.dischargederivative / self.sequences.factors.totalwidth
        else:
            self.sequences.factors.celerity = nan
    cpdef double get_wettedarea(self) noexcept nogil:
        return self.sequences.factors.totalarea
    cpdef double get_surfacewidth(self) noexcept nogil:
        return self.sequences.factors.totalwidth
    cpdef double get_discharge(self) noexcept nogil:
        return self.sequences.fluxes.discharge
    cpdef double get_celerity(self) noexcept nogil:
        return self.sequences.factors.celerity
    cpdef void use_waterdepth_v3(self, double waterdepth) noexcept nogil:
        self.set_waterdepth_v1(waterdepth)
        self.calc_waterlevel_v2()
        self.calc_index_excess_weight_v1()
        self.calc_flowwidths_v1()
        self.calc_totalwidths_v1()
        self.calc_totalwidth_v1()
        self.calc_flowareas_v1()
        self.calc_totalareas_v1()
        self.calc_flowperimeters_v1()
        self.calc_flowperimeterderivatives_v1()
        self.calc_flowarea_v1()
        self.calc_totalarea_v1()
        self.calc_discharges_v2()
        self.calc_discharge_v3()
        self.calc_dischargederivatives_v2()
        self.calc_dischargederivative_v2()
        self.calc_celerity_v2()
    cpdef void use_waterlevel_v3(self, double waterlevel) noexcept nogil:
        self.set_waterlevel_v1(waterlevel)
        self.calc_waterdepth_v3()
        self.calc_index_excess_weight_v1()
        self.calc_flowwidths_v1()
        self.calc_totalwidths_v1()
        self.calc_totalwidth_v1()
        self.calc_flowareas_v1()
        self.calc_totalareas_v1()
        self.calc_flowperimeters_v1()
        self.calc_flowperimeterderivatives_v1()
        self.calc_flowarea_v1()
        self.calc_totalarea_v1()
        self.calc_discharges_v2()
        self.calc_discharge_v3()
        self.calc_dischargederivatives_v2()
        self.calc_dischargederivative_v2()
        self.calc_celerity_v2()
    cpdef void use_waterdepth(self, double waterdepth) noexcept nogil:
        self.set_waterdepth_v1(waterdepth)
        self.calc_waterlevel_v2()
        self.calc_index_excess_weight_v1()
        self.calc_flowwidths_v1()
        self.calc_totalwidths_v1()
        self.calc_totalwidth_v1()
        self.calc_flowareas_v1()
        self.calc_totalareas_v1()
        self.calc_flowperimeters_v1()
        self.calc_flowperimeterderivatives_v1()
        self.calc_flowarea_v1()
        self.calc_totalarea_v1()
        self.calc_discharges_v2()
        self.calc_discharge_v3()
        self.calc_dischargederivatives_v2()
        self.calc_dischargederivative_v2()
        self.calc_celerity_v2()
    cpdef void use_waterlevel(self, double waterlevel) noexcept nogil:
        self.set_waterlevel_v1(waterlevel)
        self.calc_waterdepth_v3()
        self.calc_index_excess_weight_v1()
        self.calc_flowwidths_v1()
        self.calc_totalwidths_v1()
        self.calc_totalwidth_v1()
        self.calc_flowareas_v1()
        self.calc_totalareas_v1()
        self.calc_flowperimeters_v1()
        self.calc_flowperimeterderivatives_v1()
        self.calc_flowarea_v1()
        self.calc_totalarea_v1()
        self.calc_discharges_v2()
        self.calc_discharge_v3()
        self.calc_dischargederivatives_v2()
        self.calc_dischargederivative_v2()
        self.calc_celerity_v2()
