**Table of contents**

<!-- TOC depthfrom:1 insertanchor:false orderedlist:false -->

- [Extract strings](#extract-strings)
  - [What If... I don't have tox? or it's older?](#what-if-i-dont-have-tox-or-its-older)
- [Editing the catalog with poedit](#editing-the-catalog-with-poedit)

<!-- /TOC -->

## Extract strings

As described in plugins documentation, Risu can make use of translated strings.

- Strings like `$"Whatever"` in bash scripts

- Strings with `_("whatever")` in python if language file has been installed

        ```py
        # Import the _() function
        import gettext
        localedir = os.environ['TEXTDOMAINDIR']
        # This will use system defined LANGUAGE
        trad = gettext.translation('risu', localedir, fallback=True)

        try:
            _ = trad.ugettext
        except AttributeError:
            _ = trad.gettext
        ```

In order to prepare them for translation, `extractpot.sh` script must be used.

It requires some dependencies to work, so easiest way is to run `tox -e pep8` as tox takes care of preparing a virtual environment with pre-requirements and run from there.

### What If... I don't have tox? or it's older?

If your system version of tox is old, approach will be:

- If you've `pipsi` installed, just run `pipsi install tox` to get a virtualized version of tox installed that you can use.
- If `pipsi` is not installed, run first `pip install pipsi`.
- If `pip` is not available, install your distribution `python-pip` package equivalent.

**NOTE**: Ensure that your local path (`~/.local/bin`) precedes regular system path so that your shell uses first the files in the local venvs created by pipsi.

**NOTE**: Do not install anything else with `pip` as it can mess with your system-wide installed libraries and cause havoc on other programs.

## Editing the catalog with poedit

Once you have decided to start a translation or to improve a new one, you must use the risu.pot as 'base' for a new translation OR if you already have one created:

- Open prior translation with `poedit` (so you can edit missing to translate strings)
- If a plugin has introduced new strings, those will not appear on the file you're editing, so you'll need to update it:
  - Execute `./extractpot.sh` to update `risu.pot` with the new strings
  - While your older translation is open, select from the `poedit` menus: `Catalog`, then `Update from POT file`, and then select `risu.pot`.
  - The new strings will appear in your editor, remember to `save` to create `risu.po` for your language and the compiled `risu.mo`.
  - Remember to add those files to the repo in your commit if you want others to take advantage of it.
  - Execute `risu.py --lang $LANG` to test it
